/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.Record;

public class KinesisFirehose2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisFirehose2Producer.class);

    public KinesisFirehose2Producer(KinesisFirehose2Endpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KinesisFirehose2Endpoint getEndpoint() {
        return (KinesisFirehose2Endpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PutRecordRequest request = this.createRequest(exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PutRecordResponse putRecordResult = this.getEndpoint().getClient().putRecord(request);
        LOG.trace("Received result [{}]", (Object)putRecordResult);
        Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisFirehoseRecordId", (Object)putRecordResult.recordId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Record.Builder record = Record.builder();
        record.data(SdkBytes.fromByteBuffer((ByteBuffer)body));
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.deliveryStreamName(this.getEndpoint().getConfiguration().getStreamName());
        putRecordRequest.record((Record)record.build());
        return (PutRecordRequest)putRecordRequest.build();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

