/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.cloud.EtcdOnDemandServiceDiscovery;
import org.apache.camel.component.etcd.cloud.EtcdWatchServiceDiscovery;
import org.apache.camel.spi.annotations.CloudServiceFactory;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

@CloudServiceFactory(value="etcd-service-discovery")
public class EtcdServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private final EtcdConfiguration configuration;
    private String type;

    public EtcdServiceDiscoveryFactory() {
        this(new EtcdConfiguration());
    }

    public EtcdServiceDiscoveryFactory(EtcdConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getUris() {
        return this.configuration.getUris();
    }

    public void setUris(String uris) {
        this.configuration.setUris(uris);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public Integer getTimeToLive() {
        return this.configuration.getTimeToLive();
    }

    public void setTimeToLive(Integer timeToLive) {
        this.configuration.setTimeToLive(timeToLive);
    }

    public Long getTimeout() {
        return this.configuration.getTimeout();
    }

    public void setTimeout(Long timeout) {
        this.configuration.setTimeout(timeout);
    }

    public String getServicePath() {
        return this.configuration.getServicePath();
    }

    public void setServicePath(String servicePath) {
        this.configuration.setServicePath(servicePath);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        return ObjectHelper.equal((Object)"watch", (Object)this.type, (boolean)true) ? new EtcdWatchServiceDiscovery(this.configuration) : new EtcdOnDemandServiceDiscovery(this.configuration);
    }
}

