/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import mousio.client.promises.ResponsePromise;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.etcd.AbstractEtcdConsumer;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.component.etcd.EtcdWatchEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdWatchConsumer
extends AbstractEtcdConsumer
implements ResponsePromise.IsSimplePromiseResponseHandler<EtcdKeysResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdWatchConsumer.class);
    private final EtcdWatchEndpoint endpoint;
    private final EtcdConfiguration configuration;
    private final AtomicLong index;

    public EtcdWatchConsumer(EtcdWatchEndpoint endpoint, Processor processor, EtcdConfiguration configuration, String path) {
        super(endpoint, processor, configuration, path);
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.index = new AtomicLong(configuration.getFromIndex());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.watch();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    public void onResponse(ResponsePromise<EtcdKeysResponse> promise) {
        if (!this.isRunAllowed()) {
            return;
        }
        Exchange exchange = null;
        Throwable throwable = promise.getException();
        if (throwable instanceof EtcdException) {
            EtcdException exception = (EtcdException)throwable;
            if (EtcdHelper.isOutdatedIndexException(exception)) {
                LOGGER.debug("Outdated index, key: {}, cause={}", (Object)this.getPath(), (Object)exception.etcdCause);
                this.index.set(exception.index + 1L);
                throwable = null;
            }
        } else {
            try {
                EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
                exchange = this.endpoint.createExchange();
                exchange.getIn().setHeader("CamelEtcdNamespace", (Object)"watch");
                exchange.getIn().setHeader("CamelEtcdPath", (Object)response.node.key);
                exchange.getIn().setBody((Object)response);
                this.index.set(response.node.modifiedIndex + 1L);
            }
            catch (TimeoutException e) {
                LOGGER.debug("Timeout watching for {}", (Object)this.getPath());
                if (this.configuration.isSendEmptyExchangeOnTimeout()) {
                    exchange = this.endpoint.createExchange();
                    exchange.getIn().setHeader("CamelEtcdNamespace", (Object)"watch");
                    exchange.getIn().setHeader("CamelEtcdTimeout", (Object)true);
                    exchange.getIn().setHeader("CamelEtcdPath", (Object)this.getPath());
                    exchange.getIn().setBody(null);
                }
                throwable = null;
            }
            catch (Exception e1) {
                throwable = e1;
            }
            if (exchange != null) {
                try {
                    throwable = null;
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                }
            }
        }
        if (throwable != null) {
            this.handleException("Error processing etcd response", throwable);
        }
        try {
            this.watch();
        }
        catch (Exception e) {
            this.handleException("Error watching key " + this.getPath(), e);
        }
    }

    private void watch() throws Exception {
        if (!this.isRunAllowed()) {
            return;
        }
        EtcdKeyGetRequest request = this.getClient().get(this.getPath()).waitForChange(this.index.get());
        if (this.configuration.isRecursive()) {
            request.recursive();
        }
        if (this.configuration.getTimeout() != null) {
            request.timeout(this.configuration.getTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        request.send().addListener((ResponsePromise.IsSimplePromiseResponseHandler)this);
    }
}

