/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.filters;

import org.apache.camel.CamelContext;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.component.hbase.filters.ModelAwareFilter;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;

public class ModelAwareColumnMatchingFilter
implements ModelAwareFilter<FilterList> {
    FilterList fl = new FilterList(new Filter[0]);

    @Override
    public FilterList getFilteredList() {
        return this.fl;
    }

    @Override
    public void apply(CamelContext context, HBaseRow rowModel) {
        this.fl.getFilters().clear();
        if (rowModel != null) {
            for (HBaseCell cell : rowModel.getCells()) {
                if (cell.getValue() == null) continue;
                byte[] family = HBaseHelper.getHBaseFieldAsBytes(cell.getFamily());
                byte[] qualifier = HBaseHelper.getHBaseFieldAsBytes(cell.getQualifier());
                byte[] value = (byte[])context.getTypeConverter().convertTo(byte[].class, cell.getValue());
                SingleColumnValueFilter columnValueFilter = new SingleColumnValueFilter(family, qualifier, CompareOperator.EQUAL, value);
                this.fl.addFilter((Filter)columnValueFilter);
            }
        }
    }
}

