/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.splunkhec.SplunkHECComponent;
import org.apache.camel.component.splunkhec.SplunkHECConfiguration;
import org.apache.camel.component.splunkhec.SplunkHECProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.commons.validator.routines.DomainValidator;

@UriEndpoint(firstVersion="3.3.0", scheme="splunk-hec", title="Splunk HEC", producerOnly=true, syntax="splunk-hec:splunkURL/token", label="log,monitoring")
public class SplunkHECEndpoint
extends DefaultEndpoint {
    private static final Pattern URI_PARSER = Pattern.compile("splunk-hec\\:\\/?\\/?(.*?):(\\d+)/(\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12})\\??.*");
    @UriPath
    @Metadata(required=true)
    private String splunkURL;
    @UriPath(label="security")
    @Metadata(required=true)
    private String token;
    @UriParam
    private SplunkHECConfiguration configuration;

    public SplunkHECEndpoint() {
    }

    public SplunkHECEndpoint(String uri, SplunkHECComponent component, SplunkHECConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        Matcher match = URI_PARSER.matcher(uri);
        if (!match.matches() || !DomainValidator.getInstance((boolean)true).isValid(match.group(1))) {
            throw new IllegalArgumentException("Invalid URI: " + uri);
        }
        int port = Integer.parseInt(match.group(2));
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.splunkURL = match.group(1) + ":" + port;
        this.token = match.group(3);
    }

    public Producer createProducer() {
        return new SplunkHECProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException();
    }

    public SplunkHECConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSplunkURL() {
        return this.splunkURL;
    }

    public void setSplunkURL(String splunkURL) {
        this.splunkURL = splunkURL;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

