/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.io.Closeable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpoint;
import org.apache.camel.component.zendesk.internal.ZendeskApiCollection;
import org.apache.camel.component.zendesk.internal.ZendeskApiName;
import org.apache.camel.component.zendesk.internal.ZendeskHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.util.IOHelper;
import org.zendesk.client.v2.Zendesk;

@Component(value="zendesk")
public class ZendeskComponent
extends AbstractApiComponent<ZendeskApiName, ZendeskConfiguration, ZendeskApiCollection> {
    @Metadata(label="advanced")
    Zendesk zendesk;

    public ZendeskComponent() {
        super(ZendeskEndpoint.class, ZendeskApiName.class, (ApiCollection)ZendeskApiCollection.getCollection());
    }

    public ZendeskComponent(CamelContext context) {
        super(context, ZendeskEndpoint.class, ZendeskApiName.class, (ApiCollection)ZendeskApiCollection.getCollection());
    }

    protected ZendeskApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return ZendeskApiName.fromValue(apiNameStr);
    }

    public void setConfiguration(ZendeskConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public ZendeskConfiguration getConfiguration() {
        return (ZendeskConfiguration)super.getConfiguration();
    }

    public Zendesk getZendesk() {
        return this.zendesk;
    }

    public void setZendesk(Zendesk zendesk) {
        this.zendesk = zendesk;
    }

    protected Endpoint createEndpoint(String uri, String methodName, ZendeskApiName apiName, ZendeskConfiguration endpointConfiguration) {
        endpointConfiguration.setMethodName(methodName);
        return new ZendeskEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.zendesk == null && this.configuration != null) {
            this.zendesk = ZendeskHelper.create((ZendeskConfiguration)this.configuration);
        }
    }

    protected void doStop() throws Exception {
        IOHelper.close((Closeable)this.zendesk);
        super.doStop();
    }

    public void doShutdown() throws Exception {
        IOHelper.close((Closeable)this.zendesk);
        super.doShutdown();
    }
}

