/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.groovy.GroovyLanguage;
import org.apache.camel.language.groovy.GroovyShellFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionSupport;

public class GroovyExpression
extends ExpressionSupport {
    private final String text;

    public GroovyExpression(String text) {
        this.text = text;
    }

    public String toString() {
        return "groovy: " + this.text;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return "groovy: " + this.text;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Script script = this.instantiateScript(exchange);
        script.setBinding(this.createBinding(exchange));
        Object value = script.run();
        return (T)exchange.getContext().getTypeConverter().convertTo(type, value);
    }

    private Script instantiateScript(Exchange exchange) {
        String key;
        Class scriptClass;
        GroovyLanguage language = (GroovyLanguage)exchange.getContext().resolveLanguage("groovy");
        Set shellFactories = exchange.getContext().getRegistry().findByType(GroovyShellFactory.class);
        GroovyShellFactory shellFactory = null;
        String fileName = null;
        if (shellFactories.size() == 1) {
            shellFactory = (GroovyShellFactory)shellFactories.iterator().next();
            fileName = shellFactory.getFileName(exchange);
        }
        if ((scriptClass = language.getScriptFromCache(key = fileName != null ? fileName + this.text : this.text)) == null) {
            ClassLoader cl = exchange.getContext().getApplicationContextClassLoader();
            GroovyShell shell = shellFactory != null ? shellFactory.createGroovyShell(exchange) : (cl != null ? new GroovyShell(cl) : new GroovyShell());
            scriptClass = fileName != null ? shell.getClassLoader().parseClass(this.text, fileName) : shell.getClassLoader().parseClass(this.text);
            language.addScriptToCache(key, scriptClass);
        }
        try {
            return scriptClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private Binding createBinding(Exchange exchange) {
        HashMap variables = new HashMap();
        ExchangeHelper.populateVariableMap((Exchange)exchange, variables);
        return new Binding(variables);
    }
}

