/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jslt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.Parser;
import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jslt.JsltComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.1.0", scheme="jslt", title="JSLT", syntax="jslt:resourceUri", producerOnly=true, label="transformation")
public class JsltEndpoint
extends ResourceEndpoint {
    private Expression transform;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam(defaultValue="false", label="common")
    private boolean prettyPrint;

    public JsltEndpoint() {
    }

    public JsltEndpoint(String uri, JsltComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "jslt:" + this.getResourceUri();
    }

    private synchronized Expression getTransform(Message msg) throws Exception {
        if (this.transform == null) {
            if (this.log.isDebugEnabled()) {
                String path = this.getResourceUri();
                this.log.debug("Jslt content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            String jsltStringFromHeader = this.allowTemplateFromHeader ? (String)msg.getHeader("CamelJsltString", String.class) : null;
            Collection<Function> functions = ((JsltComponent)this.getComponent()).getFunctions();
            this.transform = jsltStringFromHeader != null ? (functions == null ? Parser.compileString((String)jsltStringFromHeader) : Parser.compileString((String)jsltStringFromHeader, functions)) : (functions == null ? Parser.compileResource((String)this.getResourceUri()) : Parser.compileResource((String)this.getResourceUri(), functions));
        }
        return this.transform;
    }

    public JsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JsltEndpoint)this.getCamelContext().getEndpoint(newUri, JsltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        JsonNode input;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = null;
        if (this.allowTemplateFromHeader) {
            newResourceUri = (String)exchange.getIn().getHeader("CamelJsltResourceUri", String.class);
        }
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelJsltResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJsltResourceUri", (Object)newResourceUri);
            JsltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (exchange.getIn().getBody() instanceof String) {
            input = objectMapper.readTree((String)exchange.getIn().getBody(String.class));
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            input = objectMapper.readTree((InputStream)exchange.getIn().getBody(InputStream.class));
        } else {
            this.log.debug("Body content is not String neither InputStream.");
            throw new ValidationException(exchange, "Allowed body types are String or InputStream.");
        }
        JsonNode output = this.getTransform(exchange.getMessage()).apply(input);
        Message out = exchange.getMessage();
        out.setBody((Object)(this.isPrettyPrint() ? output.toPrettyString() : output.toString()));
        out.setHeaders(exchange.getIn().getHeaders());
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }
}

