/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

public final class CamelVersionHelper {
    private CamelVersionHelper() {
    }

    public static boolean isGE(String base, String other) {
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Empty base version");
        }
        if (other == null || other.isEmpty()) {
            throw new IllegalArgumentException("Empty other version");
        }
        base = base.replaceAll("[^\\d|^\\.]", "");
        other = other.replaceAll("[^\\d|^\\.]", "");
        if (!base.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        if (!other.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        Version ver2 = new Version(other);
        Version ver1 = new Version(base);
        return ver2.compareTo(ver1) >= 0;
    }

    private static final class Version
    implements Comparable<Version> {
        private final String version;

        private Version(String version) {
            this.version = version;
        }

        private String getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            String[] thisParts = this.getVersion().split("\\.");
            String[] thatParts = that.getVersion().split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }
    }
}

