/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramProducer.class);
    private TelegramEndpoint endpoint;

    public TelegramProducer(TelegramEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (exchange.getIn().getBody() == null) {
            LOG.debug("Received exchange with empty body, skipping");
            callback.done(true);
            return true;
        }
        TelegramConfiguration config = this.endpoint.getConfiguration();
        OutgoingMessage message = (OutgoingMessage)exchange.getIn().getBody(OutgoingMessage.class);
        if (message == null) {
            throw new IllegalArgumentException("Cannot convert the content to a Telegram OutgoingMessage");
        }
        if (message.getChatId() == null) {
            LOG.debug("Chat id is null on outgoing message, trying resolution");
            String chatId = this.resolveChatId(config, message, exchange);
            LOG.debug("Resolved chat id is {}", (Object)chatId);
            message.setChatId(chatId);
        }
        TelegramService service = this.endpoint.getTelegramService();
        LOG.debug("Message being sent is: {}", (Object)message);
        LOG.debug("Headers of message being sent are: {}", (Object)exchange.getIn().getHeaders());
        service.sendMessage(exchange, callback, message);
        return false;
    }

    private String resolveChatId(TelegramConfiguration config, OutgoingMessage message, Exchange exchange) {
        String chatId = message.getChatId();
        if (chatId == null) {
            chatId = (String)exchange.getIn().getHeader("CamelTelegramChatId");
        }
        if (chatId == null) {
            chatId = config.getChatId();
        }
        if (chatId == null) {
            throw new IllegalStateException("Chat id is not set in message headers or route configuration");
        }
        return chatId;
    }
}

