/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.multimap;

import io.atomix.Atomix;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMap;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapComponent;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class AtomixMultiMapComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AtomixMultiMapConfiguration getOrCreateConfiguration(AtomixMultiMapComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AtomixMultiMapConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AtomixMultiMapComponent target = (AtomixMultiMapComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                this.getOrCreateConfiguration(target).setAtomix((Atomix)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Atomix.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((AtomixMultiMapConfiguration)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, AtomixMultiMapConfiguration.class, (Object)value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.setConfigurationUri((String)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaultaction": 
            case "defaultAction": {
                this.getOrCreateConfiguration(target).setDefaultAction((AtomixMultiMap.Action)((Object)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, AtomixMultiMap.Action.class, (Object)value)));
                return true;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                this.getOrCreateConfiguration(target).setDefaultResourceConfig((Properties)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                this.getOrCreateConfiguration(target).setDefaultResourceOptions((Properties)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "ephemeral": {
                this.getOrCreateConfiguration(target).setEphemeral((Boolean)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "key": {
                this.getOrCreateConfiguration(target).setKey(AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "nodes": {
                target.setNodes((List)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "readconsistency": 
            case "readConsistency": {
                this.getOrCreateConfiguration(target).setReadConsistency((ReadConsistency)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, ReadConsistency.class, (Object)value));
                return true;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                this.getOrCreateConfiguration(target).setResourceConfigs((Map)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                this.getOrCreateConfiguration(target).setResourceOptions((Map)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                this.getOrCreateConfiguration(target).setResultHeader((String)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "transportclassname": 
            case "transportClassName": {
                this.getOrCreateConfiguration(target).setTransportClassName((String)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ttl": {
                this.getOrCreateConfiguration(target).setTtl((Long)AtomixMultiMapComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("atomix", Atomix.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", AtomixMultiMapConfiguration.class);
        answer.put("configurationUri", String.class);
        answer.put("defaultAction", AtomixMultiMap.Action.class);
        answer.put("defaultResourceConfig", Properties.class);
        answer.put("defaultResourceOptions", Properties.class);
        answer.put("ephemeral", Boolean.TYPE);
        answer.put("key", Object.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("nodes", List.class);
        answer.put("readConsistency", ReadConsistency.class);
        answer.put("resourceConfigs", Map.class);
        answer.put("resourceOptions", Map.class);
        answer.put("resultHeader", String.class);
        answer.put("transportClassName", String.class);
        answer.put("ttl", Long.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AtomixMultiMapComponent target = (AtomixMultiMapComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return this.getOrCreateConfiguration(target).getAtomix();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfigurationUri();
            }
            case "defaultaction": 
            case "defaultAction": {
                return this.getOrCreateConfiguration(target).getDefaultAction();
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return this.getOrCreateConfiguration(target).getDefaultResourceConfig();
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return this.getOrCreateConfiguration(target).getDefaultResourceOptions();
            }
            case "ephemeral": {
                return this.getOrCreateConfiguration(target).isEphemeral();
            }
            case "key": {
                return this.getOrCreateConfiguration(target).getKey();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nodes": {
                return target.getNodes();
            }
            case "readconsistency": 
            case "readConsistency": {
                return this.getOrCreateConfiguration(target).getReadConsistency();
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return this.getOrCreateConfiguration(target).getResourceConfigs();
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return this.getOrCreateConfiguration(target).getResourceOptions();
            }
            case "resultheader": 
            case "resultHeader": {
                return this.getOrCreateConfiguration(target).getResultHeader();
            }
            case "transportclassname": 
            case "transportClassName": {
                return this.getOrCreateConfiguration(target).getTransportClassName();
            }
            case "ttl": {
                return this.getOrCreateConfiguration(target).getTtl();
            }
        }
        return null;
    }
}

