/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.yammer.YammerComponent;
import org.apache.camel.component.yammer.YammerConfiguration;
import org.apache.camel.component.yammer.YammerMessagePollingConsumer;
import org.apache.camel.component.yammer.YammerMessageProducer;
import org.apache.camel.component.yammer.YammerUserPollingConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.12.0", scheme="yammer", title="Yammer", syntax="yammer:function", label="social")
public class YammerEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private YammerConfiguration config;

    public YammerEndpoint() {
    }

    public YammerEndpoint(String uri, YammerComponent component) {
        super(uri, (Component)component);
    }

    public YammerEndpoint(String uri, YammerComponent yammerComponent, YammerConfiguration config) {
        super(uri, (Component)yammerComponent);
        this.setConfig(config);
    }

    public YammerComponent getComponent() {
        return (YammerComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new YammerMessageProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        switch (this.config.getFunction()) {
            case MESSAGES: 
            case ALGO: 
            case FOLLOWING: 
            case MY_FEED: 
            case PRIVATE: 
            case SENT: 
            case RECEIVED: {
                YammerMessagePollingConsumer answer = new YammerMessagePollingConsumer(this, processor);
                this.configureConsumer((Consumer)answer);
                return answer;
            }
            case USERS: 
            case CURRENT: {
                YammerUserPollingConsumer answer2 = new YammerUserPollingConsumer(this, processor);
                this.configureConsumer((Consumer)answer2);
                return answer2;
            }
        }
        throw new Exception(String.format("%s is not a valid Yammer function type.", new Object[]{this.config.getFunction()}));
    }

    public YammerConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(YammerConfiguration config) {
        this.config = config;
    }

    protected String createEndpointUri() {
        return String.format("yammer://%s?consumerKey=%s&consumerSecret=%s&accessToken=%s", new Object[]{this.config.getFunction(), this.config.getConsumerKey(), this.config.getConsumerSecret(), this.config.getAccessToken()});
    }
}

