/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform machine learning tasks using Weka.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WekaEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Weka component.
     */
    public interface WekaEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedWekaEndpointBuilder advanced() {
            return (AdvancedWekaEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WekaEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WekaEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The filter spec (i.e. Name Options).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WekaEndpointBuilder apply(String apply) {
            doSetProperty("apply", apply);
            return this;
        }
        /**
         * The classifier spec (i.e. Name Options).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: model
         */
        default WekaEndpointBuilder build(String build) {
            doSetProperty("build", build);
            return this;
        }
        /**
         * The named dataset to train the classifier with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: model
         */
        default WekaEndpointBuilder dsname(String dsname) {
            doSetProperty("dsname", dsname);
            return this;
        }
        /**
         * Number of folds to use for cross-validation.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: model
         */
        default WekaEndpointBuilder folds(int folds) {
            doSetProperty("folds", folds);
            return this;
        }
        /**
         * Number of folds to use for cross-validation.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: model
         */
        default WekaEndpointBuilder folds(String folds) {
            doSetProperty("folds", folds);
            return this;
        }
        /**
         * Path to load the model from.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: model
         */
        default WekaEndpointBuilder loadFrom(String loadFrom) {
            doSetProperty("loadFrom", loadFrom);
            return this;
        }
        /**
         * Path to save the model to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: model
         */
        default WekaEndpointBuilder saveTo(String saveTo) {
            doSetProperty("saveTo", saveTo);
            return this;
        }
        /**
         * An optional seed for the randomizer.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: model
         */
        default WekaEndpointBuilder seed(int seed) {
            doSetProperty("seed", seed);
            return this;
        }
        /**
         * An optional seed for the randomizer.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: model
         */
        default WekaEndpointBuilder seed(String seed) {
            doSetProperty("seed", seed);
            return this;
        }
        /**
         * Flag on whether to use cross-validation with the current dataset.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: model
         */
        default WekaEndpointBuilder xval(boolean xval) {
            doSetProperty("xval", xval);
            return this;
        }
        /**
         * Flag on whether to use cross-validation with the current dataset.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: model
         */
        default WekaEndpointBuilder xval(String xval) {
            doSetProperty("xval", xval);
            return this;
        }
        /**
         * An in/out path for the read/write commands.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: write
         */
        default WekaEndpointBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Weka component.
     */
    public interface AdvancedWekaEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WekaEndpointBuilder basic() {
            return (WekaEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWekaEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWekaEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWekaEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWekaEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface WekaBuilders {
        /**
         * Weka (camel-weka)
         * Perform machine learning tasks using Weka.
         * 
         * Category: Datamining
         * Since: 3.1
         * Maven coordinates: org.apache.camel:camel-weka
         * 
         * Syntax: <code>weka:command</code>
         * 
         * Path parameter: command (required)
         * The command to use.
         * The value can be one of: filter, model, read, write, push, pop,
         * version
         */
        default WekaEndpointBuilder weka(String path) {
            return WekaEndpointBuilderFactory.weka(path);
        }
    }
    /**
     * Weka (camel-weka)
     * Perform machine learning tasks using Weka.
     * 
     * Category: Datamining
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-weka
     * 
     * Syntax: <code>weka:command</code>
     * 
     * Path parameter: command (required)
     * The command to use.
     * The value can be one of: filter, model, read, write, push, pop, version
     */
    static WekaEndpointBuilder weka(String path) {
        class WekaEndpointBuilderImpl extends AbstractEndpointBuilder implements WekaEndpointBuilder, AdvancedWekaEndpointBuilder {
            public WekaEndpointBuilderImpl(String path) {
                super("weka", path);
            }
        }
        return new WekaEndpointBuilderImpl(path);
    }
}