/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Expose JAX-RS REST services using Apache CXF or connect to external REST
 * services using CXF REST client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CxfRsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the CXF-RS component.
     */
    public interface CxfRsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCxfRsEndpointConsumerBuilder advanced() {
            return (AdvancedCxfRsEndpointConsumerBuilder) this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder features(List<Object> features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder features(String features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder loggingFeatureEnabled(
                boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder loggingFeatureEnabled(
                String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder loggingSizeLimit(
                int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder loggingSizeLimit(
                String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option is used to specify the model file which is useful for the
         * resource class without annotation. When using this option, then the
         * service class can be omitted, to emulate document-only endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder modelRef(String modelRef) {
            doSetProperty("modelRef", modelRef);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder providers(List<Object> providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder providers(String providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option is a:
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder resourceClasses(
                List<Class<Object>> resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder resourceClasses(
                String resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder schemaLocations(
                List<String> schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder schemaLocations(
                String schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder skipFaultLogging(
                boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointConsumerBuilder skipFaultLogging(
                String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * Sets how requests and responses will be mapped to/from Camel. Two
         * values are possible: SimpleConsumer: This binding style processes
         * request parameters, multiparts, etc. and maps them to IN headers, IN
         * attachments and to the message body. It aims to eliminate low-level
         * processing of org.apache.cxf.message.MessageContentsList. It also
         * also adds more flexibility and simplicity to the response mapping.
         * Only available for consumers. Default: The default style. For
         * consumers this passes on a MessageContentsList to the route,
         * requiring low-level processing in the route. This is the traditional
         * binding style, which simply dumps the
         * org.apache.cxf.message.MessageContentsList coming in from the CXF
         * stack onto the IN message body. The user is then responsible for
         * processing it according to the contract defined by the JAX-RS method
         * signature. Custom: allows you to specify a custom binding through the
         * binding option.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.BindingStyle</code> type.
         * 
         * Default: Default
         * Group: consumer
         */
        default CxfRsEndpointConsumerBuilder bindingStyle(
                BindingStyle bindingStyle) {
            doSetProperty("bindingStyle", bindingStyle);
            return this;
        }
        /**
         * Sets how requests and responses will be mapped to/from Camel. Two
         * values are possible: SimpleConsumer: This binding style processes
         * request parameters, multiparts, etc. and maps them to IN headers, IN
         * attachments and to the message body. It aims to eliminate low-level
         * processing of org.apache.cxf.message.MessageContentsList. It also
         * also adds more flexibility and simplicity to the response mapping.
         * Only available for consumers. Default: The default style. For
         * consumers this passes on a MessageContentsList to the route,
         * requiring low-level processing in the route. This is the traditional
         * binding style, which simply dumps the
         * org.apache.cxf.message.MessageContentsList coming in from the CXF
         * stack onto the IN message body. The user is then responsible for
         * processing it according to the contract defined by the JAX-RS method
         * signature. Custom: allows you to specify a custom binding through the
         * binding option.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.BindingStyle</code> type.
         * 
         * Default: Default
         * Group: consumer
         */
        default CxfRsEndpointConsumerBuilder bindingStyle(String bindingStyle) {
            doSetProperty("bindingStyle", bindingStyle);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CxfRsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CxfRsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * This option can override the endpointUrl that published from the WADL
         * which can be accessed with resource address url plus _wadl.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default CxfRsEndpointConsumerBuilder publishedEndpointUrl(
                String publishedEndpointUrl) {
            doSetProperty("publishedEndpointUrl", publishedEndpointUrl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the CXF-RS component.
     */
    public interface AdvancedCxfRsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CxfRsEndpointConsumerBuilder basic() {
            return (CxfRsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The service beans (the bean ids to lookup in the registry) which you
         * want to export as REST service. Multiple beans can be separated by
         * comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder serviceBeans(
                List<Object> serviceBeans) {
            doSetProperty("serviceBeans", serviceBeans);
            return this;
        }
        /**
         * The service beans (the bean ids to lookup in the registry) which you
         * want to export as REST service. Multiple beans can be separated by
         * comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCxfRsEndpointConsumerBuilder serviceBeans(
                String serviceBeans) {
            doSetProperty("serviceBeans", serviceBeans);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder bus(Object bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder continuationTimeout(
                long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder continuationTimeout(
                String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder cxfRsConfigurer(
                Object cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder cxfRsConfigurer(
                String cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder defaultBus(
                boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder defaultBus(
                String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder performInvocation(
                boolean performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder performInvocation(
                String performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder propagateContexts(
                boolean propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder propagateContexts(
                String propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the CXF-RS component.
     */
    public interface CxfRsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCxfRsEndpointProducerBuilder advanced() {
            return (AdvancedCxfRsEndpointProducerBuilder) this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder features(List<Object> features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder features(String features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointProducerBuilder loggingFeatureEnabled(
                boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointProducerBuilder loggingFeatureEnabled(
                String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder loggingSizeLimit(
                int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder loggingSizeLimit(
                String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option is used to specify the model file which is useful for the
         * resource class without annotation. When using this option, then the
         * service class can be omitted, to emulate document-only endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder modelRef(String modelRef) {
            doSetProperty("modelRef", modelRef);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder providers(List<Object> providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder providers(String providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option is a:
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder resourceClasses(
                List<Class<Object>> resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder resourceClasses(
                String resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder schemaLocations(
                List<String> schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointProducerBuilder schemaLocations(
                String schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointProducerBuilder skipFaultLogging(
                boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointProducerBuilder skipFaultLogging(
                String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder cookieHandler(Object cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.base.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder cookieHandler(String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * The hostname verifier to be used. Use the # notation to reference a
         * HostnameVerifier from the registry.
         * 
         * The option is a: <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder hostnameVerifier(
                Object hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * The hostname verifier to be used. Use the # notation to reference a
         * HostnameVerifier from the registry.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.HostnameVerifier</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder hostnameVerifier(
                String hostnameVerifier) {
            doSetProperty("hostnameVerifier", hostnameVerifier);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The Camel SSL setting reference. Use the # notation to reference the
         * SSL Context.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The Camel SSL setting reference. Use the # notation to reference the
         * SSL Context.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * This option tells the CxfRsProducer to inspect return codes and will
         * generate an Exception if the return code is larger than 207.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * This option tells the CxfRsProducer to inspect return codes and will
         * generate an Exception if the return code is larger than 207.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default CxfRsEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the CXF-RS component.
     */
    public interface AdvancedCxfRsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CxfRsEndpointProducerBuilder basic() {
            return (CxfRsEndpointProducerBuilder) this;
        }
        /**
         * If it is true, the CxfRsProducer will use the HttpClientAPI to invoke
         * the service. If it is false, the CxfRsProducer will use the
         * ProxyClientAPI to invoke the service.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder httpClientAPI(
                boolean httpClientAPI) {
            doSetProperty("httpClientAPI", httpClientAPI);
            return this;
        }
        /**
         * If it is true, the CxfRsProducer will use the HttpClientAPI to invoke
         * the service. If it is false, the CxfRsProducer will use the
         * ProxyClientAPI to invoke the service.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder httpClientAPI(
                String httpClientAPI) {
            doSetProperty("httpClientAPI", httpClientAPI);
            return this;
        }
        /**
         * This option is used to tell CxfRsProducer to ignore the message body
         * of the DELETE method when using HTTP API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder ignoreDeleteMethodMessageBody(
                boolean ignoreDeleteMethodMessageBody) {
            doSetProperty("ignoreDeleteMethodMessageBody", ignoreDeleteMethodMessageBody);
            return this;
        }
        /**
         * This option is used to tell CxfRsProducer to ignore the message body
         * of the DELETE method when using HTTP API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder ignoreDeleteMethodMessageBody(
                String ignoreDeleteMethodMessageBody) {
            doSetProperty("ignoreDeleteMethodMessageBody", ignoreDeleteMethodMessageBody);
            return this;
        }
        /**
         * This option allows you to configure the maximum size of the cache.
         * The implementation caches CXF clients or ClientFactoryBean in
         * CxfProvider and CxfRsProvider.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder maxClientCacheSize(
                int maxClientCacheSize) {
            doSetProperty("maxClientCacheSize", maxClientCacheSize);
            return this;
        }
        /**
         * This option allows you to configure the maximum size of the cache.
         * The implementation caches CXF clients or ClientFactoryBean in
         * CxfProvider and CxfRsProvider.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: producer (advanced)
         */
        default AdvancedCxfRsEndpointProducerBuilder maxClientCacheSize(
                String maxClientCacheSize) {
            doSetProperty("maxClientCacheSize", maxClientCacheSize);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder bus(Object bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder continuationTimeout(
                long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder continuationTimeout(
                String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder cxfRsConfigurer(
                Object cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder cxfRsConfigurer(
                String cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder defaultBus(
                boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder defaultBus(
                String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder performInvocation(
                boolean performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder performInvocation(
                String performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder propagateContexts(
                boolean propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder propagateContexts(
                String propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the CXF-RS component.
     */
    public interface CxfRsEndpointBuilder
            extends
                CxfRsEndpointConsumerBuilder,
                CxfRsEndpointProducerBuilder {
        default AdvancedCxfRsEndpointBuilder advanced() {
            return (AdvancedCxfRsEndpointBuilder) this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder features(List<Object> features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * Set the feature list to the CxfRs endpoint.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.apache.cxf.feature.Feature&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder features(String features) {
            doSetProperty("features", features);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointBuilder loggingFeatureEnabled(
                boolean loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * This option enables CXF Logging Feature which writes inbound and
         * outbound REST messages to log.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointBuilder loggingFeatureEnabled(
                String loggingFeatureEnabled) {
            doSetProperty("loggingFeatureEnabled", loggingFeatureEnabled);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder loggingSizeLimit(int loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * To limit the total size of number of bytes the logger will output
         * when logging feature has been enabled.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder loggingSizeLimit(String loggingSizeLimit) {
            doSetProperty("loggingSizeLimit", loggingSizeLimit);
            return this;
        }
        /**
         * This option is used to specify the model file which is useful for the
         * resource class without annotation. When using this option, then the
         * service class can be omitted, to emulate document-only endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder modelRef(String modelRef) {
            doSetProperty("modelRef", modelRef);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder providers(List<Object> providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can
         * specify a string with a list of providers to lookup in the registy
         * separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder providers(String providers) {
            doSetProperty("providers", providers);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option is a:
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder resourceClasses(
                List<Class<Object>> resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * The resource classes which you want to export as REST service.
         * Multiple classes can be separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.Class&lt;java.lang.Object&gt;&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder resourceClasses(String resourceClasses) {
            doSetProperty("resourceClasses", resourceClasses);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder schemaLocations(
                List<String> schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * Sets the locations of the schema(s) which can be used to validate the
         * incoming XML or JAXB-driven JSON.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default CxfRsEndpointBuilder schemaLocations(String schemaLocations) {
            doSetProperty("schemaLocations", schemaLocations);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointBuilder skipFaultLogging(boolean skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
        /**
         * This option controls whether the PhaseInterceptorChain skips logging
         * the Fault that it catches.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default CxfRsEndpointBuilder skipFaultLogging(String skipFaultLogging) {
            doSetProperty("skipFaultLogging", skipFaultLogging);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the CXF-RS component.
     */
    public interface AdvancedCxfRsEndpointBuilder
            extends
                AdvancedCxfRsEndpointConsumerBuilder,
                AdvancedCxfRsEndpointProducerBuilder {
        default CxfRsEndpointBuilder basic() {
            return (CxfRsEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom CxfBinding to control the binding between Camel
         * Message and CXF Message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option is a: <code>org.apache.cxf.Bus</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder bus(Object bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * To use a custom configured CXF Bus.
         * 
         * The option will be converted to a <code>org.apache.cxf.Bus</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder bus(String bus) {
            doSetProperty("bus", bus);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder continuationTimeout(
                long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option is used to set the CXF continuation timeout which could
         * be used in CxfConsumer by default when the CXF server is using Jetty
         * or Servlet transport.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder continuationTimeout(
                String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder cxfRsConfigurer(
                Object cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * This option could apply the implementation of
         * org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which
         * supports to configure the CXF endpoint in programmatic way. User can
         * configure the CXF server and client by implementing
         * configure{Server/Client} method of CxfEndpointConfigurer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cxf.jaxrs.CxfRsConfigurer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder cxfRsConfigurer(
                String cxfRsConfigurer) {
            doSetProperty("cxfRsConfigurer", cxfRsConfigurer);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder defaultBus(boolean defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * Will set the default bus when CXF endpoint create a bus by itself.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder defaultBus(String defaultBus) {
            doSetProperty("defaultBus", defaultBus);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder performInvocation(
                boolean performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, Camel will perform the invocation of the
         * resource class instance and put the response object into the exchange
         * for further processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder performInvocation(
                String performInvocation) {
            doSetProperty("performInvocation", performInvocation);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder propagateContexts(
                boolean propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * When the option is true, JAXRS UriInfo, HttpHeaders, Request and
         * SecurityContext contexts will be available to custom CXFRS processors
         * as typed Camel exchange properties. These contexts can be used to
         * analyze the current requests using JAX-RS API.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder propagateContexts(
                String propagateContexts) {
            doSetProperty("propagateContexts", propagateContexts);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCxfRsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.cxf.jaxrs.BindingStyle</code> enum.
     */
    enum BindingStyle {
        SimpleConsumer,
        Default,
        Custom;
    }

    public interface CxfRsBuilders {
        /**
         * CXF-RS (camel-cxf)
         * Expose JAX-RS REST services using Apache CXF or connect to external
         * REST services using CXF REST client.
         * 
         * Category: rest
         * Since: 2.0
         * Maven coordinates: org.apache.camel:camel-cxf
         * 
         * Syntax: <code>cxfrs:beanId:address</code>
         * 
         * Path parameter: beanId
         * To lookup an existing configured CxfRsEndpoint. Must used bean: as
         * prefix.
         * 
         * Path parameter: address
         * The service publish address.
         */
        default CxfRsEndpointBuilder cxfrs(String path) {
            return CxfRsEndpointBuilderFactory.cxfrs(path);
        }
    }
    /**
     * CXF-RS (camel-cxf)
     * Expose JAX-RS REST services using Apache CXF or connect to external REST
     * services using CXF REST client.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf
     * 
     * Syntax: <code>cxfrs:beanId:address</code>
     * 
     * Path parameter: beanId
     * To lookup an existing configured CxfRsEndpoint. Must used bean: as
     * prefix.
     * 
     * Path parameter: address
     * The service publish address.
     */
    static CxfRsEndpointBuilder cxfrs(String path) {
        class CxfRsEndpointBuilderImpl extends AbstractEndpointBuilder implements CxfRsEndpointBuilder, AdvancedCxfRsEndpointBuilder {
            public CxfRsEndpointBuilderImpl(String path) {
                super("cxfrs", path);
            }
        }
        return new CxfRsEndpointBuilderImpl(path);
    }
}