/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kafka.KafkaComponent;

/**
 * Sent and receive messages to/from an Apache Kafka broker.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface KafkaComponentBuilderFactory {

    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     */
    static KafkaComponentBuilder kafka() {
        return new KafkaComponentBuilderImpl();
    }

    /**
     * Builder for the Kafka component.
     */
    interface KafkaComponentBuilder extends ComponentBuilder<KafkaComponent> {
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map<java.lang.String,
         * java.lang.Object></code> type.
         * 
         * Group: common
         */
        default KafkaComponentBuilder additionalProperties(
                java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * URL of the Kafka brokers to use. The format is
         * host1:port1,host2:port2, and the list can be a subset of brokers or a
         * VIP pointing to a subset of brokers. This option is known as
         * bootstrap.servers in the Kafka documentation.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default KafkaComponentBuilder brokers(java.lang.String brokers) {
            doSetProperty("brokers", brokers);
            return this;
        }
        /**
         * The client id is a user-specified string sent in each request to help
         * trace calls. It should logically identify the application making the
         * request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default KafkaComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Allows to pre-configure the Kafka component with common options that
         * the endpoints will reuse.
         * 
         * The option is a:
         * <code>org.apache.camel.component.kafka.KafkaConfiguration</code>
         * type.
         * 
         * Group: common
         */
        default KafkaComponentBuilder configuration(
                org.apache.camel.component.kafka.KafkaConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default KafkaComponentBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1000
         * Group: common
         */
        default KafkaComponentBuilder reconnectBackoffMaxMs(
                java.lang.Integer reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * Timeout in milli seconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30000
         * Group: common
         */
        default KafkaComponentBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Whether to allow doing manual commits via KafkaManualCommit. If this
         * option is enabled then an instance of KafkaManualCommit is stored on
         * the Exchange message header, which allows end users to access this
         * API and perform manual offset commits via the Kafka consumer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default KafkaComponentBuilder allowManualCommit(
                boolean allowManualCommit) {
            doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }
        /**
         * If true, periodically commit to ZooKeeper the offset of messages
         * already fetched by the consumer. This committed offset will be used
         * when the process fails as the position from which the new consumer
         * will begin.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default KafkaComponentBuilder autoCommitEnable(
                java.lang.Boolean autoCommitEnable) {
            doSetProperty("autoCommitEnable", autoCommitEnable);
            return this;
        }
        /**
         * The frequency in ms that the consumer offsets are committed to
         * zookeeper.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5000
         * Group: consumer
         */
        default KafkaComponentBuilder autoCommitIntervalMs(
                java.lang.Integer autoCommitIntervalMs) {
            doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }
        /**
         * Whether to perform an explicit auto commit when the consumer stops to
         * ensure the broker has a commit from the last consumed message. This
         * requires the option autoCommitEnable is turned on. The possible
         * values are: sync, async, or none. And sync is the default value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: sync
         * Group: consumer
         */
        default KafkaComponentBuilder autoCommitOnStop(
                java.lang.String autoCommitOnStop) {
            doSetProperty("autoCommitOnStop", autoCommitOnStop);
            return this;
        }
        /**
         * What to do when there is no initial offset in ZooKeeper or if an
         * offset is out of range: earliest : automatically reset the offset to
         * the earliest offset latest : automatically reset the offset to the
         * latest offset fail: throw exception to the consumer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: latest
         * Group: consumer
         */
        default KafkaComponentBuilder autoOffsetReset(
                java.lang.String autoOffsetReset) {
            doSetProperty("autoOffsetReset", autoOffsetReset);
            return this;
        }
        /**
         * This options controls what happens when a consumer is processing an
         * exchange and it fails. If the option is false then the consumer
         * continues to the next message and processes it. If the option is true
         * then the consumer breaks out, and will seek back to offset of the
         * message that caused a failure, and then re-attempt to process this
         * message. However this can lead to endless processing of the same
         * message if its bound to fail every time, eg a poison message.
         * Therefore its recommended to deal with that for example by using
         * Camel's error handler.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default KafkaComponentBuilder breakOnFirstError(
                boolean breakOnFirstError) {
            doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default KafkaComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Automatically check the CRC32 of the records consumed. This ensures
         * no on-the-wire or on-disk corruption to the messages occurred. This
         * check adds some overhead, so it may be disabled in cases seeking
         * extreme performance.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default KafkaComponentBuilder checkCrcs(java.lang.Boolean checkCrcs) {
            doSetProperty("checkCrcs", checkCrcs);
            return this;
        }
        /**
         * The configuration controls the maximum amount of time the client will
         * wait for the response of a request. If the response is not received
         * before the timeout elapses the client will resend the request if
         * necessary or fail the request if retries are exhausted.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 40000
         * Group: consumer
         */
        default KafkaComponentBuilder consumerRequestTimeoutMs(
                java.lang.Integer consumerRequestTimeoutMs) {
            doSetProperty("consumerRequestTimeoutMs", consumerRequestTimeoutMs);
            return this;
        }
        /**
         * The number of consumers that connect to kafka server.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default KafkaComponentBuilder consumersCount(int consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * Number of concurrent consumers on the consumer.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         */
        default KafkaComponentBuilder consumerStreams(int consumerStreams) {
            doSetProperty("consumerStreams", consumerStreams);
            return this;
        }
        /**
         * The maximum amount of data the server should return for a fetch
         * request This is not an absolute maximum, if the first message in the
         * first non-empty partition of the fetch is larger than this value, the
         * message will still be returned to ensure that the consumer can make
         * progress. The maximum message size accepted by the broker is defined
         * via message.max.bytes (broker config) or max.message.bytes (topic
         * config). Note that the consumer performs multiple fetches in
         * parallel.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 52428800
         * Group: consumer
         */
        default KafkaComponentBuilder fetchMaxBytes(
                java.lang.Integer fetchMaxBytes) {
            doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }
        /**
         * The minimum amount of data the server should return for a fetch
         * request. If insufficient data is available the request will wait for
         * that much data to accumulate before answering the request.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1
         * Group: consumer
         */
        default KafkaComponentBuilder fetchMinBytes(
                java.lang.Integer fetchMinBytes) {
            doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }
        /**
         * The maximum amount of time the server will block before answering the
         * fetch request if there isn't sufficient data to immediately satisfy
         * fetch.min.bytes.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 500
         * Group: consumer
         */
        default KafkaComponentBuilder fetchWaitMaxMs(
                java.lang.Integer fetchWaitMaxMs) {
            doSetProperty("fetchWaitMaxMs", fetchWaitMaxMs);
            return this;
        }
        /**
         * A string that uniquely identifies the group of consumer processes to
         * which this consumer belongs. By setting the same group id multiple
         * processes indicate that they are all part of the same consumer group.
         * This option is required for consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default KafkaComponentBuilder groupId(java.lang.String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * The expected time between heartbeats to the consumer coordinator when
         * using Kafka's group management facilities. Heartbeats are used to
         * ensure that the consumer's session stays active and to facilitate
         * rebalancing when new consumers join or leave the group. The value
         * must be set lower than session.timeout.ms, but typically should be
         * set no higher than 1/3 of that value. It can be adjusted even lower
         * to control the expected time for normal rebalances.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 3000
         * Group: consumer
         */
        default KafkaComponentBuilder heartbeatIntervalMs(
                java.lang.Integer heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * To use a custom KafkaHeaderDeserializer to deserialize kafka headers
         * values.
         * 
         * The option is a:
         * <code>org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer</code> type.
         * 
         * Group: consumer
         */
        default KafkaComponentBuilder kafkaHeaderDeserializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer kafkaHeaderDeserializer) {
            doSetProperty("kafkaHeaderDeserializer", kafkaHeaderDeserializer);
            return this;
        }
        /**
         * Deserializer class for key that implements the Deserializer
         * interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         */
        default KafkaComponentBuilder keyDeserializer(
                java.lang.String keyDeserializer) {
            doSetProperty("keyDeserializer", keyDeserializer);
            return this;
        }
        /**
         * The maximum amount of data per-partition the server will return. The
         * maximum total memory used for a request will be #partitions
         * max.partition.fetch.bytes. This size must be at least as large as the
         * maximum message size the server allows or else it is possible for the
         * producer to send messages larger than the consumer can fetch. If that
         * happens, the consumer can get stuck trying to fetch a large message
         * on a certain partition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1048576
         * Group: consumer
         */
        default KafkaComponentBuilder maxPartitionFetchBytes(
                java.lang.Integer maxPartitionFetchBytes) {
            doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }
        /**
         * The maximum delay between invocations of poll() when using consumer
         * group management. This places an upper bound on the amount of time
         * that the consumer can be idle before fetching more records. If poll()
         * is not called before expiration of this timeout, then the consumer is
         * considered failed and the group will rebalance in order to reassign
         * the partitions to another member.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default KafkaComponentBuilder maxPollIntervalMs(
                java.lang.Long maxPollIntervalMs) {
            doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }
        /**
         * The maximum number of records returned in a single call to poll().
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 500
         * Group: consumer
         */
        default KafkaComponentBuilder maxPollRecords(
                java.lang.Integer maxPollRecords) {
            doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }
        /**
         * The offset repository to use in order to locally store the offset of
         * each partition of the topic. Defining one will disable the
         * autocommit.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.StateRepository<java.lang.String,
         * java.lang.String></code> type.
         * 
         * Group: consumer
         */
        default KafkaComponentBuilder offsetRepository(
                org.apache.camel.spi.StateRepository<java.lang.String, java.lang.String> offsetRepository) {
            doSetProperty("offsetRepository", offsetRepository);
            return this;
        }
        /**
         * The class name of the partition assignment strategy that the client
         * will use to distribute partition ownership amongst consumer instances
         * when group management is used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.clients.consumer.RangeAssignor
         * Group: consumer
         */
        default KafkaComponentBuilder partitionAssignor(
                java.lang.String partitionAssignor) {
            doSetProperty("partitionAssignor", partitionAssignor);
            return this;
        }
        /**
         * The timeout used when polling the KafkaConsumer.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         */
        default KafkaComponentBuilder pollTimeoutMs(java.lang.Long pollTimeoutMs) {
            doSetProperty("pollTimeoutMs", pollTimeoutMs);
            return this;
        }
        /**
         * Set if KafkaConsumer will read from beginning or end on startup:
         * beginning : read from beginning end : read from end This is replacing
         * the earlier property seekToBeginning.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default KafkaComponentBuilder seekTo(java.lang.String seekTo) {
            doSetProperty("seekTo", seekTo);
            return this;
        }
        /**
         * The timeout used to detect failures when using Kafka's group
         * management facilities.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: consumer
         */
        default KafkaComponentBuilder sessionTimeoutMs(
                java.lang.Integer sessionTimeoutMs) {
            doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }
        /**
         * This enables the use of a specific Avro reader for use with the
         * Confluent Platform schema registry and the
         * io.confluent.kafka.serializers.KafkaAvroDeserializer. This option is
         * only available in the Confluent Platform (not standard Apache Kafka).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default KafkaComponentBuilder specificAvroReader(
                boolean specificAvroReader) {
            doSetProperty("specificAvroReader", specificAvroReader);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression). This can be used
         * to subscribe to dynamic number of topics matching the pattern.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default KafkaComponentBuilder topicIsPattern(boolean topicIsPattern) {
            doSetProperty("topicIsPattern", topicIsPattern);
            return this;
        }
        /**
         * Deserializer class for value that implements the Deserializer
         * interface.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         */
        default KafkaComponentBuilder valueDeserializer(
                java.lang.String valueDeserializer) {
            doSetProperty("valueDeserializer", valueDeserializer);
            return this;
        }
        /**
         * Factory to use for creating KafkaManualCommit instances. This allows
         * to plugin a custom factory to create custom KafkaManualCommit
         * instances in case special logic is needed when doing manual commits
         * that deviates from the default implementation that comes out of the
         * box.
         * 
         * The option is a:
         * <code>org.apache.camel.component.kafka.KafkaManualCommitFactory</code> type.
         * 
         * Group: consumer (advanced)
         */
        default KafkaComponentBuilder kafkaManualCommitFactory(
                org.apache.camel.component.kafka.KafkaManualCommitFactory kafkaManualCommitFactory) {
            doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }
        /**
         * The total bytes of memory the producer can use to buffer records
         * waiting to be sent to the server. If records are sent faster than
         * they can be delivered to the server the producer will either block or
         * throw an exception based on the preference specified by
         * block.on.buffer.full.This setting should correspond roughly to the
         * total memory the producer will use, but is not a hard bound since not
         * all memory the producer uses is used for buffering. Some additional
         * memory will be used for compression (if compression is enabled) as
         * well as for maintaining in-flight requests.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 33554432
         * Group: producer
         */
        default KafkaComponentBuilder bufferMemorySize(
                java.lang.Integer bufferMemorySize) {
            doSetProperty("bufferMemorySize", bufferMemorySize);
            return this;
        }
        /**
         * This parameter allows you to specify the compression codec for all
         * data generated by this producer. Valid values are none, gzip and
         * snappy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: producer
         */
        default KafkaComponentBuilder compressionCodec(
                java.lang.String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * Close idle connections after the number of milliseconds specified by
         * this config.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 540000
         * Group: producer
         */
        default KafkaComponentBuilder connectionMaxIdleMs(
                java.lang.Integer connectionMaxIdleMs) {
            doSetProperty("connectionMaxIdleMs", connectionMaxIdleMs);
            return this;
        }
        /**
         * If set to 'true' the producer will ensure that exactly one copy of
         * each message is written in the stream. If 'false', producer retries
         * may write duplicates of the retried message in the stream. If set to
         * true this option will require max.in.flight.requests.per.connection
         * to be set to 1 and retries cannot be zero and additionally acks must
         * be set to 'all'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default KafkaComponentBuilder enableIdempotence(
                boolean enableIdempotence) {
            doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }
        /**
         * To use a custom KafkaHeaderSerializer to serialize kafka headers
         * values.
         * 
         * The option is a:
         * <code>org.apache.camel.component.kafka.serde.KafkaHeaderSerializer</code> type.
         * 
         * Group: producer
         */
        default KafkaComponentBuilder kafkaHeaderSerializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderSerializer kafkaHeaderSerializer) {
            doSetProperty("kafkaHeaderSerializer", kafkaHeaderSerializer);
            return this;
        }
        /**
         * The record key (or null if no key is specified). If this option has
         * been configured then it take precedence over header
         * KafkaConstants#KEY.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default KafkaComponentBuilder key(java.lang.String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The serializer class for keys (defaults to the same as for messages
         * if nothing is given).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         */
        default KafkaComponentBuilder keySerializerClass(
                java.lang.String keySerializerClass) {
            doSetProperty("keySerializerClass", keySerializerClass);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default KafkaComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The producer groups together any records that arrive in between
         * request transmissions into a single batched request. Normally this
         * occurs only under load when records arrive faster than they can be
         * sent out. However in some circumstances the client may want to reduce
         * the number of requests even under moderate load. This setting
         * accomplishes this by adding a small amount of artificial delay that
         * is, rather than immediately sending out a record the producer will
         * wait for up to the given delay to allow other records to be sent so
         * that the sends can be batched together. This can be thought of as
         * analogous to Nagle's algorithm in TCP. This setting gives the upper
         * bound on the delay for batching: once we get batch.size worth of
         * records for a partition it will be sent immediately regardless of
         * this setting, however if we have fewer than this many bytes
         * accumulated for this partition we will 'linger' for the specified
         * time waiting for more records to show up. This setting defaults to 0
         * (i.e. no delay). Setting linger.ms=5, for example, would have the
         * effect of reducing the number of requests sent but would add up to
         * 5ms of latency to records sent in the absense of load.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default KafkaComponentBuilder lingerMs(java.lang.Integer lingerMs) {
            doSetProperty("lingerMs", lingerMs);
            return this;
        }
        /**
         * The configuration controls how long sending to kafka will block.
         * These methods can be blocked for multiple reasons. For e.g: buffer
         * full, metadata unavailable.This configuration imposes maximum limit
         * on the total time spent in fetching metadata, serialization of key
         * and value, partitioning and allocation of buffer memory when doing a
         * send(). In case of partitionsFor(), this configuration imposes a
         * maximum time threshold on waiting for metadata.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 60000
         * Group: producer
         */
        default KafkaComponentBuilder maxBlockMs(java.lang.Integer maxBlockMs) {
            doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }
        /**
         * The maximum number of unacknowledged requests the client will send on
         * a single connection before blocking. Note that if this setting is set
         * to be greater than 1 and there are failed sends, there is a risk of
         * message re-ordering due to retries (i.e., if retries are enabled).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: producer
         */
        default KafkaComponentBuilder maxInFlightRequest(
                java.lang.Integer maxInFlightRequest) {
            doSetProperty("maxInFlightRequest", maxInFlightRequest);
            return this;
        }
        /**
         * The maximum size of a request. This is also effectively a cap on the
         * maximum record size. Note that the server has its own cap on record
         * size which may be different from this. This setting will limit the
         * number of record batches the producer will send in a single request
         * to avoid sending huge requests.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1048576
         * Group: producer
         */
        default KafkaComponentBuilder maxRequestSize(
                java.lang.Integer maxRequestSize) {
            doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }
        /**
         * The period of time in milliseconds after which we force a refresh of
         * metadata even if we haven't seen any partition leadership changes to
         * proactively discover any new brokers or partitions.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 300000
         * Group: producer
         */
        default KafkaComponentBuilder metadataMaxAgeMs(
                java.lang.Integer metadataMaxAgeMs) {
            doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }
        /**
         * A list of classes to use as metrics reporters. Implementing the
         * MetricReporter interface allows plugging in classes that will be
         * notified of new metric creation. The JmxReporter is always included
         * to register JMX statistics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default KafkaComponentBuilder metricReporters(
                java.lang.String metricReporters) {
            doSetProperty("metricReporters", metricReporters);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 30000
         * Group: producer
         */
        default KafkaComponentBuilder metricsSampleWindowMs(
                java.lang.Integer metricsSampleWindowMs) {
            doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2
         * Group: producer
         */
        default KafkaComponentBuilder noOfMetricsSample(
                java.lang.Integer noOfMetricsSample) {
            doSetProperty("noOfMetricsSample", noOfMetricsSample);
            return this;
        }
        /**
         * The partitioner class for partitioning messages amongst sub-topics.
         * The default partitioner is based on the hash of the key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * org.apache.kafka.clients.producer.internals.DefaultPartitioner
         * Group: producer
         */
        default KafkaComponentBuilder partitioner(java.lang.String partitioner) {
            doSetProperty("partitioner", partitioner);
            return this;
        }
        /**
         * The partition to which the record will be sent (or null if no
         * partition was specified). If this option has been configured then it
         * take precedence over header KafkaConstants#PARTITION_KEY.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         */
        default KafkaComponentBuilder partitionKey(
                java.lang.Integer partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * The producer will attempt to batch records together into fewer
         * requests whenever multiple records are being sent to the same
         * partition. This helps performance on both the client and the server.
         * This configuration controls the default batch size in bytes. No
         * attempt will be made to batch records larger than this size.Requests
         * sent to brokers will contain multiple batches, one for each partition
         * with data available to be sent.A small batch size will make batching
         * less common and may reduce throughput (a batch size of zero will
         * disable batching entirely). A very large batch size may use memory a
         * bit more wastefully as we will always allocate a buffer of the
         * specified batch size in anticipation of additional records.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 16384
         * Group: producer
         */
        default KafkaComponentBuilder producerBatchSize(
                java.lang.Integer producerBatchSize) {
            doSetProperty("producerBatchSize", producerBatchSize);
            return this;
        }
        /**
         * The maximum number of unsent messages that can be queued up the
         * producer when using async mode before either the producer must be
         * blocked or data must be dropped.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: producer
         */
        default KafkaComponentBuilder queueBufferingMaxMessages(
                java.lang.Integer queueBufferingMaxMessages) {
            doSetProperty("queueBufferingMaxMessages", queueBufferingMaxMessages);
            return this;
        }
        /**
         * The size of the TCP receive buffer (SO_RCVBUF) to use when reading
         * data.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 65536
         * Group: producer
         */
        default KafkaComponentBuilder receiveBufferBytes(
                java.lang.Integer receiveBufferBytes) {
            doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }
        /**
         * The amount of time to wait before attempting to reconnect to a given
         * host. This avoids repeatedly connecting to a host in a tight loop.
         * This backoff applies to all requests sent by the consumer to the
         * broker.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 50
         * Group: producer
         */
        default KafkaComponentBuilder reconnectBackoffMs(
                java.lang.Integer reconnectBackoffMs) {
            doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }
        /**
         * Whether the producer should store the RecordMetadata results from
         * sending to Kafka. The results are stored in a List containing the
         * RecordMetadata metadata's. The list is stored on a header with the
         * key KafkaConstants#KAFKA_RECORDMETA.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default KafkaComponentBuilder recordMetadata(boolean recordMetadata) {
            doSetProperty("recordMetadata", recordMetadata);
            return this;
        }
        /**
         * The number of acknowledgments the producer requires the leader to
         * have received before considering a request complete. This controls
         * the durability of records that are sent. The following settings are
         * common: acks=0 If set to zero then the producer will not wait for any
         * acknowledgment from the server at all. The record will be immediately
         * added to the socket buffer and considered sent. No guarantee can be
         * made that the server has received the record in this case, and the
         * retries configuration will not take effect (as the client won't
         * generally know of any failures). The offset given back for each
         * record will always be set to -1. acks=1 This will mean the leader
         * will write the record to its local log but will respond without
         * awaiting full acknowledgement from all followers. In this case should
         * the leader fail immediately after acknowledging the record but before
         * the followers have replicated it then the record will be lost.
         * acks=all This means the leader will wait for the full set of in-sync
         * replicas to acknowledge the record. This guarantees that the record
         * will not be lost as long as at least one in-sync replica remains
         * alive. This is the strongest available guarantee.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 1
         * Group: producer
         */
        default KafkaComponentBuilder requestRequiredAcks(
                java.lang.String requestRequiredAcks) {
            doSetProperty("requestRequiredAcks", requestRequiredAcks);
            return this;
        }
        /**
         * The amount of time the broker will wait trying to meet the
         * request.required.acks requirement before sending back an error to the
         * client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 30000
         * Group: producer
         */
        default KafkaComponentBuilder requestTimeoutMs(
                java.lang.Integer requestTimeoutMs) {
            doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }
        /**
         * Setting a value greater than zero will cause the client to resend any
         * record whose send fails with a potentially transient error. Note that
         * this retry is no different than if the client resent the record upon
         * receiving the error. Allowing retries will potentially change the
         * ordering of records because if two records are sent to a single
         * partition, and the first fails and is retried but the second
         * succeeds, then the second record may appear first.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 0
         * Group: producer
         */
        default KafkaComponentBuilder retries(java.lang.Integer retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Before each retry, the producer refreshes the metadata of relevant
         * topics to see if a new leader has been elected. Since leader election
         * takes a bit of time, this property specifies the amount of time that
         * the producer waits before refreshing the metadata.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 100
         * Group: producer
         */
        default KafkaComponentBuilder retryBackoffMs(
                java.lang.Integer retryBackoffMs) {
            doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }
        /**
         * Socket write buffer size.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 131072
         * Group: producer
         */
        default KafkaComponentBuilder sendBufferBytes(
                java.lang.Integer sendBufferBytes) {
            doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }
        /**
         * The serializer class for messages.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         */
        default KafkaComponentBuilder serializerClass(
                java.lang.String serializerClass) {
            doSetProperty("serializerClass", serializerClass);
            return this;
        }
        /**
         * To use a custom worker pool for continue routing Exchange after kafka
         * server has acknowledge the message that was sent to it from
         * KafkaProducer using asynchronous non-blocking processing. If using
         * this option then you must handle the lifecycle of the thread pool to
         * shut the pool down when no longer needed.
         * 
         * The option is a: <code>java.util.concurrent.ExecutorService</code>
         * type.
         * 
         * Group: producer
         */
        default KafkaComponentBuilder workerPool(
                java.util.concurrent.ExecutorService workerPool) {
            doSetProperty("workerPool", workerPool);
            return this;
        }
        /**
         * Number of core threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10
         * Group: producer
         */
        default KafkaComponentBuilder workerPoolCoreSize(
                java.lang.Integer workerPoolCoreSize) {
            doSetProperty("workerPoolCoreSize", workerPoolCoreSize);
            return this;
        }
        /**
         * Maximum number of threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20
         * Group: producer
         */
        default KafkaComponentBuilder workerPoolMaxSize(
                java.lang.Integer workerPoolMaxSize) {
            doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default KafkaComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * URL of the Confluent Platform schema registry servers to use. The
         * format is host1:port1,host2:port2. This is known as
         * schema.registry.url in the Confluent Platform documentation. This
         * option is only available in the Confluent Platform (not standard
         * Apache Kafka).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: confluent
         */
        default KafkaComponentBuilder schemaRegistryURL(
                java.lang.String schemaRegistryURL) {
            doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }
        /**
         * Sets interceptors for producer or consumers. Producer interceptors
         * have to be classes implementing
         * org.apache.kafka.clients.producer.ProducerInterceptor Consumer
         * interceptors have to be classes implementing
         * org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if
         * you use Producer interceptor on a consumer it will throw a class cast
         * exception in runtime.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: monitoring
         */
        default KafkaComponentBuilder interceptorClasses(
                java.lang.String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 60000
         * Group: security
         */
        default KafkaComponentBuilder kerberosBeforeReloginMinTime(
                java.lang.Integer kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Kerberos kinit command path. Default is /usr/bin/kinit.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         */
        default KafkaComponentBuilder kerberosInitCmd(
                java.lang.String kerberosInitCmd) {
            doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }
        /**
         * A list of rules for mapping from principal names to short names
         * (typically operating system usernames). The rules are evaluated in
         * order and the first rule that matches a principal name is used to map
         * it to a short name. Any later rules in the list are ignored. By
         * default, principal names of the form {username}/{hostname}{REALM} are
         * mapped to {username}. For more details on the format please see the
         * security authorization and acls documentation.. Multiple values can
         * be separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: DEFAULT
         * Group: security
         */
        default KafkaComponentBuilder kerberosPrincipalToLocalRules(
                java.lang.String kerberosPrincipalToLocalRules) {
            doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Default: 0.05
         * Group: security
         */
        default KafkaComponentBuilder kerberosRenewJitter(
                java.lang.Double kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Default: 0.8
         * Group: security
         */
        default KafkaComponentBuilder kerberosRenewWindowFactor(
                java.lang.Double kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Expose the kafka sasl.jaas.config parameter Example:
         * org.apache.kafka.common.security.plain.PlainLoginModule required
         * username=USERNAME password=PASSWORD;.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder saslJaasConfig(
                java.lang.String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder saslKerberosServiceName(
                java.lang.String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * The Simple Authentication and Security Layer (SASL) Mechanism used.
         * For the valid values see
         * http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: GSSAPI
         * Group: security
         */
        default KafkaComponentBuilder saslMechanism(
                java.lang.String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT
         * and SSL are supported.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: PLAINTEXT
         * Group: security
         */
        default KafkaComponentBuilder securityProtocol(
                java.lang.String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol.By default all the available cipher suites are
         * supported.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslCipherSuites(
                java.lang.String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1
         * and TLSv1 are enabled by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TLSv1.2
         * Group: security
         */
        default KafkaComponentBuilder sslEnabledProtocols(
                java.lang.String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslEndpointAlgorithm(
                java.lang.String sslEndpointAlgorithm) {
            doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: SunX509
         * Group: security
         */
        default KafkaComponentBuilder sslKeymanagerAlgorithm(
                java.lang.String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The password of the private key in the key store file. This is
         * optional for client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslKeyPassword(
                java.lang.String sslKeyPassword) {
            doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }
        /**
         * The location of the key store file. This is optional for client and
         * can be used for two-way authentication for client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslKeystoreLocation(
                java.lang.String sslKeystoreLocation) {
            doSetProperty("sslKeystoreLocation", sslKeystoreLocation);
            return this;
        }
        /**
         * The store password for the key store file.This is optional for client
         * and only needed if ssl.keystore.location is configured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslKeystorePassword(
                java.lang.String sslKeystorePassword) {
            doSetProperty("sslKeystorePassword", sslKeystorePassword);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * Default value is JKS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: JKS
         * Group: security
         */
        default KafkaComponentBuilder sslKeystoreType(
                java.lang.String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. Default setting is
         * TLS, which is fine for most cases. Allowed values in recent JVMs are
         * TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in
         * older JVMs, but their usage is discouraged due to known security
         * vulnerabilities.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TLSv1.2
         * Group: security
         */
        default KafkaComponentBuilder sslProtocol(java.lang.String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslProvider(java.lang.String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: PKIX
         * Group: security
         */
        default KafkaComponentBuilder sslTrustmanagerAlgorithm(
                java.lang.String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The location of the trust store file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslTruststoreLocation(
                java.lang.String sslTruststoreLocation) {
            doSetProperty("sslTruststoreLocation", sslTruststoreLocation);
            return this;
        }
        /**
         * The password for the trust store file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default KafkaComponentBuilder sslTruststorePassword(
                java.lang.String sslTruststorePassword) {
            doSetProperty("sslTruststorePassword", sslTruststorePassword);
            return this;
        }
        /**
         * The file format of the trust store file. Default value is JKS.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: JKS
         * Group: security
         */
        default KafkaComponentBuilder sslTruststoreType(
                java.lang.String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default KafkaComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class KafkaComponentBuilderImpl
            extends
                AbstractComponentBuilder<KafkaComponent>
            implements
                KafkaComponentBuilder {
        @Override
        protected KafkaComponent buildConcreteComponent() {
            return new KafkaComponent();
        }
        private org.apache.camel.component.kafka.KafkaConfiguration getOrCreateConfiguration(
                org.apache.camel.component.kafka.KafkaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.kafka.KafkaConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((KafkaComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "brokers": getOrCreateConfiguration((KafkaComponent) component).setBrokers((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((KafkaComponent) component).setClientId((java.lang.String) value); return true;
            case "configuration": ((KafkaComponent) component).setConfiguration((org.apache.camel.component.kafka.KafkaConfiguration) value); return true;
            case "headerFilterStrategy": getOrCreateConfiguration((KafkaComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "reconnectBackoffMaxMs": getOrCreateConfiguration((KafkaComponent) component).setReconnectBackoffMaxMs((java.lang.Integer) value); return true;
            case "shutdownTimeout": getOrCreateConfiguration((KafkaComponent) component).setShutdownTimeout((int) value); return true;
            case "allowManualCommit": getOrCreateConfiguration((KafkaComponent) component).setAllowManualCommit((boolean) value); return true;
            case "autoCommitEnable": getOrCreateConfiguration((KafkaComponent) component).setAutoCommitEnable((java.lang.Boolean) value); return true;
            case "autoCommitIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setAutoCommitIntervalMs((java.lang.Integer) value); return true;
            case "autoCommitOnStop": getOrCreateConfiguration((KafkaComponent) component).setAutoCommitOnStop((java.lang.String) value); return true;
            case "autoOffsetReset": getOrCreateConfiguration((KafkaComponent) component).setAutoOffsetReset((java.lang.String) value); return true;
            case "breakOnFirstError": getOrCreateConfiguration((KafkaComponent) component).setBreakOnFirstError((boolean) value); return true;
            case "bridgeErrorHandler": ((KafkaComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "checkCrcs": getOrCreateConfiguration((KafkaComponent) component).setCheckCrcs((java.lang.Boolean) value); return true;
            case "consumerRequestTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setConsumerRequestTimeoutMs((java.lang.Integer) value); return true;
            case "consumersCount": getOrCreateConfiguration((KafkaComponent) component).setConsumersCount((int) value); return true;
            case "consumerStreams": getOrCreateConfiguration((KafkaComponent) component).setConsumerStreams((int) value); return true;
            case "fetchMaxBytes": getOrCreateConfiguration((KafkaComponent) component).setFetchMaxBytes((java.lang.Integer) value); return true;
            case "fetchMinBytes": getOrCreateConfiguration((KafkaComponent) component).setFetchMinBytes((java.lang.Integer) value); return true;
            case "fetchWaitMaxMs": getOrCreateConfiguration((KafkaComponent) component).setFetchWaitMaxMs((java.lang.Integer) value); return true;
            case "groupId": getOrCreateConfiguration((KafkaComponent) component).setGroupId((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setHeartbeatIntervalMs((java.lang.Integer) value); return true;
            case "kafkaHeaderDeserializer": getOrCreateConfiguration((KafkaComponent) component).setKafkaHeaderDeserializer((org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer) value); return true;
            case "keyDeserializer": getOrCreateConfiguration((KafkaComponent) component).setKeyDeserializer((java.lang.String) value); return true;
            case "maxPartitionFetchBytes": getOrCreateConfiguration((KafkaComponent) component).setMaxPartitionFetchBytes((java.lang.Integer) value); return true;
            case "maxPollIntervalMs": getOrCreateConfiguration((KafkaComponent) component).setMaxPollIntervalMs((java.lang.Long) value); return true;
            case "maxPollRecords": getOrCreateConfiguration((KafkaComponent) component).setMaxPollRecords((java.lang.Integer) value); return true;
            case "offsetRepository": getOrCreateConfiguration((KafkaComponent) component).setOffsetRepository((org.apache.camel.spi.StateRepository) value); return true;
            case "partitionAssignor": getOrCreateConfiguration((KafkaComponent) component).setPartitionAssignor((java.lang.String) value); return true;
            case "pollTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setPollTimeoutMs((java.lang.Long) value); return true;
            case "seekTo": getOrCreateConfiguration((KafkaComponent) component).setSeekTo((java.lang.String) value); return true;
            case "sessionTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setSessionTimeoutMs((java.lang.Integer) value); return true;
            case "specificAvroReader": getOrCreateConfiguration((KafkaComponent) component).setSpecificAvroReader((boolean) value); return true;
            case "topicIsPattern": getOrCreateConfiguration((KafkaComponent) component).setTopicIsPattern((boolean) value); return true;
            case "valueDeserializer": getOrCreateConfiguration((KafkaComponent) component).setValueDeserializer((java.lang.String) value); return true;
            case "kafkaManualCommitFactory": ((KafkaComponent) component).setKafkaManualCommitFactory((org.apache.camel.component.kafka.KafkaManualCommitFactory) value); return true;
            case "bufferMemorySize": getOrCreateConfiguration((KafkaComponent) component).setBufferMemorySize((java.lang.Integer) value); return true;
            case "compressionCodec": getOrCreateConfiguration((KafkaComponent) component).setCompressionCodec((java.lang.String) value); return true;
            case "connectionMaxIdleMs": getOrCreateConfiguration((KafkaComponent) component).setConnectionMaxIdleMs((java.lang.Integer) value); return true;
            case "enableIdempotence": getOrCreateConfiguration((KafkaComponent) component).setEnableIdempotence((boolean) value); return true;
            case "kafkaHeaderSerializer": getOrCreateConfiguration((KafkaComponent) component).setKafkaHeaderSerializer((org.apache.camel.component.kafka.serde.KafkaHeaderSerializer) value); return true;
            case "key": getOrCreateConfiguration((KafkaComponent) component).setKey((java.lang.String) value); return true;
            case "keySerializerClass": getOrCreateConfiguration((KafkaComponent) component).setKeySerializerClass((java.lang.String) value); return true;
            case "lazyStartProducer": ((KafkaComponent) component).setLazyStartProducer((boolean) value); return true;
            case "lingerMs": getOrCreateConfiguration((KafkaComponent) component).setLingerMs((java.lang.Integer) value); return true;
            case "maxBlockMs": getOrCreateConfiguration((KafkaComponent) component).setMaxBlockMs((java.lang.Integer) value); return true;
            case "maxInFlightRequest": getOrCreateConfiguration((KafkaComponent) component).setMaxInFlightRequest((java.lang.Integer) value); return true;
            case "maxRequestSize": getOrCreateConfiguration((KafkaComponent) component).setMaxRequestSize((java.lang.Integer) value); return true;
            case "metadataMaxAgeMs": getOrCreateConfiguration((KafkaComponent) component).setMetadataMaxAgeMs((java.lang.Integer) value); return true;
            case "metricReporters": getOrCreateConfiguration((KafkaComponent) component).setMetricReporters((java.lang.String) value); return true;
            case "metricsSampleWindowMs": getOrCreateConfiguration((KafkaComponent) component).setMetricsSampleWindowMs((java.lang.Integer) value); return true;
            case "noOfMetricsSample": getOrCreateConfiguration((KafkaComponent) component).setNoOfMetricsSample((java.lang.Integer) value); return true;
            case "partitioner": getOrCreateConfiguration((KafkaComponent) component).setPartitioner((java.lang.String) value); return true;
            case "partitionKey": getOrCreateConfiguration((KafkaComponent) component).setPartitionKey((java.lang.Integer) value); return true;
            case "producerBatchSize": getOrCreateConfiguration((KafkaComponent) component).setProducerBatchSize((java.lang.Integer) value); return true;
            case "queueBufferingMaxMessages": getOrCreateConfiguration((KafkaComponent) component).setQueueBufferingMaxMessages((java.lang.Integer) value); return true;
            case "receiveBufferBytes": getOrCreateConfiguration((KafkaComponent) component).setReceiveBufferBytes((java.lang.Integer) value); return true;
            case "reconnectBackoffMs": getOrCreateConfiguration((KafkaComponent) component).setReconnectBackoffMs((java.lang.Integer) value); return true;
            case "recordMetadata": getOrCreateConfiguration((KafkaComponent) component).setRecordMetadata((boolean) value); return true;
            case "requestRequiredAcks": getOrCreateConfiguration((KafkaComponent) component).setRequestRequiredAcks((java.lang.String) value); return true;
            case "requestTimeoutMs": getOrCreateConfiguration((KafkaComponent) component).setRequestTimeoutMs((java.lang.Integer) value); return true;
            case "retries": getOrCreateConfiguration((KafkaComponent) component).setRetries((java.lang.Integer) value); return true;
            case "retryBackoffMs": getOrCreateConfiguration((KafkaComponent) component).setRetryBackoffMs((java.lang.Integer) value); return true;
            case "sendBufferBytes": getOrCreateConfiguration((KafkaComponent) component).setSendBufferBytes((java.lang.Integer) value); return true;
            case "serializerClass": getOrCreateConfiguration((KafkaComponent) component).setSerializerClass((java.lang.String) value); return true;
            case "workerPool": getOrCreateConfiguration((KafkaComponent) component).setWorkerPool((java.util.concurrent.ExecutorService) value); return true;
            case "workerPoolCoreSize": getOrCreateConfiguration((KafkaComponent) component).setWorkerPoolCoreSize((java.lang.Integer) value); return true;
            case "workerPoolMaxSize": getOrCreateConfiguration((KafkaComponent) component).setWorkerPoolMaxSize((java.lang.Integer) value); return true;
            case "basicPropertyBinding": ((KafkaComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "schemaRegistryURL": getOrCreateConfiguration((KafkaComponent) component).setSchemaRegistryURL((java.lang.String) value); return true;
            case "interceptorClasses": getOrCreateConfiguration((KafkaComponent) component).setInterceptorClasses((java.lang.String) value); return true;
            case "kerberosBeforeReloginMinTime": getOrCreateConfiguration((KafkaComponent) component).setKerberosBeforeReloginMinTime((java.lang.Integer) value); return true;
            case "kerberosInitCmd": getOrCreateConfiguration((KafkaComponent) component).setKerberosInitCmd((java.lang.String) value); return true;
            case "kerberosPrincipalToLocalRules": getOrCreateConfiguration((KafkaComponent) component).setKerberosPrincipalToLocalRules((java.lang.String) value); return true;
            case "kerberosRenewJitter": getOrCreateConfiguration((KafkaComponent) component).setKerberosRenewJitter((java.lang.Double) value); return true;
            case "kerberosRenewWindowFactor": getOrCreateConfiguration((KafkaComponent) component).setKerberosRenewWindowFactor((java.lang.Double) value); return true;
            case "saslJaasConfig": getOrCreateConfiguration((KafkaComponent) component).setSaslJaasConfig((java.lang.String) value); return true;
            case "saslKerberosServiceName": getOrCreateConfiguration((KafkaComponent) component).setSaslKerberosServiceName((java.lang.String) value); return true;
            case "saslMechanism": getOrCreateConfiguration((KafkaComponent) component).setSaslMechanism((java.lang.String) value); return true;
            case "securityProtocol": getOrCreateConfiguration((KafkaComponent) component).setSecurityProtocol((java.lang.String) value); return true;
            case "sslCipherSuites": getOrCreateConfiguration((KafkaComponent) component).setSslCipherSuites((java.lang.String) value); return true;
            case "sslContextParameters": getOrCreateConfiguration((KafkaComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "sslEnabledProtocols": getOrCreateConfiguration((KafkaComponent) component).setSslEnabledProtocols((java.lang.String) value); return true;
            case "sslEndpointAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslEndpointAlgorithm((java.lang.String) value); return true;
            case "sslKeymanagerAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslKeymanagerAlgorithm((java.lang.String) value); return true;
            case "sslKeyPassword": getOrCreateConfiguration((KafkaComponent) component).setSslKeyPassword((java.lang.String) value); return true;
            case "sslKeystoreLocation": getOrCreateConfiguration((KafkaComponent) component).setSslKeystoreLocation((java.lang.String) value); return true;
            case "sslKeystorePassword": getOrCreateConfiguration((KafkaComponent) component).setSslKeystorePassword((java.lang.String) value); return true;
            case "sslKeystoreType": getOrCreateConfiguration((KafkaComponent) component).setSslKeystoreType((java.lang.String) value); return true;
            case "sslProtocol": getOrCreateConfiguration((KafkaComponent) component).setSslProtocol((java.lang.String) value); return true;
            case "sslProvider": getOrCreateConfiguration((KafkaComponent) component).setSslProvider((java.lang.String) value); return true;
            case "sslTrustmanagerAlgorithm": getOrCreateConfiguration((KafkaComponent) component).setSslTrustmanagerAlgorithm((java.lang.String) value); return true;
            case "sslTruststoreLocation": getOrCreateConfiguration((KafkaComponent) component).setSslTruststoreLocation((java.lang.String) value); return true;
            case "sslTruststorePassword": getOrCreateConfiguration((KafkaComponent) component).setSslTruststorePassword((java.lang.String) value); return true;
            case "sslTruststoreType": getOrCreateConfiguration((KafkaComponent) component).setSslTruststoreType((java.lang.String) value); return true;
            case "useGlobalSslContextParameters": ((KafkaComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}