/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//CHECKSTYLE:OFF
package org.apache.camel.builder.endpoint;

import javax.annotation.Generated;

/**
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public class StaticEndpointBuilders {

    /**
     * ActiveMQ (camel-activemq)
     * Send messages to (or consume from) Apache ActiveMQ. This component
     * extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-activemq
     * 
     * Syntax: <code>activemq:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ActiveMQEndpointBuilderFactory.ActiveMQEndpointBuilder activemq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ActiveMQEndpointBuilderFactory.endpointBuilder("activemq", path);
    }
    /**
     * ActiveMQ (camel-activemq)
     * Send messages to (or consume from) Apache ActiveMQ. This component
     * extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-activemq
     * 
     * Syntax: <code>activemq:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ActiveMQEndpointBuilderFactory.ActiveMQEndpointBuilder activemq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ActiveMQEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AMQP (camel-amqp)
     * Messaging with AMQP protocol using Apache QPid Client.
     * 
     * Category: messaging
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-amqp
     * 
     * Syntax: <code>amqp:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AMQPEndpointBuilderFactory.AMQPEndpointBuilder amqp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AMQPEndpointBuilderFactory.endpointBuilder("amqp", path);
    }
    /**
     * AMQP (camel-amqp)
     * Messaging with AMQP protocol using Apache QPid Client.
     * 
     * Category: messaging
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-amqp
     * 
     * Syntax: <code>amqp:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AMQPEndpointBuilderFactory.AMQPEndpointBuilder amqp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AMQPEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * ArangoDb (camel-arangodb)
     * Perform operations on ArangoDb when used as a Document Database, or as a
     * Graph Database
     * 
     * Category: database,nosql
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-arangodb
     * 
     * Syntax: <code>arangodb:database</code>
     * 
     * Path parameter: database (required)
     * database name
     * 
     * @param path database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ArangoDbEndpointBuilderFactory.ArangoDbEndpointBuilder arangodb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ArangoDbEndpointBuilderFactory.endpointBuilder("arangodb", path);
    }
    /**
     * ArangoDb (camel-arangodb)
     * Perform operations on ArangoDb when used as a Document Database, or as a
     * Graph Database
     * 
     * Category: database,nosql
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-arangodb
     * 
     * Syntax: <code>arangodb:database</code>
     * 
     * Path parameter: database (required)
     * database name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ArangoDbEndpointBuilderFactory.ArangoDbEndpointBuilder arangodb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ArangoDbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AS2 (camel-as2)
     * Transfer data securely and reliably using the AS2 protocol (RFC4130).
     * 
     * Category: file
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-as2
     * 
     * Syntax: <code>as2:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 2 enums and the value can be one of: CLIENT, SERVER
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AS2EndpointBuilderFactory.AS2EndpointBuilder as2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AS2EndpointBuilderFactory.endpointBuilder("as2", path);
    }
    /**
     * AS2 (camel-as2)
     * Transfer data securely and reliably using the AS2 protocol (RFC4130).
     * 
     * Category: file
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-as2
     * 
     * Syntax: <code>as2:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 2 enums and the value can be one of: CLIENT, SERVER
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AS2EndpointBuilderFactory.AS2EndpointBuilder as2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AS2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Asterisk (camel-asterisk)
     * Interact with Asterisk PBX Server.
     * 
     * Category: voip
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-asterisk
     * 
     * Syntax: <code>asterisk:name</code>
     * 
     * Path parameter: name (required)
     * Name of component
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AsteriskEndpointBuilderFactory.AsteriskEndpointBuilder asterisk(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AsteriskEndpointBuilderFactory.endpointBuilder("asterisk", path);
    }
    /**
     * Asterisk (camel-asterisk)
     * Interact with Asterisk PBX Server.
     * 
     * Category: voip
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-asterisk
     * 
     * Syntax: <code>asterisk:name</code>
     * 
     * Path parameter: name (required)
     * Name of component
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AsteriskEndpointBuilderFactory.AsteriskEndpointBuilder asterisk(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AsteriskEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AtlasMap (camel-atlasmap)
     * Transforms the message using an AtlasMap transformation.
     * 
     * Category: transformation
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-atlasmap
     * 
     * Syntax: <code>atlasmap:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtlasMapEndpointBuilderFactory.AtlasMapEndpointBuilder atlasmap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtlasMapEndpointBuilderFactory.endpointBuilder("atlasmap", path);
    }
    /**
     * AtlasMap (camel-atlasmap)
     * Transforms the message using an AtlasMap transformation.
     * 
     * Category: transformation
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-atlasmap
     * 
     * Syntax: <code>atlasmap:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtlasMapEndpointBuilderFactory.AtlasMapEndpointBuilder atlasmap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtlasMapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Atmos (camel-atmos)
     * Integrate with EMC's ViPR object data services using the Atmos Client.
     * 
     * Category: cloud,file
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-atmos
     * 
     * Syntax: <code>atmos:name/operation</code>
     * 
     * Path parameter: name
     * Atmos name
     * 
     * Path parameter: operation (required)
     * Operation to perform
     * There are 5 enums and the value can be one of: put, del, search, get,
     * move
     * 
     * @param path name/operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtmosEndpointBuilderFactory.AtmosEndpointBuilder atmos(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtmosEndpointBuilderFactory.endpointBuilder("atmos", path);
    }
    /**
     * Atmos (camel-atmos)
     * Integrate with EMC's ViPR object data services using the Atmos Client.
     * 
     * Category: cloud,file
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-atmos
     * 
     * Syntax: <code>atmos:name/operation</code>
     * 
     * Path parameter: name
     * Atmos name
     * 
     * Path parameter: operation (required)
     * Operation to perform
     * There are 5 enums and the value can be one of: put, del, search, get,
     * move
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name/operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtmosEndpointBuilderFactory.AtmosEndpointBuilder atmos(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtmosEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Atmosphere Websocket (camel-atmosphere-websocket)
     * Expose WebSocket endpoints using the Atmosphere framework.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-atmosphere-websocket
     * 
     * Syntax: <code>atmosphere-websocket:servicePath</code>
     * 
     * Path parameter: servicePath (required)
     * Name of websocket endpoint
     * 
     * @param path servicePath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtmosphereWebsocketEndpointBuilderFactory.AtmosphereWebsocketEndpointBuilder atmosphereWebsocket(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtmosphereWebsocketEndpointBuilderFactory.endpointBuilder("atmosphere-websocket", path);
    }
    /**
     * Atmosphere Websocket (camel-atmosphere-websocket)
     * Expose WebSocket endpoints using the Atmosphere framework.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-atmosphere-websocket
     * 
     * Syntax: <code>atmosphere-websocket:servicePath</code>
     * 
     * Path parameter: servicePath (required)
     * Name of websocket endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path servicePath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtmosphereWebsocketEndpointBuilderFactory.AtmosphereWebsocketEndpointBuilder atmosphereWebsocket(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtmosphereWebsocketEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Atom (camel-atom)
     * Poll Atom RSS feeds.
     * 
     * Category: rss
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-atom
     * 
     * Syntax: <code>atom:feedUri</code>
     * 
     * Path parameter: feedUri (required)
     * The URI to the feed to poll.
     * 
     * @param path feedUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtomEndpointBuilderFactory.AtomEndpointBuilder atom(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtomEndpointBuilderFactory.endpointBuilder("atom", path);
    }
    /**
     * Atom (camel-atom)
     * Poll Atom RSS feeds.
     * 
     * Category: rss
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-atom
     * 
     * Syntax: <code>atom:feedUri</code>
     * 
     * Path parameter: feedUri (required)
     * The URI to the feed to poll.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path feedUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AtomEndpointBuilderFactory.AtomEndpointBuilder atom(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AtomEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Avro RPC (camel-avro-rpc)
     * Produce or consume Apache Avro RPC services.
     * 
     * Category: rpc
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-avro-rpc
     * 
     * Syntax: <code>avro:transport:host:port/messageName</code>
     * 
     * Path parameter: transport (required)
     * Transport to use, can be either http or netty
     * There are 2 enums and the value can be one of: http, netty
     * 
     * Path parameter: port (required)
     * Port number to use
     * 
     * Path parameter: host (required)
     * Hostname to use
     * 
     * Path parameter: messageName
     * The name of the message to send.
     * 
     * @param path transport:host:port/messageName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AvroEndpointBuilderFactory.AvroEndpointBuilder avro(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AvroEndpointBuilderFactory.endpointBuilder("avro", path);
    }
    /**
     * Avro RPC (camel-avro-rpc)
     * Produce or consume Apache Avro RPC services.
     * 
     * Category: rpc
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-avro-rpc
     * 
     * Syntax: <code>avro:transport:host:port/messageName</code>
     * 
     * Path parameter: transport (required)
     * Transport to use, can be either http or netty
     * There are 2 enums and the value can be one of: http, netty
     * 
     * Path parameter: port (required)
     * Port number to use
     * 
     * Path parameter: host (required)
     * Hostname to use
     * 
     * Path parameter: messageName
     * The name of the message to send.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path transport:host:port/messageName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AvroEndpointBuilderFactory.AvroEndpointBuilder avro(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AvroEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Athena (camel-aws2-athena)
     * Access AWS Athena service using AWS SDK version 2.x.
     * 
     * Category: cloud,database
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-aws2-athena
     * 
     * Syntax: <code>aws2-athena:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Athena2EndpointBuilderFactory.Athena2EndpointBuilder aws2Athena(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Athena2EndpointBuilderFactory.endpointBuilder("aws2-athena", path);
    }
    /**
     * AWS Athena (camel-aws2-athena)
     * Access AWS Athena service using AWS SDK version 2.x.
     * 
     * Category: cloud,database
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-aws2-athena
     * 
     * Syntax: <code>aws2-athena:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Athena2EndpointBuilderFactory.Athena2EndpointBuilder aws2Athena(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Athena2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS CloudWatch (camel-aws2-cw)
     * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
     * 
     * Category: cloud,monitoring
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-cw
     * 
     * Syntax: <code>aws2-cw:namespace</code>
     * 
     * Path parameter: namespace (required)
     * The metric namespace
     * 
     * @param path namespace
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Cw2EndpointBuilderFactory.Cw2EndpointBuilder aws2Cw(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Cw2EndpointBuilderFactory.endpointBuilder("aws2-cw", path);
    }
    /**
     * AWS CloudWatch (camel-aws2-cw)
     * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
     * 
     * Category: cloud,monitoring
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-cw
     * 
     * Syntax: <code>aws2-cw:namespace</code>
     * 
     * Path parameter: namespace (required)
     * The metric namespace
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path namespace
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Cw2EndpointBuilderFactory.Cw2EndpointBuilder aws2Cw(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Cw2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS DynamoDB (camel-aws2-ddb)
     * Store and retrieve data from AWS DynamoDB service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,database,nosql
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * Syntax: <code>aws2-ddb:tableName</code>
     * 
     * Path parameter: tableName (required)
     * The name of the table currently worked with.
     * 
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ddb2EndpointBuilderFactory.Ddb2EndpointBuilder aws2Ddb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ddb2EndpointBuilderFactory.endpointBuilder("aws2-ddb", path);
    }
    /**
     * AWS DynamoDB (camel-aws2-ddb)
     * Store and retrieve data from AWS DynamoDB service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,database,nosql
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * Syntax: <code>aws2-ddb:tableName</code>
     * 
     * Path parameter: tableName (required)
     * The name of the table currently worked with.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ddb2EndpointBuilderFactory.Ddb2EndpointBuilder aws2Ddb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ddb2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS DynamoDB Streams (camel-aws2-ddb)
     * Receive messages from AWS DynamoDB Stream service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,streams
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * Syntax: <code>aws2-ddbstream:tableName</code>
     * 
     * Path parameter: tableName (required)
     * Name of the dynamodb table
     * 
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ddb2StreamEndpointBuilderFactory.Ddb2StreamEndpointBuilder aws2Ddbstream(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ddb2StreamEndpointBuilderFactory.endpointBuilder("aws2-ddbstream", path);
    }
    /**
     * AWS DynamoDB Streams (camel-aws2-ddb)
     * Receive messages from AWS DynamoDB Stream service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,streams
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * Syntax: <code>aws2-ddbstream:tableName</code>
     * 
     * Path parameter: tableName (required)
     * Name of the dynamodb table
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ddb2StreamEndpointBuilderFactory.Ddb2StreamEndpointBuilder aws2Ddbstream(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ddb2StreamEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Elastic Compute Cloud (EC2) (camel-aws2-ec2)
     * Manage AWS EC2 instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ec2
     * 
     * Syntax: <code>aws2-ec2:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AWS2EC2EndpointBuilderFactory.AWS2EC2EndpointBuilder aws2Ec2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AWS2EC2EndpointBuilderFactory.endpointBuilder("aws2-ec2", path);
    }
    /**
     * AWS Elastic Compute Cloud (EC2) (camel-aws2-ec2)
     * Manage AWS EC2 instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ec2
     * 
     * Syntax: <code>aws2-ec2:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AWS2EC2EndpointBuilderFactory.AWS2EC2EndpointBuilder aws2Ec2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AWS2EC2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Elastic Container Service (ECS) (camel-aws2-ecs)
     * Manage AWS ECS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ecs
     * 
     * Syntax: <code>aws2-ecs:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ECS2EndpointBuilderFactory.ECS2EndpointBuilder aws2Ecs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ECS2EndpointBuilderFactory.endpointBuilder("aws2-ecs", path);
    }
    /**
     * AWS Elastic Container Service (ECS) (camel-aws2-ecs)
     * Manage AWS ECS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ecs
     * 
     * Syntax: <code>aws2-ecs:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ECS2EndpointBuilderFactory.ECS2EndpointBuilder aws2Ecs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ECS2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Elastic Kubernetes Service (EKS) (camel-aws2-eks)
     * Manage AWS EKS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-eks
     * 
     * Syntax: <code>aws2-eks:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EKS2EndpointBuilderFactory.EKS2EndpointBuilder aws2Eks(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EKS2EndpointBuilderFactory.endpointBuilder("aws2-eks", path);
    }
    /**
     * AWS Elastic Kubernetes Service (EKS) (camel-aws2-eks)
     * Manage AWS EKS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-eks
     * 
     * Syntax: <code>aws2-eks:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EKS2EndpointBuilderFactory.EKS2EndpointBuilder aws2Eks(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EKS2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Eventbridge (camel-aws2-eventbridge)
     * Manage AWS Eventbridge cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.6
     * Maven coordinates: org.apache.camel:camel-aws2-eventbridge
     * 
     * Syntax: <code>aws2-eventbridge://eventbusNameOrArn</code>
     * 
     * Path parameter: eventbusNameOrArn (required)
     * Event bus name or ARN
     * 
     * @param path //eventbusNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventbridgeEndpointBuilderFactory.EventbridgeEndpointBuilder aws2Eventbridge(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventbridgeEndpointBuilderFactory.endpointBuilder("aws2-eventbridge", path);
    }
    /**
     * AWS Eventbridge (camel-aws2-eventbridge)
     * Manage AWS Eventbridge cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.6
     * Maven coordinates: org.apache.camel:camel-aws2-eventbridge
     * 
     * Syntax: <code>aws2-eventbridge://eventbusNameOrArn</code>
     * 
     * Path parameter: eventbusNameOrArn (required)
     * Event bus name or ARN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path //eventbusNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventbridgeEndpointBuilderFactory.EventbridgeEndpointBuilder aws2Eventbridge(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventbridgeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Identity and Access Management (IAM) (camel-aws2-iam)
     * Manage AWS IAM instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-iam
     * 
     * Syntax: <code>aws2-iam:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IAM2EndpointBuilderFactory.IAM2EndpointBuilder aws2Iam(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IAM2EndpointBuilderFactory.endpointBuilder("aws2-iam", path);
    }
    /**
     * AWS Identity and Access Management (IAM) (camel-aws2-iam)
     * Manage AWS IAM instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-iam
     * 
     * Syntax: <code>aws2-iam:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IAM2EndpointBuilderFactory.IAM2EndpointBuilder aws2Iam(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IAM2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Kinesis (camel-aws2-kinesis)
     * Consume and produce records from and to AWS Kinesis Streams using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * Syntax: <code>aws2-kinesis:streamName</code>
     * 
     * Path parameter: streamName (required)
     * Name of the stream
     * 
     * @param path streamName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Kinesis2EndpointBuilderFactory.Kinesis2EndpointBuilder aws2Kinesis(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Kinesis2EndpointBuilderFactory.endpointBuilder("aws2-kinesis", path);
    }
    /**
     * AWS Kinesis (camel-aws2-kinesis)
     * Consume and produce records from and to AWS Kinesis Streams using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * Syntax: <code>aws2-kinesis:streamName</code>
     * 
     * Path parameter: streamName (required)
     * Name of the stream
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path streamName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Kinesis2EndpointBuilderFactory.Kinesis2EndpointBuilder aws2Kinesis(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Kinesis2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Kinesis Firehose (camel-aws2-kinesis)
     * Produce data to AWS Kinesis Firehose streams using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * Syntax: <code>aws2-kinesis-firehose:streamName</code>
     * 
     * Path parameter: streamName (required)
     * Name of the stream
     * 
     * @param path streamName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KinesisFirehose2EndpointBuilderFactory.KinesisFirehose2EndpointBuilder aws2KinesisFirehose(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KinesisFirehose2EndpointBuilderFactory.endpointBuilder("aws2-kinesis-firehose", path);
    }
    /**
     * AWS Kinesis Firehose (camel-aws2-kinesis)
     * Produce data to AWS Kinesis Firehose streams using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * Syntax: <code>aws2-kinesis-firehose:streamName</code>
     * 
     * Path parameter: streamName (required)
     * Name of the stream
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path streamName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KinesisFirehose2EndpointBuilderFactory.KinesisFirehose2EndpointBuilder aws2KinesisFirehose(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KinesisFirehose2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Key Management Service (KMS) (camel-aws2-kms)
     * Manage keys stored in AWS KMS instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-kms
     * 
     * Syntax: <code>aws2-kms:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KMS2EndpointBuilderFactory.KMS2EndpointBuilder aws2Kms(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KMS2EndpointBuilderFactory.endpointBuilder("aws2-kms", path);
    }
    /**
     * AWS Key Management Service (KMS) (camel-aws2-kms)
     * Manage keys stored in AWS KMS instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-kms
     * 
     * Syntax: <code>aws2-kms:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KMS2EndpointBuilderFactory.KMS2EndpointBuilder aws2Kms(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KMS2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Lambda (camel-aws2-lambda)
     * Manage and invoke AWS Lambda functions using AWS SDK version 2.x.
     * 
     * Category: cloud,computing,serverless
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-lambda
     * 
     * Syntax: <code>aws2-lambda:function</code>
     * 
     * Path parameter: function (required)
     * Name of the Lambda function.
     * 
     * @param path function
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Lambda2EndpointBuilderFactory.Lambda2EndpointBuilder aws2Lambda(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Lambda2EndpointBuilderFactory.endpointBuilder("aws2-lambda", path);
    }
    /**
     * AWS Lambda (camel-aws2-lambda)
     * Manage and invoke AWS Lambda functions using AWS SDK version 2.x.
     * 
     * Category: cloud,computing,serverless
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-lambda
     * 
     * Syntax: <code>aws2-lambda:function</code>
     * 
     * Path parameter: function (required)
     * Name of the Lambda function.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path function
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Lambda2EndpointBuilderFactory.Lambda2EndpointBuilder aws2Lambda(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Lambda2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS MQ (camel-aws2-mq)
     * Manage AWS MQ instances using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-mq
     * 
     * Syntax: <code>aws2-mq:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MQ2EndpointBuilderFactory.MQ2EndpointBuilder aws2Mq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MQ2EndpointBuilderFactory.endpointBuilder("aws2-mq", path);
    }
    /**
     * AWS MQ (camel-aws2-mq)
     * Manage AWS MQ instances using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-mq
     * 
     * Syntax: <code>aws2-mq:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MQ2EndpointBuilderFactory.MQ2EndpointBuilder aws2Mq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MQ2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Managed Streaming for Apache Kafka (MSK) (camel-aws2-msk)
     * Manage AWS MSK instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-msk
     * 
     * Syntax: <code>aws2-msk:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MSK2EndpointBuilderFactory.MSK2EndpointBuilder aws2Msk(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MSK2EndpointBuilderFactory.endpointBuilder("aws2-msk", path);
    }
    /**
     * AWS Managed Streaming for Apache Kafka (MSK) (camel-aws2-msk)
     * Manage AWS MSK instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-msk
     * 
     * Syntax: <code>aws2-msk:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MSK2EndpointBuilderFactory.MSK2EndpointBuilder aws2Msk(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MSK2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS S3 Storage Service (camel-aws2-s3)
     * Store and retrieve objects from AWS S3 Storage Service using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,file
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-s3
     * 
     * Syntax: <code>aws2-s3://bucketNameOrArn</code>
     * 
     * Path parameter: bucketNameOrArn (required)
     * Bucket name or ARN
     * 
     * @param path //bucketNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AWS2S3EndpointBuilderFactory.AWS2S3EndpointBuilder aws2S3(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AWS2S3EndpointBuilderFactory.endpointBuilder("aws2-s3", path);
    }
    /**
     * AWS S3 Storage Service (camel-aws2-s3)
     * Store and retrieve objects from AWS S3 Storage Service using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,file
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-s3
     * 
     * Syntax: <code>aws2-s3://bucketNameOrArn</code>
     * 
     * Path parameter: bucketNameOrArn (required)
     * Bucket name or ARN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path //bucketNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.AWS2S3EndpointBuilderFactory.AWS2S3EndpointBuilder aws2S3(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.AWS2S3EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Simple Email Service (SES) (camel-aws2-ses)
     * Send e-mails through AWS SES service using AWS SDK version 2.x.
     * 
     * Category: cloud,mail
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ses
     * 
     * Syntax: <code>aws2-ses:from</code>
     * 
     * Path parameter: from (required)
     * The sender's email address.
     * 
     * @param path from
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ses2EndpointBuilderFactory.Ses2EndpointBuilder aws2Ses(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ses2EndpointBuilderFactory.endpointBuilder("aws2-ses", path);
    }
    /**
     * AWS Simple Email Service (SES) (camel-aws2-ses)
     * Send e-mails through AWS SES service using AWS SDK version 2.x.
     * 
     * Category: cloud,mail
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ses
     * 
     * Syntax: <code>aws2-ses:from</code>
     * 
     * Path parameter: from (required)
     * The sender's email address.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path from
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Ses2EndpointBuilderFactory.Ses2EndpointBuilder aws2Ses(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Ses2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Simple Notification System (SNS) (camel-aws2-sns)
     * Send messages to an AWS Simple Notification Topic using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,mobile
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sns
     * 
     * Syntax: <code>aws2-sns:topicNameOrArn</code>
     * 
     * Path parameter: topicNameOrArn (required)
     * Topic name or ARN
     * 
     * @param path topicNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sns2EndpointBuilderFactory.Sns2EndpointBuilder aws2Sns(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sns2EndpointBuilderFactory.endpointBuilder("aws2-sns", path);
    }
    /**
     * AWS Simple Notification System (SNS) (camel-aws2-sns)
     * Send messages to an AWS Simple Notification Topic using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,mobile
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sns
     * 
     * Syntax: <code>aws2-sns:topicNameOrArn</code>
     * 
     * Path parameter: topicNameOrArn (required)
     * Topic name or ARN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topicNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sns2EndpointBuilderFactory.Sns2EndpointBuilder aws2Sns(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sns2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
     * Send and receive messages to/from AWS SQS service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sqs
     * 
     * Syntax: <code>aws2-sqs:queueNameOrArn</code>
     * 
     * Path parameter: queueNameOrArn (required)
     * Queue name or ARN
     * 
     * @param path queueNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sqs2EndpointBuilderFactory.Sqs2EndpointBuilder aws2Sqs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sqs2EndpointBuilderFactory.endpointBuilder("aws2-sqs", path);
    }
    /**
     * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
     * Send and receive messages to/from AWS SQS service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sqs
     * 
     * Syntax: <code>aws2-sqs:queueNameOrArn</code>
     * 
     * Path parameter: queueNameOrArn (required)
     * Queue name or ARN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path queueNameOrArn
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sqs2EndpointBuilderFactory.Sqs2EndpointBuilder aws2Sqs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sqs2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Security Token Service (STS) (camel-aws2-sts)
     * Manage AWS STS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-aws2-sts
     * 
     * Syntax: <code>aws2-sts:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.STS2EndpointBuilderFactory.STS2EndpointBuilder aws2Sts(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.STS2EndpointBuilderFactory.endpointBuilder("aws2-sts", path);
    }
    /**
     * AWS Security Token Service (STS) (camel-aws2-sts)
     * Manage AWS STS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-aws2-sts
     * 
     * Syntax: <code>aws2-sts:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.STS2EndpointBuilderFactory.STS2EndpointBuilder aws2Sts(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.STS2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Translate (camel-aws2-translate)
     * Translate texts using AWS Translate and AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-translate
     * 
     * Syntax: <code>aws2-translate:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Translate2EndpointBuilderFactory.Translate2EndpointBuilder aws2Translate(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Translate2EndpointBuilderFactory.endpointBuilder("aws2-translate", path);
    }
    /**
     * AWS Translate (camel-aws2-translate)
     * Translate texts using AWS Translate and AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-translate
     * 
     * Syntax: <code>aws2-translate:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Translate2EndpointBuilderFactory.Translate2EndpointBuilder aws2Translate(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Translate2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Cloudtrail (camel-aws-cloudtrail)
     * Consume events from Amazon Cloudtrail using AWS SDK version 2.x.
     * 
     * Category: cloud,eventbus
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-aws-cloudtrail
     * 
     * Syntax: <code>aws-cloudtrail:label</code>
     * 
     * Path parameter: label (required)
     * A label for indexing cloudtrail endpoints
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CloudtrailEndpointBuilderFactory.CloudtrailEndpointBuilder awsCloudtrail(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CloudtrailEndpointBuilderFactory.endpointBuilder("aws-cloudtrail", path);
    }
    /**
     * AWS Cloudtrail (camel-aws-cloudtrail)
     * Consume events from Amazon Cloudtrail using AWS SDK version 2.x.
     * 
     * Category: cloud,eventbus
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-aws-cloudtrail
     * 
     * Syntax: <code>aws-cloudtrail:label</code>
     * 
     * Path parameter: label (required)
     * A label for indexing cloudtrail endpoints
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CloudtrailEndpointBuilderFactory.CloudtrailEndpointBuilder awsCloudtrail(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CloudtrailEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * AWS Secrets Manager (camel-aws-secrets-manager)
     * Manage AWS Secrets Manager services using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-aws-secrets-manager
     * 
     * Syntax: <code>aws-secrets-manager:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SecretsManagerEndpointBuilderFactory.SecretsManagerEndpointBuilder awsSecretsManager(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SecretsManagerEndpointBuilderFactory.endpointBuilder("aws-secrets-manager", path);
    }
    /**
     * AWS Secrets Manager (camel-aws-secrets-manager)
     * Manage AWS Secrets Manager services using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-aws-secrets-manager
     * 
     * Syntax: <code>aws-secrets-manager:label</code>
     * 
     * Path parameter: label (required)
     * Logical name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SecretsManagerEndpointBuilderFactory.SecretsManagerEndpointBuilder awsSecretsManager(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SecretsManagerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure CosmosDB (camel-azure-cosmosdb)
     * To read and write records to the CosmosDB database on Azure cloud
     * platform.
     * 
     * Category: cloud,database
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
     * 
     * Syntax: <code>azure-cosmosdb:databaseName/containerName</code>
     * 
     * Path parameter: databaseName
     * The name of the Cosmos database that component should connect to. In case
     * you are producing data and have createDatabaseIfNotExists=true, the
     * component will automatically auto create a Cosmos database.
     * 
     * Path parameter: containerName
     * The name of the Cosmos container that component should connect to. In
     * case you are producing data and have createContainerIfNotExists=true, the
     * component will automatically auto create a Cosmos container.
     * 
     * @param path databaseName/containerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CosmosDbEndpointBuilderFactory.CosmosDbEndpointBuilder azureCosmosdb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CosmosDbEndpointBuilderFactory.endpointBuilder("azure-cosmosdb", path);
    }
    /**
     * Azure CosmosDB (camel-azure-cosmosdb)
     * To read and write records to the CosmosDB database on Azure cloud
     * platform.
     * 
     * Category: cloud,database
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
     * 
     * Syntax: <code>azure-cosmosdb:databaseName/containerName</code>
     * 
     * Path parameter: databaseName
     * The name of the Cosmos database that component should connect to. In case
     * you are producing data and have createDatabaseIfNotExists=true, the
     * component will automatically auto create a Cosmos database.
     * 
     * Path parameter: containerName
     * The name of the Cosmos container that component should connect to. In
     * case you are producing data and have createContainerIfNotExists=true, the
     * component will automatically auto create a Cosmos container.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path databaseName/containerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CosmosDbEndpointBuilderFactory.CosmosDbEndpointBuilder azureCosmosdb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CosmosDbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure Event Hubs (camel-azure-eventhubs)
     * Send and receive events to/from Azure Event Hubs using AMQP protocol.
     * 
     * Category: cloud,messaging
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-azure-eventhubs
     * 
     * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
     * 
     * Path parameter: namespace
     * EventHubs namespace created in Azure Portal.
     * 
     * Path parameter: eventHubName
     * EventHubs name under a specific namespace.
     * 
     * @param path namespace/eventHubName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventHubsEndpointBuilderFactory.EventHubsEndpointBuilder azureEventhubs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventHubsEndpointBuilderFactory.endpointBuilder("azure-eventhubs", path);
    }
    /**
     * Azure Event Hubs (camel-azure-eventhubs)
     * Send and receive events to/from Azure Event Hubs using AMQP protocol.
     * 
     * Category: cloud,messaging
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-azure-eventhubs
     * 
     * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
     * 
     * Path parameter: namespace
     * EventHubs namespace created in Azure Portal.
     * 
     * Path parameter: eventHubName
     * EventHubs name under a specific namespace.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path namespace/eventHubName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventHubsEndpointBuilderFactory.EventHubsEndpointBuilder azureEventhubs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventHubsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure Key Vault (camel-azure-key-vault)
     * Manage secrets and keys in Azure Key Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-azure-key-vault
     * 
     * Syntax: <code>azure-key-vault:vaultName</code>
     * 
     * Path parameter: vaultName
     * Vault Name to be used
     * 
     * @param path vaultName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KeyVaultEndpointBuilderFactory.KeyVaultEndpointBuilder azureKeyVault(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KeyVaultEndpointBuilderFactory.endpointBuilder("azure-key-vault", path);
    }
    /**
     * Azure Key Vault (camel-azure-key-vault)
     * Manage secrets and keys in Azure Key Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-azure-key-vault
     * 
     * Syntax: <code>azure-key-vault:vaultName</code>
     * 
     * Path parameter: vaultName
     * Vault Name to be used
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path vaultName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KeyVaultEndpointBuilderFactory.KeyVaultEndpointBuilder azureKeyVault(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KeyVaultEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure ServiceBus (camel-azure-servicebus)
     * Send and receive messages to/from Azure Event Bus.
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-azure-servicebus
     * 
     * Syntax: <code>azure-servicebus:topicOrQueueName</code>
     * 
     * Path parameter: topicOrQueueName
     * Selected topic name or the queue name, that is depending on
     * serviceBusType config. For example if serviceBusType=queue, then this
     * will be the queue name and if serviceBusType=topic, this will be the
     * topic name.
     * 
     * @param path topicOrQueueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceBusEndpointBuilderFactory.ServiceBusEndpointBuilder azureServicebus(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceBusEndpointBuilderFactory.endpointBuilder("azure-servicebus", path);
    }
    /**
     * Azure ServiceBus (camel-azure-servicebus)
     * Send and receive messages to/from Azure Event Bus.
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-azure-servicebus
     * 
     * Syntax: <code>azure-servicebus:topicOrQueueName</code>
     * 
     * Path parameter: topicOrQueueName
     * Selected topic name or the queue name, that is depending on
     * serviceBusType config. For example if serviceBusType=queue, then this
     * will be the queue name and if serviceBusType=topic, this will be the
     * topic name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topicOrQueueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceBusEndpointBuilderFactory.ServiceBusEndpointBuilder azureServicebus(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceBusEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure Storage Blob Service (camel-azure-storage-blob)
     * Store and retrieve blobs from Azure Storage Blob Service.
     * 
     * Category: cloud,file
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-blob
     * 
     * Syntax: <code>azure-storage-blob:accountName/containerName</code>
     * 
     * Path parameter: accountName
     * Azure account name to be used for authentication with azure blob services
     * 
     * Path parameter: containerName
     * The blob container name
     * 
     * @param path accountName/containerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BlobEndpointBuilderFactory.BlobEndpointBuilder azureStorageBlob(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BlobEndpointBuilderFactory.endpointBuilder("azure-storage-blob", path);
    }
    /**
     * Azure Storage Blob Service (camel-azure-storage-blob)
     * Store and retrieve blobs from Azure Storage Blob Service.
     * 
     * Category: cloud,file
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-blob
     * 
     * Syntax: <code>azure-storage-blob:accountName/containerName</code>
     * 
     * Path parameter: accountName
     * Azure account name to be used for authentication with azure blob services
     * 
     * Path parameter: containerName
     * The blob container name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path accountName/containerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BlobEndpointBuilderFactory.BlobEndpointBuilder azureStorageBlob(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BlobEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure Storage Datalake Service (camel-azure-storage-datalake)
     * Sends and receives files to/from Azure DataLake Storage.
     * 
     * Category: cloud,file,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
     * 
     * Syntax: <code>azure-storage-datalake:accountName/fileSystemName</code>
     * 
     * Path parameter: accountName
     * name of the azure account
     * 
     * Path parameter: fileSystemName
     * name of filesystem to be used
     * 
     * @param path accountName/fileSystemName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataLakeEndpointBuilderFactory.DataLakeEndpointBuilder azureStorageDatalake(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataLakeEndpointBuilderFactory.endpointBuilder("azure-storage-datalake", path);
    }
    /**
     * Azure Storage Datalake Service (camel-azure-storage-datalake)
     * Sends and receives files to/from Azure DataLake Storage.
     * 
     * Category: cloud,file,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
     * 
     * Syntax: <code>azure-storage-datalake:accountName/fileSystemName</code>
     * 
     * Path parameter: accountName
     * name of the azure account
     * 
     * Path parameter: fileSystemName
     * name of filesystem to be used
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path accountName/fileSystemName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataLakeEndpointBuilderFactory.DataLakeEndpointBuilder azureStorageDatalake(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataLakeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Azure Storage Queue Service (camel-azure-storage-queue)
     * Stores and retrieves messages to/from Azure Storage Queue.
     * 
     * Category: cloud,messaging
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-queue
     * 
     * Syntax: <code>azure-storage-queue:accountName/queueName</code>
     * 
     * Path parameter: accountName
     * Azure account name to be used for authentication with azure queue
     * services
     * 
     * Path parameter: queueName
     * The queue resource name
     * 
     * @param path accountName/queueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QueueEndpointBuilderFactory.QueueEndpointBuilder azureStorageQueue(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QueueEndpointBuilderFactory.endpointBuilder("azure-storage-queue", path);
    }
    /**
     * Azure Storage Queue Service (camel-azure-storage-queue)
     * Stores and retrieves messages to/from Azure Storage Queue.
     * 
     * Category: cloud,messaging
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-queue
     * 
     * Syntax: <code>azure-storage-queue:accountName/queueName</code>
     * 
     * Path parameter: accountName
     * Azure account name to be used for authentication with azure queue
     * services
     * 
     * Path parameter: queueName
     * The queue resource name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path accountName/queueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QueueEndpointBuilderFactory.QueueEndpointBuilder azureStorageQueue(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QueueEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Bean (camel-bean)
     * Invoke methods of Java beans stored in Camel registry.
     * 
     * Category: core,java
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * Syntax: <code>bean:beanName</code>
     * 
     * Path parameter: beanName (required)
     * Sets the name of the bean to invoke
     * 
     * @param path beanName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BeanEndpointBuilderFactory.BeanEndpointBuilder bean(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BeanEndpointBuilderFactory.endpointBuilder("bean", path);
    }
    /**
     * Bean (camel-bean)
     * Invoke methods of Java beans stored in Camel registry.
     * 
     * Category: core,java
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * Syntax: <code>bean:beanName</code>
     * 
     * Path parameter: beanName (required)
     * Sets the name of the bean to invoke
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BeanEndpointBuilderFactory.BeanEndpointBuilder bean(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BeanEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Bean Validator (camel-bean-validator)
     * Validate the message body using the Java Bean Validation API.
     * 
     * Category: validation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-bean-validator
     * 
     * Syntax: <code>bean-validator:label</code>
     * 
     * Path parameter: label (required)
     * Where label is an arbitrary text value describing the endpoint
     * 
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BeanValidatorEndpointBuilderFactory.BeanValidatorEndpointBuilder beanValidator(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BeanValidatorEndpointBuilderFactory.endpointBuilder("bean-validator", path);
    }
    /**
     * Bean Validator (camel-bean-validator)
     * Validate the message body using the Java Bean Validation API.
     * 
     * Category: validation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-bean-validator
     * 
     * Syntax: <code>bean-validator:label</code>
     * 
     * Path parameter: label (required)
     * Where label is an arbitrary text value describing the endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path label
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BeanValidatorEndpointBuilderFactory.BeanValidatorEndpointBuilder beanValidator(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BeanValidatorEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Bonita (camel-bonita)
     * Communicate with a remote Bonita BPM process engine.
     * 
     * Category: process
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-bonita
     * 
     * Syntax: <code>bonita:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to use
     * There are 1 enums and the value can be one of: startCase
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BonitaEndpointBuilderFactory.BonitaEndpointBuilder bonita(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BonitaEndpointBuilderFactory.endpointBuilder("bonita", path);
    }
    /**
     * Bonita (camel-bonita)
     * Communicate with a remote Bonita BPM process engine.
     * 
     * Category: process
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-bonita
     * 
     * Syntax: <code>bonita:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to use
     * There are 1 enums and the value can be one of: startCase
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BonitaEndpointBuilderFactory.BonitaEndpointBuilder bonita(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BonitaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Box (camel-box)
     * Upload, download and manage files, folders, groups, collaborations, etc.
     * on box.com.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * Syntax: <code>box:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 10 enums and the value can be one of: COLLABORATIONS, COMMENTS,
     * EVENT_LOGS, FILES, FOLDERS, GROUPS, EVENTS, SEARCH, TASKS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BoxEndpointBuilderFactory.BoxEndpointBuilder box(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BoxEndpointBuilderFactory.endpointBuilder("box", path);
    }
    /**
     * Box (camel-box)
     * Upload, download and manage files, folders, groups, collaborations, etc.
     * on box.com.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * Syntax: <code>box:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 10 enums and the value can be one of: COLLABORATIONS, COMMENTS,
     * EVENT_LOGS, FILES, FOLDERS, GROUPS, EVENTS, SEARCH, TASKS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BoxEndpointBuilderFactory.BoxEndpointBuilder box(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BoxEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Braintree (camel-braintree)
     * Process payments using Braintree Payments.
     * 
     * Category: cloud,payment
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-braintree
     * 
     * Syntax: <code>braintree:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 17 enums and the value can be one of: ADD_ON, ADDRESS,
     * CLIENT_TOKEN, CREDIT_CARD_VERIFICATION, CUSTOMER, DISCOUNT, DISPUTE,
     * DOCUMENT_UPLOAD, MERCHANT_ACCOUNT, PAYMENT_METHOD, PAYMENT_METHOD_NONCE,
     * PLAN, REPORT, SETTLEMENT_BATCH_SUMMARY, SUBSCRIPTION, TRANSACTION,
     * WEBHOOK_NOTIFICATION
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 31 enums and the value can be one of: accept, addFileEvidence,
     * addTextEvidence, cancel, cancelRelease, cloneTransaction, create,
     * createForCurrency, credit, delete, fetchMerchantAccounts, finalize, find,
     * generate, grant, holdInEscrow, parse, refund, releaseFromEscrow,
     * removeEvidence, retryCharge, revoke, sale, search,
     * submitForPartialSettlement, submitForSettlement, transactionLevelFees,
     * update, updateDetails, verify, voidTransaction
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BraintreeEndpointBuilderFactory.BraintreeEndpointBuilder braintree(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BraintreeEndpointBuilderFactory.endpointBuilder("braintree", path);
    }
    /**
     * Braintree (camel-braintree)
     * Process payments using Braintree Payments.
     * 
     * Category: cloud,payment
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-braintree
     * 
     * Syntax: <code>braintree:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 17 enums and the value can be one of: ADD_ON, ADDRESS,
     * CLIENT_TOKEN, CREDIT_CARD_VERIFICATION, CUSTOMER, DISCOUNT, DISPUTE,
     * DOCUMENT_UPLOAD, MERCHANT_ACCOUNT, PAYMENT_METHOD, PAYMENT_METHOD_NONCE,
     * PLAN, REPORT, SETTLEMENT_BATCH_SUMMARY, SUBSCRIPTION, TRANSACTION,
     * WEBHOOK_NOTIFICATION
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 31 enums and the value can be one of: accept, addFileEvidence,
     * addTextEvidence, cancel, cancelRelease, cloneTransaction, create,
     * createForCurrency, credit, delete, fetchMerchantAccounts, finalize, find,
     * generate, grant, holdInEscrow, parse, refund, releaseFromEscrow,
     * removeEvidence, retryCharge, revoke, sale, search,
     * submitForPartialSettlement, submitForSettlement, transactionLevelFees,
     * update, updateDetails, verify, voidTransaction
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BraintreeEndpointBuilderFactory.BraintreeEndpointBuilder braintree(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BraintreeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Browse (camel-browse)
     * Inspect the messages received on endpoints supporting BrowsableEndpoint.
     * 
     * Category: core,monitoring
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-browse
     * 
     * Syntax: <code>browse:name</code>
     * 
     * Path parameter: name (required)
     * A name which can be any string to uniquely identify the endpoint
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BrowseEndpointBuilderFactory.BrowseEndpointBuilder browse(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BrowseEndpointBuilderFactory.endpointBuilder("browse", path);
    }
    /**
     * Browse (camel-browse)
     * Inspect the messages received on endpoints supporting BrowsableEndpoint.
     * 
     * Category: core,monitoring
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-browse
     * 
     * Syntax: <code>browse:name</code>
     * 
     * Path parameter: name (required)
     * A name which can be any string to uniquely identify the endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.BrowseEndpointBuilderFactory.BrowseEndpointBuilder browse(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.BrowseEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Caffeine Cache (camel-caffeine)
     * Perform caching operations using Caffeine Cache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * Syntax: <code>caffeine-cache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * Cache name
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CaffeineCacheEndpointBuilderFactory.CaffeineCacheEndpointBuilder caffeineCache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CaffeineCacheEndpointBuilderFactory.endpointBuilder("caffeine-cache", path);
    }
    /**
     * Caffeine Cache (camel-caffeine)
     * Perform caching operations using Caffeine Cache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * Syntax: <code>caffeine-cache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * Cache name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CaffeineCacheEndpointBuilderFactory.CaffeineCacheEndpointBuilder caffeineCache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CaffeineCacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Caffeine LoadCache (camel-caffeine)
     * Perform caching operations using Caffeine Cache with an attached
     * CacheLoader.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * Syntax: <code>caffeine-loadcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * the cache name
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CaffeineLoadCacheEndpointBuilderFactory.CaffeineLoadCacheEndpointBuilder caffeineLoadcache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CaffeineLoadCacheEndpointBuilderFactory.endpointBuilder("caffeine-loadcache", path);
    }
    /**
     * Caffeine LoadCache (camel-caffeine)
     * Perform caching operations using Caffeine Cache with an attached
     * CacheLoader.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * Syntax: <code>caffeine-loadcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * the cache name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CaffeineLoadCacheEndpointBuilderFactory.CaffeineLoadCacheEndpointBuilder caffeineLoadcache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CaffeineLoadCacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * ChatScript (camel-chatscript)
     * Chat with a ChatScript Server.
     * 
     * Category: ai,chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-chatscript
     * 
     * Syntax: <code>chatscript:host:port/botName</code>
     * 
     * Path parameter: host (required)
     * Hostname or IP of the server on which CS server is running
     * 
     * Path parameter: port
     * Port on which ChatScript is listening to
     * Default value: 1024
     * 
     * Path parameter: botName (required)
     * Name of the Bot in CS to converse with
     * 
     * @param path host:port/botName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ChatScriptEndpointBuilderFactory.ChatScriptEndpointBuilder chatscript(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ChatScriptEndpointBuilderFactory.endpointBuilder("chatscript", path);
    }
    /**
     * ChatScript (camel-chatscript)
     * Chat with a ChatScript Server.
     * 
     * Category: ai,chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-chatscript
     * 
     * Syntax: <code>chatscript:host:port/botName</code>
     * 
     * Path parameter: host (required)
     * Hostname or IP of the server on which CS server is running
     * 
     * Path parameter: port
     * Port on which ChatScript is listening to
     * Default value: 1024
     * 
     * Path parameter: botName (required)
     * Name of the Bot in CS to converse with
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/botName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ChatScriptEndpointBuilderFactory.ChatScriptEndpointBuilder chatscript(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ChatScriptEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Chunk (camel-chunk)
     * Transform messages using Chunk templating engine.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-chunk
     * 
     * Syntax: <code>chunk:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ChunkEndpointBuilderFactory.ChunkEndpointBuilder chunk(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ChunkEndpointBuilderFactory.endpointBuilder("chunk", path);
    }
    /**
     * Chunk (camel-chunk)
     * Transform messages using Chunk templating engine.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-chunk
     * 
     * Syntax: <code>chunk:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ChunkEndpointBuilderFactory.ChunkEndpointBuilder chunk(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ChunkEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Class (camel-bean)
     * Invoke methods of Java beans specified by class name.
     * 
     * Category: core,java
     * Since: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * Syntax: <code>class:beanName</code>
     * 
     * Path parameter: beanName (required)
     * Sets the name of the bean to invoke
     * 
     * @param path beanName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ClassEndpointBuilderFactory.ClassEndpointBuilder clas(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ClassEndpointBuilderFactory.endpointBuilder("class", path);
    }
    /**
     * Class (camel-bean)
     * Invoke methods of Java beans specified by class name.
     * 
     * Category: core,java
     * Since: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * Syntax: <code>class:beanName</code>
     * 
     * Path parameter: beanName (required)
     * Sets the name of the bean to invoke
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ClassEndpointBuilderFactory.ClassEndpointBuilder clas(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ClassEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CM SMS Gateway (camel-cm-sms)
     * Send SMS messages via CM SMS Gateway.
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-cm-sms
     * 
     * Syntax: <code>cm-sms:host</code>
     * 
     * Path parameter: host (required)
     * SMS Provider HOST with scheme
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CMEndpointBuilderFactory.CMEndpointBuilder cmSms(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CMEndpointBuilderFactory.endpointBuilder("cm-sms", path);
    }
    /**
     * CM SMS Gateway (camel-cm-sms)
     * Send SMS messages via CM SMS Gateway.
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-cm-sms
     * 
     * Syntax: <code>cm-sms:host</code>
     * 
     * Path parameter: host (required)
     * SMS Provider HOST with scheme
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CMEndpointBuilderFactory.CMEndpointBuilder cmSms(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CMEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * Syntax: <code>coap:uri</code>
     * 
     * Path parameter: uri
     * The URI for the CoAP endpoint
     * 
     * @param path uri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CoAPEndpointBuilderFactory.CoAPEndpointBuilder coap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CoAPEndpointBuilderFactory.endpointBuilder("coap", path);
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * Syntax: <code>coap:uri</code>
     * 
     * Path parameter: uri
     * The URI for the CoAP endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path uri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CoAPEndpointBuilderFactory.CoAPEndpointBuilder coap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CoAPEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CometD (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * Syntax: <code>cometd:host:port/channelName</code>
     * 
     * Path parameter: host (required)
     * Hostname
     * 
     * Path parameter: port (required)
     * Host port number
     * 
     * Path parameter: channelName (required)
     * The channelName represents a topic that can be subscribed to by the Camel
     * endpoints.
     * 
     * @param path host:port/channelName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CometdEndpointBuilderFactory.CometdEndpointBuilder cometd(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CometdEndpointBuilderFactory.endpointBuilder("cometd", path);
    }
    /**
     * CometD (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * Syntax: <code>cometd:host:port/channelName</code>
     * 
     * Path parameter: host (required)
     * Hostname
     * 
     * Path parameter: port (required)
     * Host port number
     * 
     * Path parameter: channelName (required)
     * The channelName represents a topic that can be subscribed to by the Camel
     * endpoints.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/channelName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CometdEndpointBuilderFactory.CometdEndpointBuilder cometd(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CometdEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Consul (camel-consul)
     * Integrate with Consul service discovery and configuration store.
     * 
     * Category: cloud,api
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-consul
     * 
     * Syntax: <code>consul:apiEndpoint</code>
     * 
     * Path parameter: apiEndpoint (required)
     * The API endpoint
     * 
     * @param path apiEndpoint
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ConsulEndpointBuilderFactory.ConsulEndpointBuilder consul(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ConsulEndpointBuilderFactory.endpointBuilder("consul", path);
    }
    /**
     * Consul (camel-consul)
     * Integrate with Consul service discovery and configuration store.
     * 
     * Category: cloud,api
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-consul
     * 
     * Syntax: <code>consul:apiEndpoint</code>
     * 
     * Path parameter: apiEndpoint (required)
     * The API endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiEndpoint
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ConsulEndpointBuilderFactory.ConsulEndpointBuilder consul(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ConsulEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Control Bus (camel-controlbus)
     * Manage and monitor Camel routes.
     * 
     * Category: core,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-controlbus
     * 
     * Syntax: <code>controlbus:command:language</code>
     * 
     * Path parameter: command (required)
     * Command can be either route or language
     * There are 2 enums and the value can be one of: route, language
     * 
     * Path parameter: language
     * Allows you to specify the name of a Language to use for evaluating the
     * message body. If there is any result from the evaluation, then the result
     * is put in the message body.
     * There are 22 enums and the value can be one of: bean, constant, csimple,
     * datasonnet, exchangeProperty, file, groovy, header, hl7terser, joor, jq,
     * jsonpath, mvel, ognl, python, ref, simple, spel, tokenize, xpath, xquery,
     * xtokenize
     * 
     * @param path command:language
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ControlBusEndpointBuilderFactory.ControlBusEndpointBuilder controlbus(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ControlBusEndpointBuilderFactory.endpointBuilder("controlbus", path);
    }
    /**
     * Control Bus (camel-controlbus)
     * Manage and monitor Camel routes.
     * 
     * Category: core,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-controlbus
     * 
     * Syntax: <code>controlbus:command:language</code>
     * 
     * Path parameter: command (required)
     * Command can be either route or language
     * There are 2 enums and the value can be one of: route, language
     * 
     * Path parameter: language
     * Allows you to specify the name of a Language to use for evaluating the
     * message body. If there is any result from the evaluation, then the result
     * is put in the message body.
     * There are 22 enums and the value can be one of: bean, constant, csimple,
     * datasonnet, exchangeProperty, file, groovy, header, hl7terser, joor, jq,
     * jsonpath, mvel, ognl, python, ref, simple, spel, tokenize, xpath, xquery,
     * xtokenize
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path command:language
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ControlBusEndpointBuilderFactory.ControlBusEndpointBuilder controlbus(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ControlBusEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Corda (camel-corda)
     * Perform operations against Corda blockchain platform using corda-rpc
     * library.
     * 
     * Category: blockchain,rpc
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-corda
     * 
     * Syntax: <code>corda:node</code>
     * 
     * Path parameter: node (required)
     * The url for the corda node
     * 
     * @param path node
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.CordaEndpointBuilderFactory.CordaEndpointBuilder corda(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CordaEndpointBuilderFactory.endpointBuilder("corda", path);
    }
    /**
     * Corda (camel-corda)
     * Perform operations against Corda blockchain platform using corda-rpc
     * library.
     * 
     * Category: blockchain,rpc
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-corda
     * 
     * Syntax: <code>corda:node</code>
     * 
     * Path parameter: node (required)
     * The url for the corda node
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path node
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.CordaEndpointBuilderFactory.CordaEndpointBuilder corda(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CordaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Couchbase (camel-couchbase)
     * Query Couchbase Views with a poll strategy and/or perform various
     * operations against Couchbase databases.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     * 
     * Syntax: <code>couchbase:protocol://hostname:port</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use
     * 
     * Path parameter: hostname (required)
     * The hostname to use
     * 
     * Path parameter: port
     * The port number to use
     * Default value: 8091
     * 
     * @param path protocol://hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CouchbaseEndpointBuilderFactory.CouchbaseEndpointBuilder couchbase(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CouchbaseEndpointBuilderFactory.endpointBuilder("couchbase", path);
    }
    /**
     * Couchbase (camel-couchbase)
     * Query Couchbase Views with a poll strategy and/or perform various
     * operations against Couchbase databases.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     * 
     * Syntax: <code>couchbase:protocol://hostname:port</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use
     * 
     * Path parameter: hostname (required)
     * The hostname to use
     * 
     * Path parameter: port
     * The port number to use
     * Default value: 8091
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path protocol://hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CouchbaseEndpointBuilderFactory.CouchbaseEndpointBuilder couchbase(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CouchbaseEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CouchDB (camel-couchdb)
     * Consume changesets for inserts, updates and deletes in a CouchDB
     * database, as well as get, save, update and delete documents from a
     * CouchDB database.
     * 
     * Category: database,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-couchdb
     * 
     * Syntax: <code>couchdb:protocol:hostname:port/database</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use for communicating with the database.
     * There are 2 enums and the value can be one of: http, https
     * 
     * Path parameter: hostname (required)
     * Hostname of the running couchdb instance
     * 
     * Path parameter: port
     * Port number for the running couchdb instance
     * Default value: 5984
     * 
     * Path parameter: database (required)
     * Name of the database to use
     * 
     * @param path protocol:hostname:port/database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CouchDbEndpointBuilderFactory.CouchDbEndpointBuilder couchdb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CouchDbEndpointBuilderFactory.endpointBuilder("couchdb", path);
    }
    /**
     * CouchDB (camel-couchdb)
     * Consume changesets for inserts, updates and deletes in a CouchDB
     * database, as well as get, save, update and delete documents from a
     * CouchDB database.
     * 
     * Category: database,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-couchdb
     * 
     * Syntax: <code>couchdb:protocol:hostname:port/database</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use for communicating with the database.
     * There are 2 enums and the value can be one of: http, https
     * 
     * Path parameter: hostname (required)
     * Hostname of the running couchdb instance
     * 
     * Path parameter: port
     * Port number for the running couchdb instance
     * Default value: 5984
     * 
     * Path parameter: database (required)
     * Name of the database to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path protocol:hostname:port/database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CouchDbEndpointBuilderFactory.CouchDbEndpointBuilder couchdb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CouchDbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
     * Based on Cassandra Java Driver provided by DataStax.
     * 
     * Category: database,nosql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     * 
     * Syntax: <code>cql:beanRef:hosts:port/keyspace</code>
     * 
     * Path parameter: beanRef
     * beanRef is defined using bean:id
     * 
     * Path parameter: hosts
     * Hostname(s) Cassandra server(s). Multiple hosts can be separated by
     * comma.
     * 
     * Path parameter: port
     * Port number of Cassandra server(s)
     * 
     * Path parameter: keyspace
     * Keyspace to use
     * 
     * @param path beanRef:hosts:port/keyspace
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CassandraEndpointBuilderFactory.CassandraEndpointBuilder cql(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CassandraEndpointBuilderFactory.endpointBuilder("cql", path);
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
     * Based on Cassandra Java Driver provided by DataStax.
     * 
     * Category: database,nosql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     * 
     * Syntax: <code>cql:beanRef:hosts:port/keyspace</code>
     * 
     * Path parameter: beanRef
     * beanRef is defined using bean:id
     * 
     * Path parameter: hosts
     * Hostname(s) Cassandra server(s). Multiple hosts can be separated by
     * comma.
     * 
     * Path parameter: port
     * Port number of Cassandra server(s)
     * 
     * Path parameter: keyspace
     * Keyspace to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanRef:hosts:port/keyspace
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CassandraEndpointBuilderFactory.CassandraEndpointBuilder cql(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CassandraEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Cron (camel-cron)
     * A generic interface for triggering events at times specified through the
     * Unix cron syntax.
     * 
     * Category: scheduling
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-cron
     * 
     * Syntax: <code>cron:name</code>
     * 
     * Path parameter: name (required)
     * The name of the cron trigger
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CronEndpointBuilderFactory.CronEndpointBuilder cron(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CronEndpointBuilderFactory.endpointBuilder("cron", path);
    }
    /**
     * Cron (camel-cron)
     * A generic interface for triggering events at times specified through the
     * Unix cron syntax.
     * 
     * Category: scheduling
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-cron
     * 
     * Syntax: <code>cron:name</code>
     * 
     * Path parameter: name (required)
     * The name of the cron trigger
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CronEndpointBuilderFactory.CronEndpointBuilder cron(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CronEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Crypto (JCE) (camel-crypto)
     * Sign and verify exchanges using the Signature Service of the Java
     * Cryptographic Extension (JCE).
     * 
     * Category: security,transformation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-crypto
     * 
     * Syntax: <code>crypto:cryptoOperation:name</code>
     * 
     * Path parameter: cryptoOperation (required)
     * Set the Crypto operation from that supplied after the crypto scheme in
     * the endpoint uri e.g. crypto:sign sets sign as the operation.
     * There are 2 enums and the value can be one of: sign, verify
     * 
     * Path parameter: name (required)
     * The logical name of this operation.
     * 
     * @param path cryptoOperation:name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DigitalSignatureEndpointBuilderFactory.DigitalSignatureEndpointBuilder crypto(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DigitalSignatureEndpointBuilderFactory.endpointBuilder("crypto", path);
    }
    /**
     * Crypto (JCE) (camel-crypto)
     * Sign and verify exchanges using the Signature Service of the Java
     * Cryptographic Extension (JCE).
     * 
     * Category: security,transformation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-crypto
     * 
     * Syntax: <code>crypto:cryptoOperation:name</code>
     * 
     * Path parameter: cryptoOperation (required)
     * Set the Crypto operation from that supplied after the crypto scheme in
     * the endpoint uri e.g. crypto:sign sets sign as the operation.
     * There are 2 enums and the value can be one of: sign, verify
     * 
     * Path parameter: name (required)
     * The logical name of this operation.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cryptoOperation:name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DigitalSignatureEndpointBuilderFactory.DigitalSignatureEndpointBuilder crypto(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DigitalSignatureEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CXF (camel-cxf-soap)
     * Expose SOAP WebServices using Apache CXF or connect to external
     * WebServices using CXF WS client.
     * 
     * Category: soap,webservice
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-cxf-soap
     * 
     * Syntax: <code>cxf:beanId:address</code>
     * 
     * Path parameter: beanId
     * To lookup an existing configured CxfEndpoint. Must used bean: as prefix.
     * 
     * Path parameter: address
     * The service publish address.
     * 
     * @param path beanId:address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CxfEndpointBuilderFactory.CxfEndpointBuilder cxf(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CxfEndpointBuilderFactory.endpointBuilder("cxf", path);
    }
    /**
     * CXF (camel-cxf-soap)
     * Expose SOAP WebServices using Apache CXF or connect to external
     * WebServices using CXF WS client.
     * 
     * Category: soap,webservice
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-cxf-soap
     * 
     * Syntax: <code>cxf:beanId:address</code>
     * 
     * Path parameter: beanId
     * To lookup an existing configured CxfEndpoint. Must used bean: as prefix.
     * 
     * Path parameter: address
     * The service publish address.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanId:address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CxfEndpointBuilderFactory.CxfEndpointBuilder cxf(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CxfEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * CXF-RS (camel-cxf-rest)
     * Expose JAX-RS REST services using Apache CXF or connect to external REST
     * services using CXF REST client.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf-rest
     * 
     * Syntax: <code>cxfrs:beanId:address</code>
     * 
     * Path parameter: beanId
     * To lookup an existing configured CxfRsEndpoint. Must used bean: as
     * prefix.
     * 
     * Path parameter: address
     * The service publish address.
     * 
     * @param path beanId:address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CxfRsEndpointBuilderFactory.CxfRsEndpointBuilder cxfrs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CxfRsEndpointBuilderFactory.endpointBuilder("cxfrs", path);
    }
    /**
     * CXF-RS (camel-cxf-rest)
     * Expose JAX-RS REST services using Apache CXF or connect to external REST
     * services using CXF REST client.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf-rest
     * 
     * Syntax: <code>cxfrs:beanId:address</code>
     * 
     * Path parameter: beanId
     * To lookup an existing configured CxfRsEndpoint. Must used bean: as
     * prefix.
     * 
     * Path parameter: address
     * The service publish address.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanId:address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CxfRsEndpointBuilderFactory.CxfRsEndpointBuilder cxfrs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CxfRsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Data Format (camel-dataformat)
     * Use a Camel Data Format as a regular Camel Component.
     * 
     * Category: core,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-dataformat
     * 
     * Syntax: <code>dataformat:name:operation</code>
     * 
     * Path parameter: name (required)
     * Name of data format
     * 
     * Path parameter: operation (required)
     * Operation to use either marshal or unmarshal
     * There are 2 enums and the value can be one of: marshal, unmarshal
     * 
     * @param path name:operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataFormatEndpointBuilderFactory.DataFormatEndpointBuilder dataformat(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataFormatEndpointBuilderFactory.endpointBuilder("dataformat", path);
    }
    /**
     * Data Format (camel-dataformat)
     * Use a Camel Data Format as a regular Camel Component.
     * 
     * Category: core,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-dataformat
     * 
     * Syntax: <code>dataformat:name:operation</code>
     * 
     * Path parameter: name (required)
     * Name of data format
     * 
     * Path parameter: operation (required)
     * Operation to use either marshal or unmarshal
     * There are 2 enums and the value can be one of: marshal, unmarshal
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name:operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataFormatEndpointBuilderFactory.DataFormatEndpointBuilder dataformat(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataFormatEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Dataset (camel-dataset)
     * Provide data for load and soak testing of your Camel application.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * Syntax: <code>dataset:name</code>
     * 
     * Path parameter: name (required)
     * Name of DataSet to lookup in the registry
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataSetEndpointBuilderFactory.DataSetEndpointBuilder dataset(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataSetEndpointBuilderFactory.endpointBuilder("dataset", path);
    }
    /**
     * Dataset (camel-dataset)
     * Provide data for load and soak testing of your Camel application.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * Syntax: <code>dataset:name</code>
     * 
     * Path parameter: name (required)
     * Name of DataSet to lookup in the registry
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataSetEndpointBuilderFactory.DataSetEndpointBuilder dataset(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataSetEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * DataSet Test (camel-dataset)
     * Extends the mock component by pulling messages from another endpoint on
     * startup to set the expected message bodies.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * Syntax: <code>dataset-test:name</code>
     * 
     * Path parameter: name (required)
     * Name of endpoint to lookup in the registry to use for polling messages
     * used for testing
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataSetTestEndpointBuilderFactory.DataSetTestEndpointBuilder datasetTest(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataSetTestEndpointBuilderFactory.endpointBuilder("dataset-test", path);
    }
    /**
     * DataSet Test (camel-dataset)
     * Extends the mock component by pulling messages from another endpoint on
     * startup to set the expected message bodies.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * Syntax: <code>dataset-test:name</code>
     * 
     * Path parameter: name (required)
     * Name of endpoint to lookup in the registry to use for polling messages
     * used for testing
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DataSetTestEndpointBuilderFactory.DataSetTestEndpointBuilder datasetTest(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DataSetTestEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium DB2 Connector (camel-debezium-db2)
     * Capture changes from a DB2 database.
     * 
     * Category: database,sql
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-db2
     * 
     * Syntax: <code>debezium-db2:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumDb2EndpointBuilderFactory.DebeziumDb2EndpointBuilder debeziumDb2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumDb2EndpointBuilderFactory.endpointBuilder("debezium-db2", path);
    }
    /**
     * Debezium DB2 Connector (camel-debezium-db2)
     * Capture changes from a DB2 database.
     * 
     * Category: database,sql
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-db2
     * 
     * Syntax: <code>debezium-db2:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumDb2EndpointBuilderFactory.DebeziumDb2EndpointBuilder debeziumDb2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumDb2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Capture changes from a MongoDB database.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     * 
     * Syntax: <code>debezium-mongodb:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumMongodbEndpointBuilderFactory.DebeziumMongodbEndpointBuilder debeziumMongodb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumMongodbEndpointBuilderFactory.endpointBuilder("debezium-mongodb", path);
    }
    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Capture changes from a MongoDB database.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     * 
     * Syntax: <code>debezium-mongodb:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumMongodbEndpointBuilderFactory.DebeziumMongodbEndpointBuilder debeziumMongodb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumMongodbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Capture changes from a MySQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     * 
     * Syntax: <code>debezium-mysql:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumMySqlEndpointBuilderFactory.DebeziumMySqlEndpointBuilder debeziumMysql(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumMySqlEndpointBuilderFactory.endpointBuilder("debezium-mysql", path);
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Capture changes from a MySQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     * 
     * Syntax: <code>debezium-mysql:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumMySqlEndpointBuilderFactory.DebeziumMySqlEndpointBuilder debeziumMysql(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumMySqlEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium Oracle Connector (camel-debezium-oracle)
     * Capture changes from a Oracle database.
     * 
     * Category: database,sql
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-oracle
     * 
     * Syntax: <code>debezium-oracle:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumOracleEndpointBuilderFactory.DebeziumOracleEndpointBuilder debeziumOracle(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumOracleEndpointBuilderFactory.endpointBuilder("debezium-oracle", path);
    }
    /**
     * Debezium Oracle Connector (camel-debezium-oracle)
     * Capture changes from a Oracle database.
     * 
     * Category: database,sql
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-oracle
     * 
     * Syntax: <code>debezium-oracle:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumOracleEndpointBuilderFactory.DebeziumOracleEndpointBuilder debeziumOracle(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumOracleEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Capture changes from a PostgresSQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     * 
     * Syntax: <code>debezium-postgres:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumPostgresEndpointBuilderFactory.DebeziumPostgresEndpointBuilder debeziumPostgres(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumPostgresEndpointBuilderFactory.endpointBuilder("debezium-postgres", path);
    }
    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Capture changes from a PostgresSQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     * 
     * Syntax: <code>debezium-postgres:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumPostgresEndpointBuilderFactory.DebeziumPostgresEndpointBuilder debeziumPostgres(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumPostgresEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Capture changes from an SQL Server database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     * 
     * Syntax: <code>debezium-sqlserver:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumSqlserverEndpointBuilderFactory.DebeziumSqlserverEndpointBuilder debeziumSqlserver(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumSqlserverEndpointBuilderFactory.endpointBuilder("debezium-sqlserver", path);
    }
    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Capture changes from an SQL Server database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     * 
     * Syntax: <code>debezium-sqlserver:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DebeziumSqlserverEndpointBuilderFactory.DebeziumSqlserverEndpointBuilder debeziumSqlserver(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DebeziumSqlserverEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * DigitalOcean (camel-digitalocean)
     * Manage Droplets and resources within the DigitalOcean cloud.
     * 
     * Category: cloud,management
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-digitalocean
     * 
     * Syntax: <code>digitalocean:operation</code>
     * 
     * Path parameter: operation
     * The operation to perform to the given resource.
     * There are 36 enums and the value can be one of: create, update, delete,
     * list, ownList, get, listBackups, listActions, listNeighbors,
     * listSnapshots, listKernels, listAllNeighbors, enableBackups,
     * disableBackups, reboot, powerCycle, shutdown, powerOn, powerOff, restore,
     * resetPassword, resize, rebuild, rename, changeKernel, enableIpv6,
     * enablePrivateNetworking, takeSnapshot, transfer, convert, attach, detach,
     * assign, unassign, tag, untag
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DigitalOceanEndpointBuilderFactory.DigitalOceanEndpointBuilder digitalocean(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DigitalOceanEndpointBuilderFactory.endpointBuilder("digitalocean", path);
    }
    /**
     * DigitalOcean (camel-digitalocean)
     * Manage Droplets and resources within the DigitalOcean cloud.
     * 
     * Category: cloud,management
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-digitalocean
     * 
     * Syntax: <code>digitalocean:operation</code>
     * 
     * Path parameter: operation
     * The operation to perform to the given resource.
     * There are 36 enums and the value can be one of: create, update, delete,
     * list, ownList, get, listBackups, listActions, listNeighbors,
     * listSnapshots, listKernels, listAllNeighbors, enableBackups,
     * disableBackups, reboot, powerCycle, shutdown, powerOn, powerOff, restore,
     * resetPassword, resize, rebuild, rename, changeKernel, enableIpv6,
     * enablePrivateNetworking, takeSnapshot, transfer, convert, attach, detach,
     * assign, unassign, tag, untag
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DigitalOceanEndpointBuilderFactory.DigitalOceanEndpointBuilder digitalocean(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DigitalOceanEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Direct (camel-direct)
     * Call another endpoint from the same Camel Context synchronously.
     * 
     * Category: core,endpoint
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-direct
     * 
     * Syntax: <code>direct:name</code>
     * 
     * Path parameter: name (required)
     * Name of direct endpoint
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DirectEndpointBuilderFactory.DirectEndpointBuilder direct(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DirectEndpointBuilderFactory.endpointBuilder("direct", path);
    }
    /**
     * Direct (camel-direct)
     * Call another endpoint from the same Camel Context synchronously.
     * 
     * Category: core,endpoint
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-direct
     * 
     * Syntax: <code>direct:name</code>
     * 
     * Path parameter: name (required)
     * Name of direct endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DirectEndpointBuilderFactory.DirectEndpointBuilder direct(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DirectEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Direct VM (camel-directvm)
     * Call another endpoint from any Camel Context in the same JVM
     * synchronously.
     * 
     * Category: core,endpoint
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-directvm
     * 
     * Syntax: <code>direct-vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of direct-vm endpoint
     * 
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.DirectVmEndpointBuilderFactory.DirectVmEndpointBuilder directVm(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DirectVmEndpointBuilderFactory.endpointBuilder("direct-vm", path);
    }
    /**
     * Direct VM (camel-directvm)
     * Call another endpoint from any Camel Context in the same JVM
     * synchronously.
     * 
     * Category: core,endpoint
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-directvm
     * 
     * Syntax: <code>direct-vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of direct-vm endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.DirectVmEndpointBuilderFactory.DirectVmEndpointBuilder directVm(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DirectVmEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Disruptor (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * Syntax: <code>disruptor:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DisruptorEndpointBuilderFactory.DisruptorEndpointBuilder disruptor(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DisruptorEndpointBuilderFactory.endpointBuilder("disruptor", path);
    }
    /**
     * Disruptor (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * Syntax: <code>disruptor:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DisruptorEndpointBuilderFactory.DisruptorEndpointBuilder disruptor(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DisruptorEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Disruptor VM (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * Syntax: <code>disruptor-vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DisruptorVmEndpointBuilderFactory.DisruptorVmEndpointBuilder disruptorVm(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DisruptorVmEndpointBuilderFactory.endpointBuilder("disruptor-vm", path);
    }
    /**
     * Disruptor VM (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * Syntax: <code>disruptor-vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DisruptorVmEndpointBuilderFactory.DisruptorVmEndpointBuilder disruptorVm(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DisruptorVmEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Deep Java Library (camel-djl)
     * Infer Deep Learning models from message exchanges data using Deep Java
     * Library (DJL).
     * 
     * Category: ai,deeplearning
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-djl
     * 
     * Syntax: <code>djl:application</code>
     * 
     * Path parameter: application (required)
     * Application name
     * 
     * @param path application
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DJLEndpointBuilderFactory.DJLEndpointBuilder djl(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DJLEndpointBuilderFactory.endpointBuilder("djl", path);
    }
    /**
     * Deep Java Library (camel-djl)
     * Infer Deep Learning models from message exchanges data using Deep Java
     * Library (DJL).
     * 
     * Category: ai,deeplearning
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-djl
     * 
     * Syntax: <code>djl:application</code>
     * 
     * Path parameter: application (required)
     * Application name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path application
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DJLEndpointBuilderFactory.DJLEndpointBuilder djl(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DJLEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * DNS (camel-dns)
     * Perform DNS queries using DNSJava.
     * 
     * Category: networking
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-dns
     * 
     * Syntax: <code>dns:dnsType</code>
     * 
     * Path parameter: dnsType (required)
     * The type of the lookup.
     * There are 4 enums and the value can be one of: dig, ip, lookup, wikipedia
     * 
     * @param path dnsType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DnsEndpointBuilderFactory.DnsEndpointBuilder dns(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DnsEndpointBuilderFactory.endpointBuilder("dns", path);
    }
    /**
     * DNS (camel-dns)
     * Perform DNS queries using DNSJava.
     * 
     * Category: networking
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-dns
     * 
     * Syntax: <code>dns:dnsType</code>
     * 
     * Path parameter: dnsType (required)
     * The type of the lookup.
     * There are 4 enums and the value can be one of: dig, ip, lookup, wikipedia
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path dnsType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DnsEndpointBuilderFactory.DnsEndpointBuilder dns(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DnsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Docker (camel-docker)
     * Manage Docker containers.
     * 
     * Category: cloud,container,paas
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-docker
     * 
     * Syntax: <code>docker:operation</code>
     * 
     * Path parameter: operation (required)
     * Which operation to use
     * There are 37 enums and the value can be one of: events, stats, auth,
     * info, ping, version, imagebuild, imagecreate, imageinspect, imagelist,
     * imagepull, imagepush, imageremove, imagesearch, imagetag,
     * containerattach, containercommit, containercopyfile, containercreate,
     * containerdiff, inspectcontainer, containerkill, containerlist,
     * containerlog, containerpause, containerrestart, containerremove,
     * containerstart, containerstop, containertop, containerunpause,
     * containerwait, execcreate, execstart, networkconnect, networkcreate,
     * networkremove
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DockerEndpointBuilderFactory.DockerEndpointBuilder docker(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DockerEndpointBuilderFactory.endpointBuilder("docker", path);
    }
    /**
     * Docker (camel-docker)
     * Manage Docker containers.
     * 
     * Category: cloud,container,paas
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-docker
     * 
     * Syntax: <code>docker:operation</code>
     * 
     * Path parameter: operation (required)
     * Which operation to use
     * There are 37 enums and the value can be one of: events, stats, auth,
     * info, ping, version, imagebuild, imagecreate, imageinspect, imagelist,
     * imagepull, imagepush, imageremove, imagesearch, imagetag,
     * containerattach, containercommit, containercopyfile, containercreate,
     * containerdiff, inspectcontainer, containerkill, containerlist,
     * containerlog, containerpause, containerrestart, containerremove,
     * containerstart, containerstop, containertop, containerunpause,
     * containerwait, execcreate, execstart, networkconnect, networkcreate,
     * networkremove
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DockerEndpointBuilderFactory.DockerEndpointBuilder docker(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DockerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Drill (camel-drill)
     * Perform queries against an Apache Drill cluster.
     * 
     * Category: database,sql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-drill
     * 
     * Syntax: <code>drill:host</code>
     * 
     * Path parameter: host (required)
     * Host name or IP address
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DrillEndpointBuilderFactory.DrillEndpointBuilder drill(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DrillEndpointBuilderFactory.endpointBuilder("drill", path);
    }
    /**
     * Drill (camel-drill)
     * Perform queries against an Apache Drill cluster.
     * 
     * Category: database,sql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-drill
     * 
     * Syntax: <code>drill:host</code>
     * 
     * Path parameter: host (required)
     * Host name or IP address
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DrillEndpointBuilderFactory.DrillEndpointBuilder drill(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DrillEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Dropbox (camel-dropbox)
     * Upload, download and manage files, folders, groups, collaborations, etc
     * on Dropbox.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-dropbox
     * 
     * Syntax: <code>dropbox:operation</code>
     * 
     * Path parameter: operation (required)
     * The specific action (typically is a CRUD action) to perform on Dropbox
     * remote folder.
     * There are 5 enums and the value can be one of: put, del, search, get,
     * move
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DropboxEndpointBuilderFactory.DropboxEndpointBuilder dropbox(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DropboxEndpointBuilderFactory.endpointBuilder("dropbox", path);
    }
    /**
     * Dropbox (camel-dropbox)
     * Upload, download and manage files, folders, groups, collaborations, etc
     * on Dropbox.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-dropbox
     * 
     * Syntax: <code>dropbox:operation</code>
     * 
     * Path parameter: operation (required)
     * The specific action (typically is a CRUD action) to perform on Dropbox
     * remote folder.
     * There are 5 enums and the value can be one of: put, del, search, get,
     * move
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DropboxEndpointBuilderFactory.DropboxEndpointBuilder dropbox(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DropboxEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Dynamic Router (camel-dynamic-router)
     * The Dynamic Router component routes exchanges to recipients, and the
     * recipients (and their rules) may change at runtime.
     * 
     * Category: endpoint,java
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-dynamic-router
     * 
     * Syntax: <code>dynamic-router:channel</code>
     * 
     * Path parameter: channel (required)
     * Channel of the Dynamic Router
     * 
     * Path parameter: controlAction
     * Control channel action: subscribe or unsubscribe
     * There are 2 enums and the value can be one of: subscribe, unsubscribe
     * 
     * Path parameter: subscribeChannel
     * The channel to subscribe to
     * 
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DynamicRouterEndpointBuilderFactory.DynamicRouterEndpointBuilder dynamicRouter(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DynamicRouterEndpointBuilderFactory.endpointBuilder("dynamic-router", path);
    }
    /**
     * Dynamic Router (camel-dynamic-router)
     * The Dynamic Router component routes exchanges to recipients, and the
     * recipients (and their rules) may change at runtime.
     * 
     * Category: endpoint,java
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-dynamic-router
     * 
     * Syntax: <code>dynamic-router:channel</code>
     * 
     * Path parameter: channel (required)
     * Channel of the Dynamic Router
     * 
     * Path parameter: controlAction
     * Control channel action: subscribe or unsubscribe
     * There are 2 enums and the value can be one of: subscribe, unsubscribe
     * 
     * Path parameter: subscribeChannel
     * The channel to subscribe to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DynamicRouterEndpointBuilderFactory.DynamicRouterEndpointBuilder dynamicRouter(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DynamicRouterEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ehcache (camel-ehcache)
     * Perform caching operations using Ehcache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     * 
     * Syntax: <code>ehcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * the cache name
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EhcacheEndpointBuilderFactory.EhcacheEndpointBuilder ehcache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EhcacheEndpointBuilderFactory.endpointBuilder("ehcache", path);
    }
    /**
     * Ehcache (camel-ehcache)
     * Perform caching operations using Ehcache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     * 
     * Syntax: <code>ehcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * the cache name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EhcacheEndpointBuilderFactory.EhcacheEndpointBuilder ehcache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EhcacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Elasticsearch (camel-elasticsearch)
     * Send requests to ElasticSearch via Java Client API.
     * 
     * Category: search,monitoring
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-elasticsearch
     * 
     * Syntax: <code>elasticsearch:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * Name of the cluster
     * 
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ElasticsearchEndpointBuilderFactory.ElasticsearchEndpointBuilder elasticsearch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ElasticsearchEndpointBuilderFactory.endpointBuilder("elasticsearch", path);
    }
    /**
     * Elasticsearch (camel-elasticsearch)
     * Send requests to ElasticSearch via Java Client API.
     * 
     * Category: search,monitoring
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-elasticsearch
     * 
     * Syntax: <code>elasticsearch:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * Name of the cluster
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ElasticsearchEndpointBuilderFactory.ElasticsearchEndpointBuilder elasticsearch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ElasticsearchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Elasticsearch Rest (camel-elasticsearch-rest)
     * Send requests to ElasticSearch via REST API
     * 
     * Category: search,monitoring
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-elasticsearch-rest
     * 
     * Syntax: <code>elasticsearch-rest:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * Name of the cluster
     * 
     * @param path clusterName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.ElasticsearchRestEndpointBuilderFactory.ElasticsearchRestEndpointBuilder elasticsearchRest(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ElasticsearchRestEndpointBuilderFactory.endpointBuilder("elasticsearch-rest", path);
    }
    /**
     * Elasticsearch Rest (camel-elasticsearch-rest)
     * Send requests to ElasticSearch via REST API
     * 
     * Category: search,monitoring
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-elasticsearch-rest
     * 
     * Syntax: <code>elasticsearch-rest:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * Name of the cluster
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path clusterName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.ElasticsearchRestEndpointBuilderFactory.ElasticsearchRestEndpointBuilder elasticsearchRest(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ElasticsearchRestEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Etcd v3 (camel-etcd3)
     * Get, set, delete or watch keys in etcd key-value store.
     * 
     * Category: clustering,database
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-etcd3
     * 
     * Syntax: <code>etcd3:path</code>
     * 
     * Path parameter: path
     * The path the endpoint refers to
     * 
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Etcd3EndpointBuilderFactory.Etcd3EndpointBuilder etcd3(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Etcd3EndpointBuilderFactory.endpointBuilder("etcd3", path);
    }
    /**
     * Etcd v3 (camel-etcd3)
     * Get, set, delete or watch keys in etcd key-value store.
     * 
     * Category: clustering,database
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-etcd3
     * 
     * Syntax: <code>etcd3:path</code>
     * 
     * Path parameter: path
     * The path the endpoint refers to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Etcd3EndpointBuilderFactory.Etcd3EndpointBuilder etcd3(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Etcd3EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Exec (camel-exec)
     * Execute commands on the underlying operating system.
     * 
     * Category: system
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-exec
     * 
     * Syntax: <code>exec:executable</code>
     * 
     * Path parameter: executable (required)
     * Sets the executable to be executed. The executable must not be empty or
     * null.
     * 
     * @param path executable
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ExecEndpointBuilderFactory.ExecEndpointBuilder exec(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ExecEndpointBuilderFactory.endpointBuilder("exec", path);
    }
    /**
     * Exec (camel-exec)
     * Execute commands on the underlying operating system.
     * 
     * Category: system
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-exec
     * 
     * Syntax: <code>exec:executable</code>
     * 
     * Path parameter: executable (required)
     * Sets the executable to be executed. The executable must not be empty or
     * null.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path executable
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ExecEndpointBuilderFactory.ExecEndpointBuilder exec(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ExecEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Facebook (camel-facebook)
     * Send requests to Facebook APIs supported by Facebook4J.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * Syntax: <code>facebook:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to perform
     * 
     * @param path methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FacebookEndpointBuilderFactory.FacebookEndpointBuilder facebook(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FacebookEndpointBuilderFactory.endpointBuilder("facebook", path);
    }
    /**
     * Facebook (camel-facebook)
     * Send requests to Facebook APIs supported by Facebook4J.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * Syntax: <code>facebook:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to perform
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FacebookEndpointBuilderFactory.FacebookEndpointBuilder facebook(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FacebookEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * FHIR (camel-fhir)
     * Exchange information in the healthcare domain using the FHIR (Fast
     * Healthcare Interoperability Resources) standard.
     * 
     * Category: api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     * 
     * Syntax: <code>fhir:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
     * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
     * TRANSACTION, UPDATE, VALIDATE
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FhirEndpointBuilderFactory.FhirEndpointBuilder fhir(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FhirEndpointBuilderFactory.endpointBuilder("fhir", path);
    }
    /**
     * FHIR (camel-fhir)
     * Exchange information in the healthcare domain using the FHIR (Fast
     * Healthcare Interoperability Resources) standard.
     * 
     * Category: api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     * 
     * Syntax: <code>fhir:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
     * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
     * TRANSACTION, UPDATE, VALIDATE
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FhirEndpointBuilderFactory.FhirEndpointBuilder fhir(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FhirEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * File (camel-file)
     * Read and write files.
     * 
     * Category: file,core
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-file
     * 
     * Syntax: <code>file:directoryName</code>
     * 
     * Path parameter: directoryName (required)
     * The starting directory
     * 
     * @param path directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FileEndpointBuilderFactory.FileEndpointBuilder file(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FileEndpointBuilderFactory.endpointBuilder("file", path);
    }
    /**
     * File (camel-file)
     * Read and write files.
     * 
     * Category: file,core
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-file
     * 
     * Syntax: <code>file:directoryName</code>
     * 
     * Path parameter: directoryName (required)
     * The starting directory
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FileEndpointBuilderFactory.FileEndpointBuilder file(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FileEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * File Watch (camel-file-watch)
     * Get notified about file events in a directory using
     * java.nio.file.WatchService.
     * 
     * Category: file
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-file-watch
     * 
     * Syntax: <code>file-watch:path</code>
     * 
     * Path parameter: path (required)
     * Path of directory to consume events from.
     * 
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FileWatchEndpointBuilderFactory.FileWatchEndpointBuilder fileWatch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FileWatchEndpointBuilderFactory.endpointBuilder("file-watch", path);
    }
    /**
     * File Watch (camel-file-watch)
     * Get notified about file events in a directory using
     * java.nio.file.WatchService.
     * 
     * Category: file
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-file-watch
     * 
     * Syntax: <code>file-watch:path</code>
     * 
     * Path parameter: path (required)
     * Path of directory to consume events from.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FileWatchEndpointBuilderFactory.FileWatchEndpointBuilder fileWatch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FileWatchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Flatpack (camel-flatpack)
     * Parse fixed width and delimited files using the FlatPack library.
     * 
     * Category: transformation
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     * 
     * Syntax: <code>flatpack:type:resourceUri</code>
     * 
     * Path parameter: type
     * Whether to use fixed or delimiter
     * Default value: delim
     * There are 2 enums and the value can be one of: fixed, delim
     * 
     * Path parameter: resourceUri (required)
     * URL for loading the flatpack mapping file from classpath or file system
     * 
     * @param path type:resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FlatpackEndpointBuilderFactory.FlatpackEndpointBuilder flatpack(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FlatpackEndpointBuilderFactory.endpointBuilder("flatpack", path);
    }
    /**
     * Flatpack (camel-flatpack)
     * Parse fixed width and delimited files using the FlatPack library.
     * 
     * Category: transformation
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     * 
     * Syntax: <code>flatpack:type:resourceUri</code>
     * 
     * Path parameter: type
     * Whether to use fixed or delimiter
     * Default value: delim
     * There are 2 enums and the value can be one of: fixed, delim
     * 
     * Path parameter: resourceUri (required)
     * URL for loading the flatpack mapping file from classpath or file system
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type:resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FlatpackEndpointBuilderFactory.FlatpackEndpointBuilder flatpack(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FlatpackEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Flink (camel-flink)
     * Send DataSet jobs to an Apache Flink cluster.
     * 
     * Category: transformation,bigdata,streams
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-flink
     * 
     * Syntax: <code>flink:endpointType</code>
     * 
     * Path parameter: endpointType (required)
     * Type of the endpoint (dataset, datastream).
     * There are 2 enums and the value can be one of: dataset, datastream
     * 
     * @param path endpointType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FlinkEndpointBuilderFactory.FlinkEndpointBuilder flink(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FlinkEndpointBuilderFactory.endpointBuilder("flink", path);
    }
    /**
     * Flink (camel-flink)
     * Send DataSet jobs to an Apache Flink cluster.
     * 
     * Category: transformation,bigdata,streams
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-flink
     * 
     * Syntax: <code>flink:endpointType</code>
     * 
     * Path parameter: endpointType (required)
     * Type of the endpoint (dataset, datastream).
     * There are 2 enums and the value can be one of: dataset, datastream
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FlinkEndpointBuilderFactory.FlinkEndpointBuilder flink(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FlinkEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * FOP (camel-fop)
     * Render messages into PDF and other output formats supported by Apache
     * FOP.
     * 
     * Category: file,transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-fop
     * 
     * Syntax: <code>fop:outputType</code>
     * 
     * Path parameter: outputType (required)
     * The primary output format is PDF but other output formats are also
     * supported.
     * There are 10 enums and the value can be one of: pdf, ps, pcl, png, jpeg,
     * svg, xml, mif, rtf, txt
     * 
     * @param path outputType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FopEndpointBuilderFactory.FopEndpointBuilder fop(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FopEndpointBuilderFactory.endpointBuilder("fop", path);
    }
    /**
     * FOP (camel-fop)
     * Render messages into PDF and other output formats supported by Apache
     * FOP.
     * 
     * Category: file,transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-fop
     * 
     * Syntax: <code>fop:outputType</code>
     * 
     * Path parameter: outputType (required)
     * The primary output format is PDF but other output formats are also
     * supported.
     * There are 10 enums and the value can be one of: pdf, ps, pcl, png, jpeg,
     * svg, xml, mif, rtf, txt
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path outputType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FopEndpointBuilderFactory.FopEndpointBuilder fop(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FopEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Freemarker (camel-freemarker)
     * Transform messages using FreeMarker templates.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-freemarker
     * 
     * Syntax: <code>freemarker:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FreemarkerEndpointBuilderFactory.FreemarkerEndpointBuilder freemarker(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FreemarkerEndpointBuilderFactory.endpointBuilder("freemarker", path);
    }
    /**
     * Freemarker (camel-freemarker)
     * Transform messages using FreeMarker templates.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-freemarker
     * 
     * Syntax: <code>freemarker:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FreemarkerEndpointBuilderFactory.FreemarkerEndpointBuilder freemarker(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FreemarkerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * FTP (camel-ftp)
     * Upload and download files to/from FTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>ftp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FtpEndpointBuilderFactory.FtpEndpointBuilder ftp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FtpEndpointBuilderFactory.endpointBuilder("ftp", path);
    }
    /**
     * FTP (camel-ftp)
     * Upload and download files to/from FTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>ftp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FtpEndpointBuilderFactory.FtpEndpointBuilder ftp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FtpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * FTPS (camel-ftp)
     * Upload and download files to/from FTP servers supporting the FTPS
     * protocol.
     * 
     * Category: file
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>ftps:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FtpsEndpointBuilderFactory.FtpsEndpointBuilder ftps(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FtpsEndpointBuilderFactory.endpointBuilder("ftps", path);
    }
    /**
     * FTPS (camel-ftp)
     * Upload and download files to/from FTP servers supporting the FTPS
     * protocol.
     * 
     * Category: file
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>ftps:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FtpsEndpointBuilderFactory.FtpsEndpointBuilder ftps(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FtpsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Geocoder (camel-geocoder)
     * Find geocodes (latitude and longitude) for a given address or the other
     * way round.
     * 
     * Category: api,location
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-geocoder
     * 
     * Syntax: <code>geocoder:address:latlng</code>
     * 
     * Path parameter: address
     * The geo address which should be prefixed with address:
     * 
     * Path parameter: latlng
     * The geo latitude and longitude which should be prefixed with latlng:
     * 
     * @param path address:latlng
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GeoCoderEndpointBuilderFactory.GeoCoderEndpointBuilder geocoder(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GeoCoderEndpointBuilderFactory.endpointBuilder("geocoder", path);
    }
    /**
     * Geocoder (camel-geocoder)
     * Find geocodes (latitude and longitude) for a given address or the other
     * way round.
     * 
     * Category: api,location
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-geocoder
     * 
     * Syntax: <code>geocoder:address:latlng</code>
     * 
     * Path parameter: address
     * The geo address which should be prefixed with address:
     * 
     * Path parameter: latlng
     * The geo latitude and longitude which should be prefixed with latlng:
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path address:latlng
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GeoCoderEndpointBuilderFactory.GeoCoderEndpointBuilder geocoder(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GeoCoderEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Git (camel-git)
     * Perform operations on git repositories.
     * 
     * Category: file
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-git
     * 
     * Syntax: <code>git:localPath</code>
     * 
     * Path parameter: localPath (required)
     * Local repository path
     * 
     * @param path localPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GitEndpointBuilderFactory.GitEndpointBuilder git(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GitEndpointBuilderFactory.endpointBuilder("git", path);
    }
    /**
     * Git (camel-git)
     * Perform operations on git repositories.
     * 
     * Category: file
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-git
     * 
     * Syntax: <code>git:localPath</code>
     * 
     * Path parameter: localPath (required)
     * Local repository path
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path localPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GitEndpointBuilderFactory.GitEndpointBuilder git(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GitEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * GitHub (camel-github)
     * Interact with the GitHub API.
     * 
     * Category: file,cloud,api
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     * 
     * Syntax: <code>github:type/branchName</code>
     * 
     * Path parameter: type (required)
     * What git operation to execute
     * There are 10 enums and the value can be one of: CLOSEPULLREQUEST,
     * PULLREQUESTCOMMENT, COMMIT, PULLREQUEST, TAG, PULLREQUESTSTATE,
     * PULLREQUESTFILES, GETCOMMITFILE, CREATEISSUE, EVENT
     * 
     * Path parameter: branchName
     * Name of branch
     * 
     * @param path type/branchName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GitHubEndpointBuilderFactory.GitHubEndpointBuilder github(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GitHubEndpointBuilderFactory.endpointBuilder("github", path);
    }
    /**
     * GitHub (camel-github)
     * Interact with the GitHub API.
     * 
     * Category: file,cloud,api
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     * 
     * Syntax: <code>github:type/branchName</code>
     * 
     * Path parameter: type (required)
     * What git operation to execute
     * There are 10 enums and the value can be one of: CLOSEPULLREQUEST,
     * PULLREQUESTCOMMENT, COMMIT, PULLREQUEST, TAG, PULLREQUESTSTATE,
     * PULLREQUESTFILES, GETCOMMITFILE, CREATEISSUE, EVENT
     * 
     * Path parameter: branchName
     * Name of branch
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type/branchName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GitHubEndpointBuilderFactory.GitHubEndpointBuilder github(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GitHubEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google BigQuery (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics.
     * 
     * Category: cloud,bigdata
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * Syntax: <code>google-bigquery:projectId:datasetId:tableId</code>
     * 
     * Path parameter: projectId (required)
     * Google Cloud Project Id
     * 
     * Path parameter: datasetId (required)
     * BigQuery Dataset Id
     * 
     * Path parameter: tableId
     * BigQuery table id
     * 
     * @param path projectId:datasetId:tableId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleBigQueryEndpointBuilderFactory.GoogleBigQueryEndpointBuilder googleBigquery(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleBigQueryEndpointBuilderFactory.endpointBuilder("google-bigquery", path);
    }
    /**
     * Google BigQuery (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics.
     * 
     * Category: cloud,bigdata
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * Syntax: <code>google-bigquery:projectId:datasetId:tableId</code>
     * 
     * Path parameter: projectId (required)
     * Google Cloud Project Id
     * 
     * Path parameter: datasetId (required)
     * BigQuery Dataset Id
     * 
     * Path parameter: tableId
     * BigQuery table id
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path projectId:datasetId:tableId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleBigQueryEndpointBuilderFactory.GoogleBigQueryEndpointBuilder googleBigquery(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleBigQueryEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google BigQuery Standard SQL (camel-google-bigquery)
     * Access Google Cloud BigQuery service using SQL queries.
     * 
     * Category: cloud,messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * Syntax: <code>google-bigquery-sql:projectId:queryString</code>
     * 
     * Path parameter: projectId (required)
     * Google Cloud Project Id
     * 
     * Path parameter: queryString (required)
     * BigQuery standard SQL query
     * 
     * @param path projectId:queryString
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleBigQuerySQLEndpointBuilderFactory.GoogleBigQuerySQLEndpointBuilder googleBigquerySql(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleBigQuerySQLEndpointBuilderFactory.endpointBuilder("google-bigquery-sql", path);
    }
    /**
     * Google BigQuery Standard SQL (camel-google-bigquery)
     * Access Google Cloud BigQuery service using SQL queries.
     * 
     * Category: cloud,messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * Syntax: <code>google-bigquery-sql:projectId:queryString</code>
     * 
     * Path parameter: projectId (required)
     * Google Cloud Project Id
     * 
     * Path parameter: queryString (required)
     * BigQuery standard SQL query
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path projectId:queryString
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleBigQuerySQLEndpointBuilderFactory.GoogleBigQuerySQLEndpointBuilder googleBigquerySql(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleBigQuerySQLEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Calendar (camel-google-calendar)
     * Perform various operations on a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * Syntax: <code>google-calendar:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 8 enums and the value can be one of: ACL, LIST, CALENDARS,
     * CHANNELS, COLORS, FREEBUSY, EVENTS, SETTINGS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 14 enums and the value can be one of: calendarImport, clear,
     * delete, get, insert, instances, list, move, patch, query, quickAdd, stop,
     * update, watch
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCalendarEndpointBuilderFactory.GoogleCalendarEndpointBuilder googleCalendar(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCalendarEndpointBuilderFactory.endpointBuilder("google-calendar", path);
    }
    /**
     * Google Calendar (camel-google-calendar)
     * Perform various operations on a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * Syntax: <code>google-calendar:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 8 enums and the value can be one of: ACL, LIST, CALENDARS,
     * CHANNELS, COLORS, FREEBUSY, EVENTS, SETTINGS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 14 enums and the value can be one of: calendarImport, clear,
     * delete, get, insert, instances, list, move, patch, query, quickAdd, stop,
     * update, watch
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCalendarEndpointBuilderFactory.GoogleCalendarEndpointBuilder googleCalendar(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCalendarEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * Poll for changes in a Google Calendar.
     * 
     * Category: cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * Syntax: <code>google-calendar-stream:index</code>
     * 
     * Path parameter: index (required)
     * Specifies an index for the endpoint
     * 
     * @param path index
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCalendarStreamEndpointBuilderFactory.GoogleCalendarStreamEndpointBuilder googleCalendarStream(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCalendarStreamEndpointBuilderFactory.endpointBuilder("google-calendar-stream", path);
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * Poll for changes in a Google Calendar.
     * 
     * Category: cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * Syntax: <code>google-calendar-stream:index</code>
     * 
     * Path parameter: index (required)
     * Specifies an index for the endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path index
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCalendarStreamEndpointBuilderFactory.GoogleCalendarStreamEndpointBuilder googleCalendarStream(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCalendarStreamEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Drive (camel-google-drive)
     * Manage files in Google Drive.
     * 
     * Category: file,cloud,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-google-drive
     * 
     * Syntax: <code>google-drive:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 14 enums and the value can be one of: DRIVE_ABOUT, DRIVE_APPS,
     * DRIVE_CHANGES, DRIVE_CHANNELS, DRIVE_CHILDREN, DRIVE_COMMENTS,
     * DRIVE_FILES, DRIVE_PARENTS, DRIVE_PERMISSIONS, DRIVE_PROPERTIES,
     * DRIVE_DRIVES, DRIVE_TEAMDRIVES, DRIVE_REPLIES, DRIVE_REVISIONS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 13 enums and the value can be one of: copy, delete, get,
     * getIdForEmail, insert, list, patch, stop, touch, trash, untrash, update,
     * watch
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleDriveEndpointBuilderFactory.GoogleDriveEndpointBuilder googleDrive(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleDriveEndpointBuilderFactory.endpointBuilder("google-drive", path);
    }
    /**
     * Google Drive (camel-google-drive)
     * Manage files in Google Drive.
     * 
     * Category: file,cloud,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-google-drive
     * 
     * Syntax: <code>google-drive:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 14 enums and the value can be one of: DRIVE_ABOUT, DRIVE_APPS,
     * DRIVE_CHANGES, DRIVE_CHANNELS, DRIVE_CHILDREN, DRIVE_COMMENTS,
     * DRIVE_FILES, DRIVE_PARENTS, DRIVE_PERMISSIONS, DRIVE_PROPERTIES,
     * DRIVE_DRIVES, DRIVE_TEAMDRIVES, DRIVE_REPLIES, DRIVE_REVISIONS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 13 enums and the value can be one of: copy, delete, get,
     * getIdForEmail, insert, list, patch, stop, touch, trash, untrash, update,
     * watch
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleDriveEndpointBuilderFactory.GoogleDriveEndpointBuilder googleDrive(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleDriveEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Cloud Functions (camel-google-functions)
     * Manage and invoke Google Cloud Functions
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-functions
     * 
     * Syntax: <code>google-functions:functionName</code>
     * 
     * Path parameter: functionName (required)
     * The user-defined name of the function
     * 
     * @param path functionName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCloudFunctionsEndpointBuilderFactory.GoogleCloudFunctionsEndpointBuilder googleFunctions(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCloudFunctionsEndpointBuilderFactory.endpointBuilder("google-functions", path);
    }
    /**
     * Google Cloud Functions (camel-google-functions)
     * Manage and invoke Google Cloud Functions
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-functions
     * 
     * Syntax: <code>google-functions:functionName</code>
     * 
     * Path parameter: functionName (required)
     * The user-defined name of the function
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path functionName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCloudFunctionsEndpointBuilderFactory.GoogleCloudFunctionsEndpointBuilder googleFunctions(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCloudFunctionsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Mail (camel-google-mail)
     * Manage messages in Google Mail.
     * 
     * Category: cloud,api,mail
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * Syntax: <code>google-mail:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 7 enums and the value can be one of: THREADS, MESSAGES,
     * ATTACHMENTS, LABELS, HISTORY, DRAFTS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 16 enums and the value can be one of: attachments, create,
     * delete, get, getProfile, gmailImport, insert, list, modify, patch, send,
     * stop, trash, untrash, update, watch
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleMailEndpointBuilderFactory.GoogleMailEndpointBuilder googleMail(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleMailEndpointBuilderFactory.endpointBuilder("google-mail", path);
    }
    /**
     * Google Mail (camel-google-mail)
     * Manage messages in Google Mail.
     * 
     * Category: cloud,api,mail
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * Syntax: <code>google-mail:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 7 enums and the value can be one of: THREADS, MESSAGES,
     * ATTACHMENTS, LABELS, HISTORY, DRAFTS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 16 enums and the value can be one of: attachments, create,
     * delete, get, getProfile, gmailImport, insert, list, modify, patch, send,
     * stop, trash, untrash, update, watch
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleMailEndpointBuilderFactory.GoogleMailEndpointBuilder googleMail(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleMailEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Mail Stream (camel-google-mail)
     * Poll for incoming messages in Google Mail.
     * 
     * Category: cloud,mail
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * Syntax: <code>google-mail-stream:index</code>
     * 
     * Path parameter: index (required)
     * Currently not in use
     * 
     * @param path index
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleMailStreamEndpointBuilderFactory.GoogleMailStreamEndpointBuilder googleMailStream(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleMailStreamEndpointBuilderFactory.endpointBuilder("google-mail-stream", path);
    }
    /**
     * Google Mail Stream (camel-google-mail)
     * Poll for incoming messages in Google Mail.
     * 
     * Category: cloud,mail
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * Syntax: <code>google-mail-stream:index</code>
     * 
     * Path parameter: index (required)
     * Currently not in use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path index
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleMailStreamEndpointBuilderFactory.GoogleMailStreamEndpointBuilder googleMailStream(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleMailStreamEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Pubsub (camel-google-pubsub)
     * Send and receive messages to/from Google Cloud Platform PubSub Service.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     * 
     * Syntax: <code>google-pubsub:projectId:destinationName</code>
     * 
     * Path parameter: projectId (required)
     * The Google Cloud PubSub Project Id
     * 
     * Path parameter: destinationName (required)
     * The Destination Name. For the consumer this will be the subscription
     * name, while for the producer this will be the topic name.
     * 
     * @param path projectId:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GooglePubsubEndpointBuilderFactory.GooglePubsubEndpointBuilder googlePubsub(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GooglePubsubEndpointBuilderFactory.endpointBuilder("google-pubsub", path);
    }
    /**
     * Google Pubsub (camel-google-pubsub)
     * Send and receive messages to/from Google Cloud Platform PubSub Service.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     * 
     * Syntax: <code>google-pubsub:projectId:destinationName</code>
     * 
     * Path parameter: projectId (required)
     * The Google Cloud PubSub Project Id
     * 
     * Path parameter: destinationName (required)
     * The Destination Name. For the consumer this will be the subscription
     * name, while for the producer this will be the topic name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path projectId:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GooglePubsubEndpointBuilderFactory.GooglePubsubEndpointBuilder googlePubsub(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GooglePubsubEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Secret Manager (camel-google-secret-manager)
     * Manage Google Secret Manager Secrets
     * 
     * Category: cloud
     * Since: 3.16
     * Maven coordinates: org.apache.camel:camel-google-secret-manager
     * 
     * Syntax: <code>google-secret-manager:project</code>
     * 
     * Path parameter: project (required)
     * The Google Cloud Project Id name related to the Secret Manager
     * 
     * @param path project
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSecretManagerEndpointBuilderFactory.GoogleSecretManagerEndpointBuilder googleSecretManager(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSecretManagerEndpointBuilderFactory.endpointBuilder("google-secret-manager", path);
    }
    /**
     * Google Secret Manager (camel-google-secret-manager)
     * Manage Google Secret Manager Secrets
     * 
     * Category: cloud
     * Since: 3.16
     * Maven coordinates: org.apache.camel:camel-google-secret-manager
     * 
     * Syntax: <code>google-secret-manager:project</code>
     * 
     * Path parameter: project (required)
     * The Google Cloud Project Id name related to the Secret Manager
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path project
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSecretManagerEndpointBuilderFactory.GoogleSecretManagerEndpointBuilder googleSecretManager(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSecretManagerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Sheets (camel-google-sheets)
     * Manage spreadsheets in Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * Syntax: <code>google-sheets:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 2 enums and the value can be one of: SPREADSHEETS, DATA
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 6 enums and the value can be one of: create, get, update,
     * append, batchUpdate, clear
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSheetsEndpointBuilderFactory.GoogleSheetsEndpointBuilder googleSheets(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSheetsEndpointBuilderFactory.endpointBuilder("google-sheets", path);
    }
    /**
     * Google Sheets (camel-google-sheets)
     * Manage spreadsheets in Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * Syntax: <code>google-sheets:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 2 enums and the value can be one of: SPREADSHEETS, DATA
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 6 enums and the value can be one of: create, get, update,
     * append, batchUpdate, clear
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSheetsEndpointBuilderFactory.GoogleSheetsEndpointBuilder googleSheets(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSheetsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Sheets Stream (camel-google-sheets)
     * Poll for changes in Google Sheets.
     * 
     * Category: cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * Syntax: <code>google-sheets-stream:spreadsheetId</code>
     * 
     * Path parameter: spreadsheetId (required)
     * Specifies the spreadsheet identifier that is used to identify the target
     * to obtain.
     * 
     * @param path spreadsheetId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSheetsStreamEndpointBuilderFactory.GoogleSheetsStreamEndpointBuilder googleSheetsStream(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSheetsStreamEndpointBuilderFactory.endpointBuilder("google-sheets-stream", path);
    }
    /**
     * Google Sheets Stream (camel-google-sheets)
     * Poll for changes in Google Sheets.
     * 
     * Category: cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * Syntax: <code>google-sheets-stream:spreadsheetId</code>
     * 
     * Path parameter: spreadsheetId (required)
     * Specifies the spreadsheet identifier that is used to identify the target
     * to obtain.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path spreadsheetId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleSheetsStreamEndpointBuilderFactory.GoogleSheetsStreamEndpointBuilder googleSheetsStream(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleSheetsStreamEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Google Storage (camel-google-storage)
     * Store and retrieve objects from Google Cloud Storage Service using the
     * google-cloud-storage library.
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-storage
     * 
     * Syntax: <code>google-storage:bucketName</code>
     * 
     * Path parameter: bucketName (required)
     * Bucket name or ARN
     * 
     * @param path bucketName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCloudStorageEndpointBuilderFactory.GoogleCloudStorageEndpointBuilder googleStorage(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCloudStorageEndpointBuilderFactory.endpointBuilder("google-storage", path);
    }
    /**
     * Google Storage (camel-google-storage)
     * Store and retrieve objects from Google Cloud Storage Service using the
     * google-cloud-storage library.
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-storage
     * 
     * Syntax: <code>google-storage:bucketName</code>
     * 
     * Path parameter: bucketName (required)
     * Bucket name or ARN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path bucketName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GoogleCloudStorageEndpointBuilderFactory.GoogleCloudStorageEndpointBuilder googleStorage(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoogleCloudStorageEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Gora (camel-gora)
     * Access NoSQL databases using the Apache Gora framework.
     * 
     * Category: database,nosql,bigdata
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-gora
     * 
     * Syntax: <code>gora:name</code>
     * 
     * Path parameter: name (required)
     * Instance name
     * 
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.GoraEndpointBuilderFactory.GoraEndpointBuilder gora(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoraEndpointBuilderFactory.endpointBuilder("gora", path);
    }
    /**
     * Gora (camel-gora)
     * Access NoSQL databases using the Apache Gora framework.
     * 
     * Category: database,nosql,bigdata
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-gora
     * 
     * Syntax: <code>gora:name</code>
     * 
     * Path parameter: name (required)
     * Instance name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.GoraEndpointBuilderFactory.GoraEndpointBuilder gora(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GoraEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Grape (camel-grape)
     * Fetch, load and manage additional jars dynamically after Camel Context
     * was started.
     * 
     * Category: management,deployment
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     * 
     * Syntax: <code>grape:defaultCoordinates</code>
     * 
     * Path parameter: defaultCoordinates (required)
     * Maven coordinates to use as default to grab if the message body is empty.
     * 
     * @param path defaultCoordinates
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GrapeEndpointBuilderFactory.GrapeEndpointBuilder grape(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GrapeEndpointBuilderFactory.endpointBuilder("grape", path);
    }
    /**
     * Grape (camel-grape)
     * Fetch, load and manage additional jars dynamically after Camel Context
     * was started.
     * 
     * Category: management,deployment
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     * 
     * Syntax: <code>grape:defaultCoordinates</code>
     * 
     * Path parameter: defaultCoordinates (required)
     * Maven coordinates to use as default to grab if the message body is empty.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path defaultCoordinates
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GrapeEndpointBuilderFactory.GrapeEndpointBuilder grape(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GrapeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * GraphQL (camel-graphql)
     * Send GraphQL queries and mutations to external systems.
     * 
     * Category: api
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-graphql
     * 
     * Syntax: <code>graphql:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The GraphQL server URI.
     * 
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GraphqlEndpointBuilderFactory.GraphqlEndpointBuilder graphql(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GraphqlEndpointBuilderFactory.endpointBuilder("graphql", path);
    }
    /**
     * GraphQL (camel-graphql)
     * Send GraphQL queries and mutations to external systems.
     * 
     * Category: api
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-graphql
     * 
     * Syntax: <code>graphql:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The GraphQL server URI.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GraphqlEndpointBuilderFactory.GraphqlEndpointBuilder graphql(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GraphqlEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * gRPC (camel-grpc)
     * Expose gRPC endpoints and access external gRPC endpoints.
     * 
     * Category: rpc
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-grpc
     * 
     * Syntax: <code>grpc:host:port/service</code>
     * 
     * Path parameter: host (required)
     * The gRPC server host name. This is localhost or 0.0.0.0 when being a
     * consumer or remote server host name when using producer.
     * 
     * Path parameter: port (required)
     * The gRPC local or remote server port
     * 
     * Path parameter: service (required)
     * Fully qualified service name from the protocol buffer descriptor file
     * (package dot service definition name)
     * 
     * @param path host:port/service
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GrpcEndpointBuilderFactory.GrpcEndpointBuilder grpc(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GrpcEndpointBuilderFactory.endpointBuilder("grpc", path);
    }
    /**
     * gRPC (camel-grpc)
     * Expose gRPC endpoints and access external gRPC endpoints.
     * 
     * Category: rpc
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-grpc
     * 
     * Syntax: <code>grpc:host:port/service</code>
     * 
     * Path parameter: host (required)
     * The gRPC server host name. This is localhost or 0.0.0.0 when being a
     * consumer or remote server host name when using producer.
     * 
     * Path parameter: port (required)
     * The gRPC local or remote server port
     * 
     * Path parameter: service (required)
     * Fully qualified service name from the protocol buffer descriptor file
     * (package dot service definition name)
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/service
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GrpcEndpointBuilderFactory.GrpcEndpointBuilder grpc(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GrpcEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Guava EventBus (camel-guava-eventbus)
     * Send and receive messages to/from Guava EventBus.
     * 
     * Category: eventbus
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-guava-eventbus
     * 
     * Syntax: <code>guava-eventbus:eventBusRef</code>
     * 
     * Path parameter: eventBusRef
     * To lookup the Guava EventBus from the registry with the given name
     * 
     * @param path eventBusRef
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GuavaEventBusEndpointBuilderFactory.GuavaEventBusEndpointBuilder guavaEventbus(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GuavaEventBusEndpointBuilderFactory.endpointBuilder("guava-eventbus", path);
    }
    /**
     * Guava EventBus (camel-guava-eventbus)
     * Send and receive messages to/from Guava EventBus.
     * 
     * Category: eventbus
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-guava-eventbus
     * 
     * Syntax: <code>guava-eventbus:eventBusRef</code>
     * 
     * Path parameter: eventBusRef
     * To lookup the Guava EventBus from the registry with the given name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path eventBusRef
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GuavaEventBusEndpointBuilderFactory.GuavaEventBusEndpointBuilder guavaEventbus(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GuavaEventBusEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hashicorp Vault (camel-hashicorp-vault)
     * Manage secrets in Hashicorp Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-hashicorp-vault
     * 
     * Syntax: <code>hashicorp-vault:secretsEngine</code>
     * 
     * Path parameter: secretsEngine
     * Vault Name to be used
     * 
     * @param path secretsEngine
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HashicorpVaultEndpointBuilderFactory.HashicorpVaultEndpointBuilder hashicorpVault(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HashicorpVaultEndpointBuilderFactory.endpointBuilder("hashicorp-vault", path);
    }
    /**
     * Hashicorp Vault (camel-hashicorp-vault)
     * Manage secrets in Hashicorp Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-hashicorp-vault
     * 
     * Syntax: <code>hashicorp-vault:secretsEngine</code>
     * 
     * Path parameter: secretsEngine
     * Vault Name to be used
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path secretsEngine
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HashicorpVaultEndpointBuilderFactory.HashicorpVaultEndpointBuilder hashicorpVault(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HashicorpVaultEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Atomic Number (camel-hazelcast)
     * Increment, decrement, set, etc. Hazelcast atomic number (a grid wide
     * number).
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-atomicvalue:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastAtomicnumberEndpointBuilderFactory.HazelcastAtomicnumberEndpointBuilder hazelcastAtomicvalue(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastAtomicnumberEndpointBuilderFactory.endpointBuilder("hazelcast-atomicvalue", path);
    }
    /**
     * Hazelcast Atomic Number (camel-hazelcast)
     * Increment, decrement, set, etc. Hazelcast atomic number (a grid wide
     * number).
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-atomicvalue:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastAtomicnumberEndpointBuilderFactory.HazelcastAtomicnumberEndpointBuilder hazelcastAtomicvalue(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastAtomicnumberEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Instance (camel-hazelcast)
     * Consume join/leave events of a cache instance in a Hazelcast cluster.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-instance:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastInstanceEndpointBuilderFactory.HazelcastInstanceEndpointBuilder hazelcastInstance(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastInstanceEndpointBuilderFactory.endpointBuilder("hazelcast-instance", path);
    }
    /**
     * Hazelcast Instance (camel-hazelcast)
     * Consume join/leave events of a cache instance in a Hazelcast cluster.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-instance:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastInstanceEndpointBuilderFactory.HazelcastInstanceEndpointBuilder hazelcastInstance(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastInstanceEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast List (camel-hazelcast)
     * Perform operations on Hazelcast distributed list.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-list:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastListEndpointBuilderFactory.HazelcastListEndpointBuilder hazelcastList(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastListEndpointBuilderFactory.endpointBuilder("hazelcast-list", path);
    }
    /**
     * Hazelcast List (camel-hazelcast)
     * Perform operations on Hazelcast distributed list.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-list:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastListEndpointBuilderFactory.HazelcastListEndpointBuilder hazelcastList(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastListEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Map (camel-hazelcast)
     * Perform operations on Hazelcast distributed map.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-map:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastMapEndpointBuilderFactory.HazelcastMapEndpointBuilder hazelcastMap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastMapEndpointBuilderFactory.endpointBuilder("hazelcast-map", path);
    }
    /**
     * Hazelcast Map (camel-hazelcast)
     * Perform operations on Hazelcast distributed map.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-map:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastMapEndpointBuilderFactory.HazelcastMapEndpointBuilder hazelcastMap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastMapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Multimap (camel-hazelcast)
     * Perform operations on Hazelcast distributed multimap.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-multimap:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastMultimapEndpointBuilderFactory.HazelcastMultimapEndpointBuilder hazelcastMultimap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastMultimapEndpointBuilderFactory.endpointBuilder("hazelcast-multimap", path);
    }
    /**
     * Hazelcast Multimap (camel-hazelcast)
     * Perform operations on Hazelcast distributed multimap.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-multimap:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastMultimapEndpointBuilderFactory.HazelcastMultimapEndpointBuilder hazelcastMultimap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastMultimapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Queue (camel-hazelcast)
     * Perform operations on Hazelcast distributed queue.
     * 
     * Category: cache,datagrid,messaging
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-queue:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastQueueEndpointBuilderFactory.HazelcastQueueEndpointBuilder hazelcastQueue(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastQueueEndpointBuilderFactory.endpointBuilder("hazelcast-queue", path);
    }
    /**
     * Hazelcast Queue (camel-hazelcast)
     * Perform operations on Hazelcast distributed queue.
     * 
     * Category: cache,datagrid,messaging
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-queue:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastQueueEndpointBuilderFactory.HazelcastQueueEndpointBuilder hazelcastQueue(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastQueueEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Replicated Map (camel-hazelcast)
     * Perform operations on Hazelcast replicated map.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-replicatedmap:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastReplicatedmapEndpointBuilderFactory.HazelcastReplicatedmapEndpointBuilder hazelcastReplicatedmap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastReplicatedmapEndpointBuilderFactory.endpointBuilder("hazelcast-replicatedmap", path);
    }
    /**
     * Hazelcast Replicated Map (camel-hazelcast)
     * Perform operations on Hazelcast replicated map.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-replicatedmap:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastReplicatedmapEndpointBuilderFactory.HazelcastReplicatedmapEndpointBuilder hazelcastReplicatedmap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastReplicatedmapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Ringbuffer (camel-hazelcast)
     * Perform operations on Hazelcast distributed ringbuffer.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-ringbuffer:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastRingbufferEndpointBuilderFactory.HazelcastRingbufferEndpointBuilder hazelcastRingbuffer(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastRingbufferEndpointBuilderFactory.endpointBuilder("hazelcast-ringbuffer", path);
    }
    /**
     * Hazelcast Ringbuffer (camel-hazelcast)
     * Perform operations on Hazelcast distributed ringbuffer.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-ringbuffer:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastRingbufferEndpointBuilderFactory.HazelcastRingbufferEndpointBuilder hazelcastRingbuffer(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastRingbufferEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast SEDA (camel-hazelcast)
     * Asynchronously send/receive Exchanges between Camel routes running on
     * potentially distinct JVMs/hosts backed by Hazelcast BlockingQueue.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-seda:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastSedaEndpointBuilderFactory.HazelcastSedaEndpointBuilder hazelcastSeda(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastSedaEndpointBuilderFactory.endpointBuilder("hazelcast-seda", path);
    }
    /**
     * Hazelcast SEDA (camel-hazelcast)
     * Asynchronously send/receive Exchanges between Camel routes running on
     * potentially distinct JVMs/hosts backed by Hazelcast BlockingQueue.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-seda:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastSedaEndpointBuilderFactory.HazelcastSedaEndpointBuilder hazelcastSeda(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastSedaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Set (camel-hazelcast)
     * Perform operations on Hazelcast distributed set.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-set:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastSetEndpointBuilderFactory.HazelcastSetEndpointBuilder hazelcastSet(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastSetEndpointBuilderFactory.endpointBuilder("hazelcast-set", path);
    }
    /**
     * Hazelcast Set (camel-hazelcast)
     * Perform operations on Hazelcast distributed set.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-set:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastSetEndpointBuilderFactory.HazelcastSetEndpointBuilder hazelcastSet(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastSetEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hazelcast Topic (camel-hazelcast)
     * Send and receive messages to/from Hazelcast distributed topic.
     * 
     * Category: cache,datagrid
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-topic:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastTopicEndpointBuilderFactory.HazelcastTopicEndpointBuilder hazelcastTopic(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastTopicEndpointBuilderFactory.endpointBuilder("hazelcast-topic", path);
    }
    /**
     * Hazelcast Topic (camel-hazelcast)
     * Send and receive messages to/from Hazelcast distributed topic.
     * 
     * Category: cache,datagrid
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * Syntax: <code>hazelcast-topic:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HazelcastTopicEndpointBuilderFactory.HazelcastTopicEndpointBuilder hazelcastTopic(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HazelcastTopicEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * HBase (camel-hbase)
     * Reading and write from/to an HBase store (Hadoop database).
     * 
     * Category: bigdata,database,hadoop
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-hbase
     * 
     * Syntax: <code>hbase:tableName</code>
     * 
     * Path parameter: tableName (required)
     * The name of the table
     * 
     * @param path tableName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.HBaseEndpointBuilderFactory.HBaseEndpointBuilder hbase(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HBaseEndpointBuilderFactory.endpointBuilder("hbase", path);
    }
    /**
     * HBase (camel-hbase)
     * Reading and write from/to an HBase store (Hadoop database).
     * 
     * Category: bigdata,database,hadoop
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-hbase
     * 
     * Syntax: <code>hbase:tableName</code>
     * 
     * Path parameter: tableName (required)
     * The name of the table
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path tableName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.HBaseEndpointBuilderFactory.HBaseEndpointBuilder hbase(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HBaseEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * HDFS (camel-hdfs)
     * Read and write from/to an HDFS filesystem using Hadoop 2.x.
     * 
     * Category: bigdata,hadoop,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-hdfs
     * 
     * Syntax: <code>hdfs:hostName:port/path</code>
     * 
     * Path parameter: hostName (required)
     * HDFS host to use
     * 
     * Path parameter: port
     * HDFS port to use
     * Default value: 8020
     * 
     * Path parameter: path (required)
     * The directory path to use
     * 
     * @param path hostName:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HdfsEndpointBuilderFactory.HdfsEndpointBuilder hdfs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HdfsEndpointBuilderFactory.endpointBuilder("hdfs", path);
    }
    /**
     * HDFS (camel-hdfs)
     * Read and write from/to an HDFS filesystem using Hadoop 2.x.
     * 
     * Category: bigdata,hadoop,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-hdfs
     * 
     * Syntax: <code>hdfs:hostName:port/path</code>
     * 
     * Path parameter: hostName (required)
     * HDFS host to use
     * 
     * Path parameter: port
     * HDFS port to use
     * Default value: 8020
     * 
     * Path parameter: path (required)
     * The directory path to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path hostName:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HdfsEndpointBuilderFactory.HdfsEndpointBuilder hdfs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HdfsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * HTTP (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * Syntax: <code>http://httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param path //httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HttpEndpointBuilderFactory.HttpEndpointBuilder http(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HttpEndpointBuilderFactory.endpointBuilder("http", path);
    }
    /**
     * HTTP (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * Syntax: <code>http://httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path //httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HttpEndpointBuilderFactory.HttpEndpointBuilder http(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HttpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Distributed Message Service (DMS) (camel-huaweicloud-dms)
     * To integrate with a fully managed, high-performance message queuing
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-dms
     * 
     * Syntax: <code>hwcloud-dms:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DMSEndpointBuilderFactory.DMSEndpointBuilder hwcloudDms(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DMSEndpointBuilderFactory.endpointBuilder("hwcloud-dms", path);
    }
    /**
     * Huawei Distributed Message Service (DMS) (camel-huaweicloud-dms)
     * To integrate with a fully managed, high-performance message queuing
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-dms
     * 
     * Syntax: <code>hwcloud-dms:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.DMSEndpointBuilderFactory.DMSEndpointBuilder hwcloudDms(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.DMSEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Cloud Face Recognition Service (FRS) (camel-huaweicloud-frs)
     * Face Recognition Service (FRS) is an intelligent service that uses
     * computers to process, analyze, and understand facial images based on
     * human facial features.
     * 
     * Category: cloud,messaging
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-huaweicloud-frs
     * 
     * Syntax: <code>hwcloud-frs:operation</code>
     * 
     * Path parameter: operation (required)
     * Name of Face Recognition operation to perform, including faceDetection,
     * faceVerification and faceLiveDetection
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FaceRecognitionEndpointBuilderFactory.FaceRecognitionEndpointBuilder hwcloudFrs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FaceRecognitionEndpointBuilderFactory.endpointBuilder("hwcloud-frs", path);
    }
    /**
     * Huawei Cloud Face Recognition Service (FRS) (camel-huaweicloud-frs)
     * Face Recognition Service (FRS) is an intelligent service that uses
     * computers to process, analyze, and understand facial images based on
     * human facial features.
     * 
     * Category: cloud,messaging
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-huaweicloud-frs
     * 
     * Syntax: <code>hwcloud-frs:operation</code>
     * 
     * Path parameter: operation (required)
     * Name of Face Recognition operation to perform, including faceDetection,
     * faceVerification and faceLiveDetection
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FaceRecognitionEndpointBuilderFactory.FaceRecognitionEndpointBuilder hwcloudFrs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FaceRecognitionEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei FunctionGraph (camel-huaweicloud-functiongraph)
     * To call serverless functions on Huawei Cloud
     * 
     * Category: cloud,serverless
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-functiongraph
     * 
     * Syntax: <code>hwcloud-functiongraph:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FunctionGraphEndpointBuilderFactory.FunctionGraphEndpointBuilder hwcloudFunctiongraph(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FunctionGraphEndpointBuilderFactory.endpointBuilder("hwcloud-functiongraph", path);
    }
    /**
     * Huawei FunctionGraph (camel-huaweicloud-functiongraph)
     * To call serverless functions on Huawei Cloud
     * 
     * Category: cloud,serverless
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-functiongraph
     * 
     * Syntax: <code>hwcloud-functiongraph:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.FunctionGraphEndpointBuilderFactory.FunctionGraphEndpointBuilder hwcloudFunctiongraph(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.FunctionGraphEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Identity and Access Management (IAM) (camel-huaweicloud-iam)
     * To securely manage users on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-iam
     * 
     * Syntax: <code>hwcloud-iam:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IAMEndpointBuilderFactory.IAMEndpointBuilder hwcloudIam(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IAMEndpointBuilderFactory.endpointBuilder("hwcloud-iam", path);
    }
    /**
     * Huawei Identity and Access Management (IAM) (camel-huaweicloud-iam)
     * To securely manage users on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-iam
     * 
     * Syntax: <code>hwcloud-iam:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IAMEndpointBuilderFactory.IAMEndpointBuilder hwcloudIam(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IAMEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Cloud Image Recognition (camel-huaweicloud-imagerecognition)
     * To identify objects, scenes, and concepts in images on Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-imagerecognition
     * 
     * Syntax: <code>hwcloud-imagerecognition:operation</code>
     * 
     * Path parameter: operation (required)
     * Name of Image Recognition operation to perform, including
     * celebrityRecognition and tagRecognition
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ImageRecognitionEndpointBuilderFactory.ImageRecognitionEndpointBuilder hwcloudImagerecognition(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ImageRecognitionEndpointBuilderFactory.endpointBuilder("hwcloud-imagerecognition", path);
    }
    /**
     * Huawei Cloud Image Recognition (camel-huaweicloud-imagerecognition)
     * To identify objects, scenes, and concepts in images on Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-imagerecognition
     * 
     * Syntax: <code>hwcloud-imagerecognition:operation</code>
     * 
     * Path parameter: operation (required)
     * Name of Image Recognition operation to perform, including
     * celebrityRecognition and tagRecognition
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ImageRecognitionEndpointBuilderFactory.ImageRecognitionEndpointBuilder hwcloudImagerecognition(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ImageRecognitionEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
     * To provide stable, secure, efficient, and easy-to-use cloud storage
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
     * 
     * Syntax: <code>hwcloud-obs:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OBSEndpointBuilderFactory.OBSEndpointBuilder hwcloudObs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OBSEndpointBuilderFactory.endpointBuilder("hwcloud-obs", path);
    }
    /**
     * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
     * To provide stable, secure, efficient, and easy-to-use cloud storage
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
     * 
     * Syntax: <code>hwcloud-obs:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation to be performed
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OBSEndpointBuilderFactory.OBSEndpointBuilder hwcloudObs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OBSEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Huawei Simple Message Notification (SMN) (camel-huaweicloud-smn)
     * To broadcast messages and connect cloud services through notifications on
     * Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-huaweicloud-smn
     * 
     * Syntax: <code>hwcloud-smn:smnService</code>
     * 
     * Path parameter: smnService (required)
     * Name of SMN service to invoke
     * 
     * @param path smnService
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SimpleNotificationEndpointBuilderFactory.SimpleNotificationEndpointBuilder hwcloudSmn(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SimpleNotificationEndpointBuilderFactory.endpointBuilder("hwcloud-smn", path);
    }
    /**
     * Huawei Simple Message Notification (SMN) (camel-huaweicloud-smn)
     * To broadcast messages and connect cloud services through notifications on
     * Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-huaweicloud-smn
     * 
     * Syntax: <code>hwcloud-smn:smnService</code>
     * 
     * Path parameter: smnService (required)
     * Name of SMN service to invoke
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path smnService
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SimpleNotificationEndpointBuilderFactory.SimpleNotificationEndpointBuilder hwcloudSmn(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SimpleNotificationEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Hyperledger Aries (camel-hyperledger-aries)
     * Camel support for Hyperledger Aries
     * 
     * Category: blockchain,identity
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-hyperledger-aries
     * 
     * Syntax: <code>hyperledger-aries:walletName</code>
     * 
     * Path parameter: walletName (required)
     * The wallet to connect to
     * 
     * @param path walletName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HyperledgerAriesEndpointBuilderFactory.HyperledgerAriesEndpointBuilder hyperledgerAries(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HyperledgerAriesEndpointBuilderFactory.endpointBuilder("hyperledger-aries", path);
    }
    /**
     * Hyperledger Aries (camel-hyperledger-aries)
     * Camel support for Hyperledger Aries
     * 
     * Category: blockchain,identity
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-hyperledger-aries
     * 
     * Syntax: <code>hyperledger-aries:walletName</code>
     * 
     * Path parameter: walletName (required)
     * The wallet to connect to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path walletName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.HyperledgerAriesEndpointBuilderFactory.HyperledgerAriesEndpointBuilder hyperledgerAries(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.HyperledgerAriesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) client using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-client:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     * 
     * @param path uriPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ClientEndpointBuilderFactory.ClientEndpointBuilder iec60870Client(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ClientEndpointBuilderFactory.endpointBuilder("iec60870-client", path);
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) client using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-client:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path uriPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ClientEndpointBuilderFactory.ClientEndpointBuilder iec60870Client(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ClientEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) server using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-server:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     * 
     * @param path uriPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServerEndpointBuilderFactory.ServerEndpointBuilder iec60870Server(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServerEndpointBuilderFactory.endpointBuilder("iec60870-server", path);
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) server using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-server:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path uriPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServerEndpointBuilderFactory.ServerEndpointBuilder iec60870Server(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Cache (camel-ignite)
     * Perform cache operations on an Ignite cache or consume changes from a
     * continuous query.
     * 
     * Category: cache,datagrid
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-cache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The cache name.
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteCacheEndpointBuilderFactory.IgniteCacheEndpointBuilder igniteCache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteCacheEndpointBuilderFactory.endpointBuilder("ignite-cache", path);
    }
    /**
     * Ignite Cache (camel-ignite)
     * Perform cache operations on an Ignite cache or consume changes from a
     * continuous query.
     * 
     * Category: cache,datagrid
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-cache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The cache name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteCacheEndpointBuilderFactory.IgniteCacheEndpointBuilder igniteCache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteCacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Compute (camel-ignite)
     * Run compute operations on an Ignite cluster.
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-compute:endpointId</code>
     * 
     * Path parameter: endpointId (required)
     * The endpoint ID (not used).
     * 
     * @param path endpointId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteComputeEndpointBuilderFactory.IgniteComputeEndpointBuilder igniteCompute(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteComputeEndpointBuilderFactory.endpointBuilder("ignite-compute", path);
    }
    /**
     * Ignite Compute (camel-ignite)
     * Run compute operations on an Ignite cluster.
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-compute:endpointId</code>
     * 
     * Path parameter: endpointId (required)
     * The endpoint ID (not used).
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteComputeEndpointBuilderFactory.IgniteComputeEndpointBuilder igniteCompute(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteComputeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Events (camel-ignite)
     * Receive events from an Ignite cluster by creating a local event listener.
     * 
     * Category: messaging,eventbus
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-events:endpointId</code>
     * 
     * Path parameter: endpointId
     * The endpoint ID (not used).
     * 
     * @param path endpointId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteEventsEndpointBuilderFactory.IgniteEventsEndpointBuilder igniteEvents(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteEventsEndpointBuilderFactory.endpointBuilder("ignite-events", path);
    }
    /**
     * Ignite Events (camel-ignite)
     * Receive events from an Ignite cluster by creating a local event listener.
     * 
     * Category: messaging,eventbus
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-events:endpointId</code>
     * 
     * Path parameter: endpointId
     * The endpoint ID (not used).
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteEventsEndpointBuilderFactory.IgniteEventsEndpointBuilder igniteEvents(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteEventsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite ID Generator (camel-ignite)
     * Interact with Ignite Atomic Sequences and ID Generators .
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-idgen:name</code>
     * 
     * Path parameter: name (required)
     * The sequence name.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteIdGenEndpointBuilderFactory.IgniteIdGenEndpointBuilder igniteIdgen(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteIdGenEndpointBuilderFactory.endpointBuilder("ignite-idgen", path);
    }
    /**
     * Ignite ID Generator (camel-ignite)
     * Interact with Ignite Atomic Sequences and ID Generators .
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-idgen:name</code>
     * 
     * Path parameter: name (required)
     * The sequence name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteIdGenEndpointBuilderFactory.IgniteIdGenEndpointBuilder igniteIdgen(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteIdGenEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Messaging (camel-ignite)
     * Send and receive messages from an Ignite topic.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-messaging:topic</code>
     * 
     * Path parameter: topic (required)
     * The topic name.
     * 
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteMessagingEndpointBuilderFactory.IgniteMessagingEndpointBuilder igniteMessaging(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteMessagingEndpointBuilderFactory.endpointBuilder("ignite-messaging", path);
    }
    /**
     * Ignite Messaging (camel-ignite)
     * Send and receive messages from an Ignite topic.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-messaging:topic</code>
     * 
     * Path parameter: topic (required)
     * The topic name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteMessagingEndpointBuilderFactory.IgniteMessagingEndpointBuilder igniteMessaging(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteMessagingEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Queues (camel-ignite)
     * Interact with Ignite Queue data structures.
     * 
     * Category: messaging,queue
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-queue:name</code>
     * 
     * Path parameter: name (required)
     * The queue name.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteQueueEndpointBuilderFactory.IgniteQueueEndpointBuilder igniteQueue(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteQueueEndpointBuilderFactory.endpointBuilder("ignite-queue", path);
    }
    /**
     * Ignite Queues (camel-ignite)
     * Interact with Ignite Queue data structures.
     * 
     * Category: messaging,queue
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-queue:name</code>
     * 
     * Path parameter: name (required)
     * The queue name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteQueueEndpointBuilderFactory.IgniteQueueEndpointBuilder igniteQueue(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteQueueEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ignite Sets (camel-ignite)
     * Interact with Ignite Set data structures.
     * 
     * Category: cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-set:name</code>
     * 
     * Path parameter: name (required)
     * The set name.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteSetEndpointBuilderFactory.IgniteSetEndpointBuilder igniteSet(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteSetEndpointBuilderFactory.endpointBuilder("ignite-set", path);
    }
    /**
     * Ignite Sets (camel-ignite)
     * Interact with Ignite Set data structures.
     * 
     * Category: cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * Syntax: <code>ignite-set:name</code>
     * 
     * Path parameter: name (required)
     * The set name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IgniteSetEndpointBuilderFactory.IgniteSetEndpointBuilder igniteSet(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IgniteSetEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IMAP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * Syntax: <code>imap:host:port</code>
     * 
     * Path parameter: host (required)
     * The mail server host name
     * 
     * Path parameter: port
     * The port number of the mail server
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MailEndpointBuilderFactory.MailEndpointBuilder imap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MailEndpointBuilderFactory.endpointBuilder("imap", path);
    }
    /**
     * IMAP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * Syntax: <code>imap:host:port</code>
     * 
     * Path parameter: host (required)
     * The mail server host name
     * 
     * Path parameter: port
     * The port number of the mail server
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MailEndpointBuilderFactory.MailEndpointBuilder imap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MailEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Infinispan (camel-infinispan)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan
     * 
     * Syntax: <code>infinispan:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache to use. Use current to use the existing cache name
     * from the currently configured cached manager. Or use default for the
     * default cache manager name.
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfinispanRemoteEndpointBuilderFactory.InfinispanRemoteEndpointBuilder infinispan(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfinispanRemoteEndpointBuilderFactory.endpointBuilder("infinispan", path);
    }
    /**
     * Infinispan (camel-infinispan)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan
     * 
     * Syntax: <code>infinispan:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache to use. Use current to use the existing cache name
     * from the currently configured cached manager. Or use default for the
     * default cache manager name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfinispanRemoteEndpointBuilderFactory.InfinispanRemoteEndpointBuilder infinispan(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfinispanRemoteEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Infinispan Embedded (camel-infinispan-embedded)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan-embedded
     * 
     * Syntax: <code>infinispan-embedded:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache to use. Use current to use the existing cache name
     * from the currently configured cached manager. Or use default for the
     * default cache manager name.
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfinispanEmbeddedEndpointBuilderFactory.InfinispanEmbeddedEndpointBuilder infinispanEmbedded(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfinispanEmbeddedEndpointBuilderFactory.endpointBuilder("infinispan-embedded", path);
    }
    /**
     * Infinispan Embedded (camel-infinispan-embedded)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan-embedded
     * 
     * Syntax: <code>infinispan-embedded:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache to use. Use current to use the existing cache name
     * from the currently configured cached manager. Or use default for the
     * default cache manager name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfinispanEmbeddedEndpointBuilderFactory.InfinispanEmbeddedEndpointBuilder infinispanEmbedded(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfinispanEmbeddedEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * InfluxDB (camel-influxdb)
     * Interact with InfluxDB v1, a time series database.
     * 
     * Category: database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-influxdb
     * 
     * Syntax: <code>influxdb:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Connection to the influx database, of class InfluxDB.class
     * 
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfluxDbEndpointBuilderFactory.InfluxDbEndpointBuilder influxdb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfluxDbEndpointBuilderFactory.endpointBuilder("influxdb", path);
    }
    /**
     * InfluxDB (camel-influxdb)
     * Interact with InfluxDB v1, a time series database.
     * 
     * Category: database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-influxdb
     * 
     * Syntax: <code>influxdb:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Connection to the influx database, of class InfluxDB.class
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfluxDbEndpointBuilderFactory.InfluxDbEndpointBuilder influxdb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfluxDbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * InfluxDB2 (camel-influxdb2)
     * Interact with InfluxDB v2, a time series database.
     * 
     * Category: database
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-influxdb2
     * 
     * Syntax: <code>influxdb2:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Connection to the Influx database, of class
     * com.influxdb.client.InfluxDBClient.class.
     * 
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfluxDb2EndpointBuilderFactory.InfluxDb2EndpointBuilder influxdb2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfluxDb2EndpointBuilderFactory.endpointBuilder("influxdb2", path);
    }
    /**
     * InfluxDB2 (camel-influxdb2)
     * Interact with InfluxDB v2, a time series database.
     * 
     * Category: database
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-influxdb2
     * 
     * Syntax: <code>influxdb2:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Connection to the Influx database, of class
     * com.influxdb.client.InfluxDBClient.class.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.InfluxDb2EndpointBuilderFactory.InfluxDb2EndpointBuilder influxdb2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.InfluxDb2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IOTA (camel-iota)
     * Manage financial transactions using IOTA distributed ledger.
     * 
     * Category: ledger,api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-iota
     * 
     * Syntax: <code>iota:name</code>
     * 
     * Path parameter: name (required)
     * Component name
     * 
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.IOTAEndpointBuilderFactory.IOTAEndpointBuilder iota(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IOTAEndpointBuilderFactory.endpointBuilder("iota", path);
    }
    /**
     * IOTA (camel-iota)
     * Manage financial transactions using IOTA distributed ledger.
     * 
     * Category: ledger,api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-iota
     * 
     * Syntax: <code>iota:name</code>
     * 
     * Path parameter: name (required)
     * Component name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.IOTAEndpointBuilderFactory.IOTAEndpointBuilder iota(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IOTAEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IPFS (camel-ipfs)
     * Access the Interplanetary File System (IPFS).
     * 
     * Category: file,ipfs
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-ipfs
     * 
     * Syntax: <code>ipfs:ipfsCmd</code>
     * 
     * Path parameter: ipfsCmd (required)
     * The ipfs command
     * There are 4 enums and the value can be one of: add, cat, get, version
     * 
     * @param path ipfsCmd
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.IPFSEndpointBuilderFactory.IPFSEndpointBuilder ipfs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IPFSEndpointBuilderFactory.endpointBuilder("ipfs", path);
    }
    /**
     * IPFS (camel-ipfs)
     * Access the Interplanetary File System (IPFS).
     * 
     * Category: file,ipfs
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-ipfs
     * 
     * Syntax: <code>ipfs:ipfsCmd</code>
     * 
     * Path parameter: ipfsCmd (required)
     * The ipfs command
     * There are 4 enums and the value can be one of: add, cat, get, version
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path ipfsCmd
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.IPFSEndpointBuilderFactory.IPFSEndpointBuilder ipfs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IPFSEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IRC (camel-irc)
     * Send and receive messages to/from and IRC chat.
     * 
     * Category: chat
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     * 
     * Syntax: <code>irc:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname for the IRC chat server
     * 
     * Path parameter: port
     * Port number for the IRC chat server. If no port is configured then a
     * default port of either 6667, 6668 or 6669 is used.
     * 
     * @param path hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IrcEndpointBuilderFactory.IrcEndpointBuilder irc(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IrcEndpointBuilderFactory.endpointBuilder("irc", path);
    }
    /**
     * IRC (camel-irc)
     * Send and receive messages to/from and IRC chat.
     * 
     * Category: chat
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     * 
     * Syntax: <code>irc:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname for the IRC chat server
     * 
     * Path parameter: port
     * Port number for the IRC chat server. If no port is configured then a
     * default port of either 6667, 6668 or 6669 is used.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IrcEndpointBuilderFactory.IrcEndpointBuilder irc(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IrcEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * IronMQ (camel-ironmq)
     * Send and receive messages to/from IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     * 
     * Syntax: <code>ironmq:queueName</code>
     * 
     * Path parameter: queueName (required)
     * The name of the IronMQ queue
     * 
     * @param path queueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IronMQEndpointBuilderFactory.IronMQEndpointBuilder ironmq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IronMQEndpointBuilderFactory.endpointBuilder("ironmq", path);
    }
    /**
     * IronMQ (camel-ironmq)
     * Send and receive messages to/from IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     * 
     * Syntax: <code>ironmq:queueName</code>
     * 
     * Path parameter: queueName (required)
     * The name of the IronMQ queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path queueName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.IronMQEndpointBuilderFactory.IronMQEndpointBuilder ironmq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.IronMQEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JBPM (camel-jbpm)
     * Interact with jBPM workflow engine over REST.
     * 
     * Category: api,workflow
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jbpm
     * 
     * Syntax: <code>jbpm:connectionURL</code>
     * 
     * Path parameter: connectionURL (required)
     * The URL to the jBPM server.
     * 
     * Path parameter: eventListenerType
     * Sets the event listener type to attach to
     * 
     * @param path connectionURL
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JBPMEndpointBuilderFactory.JBPMEndpointBuilder jbpm(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JBPMEndpointBuilderFactory.endpointBuilder("jbpm", path);
    }
    /**
     * JBPM (camel-jbpm)
     * Interact with jBPM workflow engine over REST.
     * 
     * Category: api,workflow
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jbpm
     * 
     * Syntax: <code>jbpm:connectionURL</code>
     * 
     * Path parameter: connectionURL (required)
     * The URL to the jBPM server.
     * 
     * Path parameter: eventListenerType
     * Sets the event listener type to attach to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path connectionURL
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JBPMEndpointBuilderFactory.JBPMEndpointBuilder jbpm(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JBPMEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JCache (camel-jcache)
     * Perform caching operations against JSR107/JCache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     * 
     * Syntax: <code>jcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JCacheEndpointBuilderFactory.JCacheEndpointBuilder jcache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JCacheEndpointBuilderFactory.endpointBuilder("jcache", path);
    }
    /**
     * JCache (camel-jcache)
     * Perform caching operations against JSR107/JCache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     * 
     * Syntax: <code>jcache:cacheName</code>
     * 
     * Path parameter: cacheName (required)
     * The name of the cache
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path cacheName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JCacheEndpointBuilderFactory.JCacheEndpointBuilder jcache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JCacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JClouds (camel-jclouds)
     * Interact with jclouds compute and blobstore service.
     * 
     * Category: api,cloud,compute
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-jclouds
     * 
     * Syntax: <code>jclouds:command:providerId</code>
     * 
     * Path parameter: command (required)
     * What command to execute such as blobstore or compute.
     * There are 2 enums and the value can be one of: blobstore, compute
     * 
     * Path parameter: providerId (required)
     * The name of the cloud provider that provides the target service (e.g.
     * aws-s3 or aws_ec2).
     * 
     * @param path command:providerId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JcloudsEndpointBuilderFactory.JcloudsEndpointBuilder jclouds(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JcloudsEndpointBuilderFactory.endpointBuilder("jclouds", path);
    }
    /**
     * JClouds (camel-jclouds)
     * Interact with jclouds compute and blobstore service.
     * 
     * Category: api,cloud,compute
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-jclouds
     * 
     * Syntax: <code>jclouds:command:providerId</code>
     * 
     * Path parameter: command (required)
     * What command to execute such as blobstore or compute.
     * There are 2 enums and the value can be one of: blobstore, compute
     * 
     * Path parameter: providerId (required)
     * The name of the cloud provider that provides the target service (e.g.
     * aws-s3 or aws_ec2).
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path command:providerId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JcloudsEndpointBuilderFactory.JcloudsEndpointBuilder jclouds(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JcloudsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JCR (camel-jcr)
     * Read and write nodes to/from a JCR compliant content repository.
     * 
     * Category: database,cms
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     * 
     * Syntax: <code>jcr:host/base</code>
     * 
     * Path parameter: host (required)
     * Name of the javax.jcr.Repository to lookup from the Camel registry to be
     * used.
     * 
     * Path parameter: base
     * Get the base node when accessing the repository
     * 
     * @param path host/base
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JcrEndpointBuilderFactory.JcrEndpointBuilder jcr(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JcrEndpointBuilderFactory.endpointBuilder("jcr", path);
    }
    /**
     * JCR (camel-jcr)
     * Read and write nodes to/from a JCR compliant content repository.
     * 
     * Category: database,cms
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     * 
     * Syntax: <code>jcr:host/base</code>
     * 
     * Path parameter: host (required)
     * Name of the javax.jcr.Repository to lookup from the Camel registry to be
     * used.
     * 
     * Path parameter: base
     * Get the base node when accessing the repository
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host/base
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JcrEndpointBuilderFactory.JcrEndpointBuilder jcr(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JcrEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JDBC (camel-jdbc)
     * Access databases through SQL and JDBC.
     * 
     * Category: database,sql
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jdbc
     * 
     * Syntax: <code>jdbc:dataSourceName</code>
     * 
     * Path parameter: dataSourceName (required)
     * Name of DataSource to lookup in the Registry. If the name is dataSource
     * or default, then Camel will attempt to lookup a default DataSource from
     * the registry, meaning if there is a only one instance of DataSource
     * found, then this DataSource will be used.
     * 
     * @param path dataSourceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JdbcEndpointBuilderFactory.JdbcEndpointBuilder jdbc(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JdbcEndpointBuilderFactory.endpointBuilder("jdbc", path);
    }
    /**
     * JDBC (camel-jdbc)
     * Access databases through SQL and JDBC.
     * 
     * Category: database,sql
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jdbc
     * 
     * Syntax: <code>jdbc:dataSourceName</code>
     * 
     * Path parameter: dataSourceName (required)
     * Name of DataSource to lookup in the Registry. If the name is dataSource
     * or default, then Camel will attempt to lookup a default DataSource from
     * the registry, meaning if there is a only one instance of DataSource
     * found, then this DataSource will be used.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path dataSourceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JdbcEndpointBuilderFactory.JdbcEndpointBuilder jdbc(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JdbcEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Jetty (camel-jetty)
     * Expose HTTP endpoints using Jetty 9.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     * 
     * Syntax: <code>jetty:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JettyHttpEndpointBuilderFactory.JettyHttpEndpointBuilder jetty(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JettyHttpEndpointBuilderFactory.endpointBuilder("jetty", path);
    }
    /**
     * Jetty (camel-jetty)
     * Expose HTTP endpoints using Jetty 9.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     * 
     * Syntax: <code>jetty:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JettyHttpEndpointBuilderFactory.JettyHttpEndpointBuilder jetty(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JettyHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JGroups (camel-jgroups)
     * Exchange messages with JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-jgroups
     * 
     * Syntax: <code>jgroups:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * The name of the JGroups cluster the component should connect to.
     * 
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JGroupsEndpointBuilderFactory.JGroupsEndpointBuilder jgroups(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JGroupsEndpointBuilderFactory.endpointBuilder("jgroups", path);
    }
    /**
     * JGroups (camel-jgroups)
     * Exchange messages with JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-jgroups
     * 
     * Syntax: <code>jgroups:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * The name of the JGroups cluster the component should connect to.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JGroupsEndpointBuilderFactory.JGroupsEndpointBuilder jgroups(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JGroupsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JGroups raft (camel-jgroups-raft)
     * Exchange messages with JGroups-raft clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-jgroups-raft
     * 
     * Syntax: <code>jgroups-raft:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * The name of the JGroupsraft cluster the component should connect to.
     * 
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JGroupsRaftEndpointBuilderFactory.JGroupsRaftEndpointBuilder jgroupsRaft(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JGroupsRaftEndpointBuilderFactory.endpointBuilder("jgroups-raft", path);
    }
    /**
     * JGroups raft (camel-jgroups-raft)
     * Exchange messages with JGroups-raft clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-jgroups-raft
     * 
     * Syntax: <code>jgroups-raft:clusterName</code>
     * 
     * Path parameter: clusterName (required)
     * The name of the JGroupsraft cluster the component should connect to.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path clusterName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JGroupsRaftEndpointBuilderFactory.JGroupsRaftEndpointBuilder jgroupsRaft(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JGroupsRaftEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Jira (camel-jira)
     * Interact with JIRA issue tracker.
     * 
     * Category: api,reporting
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jira
     * 
     * Syntax: <code>jira:type</code>
     * 
     * Path parameter: type (required)
     * Operation to perform. Consumers: NewIssues, NewComments. Producers:
     * AddIssue, AttachFile, DeleteIssue, TransitionIssue, UpdateIssue,
     * Watchers. See this class javadoc description for more information.
     * There are 14 enums and the value can be one of: ADDCOMMENT, ADDISSUE,
     * ATTACH, DELETEISSUE, NEWISSUES, NEWCOMMENTS, WATCHUPDATES, UPDATEISSUE,
     * TRANSITIONISSUE, WATCHERS, ADDISSUELINK, ADDWORKLOG, FETCHISSUE,
     * FETCHCOMMENTS
     * 
     * @param path type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JiraEndpointBuilderFactory.JiraEndpointBuilder jira(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JiraEndpointBuilderFactory.endpointBuilder("jira", path);
    }
    /**
     * Jira (camel-jira)
     * Interact with JIRA issue tracker.
     * 
     * Category: api,reporting
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jira
     * 
     * Syntax: <code>jira:type</code>
     * 
     * Path parameter: type (required)
     * Operation to perform. Consumers: NewIssues, NewComments. Producers:
     * AddIssue, AttachFile, DeleteIssue, TransitionIssue, UpdateIssue,
     * Watchers. See this class javadoc description for more information.
     * There are 14 enums and the value can be one of: ADDCOMMENT, ADDISSUE,
     * ATTACH, DELETEISSUE, NEWISSUES, NEWCOMMENTS, WATCHUPDATES, UPDATEISSUE,
     * TRANSITIONISSUE, WATCHERS, ADDISSUELINK, ADDWORKLOG, FETCHISSUE,
     * FETCHCOMMENTS
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JiraEndpointBuilderFactory.JiraEndpointBuilder jira(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JiraEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JMS (camel-jms)
     * Sent and receive messages to/from a JMS Queue or Topic.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jms
     * 
     * Syntax: <code>jms:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JmsEndpointBuilderFactory.JmsEndpointBuilder jms(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JmsEndpointBuilderFactory.endpointBuilder("jms", path);
    }
    /**
     * JMS (camel-jms)
     * Sent and receive messages to/from a JMS Queue or Topic.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jms
     * 
     * Syntax: <code>jms:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 4 enums and the value can be one of: queue, topic, temp-queue,
     * temp-topic
     * 
     * Path parameter: destinationName (required)
     * Name of the queue or topic to use as destination
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JmsEndpointBuilderFactory.JmsEndpointBuilder jms(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JmsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JMX (camel-jmx)
     * Receive JMX notifications.
     * 
     * Category: monitoring
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jmx
     * 
     * Syntax: <code>jmx:serverURL</code>
     * 
     * Path parameter: serverURL
     * Server url comes from the remaining endpoint. Use platform to connect to
     * local JVM.
     * 
     * @param path serverURL
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JMXEndpointBuilderFactory.JMXEndpointBuilder jmx(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JMXEndpointBuilderFactory.endpointBuilder("jmx", path);
    }
    /**
     * JMX (camel-jmx)
     * Receive JMX notifications.
     * 
     * Category: monitoring
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jmx
     * 
     * Syntax: <code>jmx:serverURL</code>
     * 
     * Path parameter: serverURL
     * Server url comes from the remaining endpoint. Use platform to connect to
     * local JVM.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path serverURL
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JMXEndpointBuilderFactory.JMXEndpointBuilder jmx(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JMXEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JOLT (camel-jolt)
     * JSON to JSON transformation using JOLT.
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     * 
     * Syntax: <code>jolt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JoltEndpointBuilderFactory.JoltEndpointBuilder jolt(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JoltEndpointBuilderFactory.endpointBuilder("jolt", path);
    }
    /**
     * JOLT (camel-jolt)
     * JSON to JSON transformation using JOLT.
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     * 
     * Syntax: <code>jolt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JoltEndpointBuilderFactory.JoltEndpointBuilder jolt(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JoltEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JOOQ (camel-jooq)
     * Store and retrieve Java objects from an SQL database using JOOQ.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jooq
     * 
     * Syntax: <code>jooq:entityType</code>
     * 
     * Path parameter: entityType
     * JOOQ entity class
     * 
     * @param path entityType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JooqEndpointBuilderFactory.JooqEndpointBuilder jooq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JooqEndpointBuilderFactory.endpointBuilder("jooq", path);
    }
    /**
     * JOOQ (camel-jooq)
     * Store and retrieve Java objects from an SQL database using JOOQ.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jooq
     * 
     * Syntax: <code>jooq:entityType</code>
     * 
     * Path parameter: entityType
     * JOOQ entity class
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path entityType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JooqEndpointBuilderFactory.JooqEndpointBuilder jooq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JooqEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JPA (camel-jpa)
     * Store and retrieve Java objects from databases using Java Persistence API
     * (JPA).
     * 
     * Category: database,sql
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     * 
     * Syntax: <code>jpa:entityType</code>
     * 
     * Path parameter: entityType (required)
     * Entity class name
     * 
     * @param path entityType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JpaEndpointBuilderFactory.JpaEndpointBuilder jpa(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JpaEndpointBuilderFactory.endpointBuilder("jpa", path);
    }
    /**
     * JPA (camel-jpa)
     * Store and retrieve Java objects from databases using Java Persistence API
     * (JPA).
     * 
     * Category: database,sql
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     * 
     * Syntax: <code>jpa:entityType</code>
     * 
     * Path parameter: entityType (required)
     * Entity class name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path entityType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JpaEndpointBuilderFactory.JpaEndpointBuilder jpa(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JpaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JSLT (camel-jslt)
     * Query or transform JSON payloads using an JSLT.
     * 
     * Category: transformation
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-jslt
     * 
     * Syntax: <code>jslt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsltEndpointBuilderFactory.JsltEndpointBuilder jslt(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsltEndpointBuilderFactory.endpointBuilder("jslt", path);
    }
    /**
     * JSLT (camel-jslt)
     * Query or transform JSON payloads using an JSLT.
     * 
     * Category: transformation
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-jslt
     * 
     * Syntax: <code>jslt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsltEndpointBuilderFactory.JsltEndpointBuilder jslt(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsltEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JSONata (camel-jsonata)
     * Transforms JSON payload using JSONata transformation.
     * 
     * Category: transformation
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-jsonata
     * 
     * Syntax: <code>jsonata:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonataEndpointBuilderFactory.JsonataEndpointBuilder jsonata(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonataEndpointBuilderFactory.endpointBuilder("jsonata", path);
    }
    /**
     * JSONata (camel-jsonata)
     * Transforms JSON payload using JSONata transformation.
     * 
     * Category: transformation
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-jsonata
     * 
     * Syntax: <code>jsonata:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonataEndpointBuilderFactory.JsonataEndpointBuilder jsonata(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonataEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JsonPatch (camel-json-patch)
     * Transforms JSON using JSON patch (RFC 6902).
     * 
     * Category: transformation
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-json-patch
     * 
     * Syntax: <code>json-patch:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonPatchEndpointBuilderFactory.JsonPatchEndpointBuilder jsonPatch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonPatchEndpointBuilderFactory.endpointBuilder("json-patch", path);
    }
    /**
     * JsonPatch (camel-json-patch)
     * Transforms JSON using JSON patch (RFC 6902).
     * 
     * Category: transformation
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-json-patch
     * 
     * Syntax: <code>json-patch:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonPatchEndpointBuilderFactory.JsonPatchEndpointBuilder jsonPatch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonPatchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JSON Schema Validator (camel-json-validator)
     * Validate JSON payloads using NetworkNT JSON Schema.
     * 
     * Category: validation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-json-validator
     * 
     * Syntax: <code>json-validator:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonValidatorEndpointBuilderFactory.JsonValidatorEndpointBuilder jsonValidator(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonValidatorEndpointBuilderFactory.endpointBuilder("json-validator", path);
    }
    /**
     * JSON Schema Validator (camel-json-validator)
     * Validate JSON payloads using NetworkNT JSON Schema.
     * 
     * Category: validation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-json-validator
     * 
     * Syntax: <code>json-validator:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.JsonValidatorEndpointBuilderFactory.JsonValidatorEndpointBuilder jsonValidator(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JsonValidatorEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * JT400 (camel-jt400)
     * Exchanges messages with an IBM i system using data queues, message
     * queues, or program call. IBM i is the replacement for AS/400 and iSeries
     * servers.
     * 
     * Category: messaging
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     * 
     * Syntax:
     * <code>jt400:userID:password@systemName/QSYS.LIB/objectPath.type</code>
     * 
     * Path parameter: userID (required)
     * Returns the ID of the IBM i user.
     * 
     * Path parameter: password (required)
     * Returns the password of the IBM i user.
     * 
     * Path parameter: systemName (required)
     * Returns the name of the IBM i system.
     * 
     * Path parameter: objectPath (required)
     * Returns the fully qualified integrated file system path name of the
     * target object of this endpoint.
     * 
     * Path parameter: type (required)
     * Whether to work with data queues or remote program call
     * There are 4 enums and the value can be one of: DTAQ, PGM, SRVPGM, MSGQ
     * 
     * @param path userID:password@systemName/QSYS.LIB/objectPath.type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Jt400EndpointBuilderFactory.Jt400EndpointBuilder jt400(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Jt400EndpointBuilderFactory.endpointBuilder("jt400", path);
    }
    /**
     * JT400 (camel-jt400)
     * Exchanges messages with an IBM i system using data queues, message
     * queues, or program call. IBM i is the replacement for AS/400 and iSeries
     * servers.
     * 
     * Category: messaging
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     * 
     * Syntax:
     * <code>jt400:userID:password@systemName/QSYS.LIB/objectPath.type</code>
     * 
     * Path parameter: userID (required)
     * Returns the ID of the IBM i user.
     * 
     * Path parameter: password (required)
     * Returns the password of the IBM i user.
     * 
     * Path parameter: systemName (required)
     * Returns the name of the IBM i system.
     * 
     * Path parameter: objectPath (required)
     * Returns the fully qualified integrated file system path name of the
     * target object of this endpoint.
     * 
     * Path parameter: type (required)
     * Whether to work with data queues or remote program call
     * There are 4 enums and the value can be one of: DTAQ, PGM, SRVPGM, MSGQ
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path userID:password@systemName/QSYS.LIB/objectPath.type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Jt400EndpointBuilderFactory.Jt400EndpointBuilder jt400(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Jt400EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     * 
     * Syntax: <code>kafka:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic to use. On the consumer you can use comma to separate
     * multiple topics. A producer can only send a message to a single topic.
     * 
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KafkaEndpointBuilderFactory.KafkaEndpointBuilder kafka(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KafkaEndpointBuilderFactory.endpointBuilder("kafka", path);
    }
    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     * 
     * Syntax: <code>kafka:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic to use. On the consumer you can use comma to separate
     * multiple topics. A producer can only send a message to a single topic.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KafkaEndpointBuilderFactory.KafkaEndpointBuilder kafka(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KafkaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kamelet (camel-kamelet)
     * To call Kamelets
     * 
     * Category: core
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-kamelet
     * 
     * Syntax: <code>kamelet:templateId/routeId</code>
     * 
     * Path parameter: templateId (required)
     * The Route Template ID
     * 
     * Path parameter: routeId
     * The Route ID. Default value notice: The ID will be auto-generated if not
     * provided
     * 
     * @param path templateId/routeId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KameletEndpointBuilderFactory.KameletEndpointBuilder kamelet(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KameletEndpointBuilderFactory.endpointBuilder("kamelet", path);
    }
    /**
     * Kamelet (camel-kamelet)
     * To call Kamelets
     * 
     * Category: core
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-kamelet
     * 
     * Syntax: <code>kamelet:templateId/routeId</code>
     * 
     * Path parameter: templateId (required)
     * The Route Template ID
     * 
     * Path parameter: routeId
     * The Route ID. Default value notice: The ID will be auto-generated if not
     * provided
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path templateId/routeId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KameletEndpointBuilderFactory.KameletEndpointBuilder kamelet(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KameletEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Knative (camel-knative)
     * Send and receive events from Knative.
     * 
     * Category: cloud
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-knative
     * 
     * Syntax: <code>knative:type/typeId</code>
     * 
     * Path parameter: type
     * The Knative resource type
     * There are 3 enums and the value can be one of: endpoint, channel, event
     * 
     * Path parameter: typeId
     * The identifier of the Knative resource
     * 
     * @param path type/typeId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KnativeEndpointBuilderFactory.KnativeEndpointBuilder knative(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KnativeEndpointBuilderFactory.endpointBuilder("knative", path);
    }
    /**
     * Knative (camel-knative)
     * Send and receive events from Knative.
     * 
     * Category: cloud
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-knative
     * 
     * Syntax: <code>knative:type/typeId</code>
     * 
     * Path parameter: type
     * The Knative resource type
     * There are 3 enums and the value can be one of: endpoint, channel, event
     * 
     * Path parameter: typeId
     * The identifier of the Knative resource
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type/typeId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KnativeEndpointBuilderFactory.KnativeEndpointBuilder knative(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KnativeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes ConfigMap (camel-kubernetes)
     * Perform operations on Kubernetes ConfigMaps and get notified on
     * ConfigMaps changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-config-maps:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesConfigMapsEndpointBuilderFactory.KubernetesConfigMapsEndpointBuilder kubernetesConfigMaps(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesConfigMapsEndpointBuilderFactory.endpointBuilder("kubernetes-config-maps", path);
    }
    /**
     * Kubernetes ConfigMap (camel-kubernetes)
     * Perform operations on Kubernetes ConfigMaps and get notified on
     * ConfigMaps changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-config-maps:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesConfigMapsEndpointBuilderFactory.KubernetesConfigMapsEndpointBuilder kubernetesConfigMaps(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesConfigMapsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Custom Resources (camel-kubernetes)
     * Perform operations on Kubernetes Custom Resources and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-custom-resources:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesCustomResourcesEndpointBuilderFactory.KubernetesCustomResourcesEndpointBuilder kubernetesCustomResources(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesCustomResourcesEndpointBuilderFactory.endpointBuilder("kubernetes-custom-resources", path);
    }
    /**
     * Kubernetes Custom Resources (camel-kubernetes)
     * Perform operations on Kubernetes Custom Resources and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-custom-resources:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesCustomResourcesEndpointBuilderFactory.KubernetesCustomResourcesEndpointBuilder kubernetesCustomResources(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesCustomResourcesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Deployments (camel-kubernetes)
     * Perform operations on Kubernetes Deployments and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-deployments:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesDeploymentsEndpointBuilderFactory.KubernetesDeploymentsEndpointBuilder kubernetesDeployments(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesDeploymentsEndpointBuilderFactory.endpointBuilder("kubernetes-deployments", path);
    }
    /**
     * Kubernetes Deployments (camel-kubernetes)
     * Perform operations on Kubernetes Deployments and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-deployments:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesDeploymentsEndpointBuilderFactory.KubernetesDeploymentsEndpointBuilder kubernetesDeployments(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesDeploymentsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Event (camel-kubernetes)
     * Perform operations on Kubernetes Events and get notified on Events
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-events:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesEventsEndpointBuilderFactory.KubernetesEventsEndpointBuilder kubernetesEvents(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesEventsEndpointBuilderFactory.endpointBuilder("kubernetes-events", path);
    }
    /**
     * Kubernetes Event (camel-kubernetes)
     * Perform operations on Kubernetes Events and get notified on Events
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-events:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesEventsEndpointBuilderFactory.KubernetesEventsEndpointBuilder kubernetesEvents(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesEventsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes HPA (camel-kubernetes)
     * Perform operations on Kubernetes Horizontal Pod Autoscalers (HPA) and get
     * notified on HPA changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-hpa:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesHPAEndpointBuilderFactory.KubernetesHPAEndpointBuilder kubernetesHpa(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesHPAEndpointBuilderFactory.endpointBuilder("kubernetes-hpa", path);
    }
    /**
     * Kubernetes HPA (camel-kubernetes)
     * Perform operations on Kubernetes Horizontal Pod Autoscalers (HPA) and get
     * notified on HPA changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-hpa:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesHPAEndpointBuilderFactory.KubernetesHPAEndpointBuilder kubernetesHpa(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesHPAEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Job (camel-kubernetes)
     * Perform operations on Kubernetes Jobs.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-job:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesJobEndpointBuilderFactory.KubernetesJobEndpointBuilder kubernetesJob(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesJobEndpointBuilderFactory.endpointBuilder("kubernetes-job", path);
    }
    /**
     * Kubernetes Job (camel-kubernetes)
     * Perform operations on Kubernetes Jobs.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-job:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesJobEndpointBuilderFactory.KubernetesJobEndpointBuilder kubernetesJob(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesJobEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Namespaces (camel-kubernetes)
     * Perform operations on Kubernetes Namespaces and get notified on Namespace
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-namespaces:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesNamespacesEndpointBuilderFactory.KubernetesNamespacesEndpointBuilder kubernetesNamespaces(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesNamespacesEndpointBuilderFactory.endpointBuilder("kubernetes-namespaces", path);
    }
    /**
     * Kubernetes Namespaces (camel-kubernetes)
     * Perform operations on Kubernetes Namespaces and get notified on Namespace
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-namespaces:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesNamespacesEndpointBuilderFactory.KubernetesNamespacesEndpointBuilder kubernetesNamespaces(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesNamespacesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Nodes (camel-kubernetes)
     * Perform operations on Kubernetes Nodes and get notified on Node changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-nodes:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesNodesEndpointBuilderFactory.KubernetesNodesEndpointBuilder kubernetesNodes(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesNodesEndpointBuilderFactory.endpointBuilder("kubernetes-nodes", path);
    }
    /**
     * Kubernetes Nodes (camel-kubernetes)
     * Perform operations on Kubernetes Nodes and get notified on Node changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-nodes:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesNodesEndpointBuilderFactory.KubernetesNodesEndpointBuilder kubernetesNodes(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesNodesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Persistent Volume (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes and get notified on
     * Persistent Volume changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-persistent-volumes:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesEndpointBuilderFactory.KubernetesPersistentVolumesEndpointBuilder kubernetesPersistentVolumes(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesEndpointBuilderFactory.endpointBuilder("kubernetes-persistent-volumes", path);
    }
    /**
     * Kubernetes Persistent Volume (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes and get notified on
     * Persistent Volume changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-persistent-volumes:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesEndpointBuilderFactory.KubernetesPersistentVolumesEndpointBuilder kubernetesPersistentVolumes(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Persistent Volume Claim (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes Claims and get
     * notified on Persistent Volumes Claim changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-persistent-volumes-claims:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesClaimsEndpointBuilderFactory.KubernetesPersistentVolumesClaimsEndpointBuilder kubernetesPersistentVolumesClaims(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesClaimsEndpointBuilderFactory.endpointBuilder("kubernetes-persistent-volumes-claims", path);
    }
    /**
     * Kubernetes Persistent Volume Claim (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes Claims and get
     * notified on Persistent Volumes Claim changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-persistent-volumes-claims:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesClaimsEndpointBuilderFactory.KubernetesPersistentVolumesClaimsEndpointBuilder kubernetesPersistentVolumesClaims(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPersistentVolumesClaimsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Pods (camel-kubernetes)
     * Perform operations on Kubernetes Pods and get notified on Pod changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-pods:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPodsEndpointBuilderFactory.KubernetesPodsEndpointBuilder kubernetesPods(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPodsEndpointBuilderFactory.endpointBuilder("kubernetes-pods", path);
    }
    /**
     * Kubernetes Pods (camel-kubernetes)
     * Perform operations on Kubernetes Pods and get notified on Pod changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-pods:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesPodsEndpointBuilderFactory.KubernetesPodsEndpointBuilder kubernetesPods(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesPodsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Replication Controller (camel-kubernetes)
     * Perform operations on Kubernetes Replication Controllers and get notified
     * on Replication Controllers changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-replication-controllers:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesReplicationControllersEndpointBuilderFactory.KubernetesReplicationControllersEndpointBuilder kubernetesReplicationControllers(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesReplicationControllersEndpointBuilderFactory.endpointBuilder("kubernetes-replication-controllers", path);
    }
    /**
     * Kubernetes Replication Controller (camel-kubernetes)
     * Perform operations on Kubernetes Replication Controllers and get notified
     * on Replication Controllers changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-replication-controllers:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesReplicationControllersEndpointBuilderFactory.KubernetesReplicationControllersEndpointBuilder kubernetesReplicationControllers(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesReplicationControllersEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Resources Quota (camel-kubernetes)
     * Perform operations on Kubernetes Resources Quotas.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-resources-quota:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesResourcesQuotaEndpointBuilderFactory.KubernetesResourcesQuotaEndpointBuilder kubernetesResourcesQuota(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesResourcesQuotaEndpointBuilderFactory.endpointBuilder("kubernetes-resources-quota", path);
    }
    /**
     * Kubernetes Resources Quota (camel-kubernetes)
     * Perform operations on Kubernetes Resources Quotas.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-resources-quota:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesResourcesQuotaEndpointBuilderFactory.KubernetesResourcesQuotaEndpointBuilder kubernetesResourcesQuota(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesResourcesQuotaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Secrets (camel-kubernetes)
     * Perform operations on Kubernetes Secrets.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-secrets:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesSecretsEndpointBuilderFactory.KubernetesSecretsEndpointBuilder kubernetesSecrets(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesSecretsEndpointBuilderFactory.endpointBuilder("kubernetes-secrets", path);
    }
    /**
     * Kubernetes Secrets (camel-kubernetes)
     * Perform operations on Kubernetes Secrets.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-secrets:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesSecretsEndpointBuilderFactory.KubernetesSecretsEndpointBuilder kubernetesSecrets(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesSecretsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Service Account (camel-kubernetes)
     * Perform operations on Kubernetes Service Accounts.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-service-accounts:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesServiceAccountsEndpointBuilderFactory.KubernetesServiceAccountsEndpointBuilder kubernetesServiceAccounts(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesServiceAccountsEndpointBuilderFactory.endpointBuilder("kubernetes-service-accounts", path);
    }
    /**
     * Kubernetes Service Account (camel-kubernetes)
     * Perform operations on Kubernetes Service Accounts.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-service-accounts:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesServiceAccountsEndpointBuilderFactory.KubernetesServiceAccountsEndpointBuilder kubernetesServiceAccounts(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesServiceAccountsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kubernetes Services (camel-kubernetes)
     * Perform operations on Kubernetes Services and get notified on Service
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-services:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesServicesEndpointBuilderFactory.KubernetesServicesEndpointBuilder kubernetesServices(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesServicesEndpointBuilderFactory.endpointBuilder("kubernetes-services", path);
    }
    /**
     * Kubernetes Services (camel-kubernetes)
     * Perform operations on Kubernetes Services and get notified on Service
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>kubernetes-services:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KubernetesServicesEndpointBuilderFactory.KubernetesServicesEndpointBuilder kubernetesServices(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KubernetesServicesEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Kudu (camel-kudu)
     * Interact with Apache Kudu, a free and open source column-oriented data
     * store of the Apache Hadoop ecosystem.
     * 
     * Category: database,iot,cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-kudu
     * 
     * Syntax: <code>kudu:host:port/tableName</code>
     * 
     * Path parameter: host
     * Host of the server to connect to
     * 
     * Path parameter: port
     * Port of the server to connect to
     * 
     * Path parameter: tableName
     * Table to connect to
     * 
     * @param path host:port/tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KuduEndpointBuilderFactory.KuduEndpointBuilder kudu(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KuduEndpointBuilderFactory.endpointBuilder("kudu", path);
    }
    /**
     * Kudu (camel-kudu)
     * Interact with Apache Kudu, a free and open source column-oriented data
     * store of the Apache Hadoop ecosystem.
     * 
     * Category: database,iot,cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-kudu
     * 
     * Syntax: <code>kudu:host:port/tableName</code>
     * 
     * Path parameter: host
     * Host of the server to connect to
     * 
     * Path parameter: port
     * Port of the server to connect to
     * 
     * Path parameter: tableName
     * Table to connect to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KuduEndpointBuilderFactory.KuduEndpointBuilder kudu(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KuduEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Language (camel-language)
     * Execute scripts in any of the languages supported by Camel.
     * 
     * Category: core,script
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-language
     * 
     * Syntax: <code>language:languageName:resourceUri</code>
     * 
     * Path parameter: languageName (required)
     * Sets the name of the language to use
     * There are 22 enums and the value can be one of: bean, constant, csimple,
     * datasonnet, exchangeProperty, file, groovy, header, hl7terser, joor, jq,
     * jsonpath, mvel, ognl, ref, simple, spel, sql, tokenize, xpath, xquery,
     * xtokenize
     * 
     * Path parameter: resourceUri
     * Path to the resource, or a reference to lookup a bean in the Registry to
     * use as the resource
     * 
     * @param path languageName:resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LanguageEndpointBuilderFactory.LanguageEndpointBuilder language(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LanguageEndpointBuilderFactory.endpointBuilder("language", path);
    }
    /**
     * Language (camel-language)
     * Execute scripts in any of the languages supported by Camel.
     * 
     * Category: core,script
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-language
     * 
     * Syntax: <code>language:languageName:resourceUri</code>
     * 
     * Path parameter: languageName (required)
     * Sets the name of the language to use
     * There are 22 enums and the value can be one of: bean, constant, csimple,
     * datasonnet, exchangeProperty, file, groovy, header, hl7terser, joor, jq,
     * jsonpath, mvel, ognl, ref, simple, spel, sql, tokenize, xpath, xquery,
     * xtokenize
     * 
     * Path parameter: resourceUri
     * Path to the resource, or a reference to lookup a bean in the Registry to
     * use as the resource
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path languageName:resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LanguageEndpointBuilderFactory.LanguageEndpointBuilder language(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LanguageEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * LDAP (camel-ldap)
     * Perform searches on LDAP servers.
     * 
     * Category: search,ldap
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-ldap
     * 
     * Syntax: <code>ldap:dirContextName</code>
     * 
     * Path parameter: dirContextName (required)
     * Name of either a javax.naming.directory.DirContext, or
     * java.util.Hashtable, or Map bean to lookup in the registry. If the bean
     * is either a Hashtable or Map then a new javax.naming.directory.DirContext
     * instance is created for each use. If the bean is a
     * javax.naming.directory.DirContext then the bean is used as given. The
     * latter may not be possible in all situations where the
     * javax.naming.directory.DirContext must not be shared, and in those
     * situations it can be better to use java.util.Hashtable or Map instead.
     * 
     * @param path dirContextName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LdapEndpointBuilderFactory.LdapEndpointBuilder ldap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LdapEndpointBuilderFactory.endpointBuilder("ldap", path);
    }
    /**
     * LDAP (camel-ldap)
     * Perform searches on LDAP servers.
     * 
     * Category: search,ldap
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-ldap
     * 
     * Syntax: <code>ldap:dirContextName</code>
     * 
     * Path parameter: dirContextName (required)
     * Name of either a javax.naming.directory.DirContext, or
     * java.util.Hashtable, or Map bean to lookup in the registry. If the bean
     * is either a Hashtable or Map then a new javax.naming.directory.DirContext
     * instance is created for each use. If the bean is a
     * javax.naming.directory.DirContext then the bean is used as given. The
     * latter may not be possible in all situations where the
     * javax.naming.directory.DirContext must not be shared, and in those
     * situations it can be better to use java.util.Hashtable or Map instead.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path dirContextName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LdapEndpointBuilderFactory.LdapEndpointBuilder ldap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LdapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * LDIF (camel-ldif)
     * Perform updates on an LDAP server from an LDIF body content.
     * 
     * Category: ldap
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     * 
     * Syntax: <code>ldif:ldapConnectionName</code>
     * 
     * Path parameter: ldapConnectionName (required)
     * The name of the LdapConnection bean to pull from the registry. Note that
     * this must be of scope prototype to avoid it being shared among threads or
     * using a connection that has timed out.
     * 
     * @param path ldapConnectionName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LdifEndpointBuilderFactory.LdifEndpointBuilder ldif(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LdifEndpointBuilderFactory.endpointBuilder("ldif", path);
    }
    /**
     * LDIF (camel-ldif)
     * Perform updates on an LDAP server from an LDIF body content.
     * 
     * Category: ldap
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     * 
     * Syntax: <code>ldif:ldapConnectionName</code>
     * 
     * Path parameter: ldapConnectionName (required)
     * The name of the LdapConnection bean to pull from the registry. Note that
     * this must be of scope prototype to avoid it being shared among threads or
     * using a connection that has timed out.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path ldapConnectionName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LdifEndpointBuilderFactory.LdifEndpointBuilder ldif(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LdifEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Log (camel-log)
     * Log messages to the underlying logging mechanism.
     * 
     * Category: core,monitoring
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     * 
     * Syntax: <code>log:loggerName</code>
     * 
     * Path parameter: loggerName (required)
     * Name of the logging category to use
     * 
     * @param path loggerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LogEndpointBuilderFactory.LogEndpointBuilder log(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LogEndpointBuilderFactory.endpointBuilder("log", path);
    }
    /**
     * Log (camel-log)
     * Log messages to the underlying logging mechanism.
     * 
     * Category: core,monitoring
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     * 
     * Syntax: <code>log:loggerName</code>
     * 
     * Path parameter: loggerName (required)
     * Name of the logging category to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path loggerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LogEndpointBuilderFactory.LogEndpointBuilder log(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LogEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Printer (camel-printer)
     * Send print jobs to printers.
     * 
     * Category: printing
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-printer
     * 
     * Syntax: <code>lpr:hostname:port/printername</code>
     * 
     * Path parameter: hostname (required)
     * Hostname of the printer
     * 
     * Path parameter: port
     * Port number of the printer
     * 
     * Path parameter: printername
     * Name of the printer
     * 
     * @param path hostname:port/printername
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PrinterEndpointBuilderFactory.PrinterEndpointBuilder lpr(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PrinterEndpointBuilderFactory.endpointBuilder("lpr", path);
    }
    /**
     * Printer (camel-printer)
     * Send print jobs to printers.
     * 
     * Category: printing
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-printer
     * 
     * Syntax: <code>lpr:hostname:port/printername</code>
     * 
     * Path parameter: hostname (required)
     * Hostname of the printer
     * 
     * Path parameter: port
     * Port number of the printer
     * 
     * Path parameter: printername
     * Name of the printer
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path hostname:port/printername
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PrinterEndpointBuilderFactory.PrinterEndpointBuilder lpr(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PrinterEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Lucene (camel-lucene)
     * Perform inserts or queries against Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     * 
     * Syntax: <code>lucene:host:operation</code>
     * 
     * Path parameter: host (required)
     * The URL to the lucene server
     * 
     * Path parameter: operation (required)
     * Operation to do such as insert or query.
     * There are 2 enums and the value can be one of: insert, query
     * 
     * @param path host:operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LuceneEndpointBuilderFactory.LuceneEndpointBuilder lucene(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LuceneEndpointBuilderFactory.endpointBuilder("lucene", path);
    }
    /**
     * Lucene (camel-lucene)
     * Perform inserts or queries against Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     * 
     * Syntax: <code>lucene:host:operation</code>
     * 
     * Path parameter: host (required)
     * The URL to the lucene server
     * 
     * Path parameter: operation (required)
     * Operation to do such as insert or query.
     * There are 2 enums and the value can be one of: insert, query
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LuceneEndpointBuilderFactory.LuceneEndpointBuilder lucene(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LuceneEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Lumberjack (camel-lumberjack)
     * Receive logs messages using the Lumberjack protocol.
     * 
     * Category: log
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-lumberjack
     * 
     * Syntax: <code>lumberjack:host:port</code>
     * 
     * Path parameter: host (required)
     * Network interface on which to listen for Lumberjack
     * 
     * Path parameter: port
     * Network port on which to listen for Lumberjack
     * Default value: 5044
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LumberjackEndpointBuilderFactory.LumberjackEndpointBuilder lumberjack(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LumberjackEndpointBuilderFactory.endpointBuilder("lumberjack", path);
    }
    /**
     * Lumberjack (camel-lumberjack)
     * Receive logs messages using the Lumberjack protocol.
     * 
     * Category: log
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-lumberjack
     * 
     * Syntax: <code>lumberjack:host:port</code>
     * 
     * Path parameter: host (required)
     * Network interface on which to listen for Lumberjack
     * 
     * Path parameter: port
     * Network port on which to listen for Lumberjack
     * Default value: 5044
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.LumberjackEndpointBuilderFactory.LumberjackEndpointBuilder lumberjack(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.LumberjackEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MapStruct (camel-mapstruct)
     * Type Conversion using Mapstruct
     * 
     * Category: transformation
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-mapstruct
     * 
     * Syntax: <code>mapstruct:className</code>
     * 
     * Path parameter: className (required)
     * The fully qualified class name of the POJO that mapstruct should convert
     * to (target)
     * 
     * @param path className
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MapstructEndpointBuilderFactory.MapstructEndpointBuilder mapstruct(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MapstructEndpointBuilderFactory.endpointBuilder("mapstruct", path);
    }
    /**
     * MapStruct (camel-mapstruct)
     * Type Conversion using Mapstruct
     * 
     * Category: transformation
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-mapstruct
     * 
     * Syntax: <code>mapstruct:className</code>
     * 
     * Path parameter: className (required)
     * The fully qualified class name of the POJO that mapstruct should convert
     * to (target)
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path className
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MapstructEndpointBuilderFactory.MapstructEndpointBuilder mapstruct(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MapstructEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Master (camel-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-master
     * 
     * Syntax: <code>master:namespace:delegateUri</code>
     * 
     * Path parameter: namespace (required)
     * The name of the cluster namespace to use
     * 
     * Path parameter: delegateUri (required)
     * The endpoint uri to use in master/slave mode
     * 
     * @param path namespace:delegateUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MasterEndpointBuilderFactory.MasterEndpointBuilder master(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MasterEndpointBuilderFactory.endpointBuilder("master", path);
    }
    /**
     * Master (camel-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-master
     * 
     * Syntax: <code>master:namespace:delegateUri</code>
     * 
     * Path parameter: namespace (required)
     * The name of the cluster namespace to use
     * 
     * Path parameter: delegateUri (required)
     * The endpoint uri to use in master/slave mode
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path namespace:delegateUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MasterEndpointBuilderFactory.MasterEndpointBuilder master(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MasterEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Metrics (camel-metrics)
     * Collect various metrics directly from Camel routes using the DropWizard
     * metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     * 
     * Syntax: <code>metrics:metricsType:metricsName</code>
     * 
     * Path parameter: metricsType (required)
     * Type of metrics
     * There are 5 enums and the value can be one of: gauge, counter, histogram,
     * meter, timer
     * 
     * Path parameter: metricsName (required)
     * Name of metrics
     * 
     * @param path metricsType:metricsName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MetricsEndpointBuilderFactory.MetricsEndpointBuilder metrics(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MetricsEndpointBuilderFactory.endpointBuilder("metrics", path);
    }
    /**
     * Metrics (camel-metrics)
     * Collect various metrics directly from Camel routes using the DropWizard
     * metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     * 
     * Syntax: <code>metrics:metricsType:metricsName</code>
     * 
     * Path parameter: metricsType (required)
     * Type of metrics
     * There are 5 enums and the value can be one of: gauge, counter, histogram,
     * meter, timer
     * 
     * Path parameter: metricsName (required)
     * Name of metrics
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path metricsType:metricsName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MetricsEndpointBuilderFactory.MetricsEndpointBuilder metrics(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MetricsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Micrometer (camel-micrometer)
     * Collect various metrics directly from Camel routes using the Micrometer
     * library.
     * 
     * Category: monitoring
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-micrometer
     * 
     * Syntax: <code>micrometer:metricsType:metricsName</code>
     * 
     * Path parameter: metricsType (required)
     * Type of metrics
     * There are 3 enums and the value can be one of: counter,
     * distribution_summary, timer
     * 
     * Path parameter: metricsName (required)
     * Name of metrics
     * 
     * Path parameter: tags
     * Tags of metrics
     * 
     * @param path metricsType:metricsName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MicrometerEndpointBuilderFactory.MicrometerEndpointBuilder micrometer(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MicrometerEndpointBuilderFactory.endpointBuilder("micrometer", path);
    }
    /**
     * Micrometer (camel-micrometer)
     * Collect various metrics directly from Camel routes using the Micrometer
     * library.
     * 
     * Category: monitoring
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-micrometer
     * 
     * Syntax: <code>micrometer:metricsType:metricsName</code>
     * 
     * Path parameter: metricsType (required)
     * Type of metrics
     * There are 3 enums and the value can be one of: counter,
     * distribution_summary, timer
     * 
     * Path parameter: metricsName (required)
     * Name of metrics
     * 
     * Path parameter: tags
     * Tags of metrics
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path metricsType:metricsName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MicrometerEndpointBuilderFactory.MicrometerEndpointBuilder micrometer(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MicrometerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MicroProfile Metrics (camel-microprofile-metrics)
     * Expose metrics from Camel routes.
     * 
     * Category: monitoring
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-microprofile-metrics
     * 
     * Syntax: <code>microprofile-metrics:metricType:metricName</code>
     * 
     * Path parameter: metricType (required)
     * Metric type
     * There are 8 enums and the value can be one of: concurrent gauge, counter,
     * gauge, meter, histogram, timer, simple timer, invalid
     * 
     * Path parameter: metricName (required)
     * Metric name
     * 
     * @param path metricType:metricName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.MicroProfileMetricsEndpointBuilderFactory.MicroProfileMetricsEndpointBuilder microprofileMetrics(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MicroProfileMetricsEndpointBuilderFactory.endpointBuilder("microprofile-metrics", path);
    }
    /**
     * MicroProfile Metrics (camel-microprofile-metrics)
     * Expose metrics from Camel routes.
     * 
     * Category: monitoring
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-microprofile-metrics
     * 
     * Syntax: <code>microprofile-metrics:metricType:metricName</code>
     * 
     * Path parameter: metricType (required)
     * Metric type
     * There are 8 enums and the value can be one of: concurrent gauge, counter,
     * gauge, meter, histogram, timer, simple timer, invalid
     * 
     * Path parameter: metricName (required)
     * Metric name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path metricType:metricName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.MicroProfileMetricsEndpointBuilderFactory.MicroProfileMetricsEndpointBuilder microprofileMetrics(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MicroProfileMetricsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OPC UA Browser (camel-milo)
     * Connect to OPC UA servers using the binary protocol for browsing the node
     * tree.
     * 
     * Category: iot
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-browse:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The OPC UA server endpoint
     * 
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloBrowseEndpointBuilderFactory.MiloBrowseEndpointBuilder miloBrowse(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloBrowseEndpointBuilderFactory.endpointBuilder("milo-browse", path);
    }
    /**
     * OPC UA Browser (camel-milo)
     * Connect to OPC UA servers using the binary protocol for browsing the node
     * tree.
     * 
     * Category: iot
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-browse:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The OPC UA server endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloBrowseEndpointBuilderFactory.MiloBrowseEndpointBuilder miloBrowse(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloBrowseEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OPC UA Client (camel-milo)
     * Connect to OPC UA servers using the binary protocol for acquiring
     * telemetry data.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-client:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The OPC UA server endpoint
     * 
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloClientEndpointBuilderFactory.MiloClientEndpointBuilder miloClient(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloClientEndpointBuilderFactory.endpointBuilder("milo-client", path);
    }
    /**
     * OPC UA Client (camel-milo)
     * Connect to OPC UA servers using the binary protocol for acquiring
     * telemetry data.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-client:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The OPC UA server endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloClientEndpointBuilderFactory.MiloClientEndpointBuilder miloClient(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloClientEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OPC UA Server (camel-milo)
     * Make telemetry data available as an OPC UA server.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-server:itemId</code>
     * 
     * Path parameter: itemId (required)
     * ID of the item
     * 
     * @param path itemId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloServerEndpointBuilderFactory.MiloServerEndpointBuilder miloServer(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloServerEndpointBuilderFactory.endpointBuilder("milo-server", path);
    }
    /**
     * OPC UA Server (camel-milo)
     * Make telemetry data available as an OPC UA server.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * Syntax: <code>milo-server:itemId</code>
     * 
     * Path parameter: itemId (required)
     * ID of the item
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path itemId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MiloServerEndpointBuilderFactory.MiloServerEndpointBuilder miloServer(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MiloServerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Mina (camel-mina)
     * Socket level networking using TCP or UDP with Apache Mina 2.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-mina
     * 
     * Syntax: <code>mina:protocol:host:port</code>
     * 
     * Path parameter: protocol (required)
     * Protocol to use
     * 
     * Path parameter: host (required)
     * Hostname to use. Use localhost or 0.0.0.0 for local server as consumer.
     * For producer use the hostname or ip address of the remote server.
     * 
     * Path parameter: port (required)
     * Port number
     * 
     * @param path protocol:host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MinaEndpointBuilderFactory.MinaEndpointBuilder mina(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MinaEndpointBuilderFactory.endpointBuilder("mina", path);
    }
    /**
     * Mina (camel-mina)
     * Socket level networking using TCP or UDP with Apache Mina 2.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-mina
     * 
     * Syntax: <code>mina:protocol:host:port</code>
     * 
     * Path parameter: protocol (required)
     * Protocol to use
     * 
     * Path parameter: host (required)
     * Hostname to use. Use localhost or 0.0.0.0 for local server as consumer.
     * For producer use the hostname or ip address of the remote server.
     * 
     * Path parameter: port (required)
     * Port number
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path protocol:host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MinaEndpointBuilderFactory.MinaEndpointBuilder mina(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MinaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Minio (camel-minio)
     * Store and retrieve objects from Minio Storage Service using Minio SDK.
     * 
     * Category: cloud,file
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-minio
     * 
     * Syntax: <code>minio:bucketName</code>
     * 
     * Path parameter: bucketName (required)
     * Bucket name
     * 
     * @param path bucketName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MinioEndpointBuilderFactory.MinioEndpointBuilder minio(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MinioEndpointBuilderFactory.endpointBuilder("minio", path);
    }
    /**
     * Minio (camel-minio)
     * Store and retrieve objects from Minio Storage Service using Minio SDK.
     * 
     * Category: cloud,file
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-minio
     * 
     * Syntax: <code>minio:bucketName</code>
     * 
     * Path parameter: bucketName (required)
     * Bucket name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path bucketName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MinioEndpointBuilderFactory.MinioEndpointBuilder minio(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MinioEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MLLP (camel-mllp)
     * Communicate with external systems using the MLLP protocol.
     * 
     * Category: networking,rpc,mllp
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     * 
     * Syntax: <code>mllp:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname or IP for connection for the TCP connection. The default value
     * is null, which means any local IP address
     * 
     * Path parameter: port (required)
     * Port number for the TCP connection
     * 
     * @param path hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MllpEndpointBuilderFactory.MllpEndpointBuilder mllp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MllpEndpointBuilderFactory.endpointBuilder("mllp", path);
    }
    /**
     * MLLP (camel-mllp)
     * Communicate with external systems using the MLLP protocol.
     * 
     * Category: networking,rpc,mllp
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     * 
     * Syntax: <code>mllp:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname or IP for connection for the TCP connection. The default value
     * is null, which means any local IP address
     * 
     * Path parameter: port (required)
     * Port number for the TCP connection
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path hostname:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MllpEndpointBuilderFactory.MllpEndpointBuilder mllp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MllpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Mock (camel-mock)
     * Test routes and mediation rules using mocks.
     * 
     * Category: core,testing
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mock
     * 
     * Syntax: <code>mock:name</code>
     * 
     * Path parameter: name (required)
     * Name of mock endpoint
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MockEndpointBuilderFactory.MockEndpointBuilder mock(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MockEndpointBuilderFactory.endpointBuilder("mock", path);
    }
    /**
     * Mock (camel-mock)
     * Test routes and mediation rules using mocks.
     * 
     * Category: core,testing
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mock
     * 
     * Syntax: <code>mock:name</code>
     * 
     * Path parameter: name (required)
     * Name of mock endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MockEndpointBuilderFactory.MockEndpointBuilder mock(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MockEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MongoDB (camel-mongodb)
     * Perform operations on MongoDB documents and collections.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-mongodb
     * 
     * Syntax: <code>mongodb:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Sets the connection bean reference used to lookup a client for connecting
     * to a database if no hosts parameter is present.
     * 
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MongoDbEndpointBuilderFactory.MongoDbEndpointBuilder mongodb(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MongoDbEndpointBuilderFactory.endpointBuilder("mongodb", path);
    }
    /**
     * MongoDB (camel-mongodb)
     * Perform operations on MongoDB documents and collections.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-mongodb
     * 
     * Syntax: <code>mongodb:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Sets the connection bean reference used to lookup a client for connecting
     * to a database if no hosts parameter is present.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MongoDbEndpointBuilderFactory.MongoDbEndpointBuilder mongodb(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MongoDbEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MongoDB GridFS (camel-mongodb-gridfs)
     * Interact with MongoDB GridFS.
     * 
     * Category: database,nosql
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-mongodb-gridfs
     * 
     * Syntax: <code>mongodb-gridfs:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Name of com.mongodb.client.MongoClient to use.
     * 
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GridFsEndpointBuilderFactory.GridFsEndpointBuilder mongodbGridfs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GridFsEndpointBuilderFactory.endpointBuilder("mongodb-gridfs", path);
    }
    /**
     * MongoDB GridFS (camel-mongodb-gridfs)
     * Interact with MongoDB GridFS.
     * 
     * Category: database,nosql
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-mongodb-gridfs
     * 
     * Syntax: <code>mongodb-gridfs:connectionBean</code>
     * 
     * Path parameter: connectionBean (required)
     * Name of com.mongodb.client.MongoClient to use.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path connectionBean
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GridFsEndpointBuilderFactory.GridFsEndpointBuilder mongodbGridfs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GridFsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Mustache (camel-mustache)
     * Transform messages using a Mustache template.
     * 
     * Category: transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mustache
     * 
     * Syntax: <code>mustache:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MustacheEndpointBuilderFactory.MustacheEndpointBuilder mustache(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MustacheEndpointBuilderFactory.endpointBuilder("mustache", path);
    }
    /**
     * Mustache (camel-mustache)
     * Transform messages using a Mustache template.
     * 
     * Category: transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mustache
     * 
     * Syntax: <code>mustache:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MustacheEndpointBuilderFactory.MustacheEndpointBuilder mustache(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MustacheEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MVEL (camel-mvel)
     * Transform messages using an MVEL template.
     * 
     * Category: transformation,script
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mvel
     * 
     * Syntax: <code>mvel:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MvelEndpointBuilderFactory.MvelEndpointBuilder mvel(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MvelEndpointBuilderFactory.endpointBuilder("mvel", path);
    }
    /**
     * MVEL (camel-mvel)
     * Transform messages using an MVEL template.
     * 
     * Category: transformation,script
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mvel
     * 
     * Syntax: <code>mvel:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MvelEndpointBuilderFactory.MvelEndpointBuilder mvel(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MvelEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MyBatis (camel-mybatis)
     * Performs a query, poll, insert, update or delete in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * Syntax: <code>mybatis:statement</code>
     * 
     * Path parameter: statement (required)
     * The statement name in the MyBatis XML mapping file which maps to the
     * query, insert, update or delete operation you wish to evaluate.
     * 
     * @param path statement
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MyBatisEndpointBuilderFactory.MyBatisEndpointBuilder mybatis(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MyBatisEndpointBuilderFactory.endpointBuilder("mybatis", path);
    }
    /**
     * MyBatis (camel-mybatis)
     * Performs a query, poll, insert, update or delete in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * Syntax: <code>mybatis:statement</code>
     * 
     * Path parameter: statement (required)
     * The statement name in the MyBatis XML mapping file which maps to the
     * query, insert, update or delete operation you wish to evaluate.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path statement
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MyBatisEndpointBuilderFactory.MyBatisEndpointBuilder mybatis(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MyBatisEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * MyBatis Bean (camel-mybatis)
     * Perform queries, inserts, updates or deletes in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * Syntax: <code>mybatis-bean:beanName:methodName</code>
     * 
     * Path parameter: beanName (required)
     * Name of the bean with the MyBatis annotations. This can either by a type
     * alias or a FQN class name.
     * 
     * Path parameter: methodName (required)
     * Name of the method on the bean that has the SQL query to be executed.
     * 
     * @param path beanName:methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MyBatisBeanEndpointBuilderFactory.MyBatisBeanEndpointBuilder mybatisBean(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MyBatisBeanEndpointBuilderFactory.endpointBuilder("mybatis-bean", path);
    }
    /**
     * MyBatis Bean (camel-mybatis)
     * Perform queries, inserts, updates or deletes in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * Syntax: <code>mybatis-bean:beanName:methodName</code>
     * 
     * Path parameter: beanName (required)
     * Name of the bean with the MyBatis annotations. This can either by a type
     * alias or a FQN class name.
     * 
     * Path parameter: methodName (required)
     * Name of the method on the bean that has the SQL query to be executed.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path beanName:methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.MyBatisBeanEndpointBuilderFactory.MyBatisBeanEndpointBuilder mybatisBean(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.MyBatisBeanEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Nats (camel-nats)
     * Send and receive messages from NATS messaging system.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     * 
     * Syntax: <code>nats:topic</code>
     * 
     * Path parameter: topic (required)
     * The name of topic we want to use
     * 
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NatsEndpointBuilderFactory.NatsEndpointBuilder nats(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NatsEndpointBuilderFactory.endpointBuilder("nats", path);
    }
    /**
     * Nats (camel-nats)
     * Send and receive messages from NATS messaging system.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     * 
     * Syntax: <code>nats:topic</code>
     * 
     * Path parameter: topic (required)
     * The name of topic we want to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NatsEndpointBuilderFactory.NatsEndpointBuilder nats(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NatsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with Netty 4.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     * 
     * Syntax: <code>netty:protocol://host:port</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use which can be tcp or udp.
     * There are 2 enums and the value can be one of: tcp, udp
     * 
     * Path parameter: host (required)
     * The hostname. For the consumer the hostname is localhost or 0.0.0.0. For
     * the producer the hostname is the remote host to connect to
     * 
     * Path parameter: port (required)
     * The host port number
     * 
     * @param path protocol://host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NettyEndpointBuilderFactory.NettyEndpointBuilder netty(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NettyEndpointBuilderFactory.endpointBuilder("netty", path);
    }
    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with Netty 4.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     * 
     * Syntax: <code>netty:protocol://host:port</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use which can be tcp or udp.
     * There are 2 enums and the value can be one of: tcp, udp
     * 
     * Path parameter: host (required)
     * The hostname. For the consumer the hostname is localhost or 0.0.0.0. For
     * the producer the hostname is the remote host to connect to
     * 
     * Path parameter: port (required)
     * The host port number
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path protocol://host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NettyEndpointBuilderFactory.NettyEndpointBuilder netty(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NettyEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x.
     * 
     * Category: networking,http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     * 
     * Syntax: <code>netty-http:protocol://host:port/path</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use which is either http, https or proxy - a consumer
     * only option.
     * There are 2 enums and the value can be one of: http, https
     * 
     * Path parameter: host (required)
     * The local hostname such as localhost, or 0.0.0.0 when being a consumer.
     * The remote HTTP server hostname when using producer.
     * 
     * Path parameter: port
     * The host port number
     * 
     * Path parameter: path
     * Resource path
     * 
     * @param path protocol://host:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NettyHttpEndpointBuilderFactory.NettyHttpEndpointBuilder nettyHttp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NettyHttpEndpointBuilderFactory.endpointBuilder("netty-http", path);
    }
    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x.
     * 
     * Category: networking,http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     * 
     * Syntax: <code>netty-http:protocol://host:port/path</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use which is either http, https or proxy - a consumer
     * only option.
     * There are 2 enums and the value can be one of: http, https
     * 
     * Path parameter: host (required)
     * The local hostname such as localhost, or 0.0.0.0 when being a consumer.
     * The remote HTTP server hostname when using producer.
     * 
     * Path parameter: port
     * The host port number
     * 
     * Path parameter: path
     * Resource path
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path protocol://host:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NettyHttpEndpointBuilderFactory.NettyHttpEndpointBuilder nettyHttp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NettyHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Nitrite (camel-nitrite)
     * Access Nitrite databases.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-nitrite
     * 
     * Syntax: <code>nitrite:database</code>
     * 
     * Path parameter: database (required)
     * Path to database file. Will be created if not exists.
     * 
     * @param path database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NitriteEndpointBuilderFactory.NitriteEndpointBuilder nitrite(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NitriteEndpointBuilderFactory.endpointBuilder("nitrite", path);
    }
    /**
     * Nitrite (camel-nitrite)
     * Access Nitrite databases.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-nitrite
     * 
     * Syntax: <code>nitrite:database</code>
     * 
     * Path parameter: database (required)
     * Path to database file. Will be created if not exists.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path database
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NitriteEndpointBuilderFactory.NitriteEndpointBuilder nitrite(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NitriteEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OAI-PMH (camel-oaipmh)
     * Harvest metadata using OAI-PMH protocol
     * 
     * Category: endpoint,webservice,batch
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-oaipmh
     * 
     * Syntax: <code>oaipmh:baseUrl</code>
     * 
     * Path parameter: baseUrl (required)
     * Base URL of the repository to which the request is made through the
     * OAI-PMH protocol
     * 
     * @param path baseUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OAIPMHEndpointBuilderFactory.OAIPMHEndpointBuilder oaipmh(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OAIPMHEndpointBuilderFactory.endpointBuilder("oaipmh", path);
    }
    /**
     * OAI-PMH (camel-oaipmh)
     * Harvest metadata using OAI-PMH protocol
     * 
     * Category: endpoint,webservice,batch
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-oaipmh
     * 
     * Syntax: <code>oaipmh:baseUrl</code>
     * 
     * Path parameter: baseUrl (required)
     * Base URL of the repository to which the request is made through the
     * OAI-PMH protocol
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path baseUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OAIPMHEndpointBuilderFactory.OAIPMHEndpointBuilder oaipmh(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OAIPMHEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicate with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     * 
     * Syntax: <code>olingo2:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 1 enums and the value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Olingo2EndpointBuilderFactory.Olingo2EndpointBuilder olingo2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Olingo2EndpointBuilderFactory.endpointBuilder("olingo2", path);
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicate with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     * 
     * Syntax: <code>olingo2:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 1 enums and the value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Olingo2EndpointBuilderFactory.Olingo2EndpointBuilder olingo2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Olingo2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicate with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     * 
     * Syntax: <code>olingo4:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 1 enums and the value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Olingo4EndpointBuilderFactory.Olingo4EndpointBuilder olingo4(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Olingo4EndpointBuilderFactory.endpointBuilder("olingo4", path);
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicate with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     * 
     * Syntax: <code>olingo4:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 1 enums and the value can be one of: DEFAULT
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Olingo4EndpointBuilderFactory.Olingo4EndpointBuilder olingo4(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Olingo4EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Openshift Build Config (camel-kubernetes)
     * Perform operations on OpenShift Build Configs.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-build-configs:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftBuildConfigsEndpointBuilderFactory.OpenshiftBuildConfigsEndpointBuilder openshiftBuildConfigs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftBuildConfigsEndpointBuilderFactory.endpointBuilder("openshift-build-configs", path);
    }
    /**
     * Openshift Build Config (camel-kubernetes)
     * Perform operations on OpenShift Build Configs.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-build-configs:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftBuildConfigsEndpointBuilderFactory.OpenshiftBuildConfigsEndpointBuilder openshiftBuildConfigs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftBuildConfigsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Openshift Builds (camel-kubernetes)
     * Perform operations on OpenShift Builds.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-builds:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftBuildsEndpointBuilderFactory.OpenshiftBuildsEndpointBuilder openshiftBuilds(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftBuildsEndpointBuilderFactory.endpointBuilder("openshift-builds", path);
    }
    /**
     * Openshift Builds (camel-kubernetes)
     * Perform operations on OpenShift Builds.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-builds:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftBuildsEndpointBuilderFactory.OpenshiftBuildsEndpointBuilder openshiftBuilds(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftBuildsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Openshift Deployment Configs (camel-kubernetes)
     * Perform operations on Openshift Deployment Configs and get notified on
     * Deployment Config changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-deploymentconfigs:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftDeploymentConfigsEndpointBuilderFactory.OpenshiftDeploymentConfigsEndpointBuilder openshiftDeploymentconfigs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftDeploymentConfigsEndpointBuilderFactory.endpointBuilder("openshift-deploymentconfigs", path);
    }
    /**
     * Openshift Deployment Configs (camel-kubernetes)
     * Perform operations on Openshift Deployment Configs and get notified on
     * Deployment Config changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * Syntax: <code>openshift-deploymentconfigs:masterUrl</code>
     * 
     * Path parameter: masterUrl (required)
     * Kubernetes Master url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path masterUrl
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OpenshiftDeploymentConfigsEndpointBuilderFactory.OpenshiftDeploymentConfigsEndpointBuilder openshiftDeploymentconfigs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OpenshiftDeploymentConfigsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Cinder (camel-openstack)
     * Access data in OpenStack Cinder block storage.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-cinder:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CinderEndpointBuilderFactory.CinderEndpointBuilder openstackCinder(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CinderEndpointBuilderFactory.endpointBuilder("openstack-cinder", path);
    }
    /**
     * OpenStack Cinder (camel-openstack)
     * Access data in OpenStack Cinder block storage.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-cinder:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.CinderEndpointBuilderFactory.CinderEndpointBuilder openstackCinder(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.CinderEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Glance (camel-openstack)
     * Manage VM images and metadata definitions in OpenStack Glance.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-glance:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GlanceEndpointBuilderFactory.GlanceEndpointBuilder openstackGlance(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GlanceEndpointBuilderFactory.endpointBuilder("openstack-glance", path);
    }
    /**
     * OpenStack Glance (camel-openstack)
     * Manage VM images and metadata definitions in OpenStack Glance.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-glance:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.GlanceEndpointBuilderFactory.GlanceEndpointBuilder openstackGlance(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.GlanceEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Keystone (camel-openstack)
     * Access OpenStack Keystone for API client authentication, service
     * discovery and distributed multi-tenant authorization.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-keystone:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KeystoneEndpointBuilderFactory.KeystoneEndpointBuilder openstackKeystone(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KeystoneEndpointBuilderFactory.endpointBuilder("openstack-keystone", path);
    }
    /**
     * OpenStack Keystone (camel-openstack)
     * Access OpenStack Keystone for API client authentication, service
     * discovery and distributed multi-tenant authorization.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-keystone:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.KeystoneEndpointBuilderFactory.KeystoneEndpointBuilder openstackKeystone(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.KeystoneEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Neutron (camel-openstack)
     * Access OpenStack Neutron for network services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-neutron:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NeutronEndpointBuilderFactory.NeutronEndpointBuilder openstackNeutron(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NeutronEndpointBuilderFactory.endpointBuilder("openstack-neutron", path);
    }
    /**
     * OpenStack Neutron (camel-openstack)
     * Access OpenStack Neutron for network services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-neutron:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NeutronEndpointBuilderFactory.NeutronEndpointBuilder openstackNeutron(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NeutronEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Nova (camel-openstack)
     * Access OpenStack to manage compute resources.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-nova:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NovaEndpointBuilderFactory.NovaEndpointBuilder openstackNova(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NovaEndpointBuilderFactory.endpointBuilder("openstack-nova", path);
    }
    /**
     * OpenStack Nova (camel-openstack)
     * Access OpenStack to manage compute resources.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-nova:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NovaEndpointBuilderFactory.NovaEndpointBuilder openstackNova(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NovaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OpenStack Swift (camel-openstack)
     * Access OpenStack Swift object/blob store.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-swift:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SwiftEndpointBuilderFactory.SwiftEndpointBuilder openstackSwift(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SwiftEndpointBuilderFactory.endpointBuilder("openstack-swift", path);
    }
    /**
     * OpenStack Swift (camel-openstack)
     * Access OpenStack Swift object/blob store.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * Syntax: <code>openstack-swift:host</code>
     * 
     * Path parameter: host (required)
     * OpenStack host url
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SwiftEndpointBuilderFactory.SwiftEndpointBuilder openstackSwift(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SwiftEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * OptaPlanner (camel-optaplanner)
     * Solve planning problems with OptaPlanner.
     * 
     * Category: engine,planning
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-optaplanner
     * 
     * Syntax: <code>optaplanner:configFile</code>
     * 
     * Path parameter: configFile (required)
     * Specifies the location to the solver file. If useSolverManager=FALSE,
     * Camel uses this file and create the Solver. If useSolverManager=TRUE and
     * SolverManager is set in the header {OptaPlannerConstants.SOLVER_MANAGER}
     * : this file is ignored by Camel usage of SolverManager. SolverManager can
     * be injected by DI in Quarkus or Spring.
     * 
     * @param path configFile
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OptaPlannerEndpointBuilderFactory.OptaPlannerEndpointBuilder optaplanner(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OptaPlannerEndpointBuilderFactory.endpointBuilder("optaplanner", path);
    }
    /**
     * OptaPlanner (camel-optaplanner)
     * Solve planning problems with OptaPlanner.
     * 
     * Category: engine,planning
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-optaplanner
     * 
     * Syntax: <code>optaplanner:configFile</code>
     * 
     * Path parameter: configFile (required)
     * Specifies the location to the solver file. If useSolverManager=FALSE,
     * Camel uses this file and create the Solver. If useSolverManager=TRUE and
     * SolverManager is set in the header {OptaPlannerConstants.SOLVER_MANAGER}
     * : this file is ignored by Camel usage of SolverManager. SolverManager can
     * be injected by DI in Quarkus or Spring.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path configFile
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.OptaPlannerEndpointBuilderFactory.OptaPlannerEndpointBuilder optaplanner(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.OptaPlannerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Paho (camel-paho)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT Client.
     * 
     * Category: messaging,iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-paho
     * 
     * Syntax: <code>paho:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic
     * 
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PahoEndpointBuilderFactory.PahoEndpointBuilder paho(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PahoEndpointBuilderFactory.endpointBuilder("paho", path);
    }
    /**
     * Paho (camel-paho)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT Client.
     * 
     * Category: messaging,iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-paho
     * 
     * Syntax: <code>paho:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PahoEndpointBuilderFactory.PahoEndpointBuilder paho(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PahoEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Paho MQTT 5 (camel-paho-mqtt5)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT v5 Client.
     * 
     * Category: messaging,iot
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-paho-mqtt5
     * 
     * Syntax: <code>paho-mqtt5:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic
     * 
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PahoMqtt5EndpointBuilderFactory.PahoMqtt5EndpointBuilder pahoMqtt5(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PahoMqtt5EndpointBuilderFactory.endpointBuilder("paho-mqtt5", path);
    }
    /**
     * Paho MQTT 5 (camel-paho-mqtt5)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT v5 Client.
     * 
     * Category: messaging,iot
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-paho-mqtt5
     * 
     * Syntax: <code>paho-mqtt5:topic</code>
     * 
     * Path parameter: topic (required)
     * Name of the topic
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PahoMqtt5EndpointBuilderFactory.PahoMqtt5EndpointBuilder pahoMqtt5(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PahoMqtt5EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * PDF (camel-pdf)
     * Create, modify or extract content from PDF documents.
     * 
     * Category: document,transformation,printing
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-pdf
     * 
     * Syntax: <code>pdf:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation type
     * There are 3 enums and the value can be one of: create, append,
     * extractText
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PdfEndpointBuilderFactory.PdfEndpointBuilder pdf(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PdfEndpointBuilderFactory.endpointBuilder("pdf", path);
    }
    /**
     * PDF (camel-pdf)
     * Create, modify or extract content from PDF documents.
     * 
     * Category: document,transformation,printing
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-pdf
     * 
     * Syntax: <code>pdf:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation type
     * There are 3 enums and the value can be one of: create, append,
     * extractText
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PdfEndpointBuilderFactory.PdfEndpointBuilder pdf(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PdfEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * PostgresSQL Event (camel-pgevent)
     * Send and receive PostgreSQL events via LISTEN and NOTIFY commands.
     * 
     * Category: database,sql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-pgevent
     * 
     * Syntax: <code>pgevent:host:port/database/channel</code>
     * 
     * Path parameter: host
     * To connect using hostname and port to the database.
     * Default value: localhost
     * 
     * Path parameter: port
     * To connect using hostname and port to the database.
     * Default value: 5432
     * 
     * Path parameter: database (required)
     * The database name. The database name can take any characters because it
     * is sent as a quoted identifier. It is part of the endpoint URI, so
     * diacritical marks and non-Latin letters have to be URL encoded.
     * 
     * Path parameter: channel (required)
     * The channel name
     * 
     * @param path host:port/database/channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PgEventEndpointBuilderFactory.PgEventEndpointBuilder pgevent(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PgEventEndpointBuilderFactory.endpointBuilder("pgevent", path);
    }
    /**
     * PostgresSQL Event (camel-pgevent)
     * Send and receive PostgreSQL events via LISTEN and NOTIFY commands.
     * 
     * Category: database,sql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-pgevent
     * 
     * Syntax: <code>pgevent:host:port/database/channel</code>
     * 
     * Path parameter: host
     * To connect using hostname and port to the database.
     * Default value: localhost
     * 
     * Path parameter: port
     * To connect using hostname and port to the database.
     * Default value: 5432
     * 
     * Path parameter: database (required)
     * The database name. The database name can take any characters because it
     * is sent as a quoted identifier. It is part of the endpoint URI, so
     * diacritical marks and non-Latin letters have to be URL encoded.
     * 
     * Path parameter: channel (required)
     * The channel name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/database/channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PgEventEndpointBuilderFactory.PgEventEndpointBuilder pgevent(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PgEventEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * PostgresSQL Replication Slot (camel-pg-replication-slot)
     * Poll for PostgreSQL Write-Ahead Log (WAL) records using Streaming
     * Replication Slots.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-pg-replication-slot
     * 
     * Syntax:
     * <code>pg-replication-slot:host:port/database/slot:outputPlugin</code>
     * 
     * Path parameter: slot (required)
     * Replication Slot name
     * 
     * Path parameter: host
     * Postgres host
     * Default value: localhost
     * 
     * Path parameter: port
     * Postgres port
     * Default value: 5432
     * 
     * Path parameter: database (required)
     * Postgres database name
     * 
     * Path parameter: outputPlugin (required)
     * Output plugin name
     * 
     * @param path host:port/database/slot:outputPlugin
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PgReplicationSlotEndpointBuilderFactory.PgReplicationSlotEndpointBuilder pgReplicationSlot(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PgReplicationSlotEndpointBuilderFactory.endpointBuilder("pg-replication-slot", path);
    }
    /**
     * PostgresSQL Replication Slot (camel-pg-replication-slot)
     * Poll for PostgreSQL Write-Ahead Log (WAL) records using Streaming
     * Replication Slots.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-pg-replication-slot
     * 
     * Syntax:
     * <code>pg-replication-slot:host:port/database/slot:outputPlugin</code>
     * 
     * Path parameter: slot (required)
     * Replication Slot name
     * 
     * Path parameter: host
     * Postgres host
     * Default value: localhost
     * 
     * Path parameter: port
     * Postgres port
     * Default value: 5432
     * 
     * Path parameter: database (required)
     * Postgres database name
     * 
     * Path parameter: outputPlugin (required)
     * Output plugin name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/database/slot:outputPlugin
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PgReplicationSlotEndpointBuilderFactory.PgReplicationSlotEndpointBuilder pgReplicationSlot(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PgReplicationSlotEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Platform HTTP (camel-platform-http)
     * Expose HTTP endpoints using the HTTP server available in the current
     * platform.
     * 
     * Category: http
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-platform-http
     * 
     * Syntax: <code>platform-http:path</code>
     * 
     * Path parameter: path (required)
     * The path under which this endpoint serves the HTTP requests, for proxy
     * use 'proxy'
     * 
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PlatformHttpEndpointBuilderFactory.PlatformHttpEndpointBuilder platformHttp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PlatformHttpEndpointBuilderFactory.endpointBuilder("platform-http", path);
    }
    /**
     * Platform HTTP (camel-platform-http)
     * Expose HTTP endpoints using the HTTP server available in the current
     * platform.
     * 
     * Category: http
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-platform-http
     * 
     * Syntax: <code>platform-http:path</code>
     * 
     * Path parameter: path (required)
     * The path under which this endpoint serves the HTTP requests, for proxy
     * use 'proxy'
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PlatformHttpEndpointBuilderFactory.PlatformHttpEndpointBuilder platformHttp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PlatformHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * PLC4X (camel-plc4x)
     * Read and write to PLC devices
     * 
     * Category: iot
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-plc4x
     * 
     * Syntax: <code>plc4x:driver</code>
     * 
     * Path parameter: driver (required)
     * PLC4X connection string for the connection to the target
     * 
     * @param path driver
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Plc4XEndpointBuilderFactory.Plc4XEndpointBuilder plc4x(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Plc4XEndpointBuilderFactory.endpointBuilder("plc4x", path);
    }
    /**
     * PLC4X (camel-plc4x)
     * Read and write to PLC devices
     * 
     * Category: iot
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-plc4x
     * 
     * Syntax: <code>plc4x:driver</code>
     * 
     * Path parameter: driver (required)
     * PLC4X connection string for the connection to the target
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path driver
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Plc4XEndpointBuilderFactory.Plc4XEndpointBuilder plc4x(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Plc4XEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * PubNub (camel-pubnub)
     * Send and receive messages to/from PubNub data stream network for
     * connected devices.
     * 
     * Category: cloud,iot,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-pubnub
     * 
     * Syntax: <code>pubnub:channel</code>
     * 
     * Path parameter: channel (required)
     * The channel used for subscribing/publishing events
     * 
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PubNubEndpointBuilderFactory.PubNubEndpointBuilder pubnub(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PubNubEndpointBuilderFactory.endpointBuilder("pubnub", path);
    }
    /**
     * PubNub (camel-pubnub)
     * Send and receive messages to/from PubNub data stream network for
     * connected devices.
     * 
     * Category: cloud,iot,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-pubnub
     * 
     * Syntax: <code>pubnub:channel</code>
     * 
     * Path parameter: channel (required)
     * The channel used for subscribing/publishing events
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PubNubEndpointBuilderFactory.PubNubEndpointBuilder pubnub(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PubNubEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Pulsar (camel-pulsar)
     * Send and receive messages from/to Apache Pulsar messaging system.
     * 
     * Category: messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-pulsar
     * 
     * Syntax: <code>pulsar:persistence://tenant/namespace/topic</code>
     * 
     * Path parameter: persistence (required)
     * Whether the topic is persistent or non-persistent
     * There are 2 enums and the value can be one of: persistent, non-persistent
     * 
     * Path parameter: tenant (required)
     * The tenant
     * 
     * Path parameter: namespace (required)
     * The namespace
     * 
     * Path parameter: topic (required)
     * The topic
     * 
     * @param path persistence://tenant/namespace/topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PulsarEndpointBuilderFactory.PulsarEndpointBuilder pulsar(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PulsarEndpointBuilderFactory.endpointBuilder("pulsar", path);
    }
    /**
     * Pulsar (camel-pulsar)
     * Send and receive messages from/to Apache Pulsar messaging system.
     * 
     * Category: messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-pulsar
     * 
     * Syntax: <code>pulsar:persistence://tenant/namespace/topic</code>
     * 
     * Path parameter: persistence (required)
     * Whether the topic is persistent or non-persistent
     * There are 2 enums and the value can be one of: persistent, non-persistent
     * 
     * Path parameter: tenant (required)
     * The tenant
     * 
     * Path parameter: namespace (required)
     * The namespace
     * 
     * Path parameter: topic (required)
     * The topic
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path persistence://tenant/namespace/topic
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.PulsarEndpointBuilderFactory.PulsarEndpointBuilder pulsar(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.PulsarEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Quartz (camel-quartz)
     * Schedule sending of messages using the Quartz 2.x scheduler.
     * 
     * Category: scheduling
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-quartz
     * 
     * Syntax: <code>quartz:groupName/triggerName</code>
     * 
     * Path parameter: groupName
     * The quartz group name to use. The combination of group name and trigger
     * name should be unique.
     * Default value: Camel
     * 
     * Path parameter: triggerName (required)
     * The quartz trigger name to use. The combination of group name and trigger
     * name should be unique.
     * 
     * @param path groupName/triggerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QuartzEndpointBuilderFactory.QuartzEndpointBuilder quartz(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QuartzEndpointBuilderFactory.endpointBuilder("quartz", path);
    }
    /**
     * Quartz (camel-quartz)
     * Schedule sending of messages using the Quartz 2.x scheduler.
     * 
     * Category: scheduling
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-quartz
     * 
     * Syntax: <code>quartz:groupName/triggerName</code>
     * 
     * Path parameter: groupName
     * The quartz group name to use. The combination of group name and trigger
     * name should be unique.
     * Default value: Camel
     * 
     * Path parameter: triggerName (required)
     * The quartz trigger name to use. The combination of group name and trigger
     * name should be unique.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path groupName/triggerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QuartzEndpointBuilderFactory.QuartzEndpointBuilder quartz(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QuartzEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * QuickFix (camel-quickfix)
     * Open a Financial Interchange (FIX) session using an embedded QuickFix/J
     * engine.
     * 
     * Category: messaging
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-quickfix
     * 
     * Syntax: <code>quickfix:configurationName</code>
     * 
     * Path parameter: configurationName (required)
     * Path to the quickfix configuration file. You can prefix with: classpath,
     * file, http, ref, or bean. classpath, file and http loads the
     * configuration file using these protocols (classpath is default). ref will
     * lookup the configuration file in the registry. bean will call a method on
     * a bean to be used as the configuration. For bean you can specify the
     * method name after dot, eg bean:myBean.myMethod
     * 
     * @param path configurationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QuickfixjEndpointBuilderFactory.QuickfixjEndpointBuilder quickfix(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QuickfixjEndpointBuilderFactory.endpointBuilder("quickfix", path);
    }
    /**
     * QuickFix (camel-quickfix)
     * Open a Financial Interchange (FIX) session using an embedded QuickFix/J
     * engine.
     * 
     * Category: messaging
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-quickfix
     * 
     * Syntax: <code>quickfix:configurationName</code>
     * 
     * Path parameter: configurationName (required)
     * Path to the quickfix configuration file. You can prefix with: classpath,
     * file, http, ref, or bean. classpath, file and http loads the
     * configuration file using these protocols (classpath is default). ref will
     * lookup the configuration file in the registry. bean will call a method on
     * a bean to be used as the configuration. For bean you can specify the
     * method name after dot, eg bean:myBean.myMethod
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path configurationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.QuickfixjEndpointBuilderFactory.QuickfixjEndpointBuilder quickfix(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.QuickfixjEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * RabbitMQ (camel-rabbitmq)
     * Send and receive messages from RabbitMQ instances.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-rabbitmq
     * 
     * Syntax: <code>rabbitmq:exchangeName</code>
     * 
     * Path parameter: exchangeName (required)
     * The exchange name determines the exchange to which the produced messages
     * will be sent to. In the case of consumers, the exchange name determines
     * the exchange the queue will be bound to.
     * 
     * @param path exchangeName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.RabbitMQEndpointBuilderFactory.RabbitMQEndpointBuilder rabbitmq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RabbitMQEndpointBuilderFactory.endpointBuilder("rabbitmq", path);
    }
    /**
     * RabbitMQ (camel-rabbitmq)
     * Send and receive messages from RabbitMQ instances.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-rabbitmq
     * 
     * Syntax: <code>rabbitmq:exchangeName</code>
     * 
     * Path parameter: exchangeName (required)
     * The exchange name determines the exchange to which the produced messages
     * will be sent to. In the case of consumers, the exchange name determines
     * the exchange the queue will be bound to.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path exchangeName
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.RabbitMQEndpointBuilderFactory.RabbitMQEndpointBuilder rabbitmq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RabbitMQEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Reactive Streams (camel-reactive-streams)
     * Exchange messages with reactive stream processing libraries compatible
     * with the reactive streams standard.
     * 
     * Category: reactive,streams
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-reactive-streams
     * 
     * Syntax: <code>reactive-streams:stream</code>
     * 
     * Path parameter: stream
     * Name of the stream channel used by the endpoint to exchange messages.
     * 
     * @param path stream
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ReactiveStreamsEndpointBuilderFactory.ReactiveStreamsEndpointBuilder reactiveStreams(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ReactiveStreamsEndpointBuilderFactory.endpointBuilder("reactive-streams", path);
    }
    /**
     * Reactive Streams (camel-reactive-streams)
     * Exchange messages with reactive stream processing libraries compatible
     * with the reactive streams standard.
     * 
     * Category: reactive,streams
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-reactive-streams
     * 
     * Syntax: <code>reactive-streams:stream</code>
     * 
     * Path parameter: stream
     * Name of the stream channel used by the endpoint to exchange messages.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path stream
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ReactiveStreamsEndpointBuilderFactory.ReactiveStreamsEndpointBuilder reactiveStreams(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ReactiveStreamsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Ref (camel-ref)
     * Route messages to an endpoint looked up dynamically by name in the Camel
     * Registry.
     * 
     * Category: core,endpoint
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-ref
     * 
     * Syntax: <code>ref:name</code>
     * 
     * Path parameter: name (required)
     * Name of endpoint to lookup in the registry.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RefEndpointBuilderFactory.RefEndpointBuilder ref(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RefEndpointBuilderFactory.endpointBuilder("ref", path);
    }
    /**
     * Ref (camel-ref)
     * Route messages to an endpoint looked up dynamically by name in the Camel
     * Registry.
     * 
     * Category: core,endpoint
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-ref
     * 
     * Syntax: <code>ref:name</code>
     * 
     * Path parameter: name (required)
     * Name of endpoint to lookup in the registry.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RefEndpointBuilderFactory.RefEndpointBuilder ref(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RefEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * REST API (camel-rest)
     * Expose OpenAPI Specification of the REST services defined using Camel
     * REST DSL.
     * 
     * Category: core,rest
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * Syntax: <code>rest-api:path</code>
     * 
     * Path parameter: path (required)
     * The base path
     * 
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestApiEndpointBuilderFactory.RestApiEndpointBuilder restApi(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestApiEndpointBuilderFactory.endpointBuilder("rest-api", path);
    }
    /**
     * REST API (camel-rest)
     * Expose OpenAPI Specification of the REST services defined using Camel
     * REST DSL.
     * 
     * Category: core,rest
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * Syntax: <code>rest-api:path</code>
     * 
     * Path parameter: path (required)
     * The base path
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestApiEndpointBuilderFactory.RestApiEndpointBuilder restApi(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestApiEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Resteasy (camel-resteasy)
     * Expose REST endpoints and access external REST servers.
     * 
     * Category: rest
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-resteasy
     * 
     * Syntax: <code>resteasy:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param path httpUri
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.ResteasyEndpointBuilderFactory.ResteasyEndpointBuilder resteasy(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ResteasyEndpointBuilderFactory.endpointBuilder("resteasy", path);
    }
    /**
     * Resteasy (camel-resteasy)
     * Expose REST endpoints and access external REST servers.
     * 
     * Category: rest
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-resteasy
     * 
     * Syntax: <code>resteasy:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path httpUri
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.ResteasyEndpointBuilderFactory.ResteasyEndpointBuilder resteasy(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ResteasyEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * REST (camel-rest)
     * Expose REST services or call external REST services.
     * 
     * Category: core,rest
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * Syntax: <code>rest:method:path:uriTemplate</code>
     * 
     * Path parameter: method (required)
     * HTTP method to use.
     * There are 9 enums and the value can be one of: get, post, put, delete,
     * patch, head, trace, connect, options
     * 
     * Path parameter: path (required)
     * The base path
     * 
     * Path parameter: uriTemplate
     * The uri template
     * 
     * @param path method:path:uriTemplate
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestEndpointBuilderFactory.RestEndpointBuilder restEndpoint(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestEndpointBuilderFactory.endpointBuilder("rest", path);
    }
    /**
     * REST (camel-rest)
     * Expose REST services or call external REST services.
     * 
     * Category: core,rest
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * Syntax: <code>rest:method:path:uriTemplate</code>
     * 
     * Path parameter: method (required)
     * HTTP method to use.
     * There are 9 enums and the value can be one of: get, post, put, delete,
     * patch, head, trace, connect, options
     * 
     * Path parameter: path (required)
     * The base path
     * 
     * Path parameter: uriTemplate
     * The uri template
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path method:path:uriTemplate
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestEndpointBuilderFactory.RestEndpointBuilder restEndpoint(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * REST OpenApi (camel-rest-openapi)
     * Configure REST producers based on an OpenAPI specification document
     * delegating to a component implementing the RestProducerFactory interface.
     * 
     * Category: openapi,rest,api
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     * 
     * Syntax: <code>rest-openapi:specificationUri#operationId</code>
     * 
     * Path parameter: specificationUri
     * Path to the OpenApi specification file. The scheme, host base path are
     * taken from this specification, but these can be overridden with
     * properties on the component or endpoint level. If not given the component
     * tries to load openapi.json resource from the classpath. Note that the
     * host defined on the component and endpoint of this Component should
     * contain the scheme, hostname and optionally the port in the URI syntax
     * (i.e. http://api.example.com:8080). Overrides component configuration.
     * The OpenApi specification can be loaded from different sources by
     * prefixing with file: classpath: http: https:. Support for https is
     * limited to using the JDK installed UrlHandler, and as such it can be
     * cumbersome to setup TLS/SSL certificates for https (such as setting a
     * number of javax.net.ssl JVM system properties). How to do that consult
     * the JDK documentation for UrlHandler. Default value notice: By default
     * loads openapi.json file
     * Default value: openapi.json
     * 
     * Path parameter: operationId (required)
     * ID of the operation from the OpenApi specification.
     * 
     * @param path specificationUri#operationId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestOpenApiEndpointBuilderFactory.RestOpenApiEndpointBuilder restOpenapi(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestOpenApiEndpointBuilderFactory.endpointBuilder("rest-openapi", path);
    }
    /**
     * REST OpenApi (camel-rest-openapi)
     * Configure REST producers based on an OpenAPI specification document
     * delegating to a component implementing the RestProducerFactory interface.
     * 
     * Category: openapi,rest,api
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     * 
     * Syntax: <code>rest-openapi:specificationUri#operationId</code>
     * 
     * Path parameter: specificationUri
     * Path to the OpenApi specification file. The scheme, host base path are
     * taken from this specification, but these can be overridden with
     * properties on the component or endpoint level. If not given the component
     * tries to load openapi.json resource from the classpath. Note that the
     * host defined on the component and endpoint of this Component should
     * contain the scheme, hostname and optionally the port in the URI syntax
     * (i.e. http://api.example.com:8080). Overrides component configuration.
     * The OpenApi specification can be loaded from different sources by
     * prefixing with file: classpath: http: https:. Support for https is
     * limited to using the JDK installed UrlHandler, and as such it can be
     * cumbersome to setup TLS/SSL certificates for https (such as setting a
     * number of javax.net.ssl JVM system properties). How to do that consult
     * the JDK documentation for UrlHandler. Default value notice: By default
     * loads openapi.json file
     * Default value: openapi.json
     * 
     * Path parameter: operationId (required)
     * ID of the operation from the OpenApi specification.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path specificationUri#operationId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RestOpenApiEndpointBuilderFactory.RestOpenApiEndpointBuilder restOpenapi(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestOpenApiEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * REST Swagger (camel-rest-swagger)
     * Configure REST producers based on a Swagger (OpenAPI) specification
     * document delegating to a component implementing the RestProducerFactory
     * interface.
     * 
     * Category: rest,swagger,http
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-rest-swagger
     * 
     * Syntax: <code>rest-swagger:specificationUri#operationId</code>
     * 
     * Path parameter: specificationUri
     * Path to the Swagger specification file. The scheme, host base path are
     * taken from this specification, but these can be overridden with
     * properties on the component or endpoint level. If not given the component
     * tries to load swagger.json resource from the classpath. Note that the
     * host defined on the component and endpoint of this Component should
     * contain the scheme, hostname and optionally the port in the URI syntax
     * (i.e. http://api.example.com:8080). Overrides component configuration.
     * The Swagger specification can be loaded from different sources by
     * prefixing with file: classpath: http: https:. Support for https is
     * limited to using the JDK installed UrlHandler, and as such it can be
     * cumbersome to setup TLS/SSL certificates for https (such as setting a
     * number of javax.net.ssl JVM system properties). How to do that consult
     * the JDK documentation for UrlHandler. Default value notice: By default
     * loads swagger.json file
     * Default value: swagger.json
     * 
     * Path parameter: operationId (required)
     * ID of the operation from the Swagger specification.
     * 
     * @param path specificationUri#operationId
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.RestSwaggerEndpointBuilderFactory.RestSwaggerEndpointBuilder restSwagger(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestSwaggerEndpointBuilderFactory.endpointBuilder("rest-swagger", path);
    }
    /**
     * REST Swagger (camel-rest-swagger)
     * Configure REST producers based on a Swagger (OpenAPI) specification
     * document delegating to a component implementing the RestProducerFactory
     * interface.
     * 
     * Category: rest,swagger,http
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-rest-swagger
     * 
     * Syntax: <code>rest-swagger:specificationUri#operationId</code>
     * 
     * Path parameter: specificationUri
     * Path to the Swagger specification file. The scheme, host base path are
     * taken from this specification, but these can be overridden with
     * properties on the component or endpoint level. If not given the component
     * tries to load swagger.json resource from the classpath. Note that the
     * host defined on the component and endpoint of this Component should
     * contain the scheme, hostname and optionally the port in the URI syntax
     * (i.e. http://api.example.com:8080). Overrides component configuration.
     * The Swagger specification can be loaded from different sources by
     * prefixing with file: classpath: http: https:. Support for https is
     * limited to using the JDK installed UrlHandler, and as such it can be
     * cumbersome to setup TLS/SSL certificates for https (such as setting a
     * number of javax.net.ssl JVM system properties). How to do that consult
     * the JDK documentation for UrlHandler. Default value notice: By default
     * loads swagger.json file
     * Default value: swagger.json
     * 
     * Path parameter: operationId (required)
     * ID of the operation from the Swagger specification.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path specificationUri#operationId
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.RestSwaggerEndpointBuilderFactory.RestSwaggerEndpointBuilder restSwagger(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RestSwaggerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Robot Framework (camel-robotframework)
     * Pass camel exchanges to acceptence test written in Robot DSL.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * Syntax: <code>robotframework:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RobotFrameworkEndpointBuilderFactory.RobotFrameworkEndpointBuilder robotframework(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RobotFrameworkEndpointBuilderFactory.endpointBuilder("robotframework", path);
    }
    /**
     * Robot Framework (camel-robotframework)
     * Pass camel exchanges to acceptence test written in Robot DSL.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * Syntax: <code>robotframework:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RobotFrameworkEndpointBuilderFactory.RobotFrameworkEndpointBuilder robotframework(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RobotFrameworkEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * RocketMQ (camel-rocketmq)
     * Send and receive messages from RocketMQ cluster.
     * 
     * Category: messaging
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-rocketmq
     * 
     * Syntax: <code>rocketmq:topicName</code>
     * 
     * Path parameter: topicName (required)
     * Topic name of this endpoint.
     * 
     * @param path topicName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RocketMQEndpointBuilderFactory.RocketMQEndpointBuilder rocketmq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RocketMQEndpointBuilderFactory.endpointBuilder("rocketmq", path);
    }
    /**
     * RocketMQ (camel-rocketmq)
     * Send and receive messages from RocketMQ cluster.
     * 
     * Category: messaging
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-rocketmq
     * 
     * Syntax: <code>rocketmq:topicName</code>
     * 
     * Path parameter: topicName (required)
     * Topic name of this endpoint.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path topicName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RocketMQEndpointBuilderFactory.RocketMQEndpointBuilder rocketmq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RocketMQEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * RSS (camel-rss)
     * Poll RSS feeds.
     * 
     * Category: rss
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-rss
     * 
     * Syntax: <code>rss:feedUri</code>
     * 
     * Path parameter: feedUri (required)
     * The URI to the feed to poll.
     * 
     * @param path feedUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RssEndpointBuilderFactory.RssEndpointBuilder rss(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RssEndpointBuilderFactory.endpointBuilder("rss", path);
    }
    /**
     * RSS (camel-rss)
     * Poll RSS feeds.
     * 
     * Category: rss
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-rss
     * 
     * Syntax: <code>rss:feedUri</code>
     * 
     * Path parameter: feedUri (required)
     * The URI to the feed to poll.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path feedUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RssEndpointBuilderFactory.RssEndpointBuilder rss(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RssEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Saga (camel-saga)
     * Execute custom actions within a route using the Saga EIP.
     * 
     * Category: core,endpoint
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-saga
     * 
     * Syntax: <code>saga:action</code>
     * 
     * Path parameter: action (required)
     * Action to execute (complete or compensate)
     * There are 2 enums and the value can be one of: COMPLETE, COMPENSATE
     * 
     * @param path action
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SagaEndpointBuilderFactory.SagaEndpointBuilder saga(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SagaEndpointBuilderFactory.endpointBuilder("saga", path);
    }
    /**
     * Saga (camel-saga)
     * Execute custom actions within a route using the Saga EIP.
     * 
     * Category: core,endpoint
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-saga
     * 
     * Syntax: <code>saga:action</code>
     * 
     * Path parameter: action (required)
     * Action to execute (complete or compensate)
     * There are 2 enums and the value can be one of: COMPLETE, COMPENSATE
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path action
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SagaEndpointBuilderFactory.SagaEndpointBuilder saga(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SagaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Salesforce (camel-salesforce)
     * Communicate with Salesforce using Java DTOs.
     * 
     * Category: cloud,api,crm
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * Syntax: <code>salesforce:operationName:topicName</code>
     * 
     * Path parameter: operationName (required)
     * The operation to use
     * There are 66 enums and the value can be one of: getVersions,
     * getResources, getGlobalObjects, getBasicInfo, getDescription, getSObject,
     * createSObject, updateSObject, deleteSObject, getSObjectWithId,
     * upsertSObject, deleteSObjectWithId, getBlobField, query, queryMore,
     * queryAll, search, apexCall, recent, createJob, getJob, closeJob,
     * abortJob, createBatch, getBatch, getAllBatches, getRequest, getResults,
     * createBatchQuery, getQueryResultIds, getQueryResult, getRecentReports,
     * getReportDescription, executeSyncReport, executeAsyncReport,
     * getReportInstances, getReportResults, limits, approval, approvals,
     * composite-tree, composite-batch, composite,
     * compositeRetrieveSObjectCollections, compositeCreateSObjectCollections,
     * compositeUpdateSObjectCollections, compositeUpsertSObjectCollections,
     * compositeDeleteSObjectCollections, bulk2GetAllJobs, bulk2CreateJob,
     * bulk2GetJob, bulk2CreateBatch, bulk2CloseJob, bulk2AbortJob,
     * bulk2DeleteJob, bulk2GetSuccessfulResults, bulk2GetFailedResults,
     * bulk2GetUnprocessedRecords, bulk2CreateQueryJob, bulk2GetQueryJob,
     * bulk2GetAllQueryJobs, bulk2GetQueryJobResults, bulk2AbortQueryJob,
     * bulk2DeleteQueryJob, raw, subscribe
     * 
     * Path parameter: topicName
     * The name of the topic/channel to use
     * 
     * @param path operationName:topicName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SalesforceEndpointBuilderFactory.SalesforceEndpointBuilder salesforce(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SalesforceEndpointBuilderFactory.endpointBuilder("salesforce", path);
    }
    /**
     * Salesforce (camel-salesforce)
     * Communicate with Salesforce using Java DTOs.
     * 
     * Category: cloud,api,crm
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * Syntax: <code>salesforce:operationName:topicName</code>
     * 
     * Path parameter: operationName (required)
     * The operation to use
     * There are 66 enums and the value can be one of: getVersions,
     * getResources, getGlobalObjects, getBasicInfo, getDescription, getSObject,
     * createSObject, updateSObject, deleteSObject, getSObjectWithId,
     * upsertSObject, deleteSObjectWithId, getBlobField, query, queryMore,
     * queryAll, search, apexCall, recent, createJob, getJob, closeJob,
     * abortJob, createBatch, getBatch, getAllBatches, getRequest, getResults,
     * createBatchQuery, getQueryResultIds, getQueryResult, getRecentReports,
     * getReportDescription, executeSyncReport, executeAsyncReport,
     * getReportInstances, getReportResults, limits, approval, approvals,
     * composite-tree, composite-batch, composite,
     * compositeRetrieveSObjectCollections, compositeCreateSObjectCollections,
     * compositeUpdateSObjectCollections, compositeUpsertSObjectCollections,
     * compositeDeleteSObjectCollections, bulk2GetAllJobs, bulk2CreateJob,
     * bulk2GetJob, bulk2CreateBatch, bulk2CloseJob, bulk2AbortJob,
     * bulk2DeleteJob, bulk2GetSuccessfulResults, bulk2GetFailedResults,
     * bulk2GetUnprocessedRecords, bulk2CreateQueryJob, bulk2GetQueryJob,
     * bulk2GetAllQueryJobs, bulk2GetQueryJobResults, bulk2AbortQueryJob,
     * bulk2DeleteQueryJob, raw, subscribe
     * 
     * Path parameter: topicName
     * The name of the topic/channel to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operationName:topicName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SalesforceEndpointBuilderFactory.SalesforceEndpointBuilder salesforce(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SalesforceEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SAP NetWeaver (camel-sap-netweaver)
     * Send requests to SAP NetWeaver Gateway using HTTP.
     * 
     * Category: sap,cloud,api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-sap-netweaver
     * 
     * Syntax: <code>sap-netweaver:url</code>
     * 
     * Path parameter: url (required)
     * Url to the SAP net-weaver gateway server.
     * 
     * @param path url
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NetWeaverEndpointBuilderFactory.NetWeaverEndpointBuilder sapNetweaver(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NetWeaverEndpointBuilderFactory.endpointBuilder("sap-netweaver", path);
    }
    /**
     * SAP NetWeaver (camel-sap-netweaver)
     * Send requests to SAP NetWeaver Gateway using HTTP.
     * 
     * Category: sap,cloud,api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-sap-netweaver
     * 
     * Syntax: <code>sap-netweaver:url</code>
     * 
     * Path parameter: url (required)
     * Url to the SAP net-weaver gateway server.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path url
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.NetWeaverEndpointBuilderFactory.NetWeaverEndpointBuilder sapNetweaver(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.NetWeaverEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Scheduler (camel-scheduler)
     * Generate messages in specified intervals using
     * java.util.concurrent.ScheduledExecutorService.
     * 
     * Category: core,scheduling
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-scheduler
     * 
     * Syntax: <code>scheduler:name</code>
     * 
     * Path parameter: name (required)
     * The name of the scheduler
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SchedulerEndpointBuilderFactory.SchedulerEndpointBuilder scheduler(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SchedulerEndpointBuilderFactory.endpointBuilder("scheduler", path);
    }
    /**
     * Scheduler (camel-scheduler)
     * Generate messages in specified intervals using
     * java.util.concurrent.ScheduledExecutorService.
     * 
     * Category: core,scheduling
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-scheduler
     * 
     * Syntax: <code>scheduler:name</code>
     * 
     * Path parameter: name (required)
     * The name of the scheduler
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SchedulerEndpointBuilderFactory.SchedulerEndpointBuilder scheduler(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SchedulerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Schematron (camel-schematron)
     * Validate XML payload using the Schematron Library.
     * 
     * Category: validation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-schematron
     * 
     * Syntax: <code>schematron:path</code>
     * 
     * Path parameter: path (required)
     * The path to the schematron rules file. Can either be in class path or
     * location in the file system.
     * 
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SchematronEndpointBuilderFactory.SchematronEndpointBuilder schematron(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SchematronEndpointBuilderFactory.endpointBuilder("schematron", path);
    }
    /**
     * Schematron (camel-schematron)
     * Validate XML payload using the Schematron Library.
     * 
     * Category: validation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-schematron
     * 
     * Syntax: <code>schematron:path</code>
     * 
     * Path parameter: path (required)
     * The path to the schematron rules file. Can either be in class path or
     * location in the file system.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SchematronEndpointBuilderFactory.SchematronEndpointBuilder schematron(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SchematronEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SCP (camel-jsch)
     * Copy files to/from remote hosts using the secure copy protocol (SCP).
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     * 
     * Syntax: <code>scp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ScpEndpointBuilderFactory.ScpEndpointBuilder scp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ScpEndpointBuilderFactory.endpointBuilder("scp", path);
    }
    /**
     * SCP (camel-jsch)
     * Copy files to/from remote hosts using the secure copy protocol (SCP).
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     * 
     * Syntax: <code>scp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ScpEndpointBuilderFactory.ScpEndpointBuilder scp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ScpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SEDA (camel-seda)
     * Asynchronously call another endpoint from any Camel Context in the same
     * JVM.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-seda
     * 
     * Syntax: <code>seda:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SedaEndpointBuilderFactory.SedaEndpointBuilder seda(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SedaEndpointBuilderFactory.endpointBuilder("seda", path);
    }
    /**
     * SEDA (camel-seda)
     * Asynchronously call another endpoint from any Camel Context in the same
     * JVM.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-seda
     * 
     * Syntax: <code>seda:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SedaEndpointBuilderFactory.SedaEndpointBuilder seda(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SedaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Service (camel-service)
     * Register a Camel endpoint to a Service Registry (such as Consul, Etcd)
     * and delegate to it.
     * 
     * Category: cloud
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-service
     * 
     * Syntax: <code>service:delegateUri</code>
     * 
     * Path parameter: delegateUri (required)
     * The endpoint uri to expose as service
     * 
     * @param path delegateUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceEndpointBuilderFactory.ServiceEndpointBuilder service(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceEndpointBuilderFactory.endpointBuilder("service", path);
    }
    /**
     * Service (camel-service)
     * Register a Camel endpoint to a Service Registry (such as Consul, Etcd)
     * and delegate to it.
     * 
     * Category: cloud
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-service
     * 
     * Syntax: <code>service:delegateUri</code>
     * 
     * Path parameter: delegateUri (required)
     * The endpoint uri to expose as service
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path delegateUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceEndpointBuilderFactory.ServiceEndpointBuilder service(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * ServiceNow (camel-servicenow)
     * Interact with ServiceNow via its REST API.
     * 
     * Category: api,cloud,management
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-servicenow
     * 
     * Syntax: <code>servicenow:instanceName</code>
     * 
     * Path parameter: instanceName (required)
     * The ServiceNow instance name
     * 
     * @param path instanceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceNowEndpointBuilderFactory.ServiceNowEndpointBuilder servicenow(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceNowEndpointBuilderFactory.endpointBuilder("servicenow", path);
    }
    /**
     * ServiceNow (camel-servicenow)
     * Interact with ServiceNow via its REST API.
     * 
     * Category: api,cloud,management
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-servicenow
     * 
     * Syntax: <code>servicenow:instanceName</code>
     * 
     * Path parameter: instanceName (required)
     * The ServiceNow instance name
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path instanceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServiceNowEndpointBuilderFactory.ServiceNowEndpointBuilder servicenow(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServiceNowEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Servlet (camel-servlet)
     * Serve HTTP requests by a Servlet.
     * 
     * Category: http
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-servlet
     * 
     * Syntax: <code>servlet:contextPath</code>
     * 
     * Path parameter: contextPath (required)
     * The context-path to use
     * 
     * @param path contextPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServletEndpointBuilderFactory.ServletEndpointBuilder servlet(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServletEndpointBuilderFactory.endpointBuilder("servlet", path);
    }
    /**
     * Servlet (camel-servlet)
     * Serve HTTP requests by a Servlet.
     * 
     * Category: http
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-servlet
     * 
     * Syntax: <code>servlet:contextPath</code>
     * 
     * Path parameter: contextPath (required)
     * The context-path to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path contextPath
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ServletEndpointBuilderFactory.ServletEndpointBuilder servlet(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ServletEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SFTP (camel-ftp)
     * Upload and download files to/from SFTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>sftp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SftpEndpointBuilderFactory.SftpEndpointBuilder sftp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SftpEndpointBuilderFactory.endpointBuilder("sftp", path);
    }
    /**
     * SFTP (camel-ftp)
     * Upload and download files to/from SFTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * Syntax: <code>sftp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/directoryName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SftpEndpointBuilderFactory.SftpEndpointBuilder sftp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SftpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Simple JMS (camel-sjms)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 1.x API.
     * 
     * Category: messaging
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     * 
     * Syntax: <code>sjms:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 2 enums and the value can be one of: queue, topic
     * 
     * Path parameter: destinationName (required)
     * DestinationName is a JMS queue or topic name. By default, the
     * destinationName is interpreted as a queue name.
     * 
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SjmsEndpointBuilderFactory.SjmsEndpointBuilder sjms(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SjmsEndpointBuilderFactory.endpointBuilder("sjms", path);
    }
    /**
     * Simple JMS (camel-sjms)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 1.x API.
     * 
     * Category: messaging
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     * 
     * Syntax: <code>sjms:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 2 enums and the value can be one of: queue, topic
     * 
     * Path parameter: destinationName (required)
     * DestinationName is a JMS queue or topic name. By default, the
     * destinationName is interpreted as a queue name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SjmsEndpointBuilderFactory.SjmsEndpointBuilder sjms(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SjmsEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Simple JMS2 (camel-sjms2)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 2.x API.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-sjms2
     * 
     * Syntax: <code>sjms2:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 2 enums and the value can be one of: queue, topic
     * 
     * Path parameter: destinationName (required)
     * DestinationName is a JMS queue or topic name. By default, the
     * destinationName is interpreted as a queue name.
     * 
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sjms2EndpointBuilderFactory.Sjms2EndpointBuilder sjms2(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sjms2EndpointBuilderFactory.endpointBuilder("sjms2", path);
    }
    /**
     * Simple JMS2 (camel-sjms2)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 2.x API.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-sjms2
     * 
     * Syntax: <code>sjms2:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * There are 2 enums and the value can be one of: queue, topic
     * 
     * Path parameter: destinationName (required)
     * DestinationName is a JMS queue or topic name. By default, the
     * destinationName is interpreted as a queue name.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destinationType:destinationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Sjms2EndpointBuilderFactory.Sjms2EndpointBuilder sjms2(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Sjms2EndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Slack (camel-slack)
     * Send and receive messages to/from Slack.
     * 
     * Category: social
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-slack
     * 
     * Syntax: <code>slack:channel</code>
     * 
     * Path parameter: channel (required)
     * The channel name (syntax #name) or slack user (syntax userName) to send a
     * message directly to an user.
     * 
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SlackEndpointBuilderFactory.SlackEndpointBuilder slack(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SlackEndpointBuilderFactory.endpointBuilder("slack", path);
    }
    /**
     * Slack (camel-slack)
     * Send and receive messages to/from Slack.
     * 
     * Category: social
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-slack
     * 
     * Syntax: <code>slack:channel</code>
     * 
     * Path parameter: channel (required)
     * The channel name (syntax #name) or slack user (syntax userName) to send a
     * message directly to an user.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path channel
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SlackEndpointBuilderFactory.SlackEndpointBuilder slack(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SlackEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SMPP (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * Syntax: <code>smpp:host:port</code>
     * 
     * Path parameter: host
     * Hostname for the SMSC server to use.
     * Default value: localhost
     * 
     * Path parameter: port
     * Port number for the SMSC server to use.
     * Default value: 2775
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SmppEndpointBuilderFactory.SmppEndpointBuilder smpp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SmppEndpointBuilderFactory.endpointBuilder("smpp", path);
    }
    /**
     * SMPP (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * Syntax: <code>smpp:host:port</code>
     * 
     * Path parameter: host
     * Hostname for the SMSC server to use.
     * Default value: localhost
     * 
     * Path parameter: port
     * Port number for the SMSC server to use.
     * Default value: 2775
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SmppEndpointBuilderFactory.SmppEndpointBuilder smpp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SmppEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SNMP (camel-snmp)
     * Receive traps and poll SNMP (Simple Network Management Protocol) capable
     * devices.
     * 
     * Category: monitoring
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-snmp
     * 
     * Syntax: <code>snmp:host:port</code>
     * 
     * Path parameter: host (required)
     * Hostname of the SNMP enabled device
     * 
     * Path parameter: port (required)
     * Port number of the SNMP enabled device
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SnmpEndpointBuilderFactory.SnmpEndpointBuilder snmp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SnmpEndpointBuilderFactory.endpointBuilder("snmp", path);
    }
    /**
     * SNMP (camel-snmp)
     * Receive traps and poll SNMP (Simple Network Management Protocol) capable
     * devices.
     * 
     * Category: monitoring
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-snmp
     * 
     * Syntax: <code>snmp:host:port</code>
     * 
     * Path parameter: host (required)
     * Hostname of the SNMP enabled device
     * 
     * Path parameter: port (required)
     * Port number of the SNMP enabled device
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SnmpEndpointBuilderFactory.SnmpEndpointBuilder snmp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SnmpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Solr (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * Syntax: <code>solr:url</code>
     * 
     * Path parameter: url (required)
     * Hostname and port for the Solr server(s). Multiple hosts can be
     * specified, separated with a comma. See the solrClient parameter for more
     * information on the SolrClient used to connect to Solr.
     * 
     * @param path url
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SolrEndpointBuilderFactory.SolrEndpointBuilder solr(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SolrEndpointBuilderFactory.endpointBuilder("solr", path);
    }
    /**
     * Solr (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * Syntax: <code>solr:url</code>
     * 
     * Path parameter: url (required)
     * Hostname and port for the Solr server(s). Multiple hosts can be
     * specified, separated with a comma. See the solrClient parameter for more
     * information on the SolrClient used to connect to Solr.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path url
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SolrEndpointBuilderFactory.SolrEndpointBuilder solr(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SolrEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spark (camel-spark)
     * Send RDD or DataFrame jobs to Apache Spark clusters.
     * 
     * Category: bigdata,iot
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-spark
     * 
     * Syntax: <code>spark:endpointType</code>
     * 
     * Path parameter: endpointType (required)
     * Type of the endpoint (rdd, dataframe, hive).
     * There are 3 enums and the value can be one of: rdd, dataframe, hive
     * 
     * @param path endpointType
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SparkEndpointBuilderFactory.SparkEndpointBuilder spark(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SparkEndpointBuilderFactory.endpointBuilder("spark", path);
    }
    /**
     * Spark (camel-spark)
     * Send RDD or DataFrame jobs to Apache Spark clusters.
     * 
     * Category: bigdata,iot
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-spark
     * 
     * Syntax: <code>spark:endpointType</code>
     * 
     * Path parameter: endpointType (required)
     * Type of the endpoint (rdd, dataframe, hive).
     * There are 3 enums and the value can be one of: rdd, dataframe, hive
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointType
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SparkEndpointBuilderFactory.SparkEndpointBuilder spark(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SparkEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Splunk (camel-splunk)
     * Publish or search for events in Splunk.
     * 
     * Category: iot,monitoring
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-splunk
     * 
     * Syntax: <code>splunk:name</code>
     * 
     * Path parameter: name (required)
     * Name has no purpose
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SplunkEndpointBuilderFactory.SplunkEndpointBuilder splunk(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SplunkEndpointBuilderFactory.endpointBuilder("splunk", path);
    }
    /**
     * Splunk (camel-splunk)
     * Publish or search for events in Splunk.
     * 
     * Category: iot,monitoring
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-splunk
     * 
     * Syntax: <code>splunk:name</code>
     * 
     * Path parameter: name (required)
     * Name has no purpose
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SplunkEndpointBuilderFactory.SplunkEndpointBuilder splunk(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SplunkEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Splunk HEC (camel-splunk-hec)
     * The splunk component allows to publish events in Splunk using the HTTP
     * Event Collector.
     * 
     * Category: log,monitoring
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-splunk-hec
     * 
     * Syntax: <code>splunk-hec:splunkURL/token</code>
     * 
     * Path parameter: splunkURL (required)
     * Splunk Host and Port (example: my_splunk_server:8089)
     * 
     * Path parameter: token (required)
     * Splunk HEC token (this is the token created for HEC and not the user's
     * token)
     * 
     * @param path splunkURL/token
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SplunkHECEndpointBuilderFactory.SplunkHECEndpointBuilder splunkHec(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SplunkHECEndpointBuilderFactory.endpointBuilder("splunk-hec", path);
    }
    /**
     * Splunk HEC (camel-splunk-hec)
     * The splunk component allows to publish events in Splunk using the HTTP
     * Event Collector.
     * 
     * Category: log,monitoring
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-splunk-hec
     * 
     * Syntax: <code>splunk-hec:splunkURL/token</code>
     * 
     * Path parameter: splunkURL (required)
     * Splunk Host and Port (example: my_splunk_server:8089)
     * 
     * Path parameter: token (required)
     * Splunk HEC token (this is the token created for HEC and not the user's
     * token)
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path splunkURL/token
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SplunkHECEndpointBuilderFactory.SplunkHECEndpointBuilder splunkHec(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SplunkHECEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring Batch (camel-spring-batch)
     * Send messages to Spring Batch for further processing.
     * 
     * Category: spring,batch,scheduling
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-spring-batch
     * 
     * Syntax: <code>spring-batch:jobName</code>
     * 
     * Path parameter: jobName (required)
     * The name of the Spring Batch job located in the registry.
     * 
     * @param path jobName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringBatchEndpointBuilderFactory.SpringBatchEndpointBuilder springBatch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringBatchEndpointBuilderFactory.endpointBuilder("spring-batch", path);
    }
    /**
     * Spring Batch (camel-spring-batch)
     * Send messages to Spring Batch for further processing.
     * 
     * Category: spring,batch,scheduling
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-spring-batch
     * 
     * Syntax: <code>spring-batch:jobName</code>
     * 
     * Path parameter: jobName (required)
     * The name of the Spring Batch job located in the registry.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path jobName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringBatchEndpointBuilderFactory.SpringBatchEndpointBuilder springBatch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringBatchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring Event (camel-spring)
     * Listen for Spring Application Events.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring
     * 
     * Syntax: <code>spring-event:name</code>
     * 
     * Path parameter: name
     * Name of endpoint
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventEndpointBuilderFactory.EventEndpointBuilder springEvent(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventEndpointBuilderFactory.endpointBuilder("spring-event", path);
    }
    /**
     * Spring Event (camel-spring)
     * Listen for Spring Application Events.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring
     * 
     * Syntax: <code>spring-event:name</code>
     * 
     * Path parameter: name
     * Name of endpoint
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.EventEndpointBuilderFactory.EventEndpointBuilder springEvent(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.EventEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring Integration (camel-spring-integration)
     * Bridge Camel with Spring Integration.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring-integration
     * 
     * Syntax: <code>spring-integration:defaultChannel</code>
     * 
     * Path parameter: defaultChannel (required)
     * The default channel name which is used by the Spring Integration Spring
     * context. It will equal to the inputChannel name for the Spring
     * Integration consumer and the outputChannel name for the Spring
     * Integration provider.
     * 
     * @param path defaultChannel
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SpringIntegrationEndpointBuilderFactory.SpringIntegrationEndpointBuilder springIntegration(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringIntegrationEndpointBuilderFactory.endpointBuilder("spring-integration", path);
    }
    /**
     * Spring Integration (camel-spring-integration)
     * Bridge Camel with Spring Integration.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring-integration
     * 
     * Syntax: <code>spring-integration:defaultChannel</code>
     * 
     * Path parameter: defaultChannel (required)
     * The default channel name which is used by the Spring Integration Spring
     * context. It will equal to the inputChannel name for the Spring
     * Integration consumer and the outputChannel name for the Spring
     * Integration provider.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path defaultChannel
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.SpringIntegrationEndpointBuilderFactory.SpringIntegrationEndpointBuilder springIntegration(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringIntegrationEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring JDBC (camel-spring-jdbc)
     * Access databases through SQL and JDBC with Spring Transaction support.
     * 
     * Category: database,sql
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-spring-jdbc
     * 
     * Syntax: <code>spring-jdbc:dataSourceName</code>
     * 
     * Path parameter: dataSourceName (required)
     * Name of DataSource to lookup in the Registry. If the name is dataSource
     * or default, then Camel will attempt to lookup a default DataSource from
     * the registry, meaning if there is a only one instance of DataSource
     * found, then this DataSource will be used.
     * 
     * @param path dataSourceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringJdbcEndpointBuilderFactory.SpringJdbcEndpointBuilder springJdbc(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringJdbcEndpointBuilderFactory.endpointBuilder("spring-jdbc", path);
    }
    /**
     * Spring JDBC (camel-spring-jdbc)
     * Access databases through SQL and JDBC with Spring Transaction support.
     * 
     * Category: database,sql
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-spring-jdbc
     * 
     * Syntax: <code>spring-jdbc:dataSourceName</code>
     * 
     * Path parameter: dataSourceName (required)
     * Name of DataSource to lookup in the Registry. If the name is dataSource
     * or default, then Camel will attempt to lookup a default DataSource from
     * the registry, meaning if there is a only one instance of DataSource
     * found, then this DataSource will be used.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path dataSourceName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringJdbcEndpointBuilderFactory.SpringJdbcEndpointBuilder springJdbc(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringJdbcEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring LDAP (camel-spring-ldap)
     * Perform searches in LDAP servers using filters as the message payload.
     * 
     * Category: spring,ldap
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-ldap
     * 
     * Syntax: <code>spring-ldap:templateName</code>
     * 
     * Path parameter: templateName (required)
     * Name of the Spring LDAP Template bean
     * 
     * @param path templateName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringLdapEndpointBuilderFactory.SpringLdapEndpointBuilder springLdap(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringLdapEndpointBuilderFactory.endpointBuilder("spring-ldap", path);
    }
    /**
     * Spring LDAP (camel-spring-ldap)
     * Perform searches in LDAP servers using filters as the message payload.
     * 
     * Category: spring,ldap
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-ldap
     * 
     * Syntax: <code>spring-ldap:templateName</code>
     * 
     * Path parameter: templateName (required)
     * Name of the Spring LDAP Template bean
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path templateName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringLdapEndpointBuilderFactory.SpringLdapEndpointBuilder springLdap(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringLdapEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring RabbitMQ (camel-spring-rabbitmq)
     * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
     * 
     * Category: messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
     * 
     * Syntax: <code>spring-rabbitmq:exchangeName</code>
     * 
     * Path parameter: exchangeName (required)
     * The exchange name determines the exchange to which the produced messages
     * will be sent to. In the case of consumers, the exchange name determines
     * the exchange the queue will be bound to. Note: to use default exchange
     * then do not use empty name, but use default instead.
     * 
     * @param path exchangeName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringRabbitMQEndpointBuilderFactory.SpringRabbitMQEndpointBuilder springRabbitmq(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringRabbitMQEndpointBuilderFactory.endpointBuilder("spring-rabbitmq", path);
    }
    /**
     * Spring RabbitMQ (camel-spring-rabbitmq)
     * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
     * 
     * Category: messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
     * 
     * Syntax: <code>spring-rabbitmq:exchangeName</code>
     * 
     * Path parameter: exchangeName (required)
     * The exchange name determines the exchange to which the produced messages
     * will be sent to. In the case of consumers, the exchange name determines
     * the exchange the queue will be bound to. Note: to use default exchange
     * then do not use empty name, but use default instead.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path exchangeName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringRabbitMQEndpointBuilderFactory.SpringRabbitMQEndpointBuilder springRabbitmq(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringRabbitMQEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring Redis (camel-spring-redis)
     * Send and receive messages from Redis.
     * 
     * Category: spring,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-redis
     * 
     * Syntax: <code>spring-redis:host:port</code>
     * 
     * Path parameter: host (required)
     * The host where Redis server is running.
     * 
     * Path parameter: port (required)
     * Redis server port number
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RedisEndpointBuilderFactory.RedisEndpointBuilder springRedis(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RedisEndpointBuilderFactory.endpointBuilder("spring-redis", path);
    }
    /**
     * Spring Redis (camel-spring-redis)
     * Send and receive messages from Redis.
     * 
     * Category: spring,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-redis
     * 
     * Syntax: <code>spring-redis:host:port</code>
     * 
     * Path parameter: host (required)
     * The host where Redis server is running.
     * 
     * Path parameter: port (required)
     * Redis server port number
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.RedisEndpointBuilderFactory.RedisEndpointBuilder springRedis(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.RedisEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Spring WebService (camel-spring-ws)
     * Access external web services as a client or expose your own web services.
     * 
     * Category: spring,soap,webservice
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     * 
     * Syntax: <code>spring-ws:type:lookupKey:webServiceEndpointUri</code>
     * 
     * Path parameter: type
     * Endpoint mapping type if endpoint mapping is used. rootqname - Offers the
     * option to map web service requests based on the qualified name of the
     * root element contained in the message. soapaction - Used to map web
     * service requests based on the SOAP action specified in the header of the
     * message. uri - In order to map web service requests that target a
     * specific URI. xpathresult - Used to map web service requests based on the
     * evaluation of an XPath expression against the incoming message. The
     * result of the evaluation should match the XPath result specified in the
     * endpoint URI. beanname - Allows you to reference an
     * org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher object
     * in order to integrate with existing (legacy) endpoint mappings like
     * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc
     * There are 8 enums and the value can be one of: ROOT_QNAME, ACTION, TO,
     * SOAP_ACTION, XPATHRESULT, URI, URI_PATH, BEANNAME
     * 
     * Path parameter: lookupKey
     * Endpoint mapping key if endpoint mapping is used
     * 
     * Path parameter: webServiceEndpointUri
     * The default Web Service endpoint uri to use for the producer.
     * 
     * @param path type:lookupKey:webServiceEndpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringWebserviceEndpointBuilderFactory.SpringWebserviceEndpointBuilder springWs(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringWebserviceEndpointBuilderFactory.endpointBuilder("spring-ws", path);
    }
    /**
     * Spring WebService (camel-spring-ws)
     * Access external web services as a client or expose your own web services.
     * 
     * Category: spring,soap,webservice
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     * 
     * Syntax: <code>spring-ws:type:lookupKey:webServiceEndpointUri</code>
     * 
     * Path parameter: type
     * Endpoint mapping type if endpoint mapping is used. rootqname - Offers the
     * option to map web service requests based on the qualified name of the
     * root element contained in the message. soapaction - Used to map web
     * service requests based on the SOAP action specified in the header of the
     * message. uri - In order to map web service requests that target a
     * specific URI. xpathresult - Used to map web service requests based on the
     * evaluation of an XPath expression against the incoming message. The
     * result of the evaluation should match the XPath result specified in the
     * endpoint URI. beanname - Allows you to reference an
     * org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher object
     * in order to integrate with existing (legacy) endpoint mappings like
     * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc
     * There are 8 enums and the value can be one of: ROOT_QNAME, ACTION, TO,
     * SOAP_ACTION, XPATHRESULT, URI, URI_PATH, BEANNAME
     * 
     * Path parameter: lookupKey
     * Endpoint mapping key if endpoint mapping is used
     * 
     * Path parameter: webServiceEndpointUri
     * The default Web Service endpoint uri to use for the producer.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type:lookupKey:webServiceEndpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SpringWebserviceEndpointBuilderFactory.SpringWebserviceEndpointBuilder springWs(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SpringWebserviceEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SQL (camel-sql)
     * Perform SQL queries using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * Syntax: <code>sql:query</code>
     * 
     * Path parameter: query (required)
     * Sets the SQL query to perform. You can externalize the query by using
     * file: or classpath: as prefix and specify the location of the file.
     * 
     * @param path query
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SqlEndpointBuilderFactory.SqlEndpointBuilder sql(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SqlEndpointBuilderFactory.endpointBuilder("sql", path);
    }
    /**
     * SQL (camel-sql)
     * Perform SQL queries using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * Syntax: <code>sql:query</code>
     * 
     * Path parameter: query (required)
     * Sets the SQL query to perform. You can externalize the query by using
     * file: or classpath: as prefix and specify the location of the file.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path query
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SqlEndpointBuilderFactory.SqlEndpointBuilder sql(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SqlEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SQL Stored Procedure (camel-sql)
     * Perform SQL queries as a JDBC Stored Procedures using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * Syntax: <code>sql-stored:template</code>
     * 
     * Path parameter: template (required)
     * Sets the StoredProcedure template to perform
     * 
     * @param path template
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SqlStoredEndpointBuilderFactory.SqlStoredEndpointBuilder sqlStored(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SqlStoredEndpointBuilderFactory.endpointBuilder("sql-stored", path);
    }
    /**
     * SQL Stored Procedure (camel-sql)
     * Perform SQL queries as a JDBC Stored Procedures using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * Syntax: <code>sql-stored:template</code>
     * 
     * Path parameter: template (required)
     * Sets the StoredProcedure template to perform
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path template
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SqlStoredEndpointBuilderFactory.SqlStoredEndpointBuilder sqlStored(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SqlStoredEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * SSH (camel-ssh)
     * Execute commands on remote hosts using SSH.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     * 
     * Syntax: <code>ssh:host:port</code>
     * 
     * Path parameter: host (required)
     * Sets the hostname of the remote SSH server.
     * 
     * Path parameter: port
     * Sets the port number for the remote SSH server.
     * Default value: 22
     * 
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SshEndpointBuilderFactory.SshEndpointBuilder ssh(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SshEndpointBuilderFactory.endpointBuilder("ssh", path);
    }
    /**
     * SSH (camel-ssh)
     * Execute commands on remote hosts using SSH.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     * 
     * Syntax: <code>ssh:host:port</code>
     * 
     * Path parameter: host (required)
     * Sets the hostname of the remote SSH server.
     * 
     * Path parameter: port
     * Sets the port number for the remote SSH server.
     * Default value: 22
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.SshEndpointBuilderFactory.SshEndpointBuilder ssh(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.SshEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * StAX (camel-stax)
     * Process XML payloads by a SAX ContentHandler.
     * 
     * Category: transformation
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-stax
     * 
     * Syntax: <code>stax:contentHandlerClass</code>
     * 
     * Path parameter: contentHandlerClass (required)
     * The FQN class name for the ContentHandler implementation to use.
     * 
     * @param path contentHandlerClass
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StAXEndpointBuilderFactory.StAXEndpointBuilder stax(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StAXEndpointBuilderFactory.endpointBuilder("stax", path);
    }
    /**
     * StAX (camel-stax)
     * Process XML payloads by a SAX ContentHandler.
     * 
     * Category: transformation
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-stax
     * 
     * Syntax: <code>stax:contentHandlerClass</code>
     * 
     * Path parameter: contentHandlerClass (required)
     * The FQN class name for the ContentHandler implementation to use.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path contentHandlerClass
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StAXEndpointBuilderFactory.StAXEndpointBuilder stax(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StAXEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Stitch (camel-stitch)
     * Stitch is a cloud ETL service that integrates various data sources into a
     * central data warehouse through various integrations.
     * 
     * Category: cloud,api,compute,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-stitch
     * 
     * Syntax: <code>stitch:tableName</code>
     * 
     * Path parameter: tableName
     * The name of the destination table the data is being pushed to. Table
     * names must be unique in each destination schema, or loading issues will
     * occur. Note: The number of characters in the table name should be within
     * the destination's allowed limits or data will rejected.
     * 
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StitchEndpointBuilderFactory.StitchEndpointBuilder stitch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StitchEndpointBuilderFactory.endpointBuilder("stitch", path);
    }
    /**
     * Stitch (camel-stitch)
     * Stitch is a cloud ETL service that integrates various data sources into a
     * central data warehouse through various integrations.
     * 
     * Category: cloud,api,compute,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-stitch
     * 
     * Syntax: <code>stitch:tableName</code>
     * 
     * Path parameter: tableName
     * The name of the destination table the data is being pushed to. Table
     * names must be unique in each destination schema, or loading issues will
     * occur. Note: The number of characters in the table name should be within
     * the destination's allowed limits or data will rejected.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path tableName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StitchEndpointBuilderFactory.StitchEndpointBuilder stitch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StitchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Stomp (camel-stomp)
     * Send and rececive messages to/from STOMP (Simple Text Oriented Messaging
     * Protocol) compliant message brokers.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-stomp
     * 
     * Syntax: <code>stomp:destination</code>
     * 
     * Path parameter: destination (required)
     * Name of the queue
     * 
     * @param path destination
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StompEndpointBuilderFactory.StompEndpointBuilder stomp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StompEndpointBuilderFactory.endpointBuilder("stomp", path);
    }
    /**
     * Stomp (camel-stomp)
     * Send and rececive messages to/from STOMP (Simple Text Oriented Messaging
     * Protocol) compliant message brokers.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-stomp
     * 
     * Syntax: <code>stomp:destination</code>
     * 
     * Path parameter: destination (required)
     * Name of the queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path destination
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StompEndpointBuilderFactory.StompEndpointBuilder stomp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StompEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Stream (camel-stream)
     * Read from system-in and write to system-out and system-err streams.
     * 
     * Category: file,system
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-stream
     * 
     * Syntax: <code>stream:kind</code>
     * 
     * Path parameter: kind (required)
     * Kind of stream to use such as System.in, System.out, a file, or a http
     * url.
     * There are 6 enums and the value can be one of: in, out, err, header,
     * file, http
     * 
     * @param path kind
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StreamEndpointBuilderFactory.StreamEndpointBuilder stream(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StreamEndpointBuilderFactory.endpointBuilder("stream", path);
    }
    /**
     * Stream (camel-stream)
     * Read from system-in and write to system-out and system-err streams.
     * 
     * Category: file,system
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-stream
     * 
     * Syntax: <code>stream:kind</code>
     * 
     * Path parameter: kind (required)
     * Kind of stream to use such as System.in, System.out, a file, or a http
     * url.
     * There are 6 enums and the value can be one of: in, out, err, header,
     * file, http
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path kind
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StreamEndpointBuilderFactory.StreamEndpointBuilder stream(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StreamEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * String Template (camel-stringtemplate)
     * Transform messages using StringTemplate engine.
     * 
     * Category: transformation,script
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-stringtemplate
     * 
     * Syntax: <code>string-template:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StringTemplateEndpointBuilderFactory.StringTemplateEndpointBuilder stringTemplate(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StringTemplateEndpointBuilderFactory.endpointBuilder("string-template", path);
    }
    /**
     * String Template (camel-stringtemplate)
     * Transform messages using StringTemplate engine.
     * 
     * Category: transformation,script
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-stringtemplate
     * 
     * Syntax: <code>string-template:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StringTemplateEndpointBuilderFactory.StringTemplateEndpointBuilder stringTemplate(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StringTemplateEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Stub (camel-stub)
     * Stub out any physical endpoints while in development or testing.
     * 
     * Category: core,testing
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-stub
     * 
     * Syntax: <code>stub:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StubEndpointBuilderFactory.StubEndpointBuilder stub(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StubEndpointBuilderFactory.endpointBuilder("stub", path);
    }
    /**
     * Stub (camel-stub)
     * Stub out any physical endpoints while in development or testing.
     * 
     * Category: core,testing
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-stub
     * 
     * Syntax: <code>stub:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.StubEndpointBuilderFactory.StubEndpointBuilder stub(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.StubEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Telegram (camel-telegram)
     * Send and receive messages acting as a Telegram Bot Telegram Bot API.
     * 
     * Category: cloud,api,chat
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-telegram
     * 
     * Syntax: <code>telegram:type</code>
     * 
     * Path parameter: type (required)
     * The endpoint type. Currently, only the 'bots' type is supported.
     * There are 1 enums and the value can be one of: bots
     * 
     * @param path type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TelegramEndpointBuilderFactory.TelegramEndpointBuilder telegram(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TelegramEndpointBuilderFactory.endpointBuilder("telegram", path);
    }
    /**
     * Telegram (camel-telegram)
     * Send and receive messages acting as a Telegram Bot Telegram Bot API.
     * 
     * Category: cloud,api,chat
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-telegram
     * 
     * Syntax: <code>telegram:type</code>
     * 
     * Path parameter: type (required)
     * The endpoint type. Currently, only the 'bots' type is supported.
     * There are 1 enums and the value can be one of: bots
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path type
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TelegramEndpointBuilderFactory.TelegramEndpointBuilder telegram(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TelegramEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Thrift (camel-thrift)
     * Call and expose remote procedures (RPC) with Apache Thrift data format
     * and serialization mechanism.
     * 
     * Category: rpc,transformation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     * 
     * Syntax: <code>thrift:host:port/service</code>
     * 
     * Path parameter: host
     * The Thrift server host name. This is localhost or 0.0.0.0 (if not
     * defined) when being a consumer or remote server host name when using
     * producer.
     * 
     * Path parameter: port (required)
     * The Thrift server port
     * 
     * Path parameter: service (required)
     * Fully qualified service name from the thrift descriptor file (package dot
     * service definition name)
     * 
     * @param path host:port/service
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ThriftEndpointBuilderFactory.ThriftEndpointBuilder thrift(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ThriftEndpointBuilderFactory.endpointBuilder("thrift", path);
    }
    /**
     * Thrift (camel-thrift)
     * Call and expose remote procedures (RPC) with Apache Thrift data format
     * and serialization mechanism.
     * 
     * Category: rpc,transformation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     * 
     * Syntax: <code>thrift:host:port/service</code>
     * 
     * Path parameter: host
     * The Thrift server host name. This is localhost or 0.0.0.0 (if not
     * defined) when being a consumer or remote server host name when using
     * producer.
     * 
     * Path parameter: port (required)
     * The Thrift server port
     * 
     * Path parameter: service (required)
     * Fully qualified service name from the thrift descriptor file (package dot
     * service definition name)
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/service
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ThriftEndpointBuilderFactory.ThriftEndpointBuilder thrift(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ThriftEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Tika (camel-tika)
     * Parse documents and extract metadata and text using Apache Tika.
     * 
     * Category: document,transformation
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-tika
     * 
     * Syntax: <code>tika:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation type
     * There are 2 enums and the value can be one of: parse, detect
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TikaEndpointBuilderFactory.TikaEndpointBuilder tika(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TikaEndpointBuilderFactory.endpointBuilder("tika", path);
    }
    /**
     * Tika (camel-tika)
     * Parse documents and extract metadata and text using Apache Tika.
     * 
     * Category: document,transformation
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-tika
     * 
     * Syntax: <code>tika:operation</code>
     * 
     * Path parameter: operation (required)
     * Operation type
     * There are 2 enums and the value can be one of: parse, detect
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TikaEndpointBuilderFactory.TikaEndpointBuilder tika(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TikaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Timer (camel-timer)
     * Generate messages in specified intervals using java.util.Timer.
     * 
     * Category: core,scheduling
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-timer
     * 
     * Syntax: <code>timer:timerName</code>
     * 
     * Path parameter: timerName (required)
     * The name of the timer
     * 
     * @param path timerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TimerEndpointBuilderFactory.TimerEndpointBuilder timer(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TimerEndpointBuilderFactory.endpointBuilder("timer", path);
    }
    /**
     * Timer (camel-timer)
     * Generate messages in specified intervals using java.util.Timer.
     * 
     * Category: core,scheduling
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-timer
     * 
     * Syntax: <code>timer:timerName</code>
     * 
     * Path parameter: timerName (required)
     * The name of the timer
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path timerName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TimerEndpointBuilderFactory.TimerEndpointBuilder timer(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TimerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Twilio (camel-twilio)
     * Interact with Twilio REST APIs using Twilio Java SDK.
     * 
     * Category: api,messaging,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-twilio
     * 
     * Syntax: <code>twilio:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 56 enums and the value can be one of: ACCOUNT, ADDRESS,
     * APPLICATION, AVAILABLE_PHONE_NUMBER_COUNTRY, CALL, CONFERENCE,
     * CONNECT_APP, INCOMING_PHONE_NUMBER, KEY, MESSAGE, NEW_KEY,
     * NEW_SIGNING_KEY, NOTIFICATION, OUTGOING_CALLER_ID, QUEUE, RECORDING,
     * SHORT_CODE, SIGNING_KEY, TOKEN, TRANSCRIPTION, VALIDATION_REQUEST,
     * ADDRESS_DEPENDENT_PHONE_NUMBER, AVAILABLE_PHONE_NUMBER_COUNTRY_LOCAL,
     * AVAILABLE_PHONE_NUMBER_COUNTRY_MOBILE,
     * AVAILABLE_PHONE_NUMBER_COUNTRY_TOLL_FREE, CALL_FEEDBACK,
     * CALL_FEEDBACK_SUMMARY, CALL_NOTIFICATION, CALL_RECORDING,
     * CONFERENCE_PARTICIPANT, INCOMING_PHONE_NUMBER_LOCAL,
     * INCOMING_PHONE_NUMBER_MOBILE, INCOMING_PHONE_NUMBER_TOLL_FREE,
     * MESSAGE_FEEDBACK, MESSAGE_MEDIA, QUEUE_MEMBER, RECORDING_ADD_ON_RESULT,
     * RECORDING_TRANSCRIPTION, RECORDING_ADD_ON_RESULT_PAYLOAD,
     * SIP_CREDENTIAL_LIST, SIP_DOMAIN, SIP_IP_ACCESS_CONTROL_LIST,
     * SIP_CREDENTIAL_LIST_CREDENTIAL, SIP_DOMAIN_CREDENTIAL_LIST_MAPPING,
     * SIP_DOMAIN_IP_ACCESS_CONTROL_LIST_MAPPING,
     * SIP_IP_ACCESS_CONTROL_LIST_IP_ADDRESS, USAGE_RECORD, USAGE_TRIGGER,
     * USAGE_RECORD_ALL_TIME, USAGE_RECORD_DAILY, USAGE_RECORD_LAST_MONTH,
     * USAGE_RECORD_MONTHLY, USAGE_RECORD_THIS_MONTH, USAGE_RECORD_TODAY,
     * USAGE_RECORD_YEARLY, USAGE_RECORD_YESTERDAY
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 5 enums and the value can be one of: create, delete, fetch,
     * read, update
     * 
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwilioEndpointBuilderFactory.TwilioEndpointBuilder twilio(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwilioEndpointBuilderFactory.endpointBuilder("twilio", path);
    }
    /**
     * Twilio (camel-twilio)
     * Interact with Twilio REST APIs using Twilio Java SDK.
     * 
     * Category: api,messaging,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-twilio
     * 
     * Syntax: <code>twilio:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * There are 56 enums and the value can be one of: ACCOUNT, ADDRESS,
     * APPLICATION, AVAILABLE_PHONE_NUMBER_COUNTRY, CALL, CONFERENCE,
     * CONNECT_APP, INCOMING_PHONE_NUMBER, KEY, MESSAGE, NEW_KEY,
     * NEW_SIGNING_KEY, NOTIFICATION, OUTGOING_CALLER_ID, QUEUE, RECORDING,
     * SHORT_CODE, SIGNING_KEY, TOKEN, TRANSCRIPTION, VALIDATION_REQUEST,
     * ADDRESS_DEPENDENT_PHONE_NUMBER, AVAILABLE_PHONE_NUMBER_COUNTRY_LOCAL,
     * AVAILABLE_PHONE_NUMBER_COUNTRY_MOBILE,
     * AVAILABLE_PHONE_NUMBER_COUNTRY_TOLL_FREE, CALL_FEEDBACK,
     * CALL_FEEDBACK_SUMMARY, CALL_NOTIFICATION, CALL_RECORDING,
     * CONFERENCE_PARTICIPANT, INCOMING_PHONE_NUMBER_LOCAL,
     * INCOMING_PHONE_NUMBER_MOBILE, INCOMING_PHONE_NUMBER_TOLL_FREE,
     * MESSAGE_FEEDBACK, MESSAGE_MEDIA, QUEUE_MEMBER, RECORDING_ADD_ON_RESULT,
     * RECORDING_TRANSCRIPTION, RECORDING_ADD_ON_RESULT_PAYLOAD,
     * SIP_CREDENTIAL_LIST, SIP_DOMAIN, SIP_IP_ACCESS_CONTROL_LIST,
     * SIP_CREDENTIAL_LIST_CREDENTIAL, SIP_DOMAIN_CREDENTIAL_LIST_MAPPING,
     * SIP_DOMAIN_IP_ACCESS_CONTROL_LIST_MAPPING,
     * SIP_IP_ACCESS_CONTROL_LIST_IP_ADDRESS, USAGE_RECORD, USAGE_TRIGGER,
     * USAGE_RECORD_ALL_TIME, USAGE_RECORD_DAILY, USAGE_RECORD_LAST_MONTH,
     * USAGE_RECORD_MONTHLY, USAGE_RECORD_THIS_MONTH, USAGE_RECORD_TODAY,
     * USAGE_RECORD_YEARLY, USAGE_RECORD_YESTERDAY
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     * There are 5 enums and the value can be one of: create, delete, fetch,
     * read, update
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path apiName/methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwilioEndpointBuilderFactory.TwilioEndpointBuilder twilio(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwilioEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Twitter Direct Message (camel-twitter)
     * Send and receive Twitter direct messages.
     * 
     * Category: cloud,api,social,chat
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-directmessage:user</code>
     * 
     * Path parameter: user (required)
     * The user name to send a direct message. This will be ignored for
     * consumer.
     * 
     * @param path user
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterDirectMessageEndpointBuilderFactory.TwitterDirectMessageEndpointBuilder twitterDirectmessage(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterDirectMessageEndpointBuilderFactory.endpointBuilder("twitter-directmessage", path);
    }
    /**
     * Twitter Direct Message (camel-twitter)
     * Send and receive Twitter direct messages.
     * 
     * Category: cloud,api,social,chat
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-directmessage:user</code>
     * 
     * Path parameter: user (required)
     * The user name to send a direct message. This will be ignored for
     * consumer.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path user
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterDirectMessageEndpointBuilderFactory.TwitterDirectMessageEndpointBuilder twitterDirectmessage(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterDirectMessageEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Twitter Search (camel-twitter)
     * Access Twitter Search.
     * 
     * Category: cloud,api,search,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-search:keywords</code>
     * 
     * Path parameter: keywords (required)
     * The search query, use the keywords AND, OR, - and () to narrow the search
     * results.
     * 
     * @param path keywords
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterSearchEndpointBuilderFactory.TwitterSearchEndpointBuilder twitterSearch(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterSearchEndpointBuilderFactory.endpointBuilder("twitter-search", path);
    }
    /**
     * Twitter Search (camel-twitter)
     * Access Twitter Search.
     * 
     * Category: cloud,api,search,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-search:keywords</code>
     * 
     * Path parameter: keywords (required)
     * The search query, use the keywords AND, OR, - and () to narrow the search
     * results.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path keywords
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterSearchEndpointBuilderFactory.TwitterSearchEndpointBuilder twitterSearch(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterSearchEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Twitter Timeline (camel-twitter)
     * Send tweets and receive tweets from user's timeline.
     * 
     * Category: api,cloud,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-timeline:timelineType</code>
     * 
     * Path parameter: timelineType (required)
     * The timeline type to produce/consume.
     * There are 7 enums and the value can be one of: PUBLIC, HOME, USER,
     * MENTIONS, RETWEETSOFME, LIST, UNKNOWN
     * 
     * @param path timelineType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterTimelineEndpointBuilderFactory.TwitterTimelineEndpointBuilder twitterTimeline(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterTimelineEndpointBuilderFactory.endpointBuilder("twitter-timeline", path);
    }
    /**
     * Twitter Timeline (camel-twitter)
     * Send tweets and receive tweets from user's timeline.
     * 
     * Category: api,cloud,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-timeline:timelineType</code>
     * 
     * Path parameter: timelineType (required)
     * The timeline type to produce/consume.
     * There are 7 enums and the value can be one of: PUBLIC, HOME, USER,
     * MENTIONS, RETWEETSOFME, LIST, UNKNOWN
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path timelineType
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.TwitterTimelineEndpointBuilderFactory.TwitterTimelineEndpointBuilder twitterTimeline(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.TwitterTimelineEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Undertow (camel-undertow)
     * Expose HTTP and WebSocket endpoints and access external HTTP/WebSocket
     * servers.
     * 
     * Category: http,websocket
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     * 
     * Syntax: <code>undertow:httpURI</code>
     * 
     * Path parameter: httpURI (required)
     * The url of the HTTP endpoint to use.
     * 
     * @param path httpURI
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.UndertowEndpointBuilderFactory.UndertowEndpointBuilder undertow(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.UndertowEndpointBuilderFactory.endpointBuilder("undertow", path);
    }
    /**
     * Undertow (camel-undertow)
     * Expose HTTP and WebSocket endpoints and access external HTTP/WebSocket
     * servers.
     * 
     * Category: http,websocket
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     * 
     * Syntax: <code>undertow:httpURI</code>
     * 
     * Path parameter: httpURI (required)
     * The url of the HTTP endpoint to use.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path httpURI
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.UndertowEndpointBuilderFactory.UndertowEndpointBuilder undertow(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.UndertowEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Validator (camel-validator)
     * Validate the payload using XML Schema and JAXP Validation.
     * 
     * Category: core,validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-validator
     * 
     * Syntax: <code>validator:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * URL to a local resource on the classpath, or a reference to lookup a bean
     * in the Registry, or a full URL to a remote resource or resource on the
     * file system which contains the XSD to validate against.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ValidatorEndpointBuilderFactory.ValidatorEndpointBuilder validator(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ValidatorEndpointBuilderFactory.endpointBuilder("validator", path);
    }
    /**
     * Validator (camel-validator)
     * Validate the payload using XML Schema and JAXP Validation.
     * 
     * Category: core,validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-validator
     * 
     * Syntax: <code>validator:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * URL to a local resource on the classpath, or a reference to lookup a bean
     * in the Registry, or a full URL to a remote resource or resource on the
     * file system which contains the XSD to validate against.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ValidatorEndpointBuilderFactory.ValidatorEndpointBuilder validator(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ValidatorEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Velocity (camel-velocity)
     * Transform messages using a Velocity template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-velocity
     * 
     * Syntax: <code>velocity:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VelocityEndpointBuilderFactory.VelocityEndpointBuilder velocity(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VelocityEndpointBuilderFactory.endpointBuilder("velocity", path);
    }
    /**
     * Velocity (camel-velocity)
     * Transform messages using a Velocity template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-velocity
     * 
     * Syntax: <code>velocity:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VelocityEndpointBuilderFactory.VelocityEndpointBuilder velocity(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VelocityEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Vert.x (camel-vertx)
     * Send and receive messages to/from Vert.x Event Bus.
     * 
     * Category: eventbus,reactive
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-vertx
     * 
     * Syntax: <code>vertx:address</code>
     * 
     * Path parameter: address (required)
     * Sets the event bus address used to communicate
     * 
     * @param path address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxEndpointBuilderFactory.VertxEndpointBuilder vertx(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxEndpointBuilderFactory.endpointBuilder("vertx", path);
    }
    /**
     * Vert.x (camel-vertx)
     * Send and receive messages to/from Vert.x Event Bus.
     * 
     * Category: eventbus,reactive
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-vertx
     * 
     * Syntax: <code>vertx:address</code>
     * 
     * Path parameter: address (required)
     * Sets the event bus address used to communicate
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path address
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxEndpointBuilderFactory.VertxEndpointBuilder vertx(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Vert.x HTTP Client (camel-vertx-http)
     * Send requests to external HTTP servers using Vert.x
     * 
     * Category: http
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-http
     * 
     * Syntax: <code>vertx-http:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The HTTP URI to connect to
     * 
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxHttpEndpointBuilderFactory.VertxHttpEndpointBuilder vertxHttp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxHttpEndpointBuilderFactory.endpointBuilder("vertx-http", path);
    }
    /**
     * Vert.x HTTP Client (camel-vertx-http)
     * Send requests to external HTTP servers using Vert.x
     * 
     * Category: http
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-http
     * 
     * Syntax: <code>vertx-http:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The HTTP URI to connect to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path httpUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxHttpEndpointBuilderFactory.VertxHttpEndpointBuilder vertxHttp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Vert.x WebSocket (camel-vertx-websocket)
     * Expose WebSocket endpoints and connect to remote WebSocket servers using
     * Vert.x
     * 
     * Category: websocket
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-websocket
     * 
     * Syntax: <code>vertx-websocket:host:port/path</code>
     * 
     * Path parameter: host (required)
     * WebSocket hostname, such as localhost or a remote host when in client
     * mode.
     * 
     * Path parameter: port (required)
     * WebSocket port number to use.
     * 
     * Path parameter: path
     * WebSocket path to use.
     * 
     * @param path host:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxWebsocketEndpointBuilderFactory.VertxWebsocketEndpointBuilder vertxWebsocket(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxWebsocketEndpointBuilderFactory.endpointBuilder("vertx-websocket", path);
    }
    /**
     * Vert.x WebSocket (camel-vertx-websocket)
     * Expose WebSocket endpoints and connect to remote WebSocket servers using
     * Vert.x
     * 
     * Category: websocket
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-websocket
     * 
     * Syntax: <code>vertx-websocket:host:port/path</code>
     * 
     * Path parameter: host (required)
     * WebSocket hostname, such as localhost or a remote host when in client
     * mode.
     * 
     * Path parameter: port (required)
     * WebSocket port number to use.
     * 
     * Path parameter: path
     * WebSocket path to use.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.VertxWebsocketEndpointBuilderFactory.VertxWebsocketEndpointBuilder vertxWebsocket(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VertxWebsocketEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * VM (camel-vm)
     * Call another endpoint in the same CamelContext asynchronously.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-vm
     * 
     * Syntax: <code>vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.VmEndpointBuilderFactory.VmEndpointBuilder vm(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VmEndpointBuilderFactory.endpointBuilder("vm", path);
    }
    /**
     * VM (camel-vm)
     * Call another endpoint in the same CamelContext asynchronously.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-vm
     * 
     * Syntax: <code>vm:name</code>
     * 
     * Path parameter: name (required)
     * Name of queue
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.VmEndpointBuilderFactory.VmEndpointBuilder vm(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.VmEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Weather (camel-weather)
     * Poll the weather information from Open Weather Map.
     * 
     * Category: api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     * 
     * Syntax: <code>weather:name</code>
     * 
     * Path parameter: name (required)
     * The name value is not used.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WeatherEndpointBuilderFactory.WeatherEndpointBuilder weather(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WeatherEndpointBuilderFactory.endpointBuilder("weather", path);
    }
    /**
     * Weather (camel-weather)
     * Poll the weather information from Open Weather Map.
     * 
     * Category: api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     * 
     * Syntax: <code>weather:name</code>
     * 
     * Path parameter: name (required)
     * The name value is not used.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WeatherEndpointBuilderFactory.WeatherEndpointBuilder weather(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WeatherEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * Interact with Ethereum nodes using web3j client API.
     * 
     * Category: bitcoin,blockchain,api
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     * 
     * Syntax: <code>web3j:nodeAddress</code>
     * 
     * Path parameter: nodeAddress (required)
     * Sets the node address used to communicate
     * 
     * @param path nodeAddress
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Web3jEndpointBuilderFactory.Web3jEndpointBuilder web3j(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Web3jEndpointBuilderFactory.endpointBuilder("web3j", path);
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * Interact with Ethereum nodes using web3j client API.
     * 
     * Category: bitcoin,blockchain,api
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     * 
     * Syntax: <code>web3j:nodeAddress</code>
     * 
     * Path parameter: nodeAddress (required)
     * Sets the node address used to communicate
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path nodeAddress
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.Web3jEndpointBuilderFactory.Web3jEndpointBuilder web3j(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.Web3jEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Webhook (camel-webhook)
     * Expose webhook endpoints to receive push notifications for other Camel
     * components.
     * 
     * Category: cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-webhook
     * 
     * Syntax: <code>webhook:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The delegate uri. Must belong to a component that supports webhooks.
     * 
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WebhookEndpointBuilderFactory.WebhookEndpointBuilder webhook(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WebhookEndpointBuilderFactory.endpointBuilder("webhook", path);
    }
    /**
     * Webhook (camel-webhook)
     * Expose webhook endpoints to receive push notifications for other Camel
     * components.
     * 
     * Category: cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-webhook
     * 
     * Syntax: <code>webhook:endpointUri</code>
     * 
     * Path parameter: endpointUri (required)
     * The delegate uri. Must belong to a component that supports webhooks.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path endpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WebhookEndpointBuilderFactory.WebhookEndpointBuilder webhook(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WebhookEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Jetty Websocket (camel-websocket)
     * Expose websocket endpoints using Jetty.
     * 
     * Category: websocket
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-websocket
     * 
     * Syntax: <code>websocket:host:port/resourceUri</code>
     * 
     * Path parameter: host
     * The hostname. The default value is 0.0.0.0. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 0.0.0.0
     * 
     * Path parameter: port
     * The port number. The default value is 9292. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 9292
     * 
     * Path parameter: resourceUri (required)
     * Name of the websocket channel to use
     * 
     * @param path host:port/resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WebsocketEndpointBuilderFactory.WebsocketEndpointBuilder websocket(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WebsocketEndpointBuilderFactory.endpointBuilder("websocket", path);
    }
    /**
     * Jetty Websocket (camel-websocket)
     * Expose websocket endpoints using Jetty.
     * 
     * Category: websocket
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-websocket
     * 
     * Syntax: <code>websocket:host:port/resourceUri</code>
     * 
     * Path parameter: host
     * The hostname. The default value is 0.0.0.0. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 0.0.0.0
     * 
     * Path parameter: port
     * The port number. The default value is 9292. Setting this option on the
     * component will use the component configured value as default.
     * Default value: 9292
     * 
     * Path parameter: resourceUri (required)
     * Name of the websocket channel to use
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WebsocketEndpointBuilderFactory.WebsocketEndpointBuilder websocket(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WebsocketEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Javax Websocket (camel-websocket-jsr356)
     * Expose websocket endpoints using JSR356.
     * 
     * Category: http
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-websocket-jsr356
     * 
     * Syntax: <code>websocket-jsr356:uri</code>
     * 
     * Path parameter: uri
     * If a schemeless URI path is provided, a ServerEndpoint is deployed under
     * that path. Else if the URI is prefixed with the 'ws://' scheme, then a
     * connection is established to the corresponding server
     * 
     * @param path uri
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.JSR356WebSocketEndpointBuilderFactory.JSR356WebSocketEndpointBuilder websocketJsr356(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JSR356WebSocketEndpointBuilderFactory.endpointBuilder("websocket-jsr356", path);
    }
    /**
     * Javax Websocket (camel-websocket-jsr356)
     * Expose websocket endpoints using JSR356.
     * 
     * Category: http
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-websocket-jsr356
     * 
     * Syntax: <code>websocket-jsr356:uri</code>
     * 
     * Path parameter: uri
     * If a schemeless URI path is provided, a ServerEndpoint is deployed under
     * that path. Else if the URI is prefixed with the 'ws://' scheme, then a
     * connection is established to the corresponding server
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path uri
     * @return the dsl builder
     */
    @Deprecated
    public static org.apache.camel.builder.endpoint.dsl.JSR356WebSocketEndpointBuilderFactory.JSR356WebSocketEndpointBuilder websocketJsr356(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.JSR356WebSocketEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Weka (camel-weka)
     * Perform machine learning tasks using Weka.
     * 
     * Category: datamining
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-weka
     * 
     * Syntax: <code>weka:command</code>
     * 
     * Path parameter: command (required)
     * The command to use.
     * There are 7 enums and the value can be one of: filter, model, read,
     * write, push, pop, version
     * 
     * @param path command
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WekaEndpointBuilderFactory.WekaEndpointBuilder weka(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WekaEndpointBuilderFactory.endpointBuilder("weka", path);
    }
    /**
     * Weka (camel-weka)
     * Perform machine learning tasks using Weka.
     * 
     * Category: datamining
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-weka
     * 
     * Syntax: <code>weka:command</code>
     * 
     * Path parameter: command (required)
     * The command to use.
     * There are 7 enums and the value can be one of: filter, model, read,
     * write, push, pop, version
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path command
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WekaEndpointBuilderFactory.WekaEndpointBuilder weka(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WekaEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * WhatsApp (camel-whatsapp)
     * Send messages to WhatsApp.
     * 
     * Category: cloud,api,chat
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-whatsapp
     * 
     * Syntax: <code>whatsapp:phoneNumberId</code>
     * 
     * Path parameter: phoneNumberId (required)
     * The phone number ID taken from whatsapp-business dashboard.
     * 
     * @param path phoneNumberId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WhatsAppEndpointBuilderFactory.WhatsAppEndpointBuilder whatsapp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WhatsAppEndpointBuilderFactory.endpointBuilder("whatsapp", path);
    }
    /**
     * WhatsApp (camel-whatsapp)
     * Send messages to WhatsApp.
     * 
     * Category: cloud,api,chat
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-whatsapp
     * 
     * Syntax: <code>whatsapp:phoneNumberId</code>
     * 
     * Path parameter: phoneNumberId (required)
     * The phone number ID taken from whatsapp-business dashboard.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path phoneNumberId
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WhatsAppEndpointBuilderFactory.WhatsAppEndpointBuilder whatsapp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WhatsAppEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Wordpress (camel-wordpress)
     * Manage posts and users using Wordpress API.
     * 
     * Category: cloud,api,cms
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-wordpress
     * 
     * Syntax: <code>wordpress:operation</code>
     * 
     * Path parameter: operation (required)
     * The endpoint operation.
     * There are 2 enums and the value can be one of: post, user
     * 
     * Path parameter: operationDetail
     * The second part of an endpoint operation. Needed only when endpoint
     * semantic is not enough, like wordpress:post:delete
     * There are 1 enums and the value can be one of: delete
     * 
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WordpressEndpointBuilderFactory.WordpressEndpointBuilder wordpress(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WordpressEndpointBuilderFactory.endpointBuilder("wordpress", path);
    }
    /**
     * Wordpress (camel-wordpress)
     * Manage posts and users using Wordpress API.
     * 
     * Category: cloud,api,cms
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-wordpress
     * 
     * Syntax: <code>wordpress:operation</code>
     * 
     * Path parameter: operation (required)
     * The endpoint operation.
     * There are 2 enums and the value can be one of: post, user
     * 
     * Path parameter: operationDetail
     * The second part of an endpoint operation. Needed only when endpoint
     * semantic is not enough, like wordpress:post:delete
     * There are 1 enums and the value can be one of: delete
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operation
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WordpressEndpointBuilderFactory.WordpressEndpointBuilder wordpress(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WordpressEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Workday (camel-workday)
     * Detect and parse documents using Workday.
     * 
     * Category: cloud,api,hcm
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-workday
     * 
     * Syntax: <code>workday:entity:path</code>
     * 
     * Path parameter: entity (required)
     * The entity to be requested or subscribed via API.
     * There are 2 enums and the value can be one of: report, commonAPI
     * 
     * Path parameter: path (required)
     * The API path to access an entity structure.
     * 
     * @param path entity:path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WorkdayEndpointBuilderFactory.WorkdayEndpointBuilder workday(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WorkdayEndpointBuilderFactory.endpointBuilder("workday", path);
    }
    /**
     * Workday (camel-workday)
     * Detect and parse documents using Workday.
     * 
     * Category: cloud,api,hcm
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-workday
     * 
     * Syntax: <code>workday:entity:path</code>
     * 
     * Path parameter: entity (required)
     * The entity to be requested or subscribed via API.
     * There are 2 enums and the value can be one of: report, commonAPI
     * 
     * Path parameter: path (required)
     * The API path to access an entity structure.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path entity:path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.WorkdayEndpointBuilderFactory.WorkdayEndpointBuilder workday(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.WorkdayEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XChange (camel-xchange)
     * Access market data and trade on Bitcoin and Altcoin exchanges.
     * 
     * Category: bitcoin,blockchain
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     * 
     * Syntax: <code>xchange:name</code>
     * 
     * Path parameter: name (required)
     * The exchange to connect to
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XChangeEndpointBuilderFactory.XChangeEndpointBuilder xchange(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XChangeEndpointBuilderFactory.endpointBuilder("xchange", path);
    }
    /**
     * XChange (camel-xchange)
     * Access market data and trade on Bitcoin and Altcoin exchanges.
     * 
     * Category: bitcoin,blockchain
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     * 
     * Syntax: <code>xchange:name</code>
     * 
     * Path parameter: name (required)
     * The exchange to connect to
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XChangeEndpointBuilderFactory.XChangeEndpointBuilder xchange(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XChangeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XJ (camel-xj)
     * Transform JSON and XML message using a XSLT.
     * 
     * Category: transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xj
     * 
     * Syntax: <code>xj:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XJEndpointBuilderFactory.XJEndpointBuilder xj(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XJEndpointBuilderFactory.endpointBuilder("xj", path);
    }
    /**
     * XJ (camel-xj)
     * Transform JSON and XML message using a XSLT.
     * 
     * Category: transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xj
     * 
     * Syntax: <code>xj:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XJEndpointBuilderFactory.XJEndpointBuilder xj(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XJEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XML Security Sign (camel-xmlsecurity)
     * Sign XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * Syntax: <code>xmlsecurity-sign:name</code>
     * 
     * Path parameter: name (required)
     * The name part in the URI can be chosen by the user to distinguish between
     * different signer endpoints within the camel context.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmlSignerEndpointBuilderFactory.XmlSignerEndpointBuilder xmlsecuritySign(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmlSignerEndpointBuilderFactory.endpointBuilder("xmlsecurity-sign", path);
    }
    /**
     * XML Security Sign (camel-xmlsecurity)
     * Sign XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * Syntax: <code>xmlsecurity-sign:name</code>
     * 
     * Path parameter: name (required)
     * The name part in the URI can be chosen by the user to distinguish between
     * different signer endpoints within the camel context.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmlSignerEndpointBuilderFactory.XmlSignerEndpointBuilder xmlsecuritySign(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmlSignerEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XML Security Verify (camel-xmlsecurity)
     * Verify XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * Syntax: <code>xmlsecurity-verify:name</code>
     * 
     * Path parameter: name (required)
     * The name part in the URI can be chosen by the user to distinguish between
     * different verify endpoints within the camel context.
     * 
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmlVerifierEndpointBuilderFactory.XmlVerifierEndpointBuilder xmlsecurityVerify(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmlVerifierEndpointBuilderFactory.endpointBuilder("xmlsecurity-verify", path);
    }
    /**
     * XML Security Verify (camel-xmlsecurity)
     * Verify XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * Syntax: <code>xmlsecurity-verify:name</code>
     * 
     * Path parameter: name (required)
     * The name part in the URI can be chosen by the user to distinguish between
     * different verify endpoints within the camel context.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path name
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmlVerifierEndpointBuilderFactory.XmlVerifierEndpointBuilder xmlsecurityVerify(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmlVerifierEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XMPP (camel-xmpp)
     * Send and receive messages to/from an XMPP chat server.
     * 
     * Category: chat,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-xmpp
     * 
     * Syntax: <code>xmpp:host:port/participant</code>
     * 
     * Path parameter: host (required)
     * Hostname for the chat server
     * 
     * Path parameter: port (required)
     * Port number for the chat server
     * 
     * Path parameter: participant
     * JID (Jabber ID) of person to receive messages. room parameter has
     * precedence over participant.
     * 
     * @param path host:port/participant
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmppEndpointBuilderFactory.XmppEndpointBuilder xmpp(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmppEndpointBuilderFactory.endpointBuilder("xmpp", path);
    }
    /**
     * XMPP (camel-xmpp)
     * Send and receive messages to/from an XMPP chat server.
     * 
     * Category: chat,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-xmpp
     * 
     * Syntax: <code>xmpp:host:port/participant</code>
     * 
     * Path parameter: host (required)
     * Hostname for the chat server
     * 
     * Path parameter: port (required)
     * Port number for the chat server
     * 
     * Path parameter: participant
     * JID (Jabber ID) of person to receive messages. room parameter has
     * precedence over participant.
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path host:port/participant
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XmppEndpointBuilderFactory.XmppEndpointBuilder xmpp(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XmppEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XQuery (camel-saxon)
     * Query and/or transform XML payloads using XQuery and Saxon.
     * 
     * Category: transformation
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     * 
     * Syntax: <code>xquery:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * The name of the template to load from classpath or file system
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XQueryEndpointBuilderFactory.XQueryEndpointBuilder xquery(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XQueryEndpointBuilderFactory.endpointBuilder("xquery", path);
    }
    /**
     * XQuery (camel-saxon)
     * Query and/or transform XML payloads using XQuery and Saxon.
     * 
     * Category: transformation
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     * 
     * Syntax: <code>xquery:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * The name of the template to load from classpath or file system
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XQueryEndpointBuilderFactory.XQueryEndpointBuilder xquery(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XQueryEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XSLT (camel-xslt)
     * Transforms XML payload using an XSLT template.
     * 
     * Category: core,transformation
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-xslt
     * 
     * Syntax: <code>xslt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XsltEndpointBuilderFactory.XsltEndpointBuilder xslt(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XsltEndpointBuilderFactory.endpointBuilder("xslt", path);
    }
    /**
     * XSLT (camel-xslt)
     * Transforms XML payload using an XSLT template.
     * 
     * Category: core,transformation
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-xslt
     * 
     * Syntax: <code>xslt:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XsltEndpointBuilderFactory.XsltEndpointBuilder xslt(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XsltEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * XSLT Saxon (camel-xslt-saxon)
     * Transform XML payloads using an XSLT template using Saxon.
     * 
     * Category: core,transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xslt-saxon
     * 
     * Syntax: <code>xslt-saxon:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XsltSaxonEndpointBuilderFactory.XsltSaxonEndpointBuilder xsltSaxon(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XsltSaxonEndpointBuilderFactory.endpointBuilder("xslt-saxon", path);
    }
    /**
     * XSLT Saxon (camel-xslt-saxon)
     * Transform XML payloads using an XSLT template using Saxon.
     * 
     * Category: core,transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xslt-saxon
     * 
     * Syntax: <code>xslt-saxon:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the template. The following is supported by the default
     * URIResolver. You can prefix with: classpath, file, http, ref, or bean.
     * classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path resourceUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.XsltSaxonEndpointBuilderFactory.XsltSaxonEndpointBuilder xsltSaxon(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.XsltSaxonEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Zeebe (camel-zeebe)
     * Workflow processes with Camunda Zeebe
     * 
     * Category: process
     * Since: 3.21
     * Maven coordinates: org.apache.camel:camel-zeebe
     * 
     * Syntax: <code>zeebe:operationName</code>
     * 
     * Path parameter: operationName (required)
     * The operation to use
     * There are 9 enums and the value can be one of: startProcess,
     * cancelProcess, publishMessage, completeJob, failJob, updateJobRetries,
     * worker, throwError, deployResource
     * 
     * @param path operationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZeebeEndpointBuilderFactory.ZeebeEndpointBuilder zeebe(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZeebeEndpointBuilderFactory.endpointBuilder("zeebe", path);
    }
    /**
     * Zeebe (camel-zeebe)
     * Workflow processes with Camunda Zeebe
     * 
     * Category: process
     * Since: 3.21
     * Maven coordinates: org.apache.camel:camel-zeebe
     * 
     * Syntax: <code>zeebe:operationName</code>
     * 
     * Path parameter: operationName (required)
     * The operation to use
     * There are 9 enums and the value can be one of: startProcess,
     * cancelProcess, publishMessage, completeJob, failJob, updateJobRetries,
     * worker, throwError, deployResource
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path operationName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZeebeEndpointBuilderFactory.ZeebeEndpointBuilder zeebe(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZeebeEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * Zendesk (camel-zendesk)
     * Manage Zendesk tickets, users, organizations, etc.
     * 
     * Category: cloud,api,support
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zendesk
     * 
     * Syntax: <code>zendesk:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to use
     * There are 355 enums and the value can be one of:
     * ADD_TAG_TO_ORGANISATIONS, ADD_TAG_TO_TICKET, ADD_TAG_TO_TOPICS,
     * ASSOCIATE_ATTACHMENTS_TO_ARTICLE, CHANGE_USER_PASSWORD, CREATE_ARTICLE,
     * CREATE_ARTICLE_1, CREATE_ARTICLE_TRANSLATION, CREATE_AUTOMATION,
     * CREATE_CATEGORY, CREATE_CATEGORY_TRANSLATION, CREATE_COMMENT,
     * CREATE_DYNAMIC_CONTENT_ITEM, CREATE_DYNAMIC_CONTENT_ITEM_VARIANT,
     * CREATE_FORUM, CREATE_GROUP, CREATE_GROUP_MEMBERSHIP,
     * CREATE_GROUP_MEMBERSHIP_1, CREATE_MACRO, CREATE_OR_UPDATE_USER,
     * CREATE_OR_UPDATE_USERS, CREATE_OR_UPDATE_USERS_1,
     * CREATE_OR_UPDATE_USERS_ASYNC, CREATE_ORGANIZATION,
     * CREATE_ORGANIZATION_MEMBERSHIP, CREATE_ORGANIZATION_MEMBERSHIP_1,
     * CREATE_ORGANIZATION_MEMBERSHIPS, CREATE_ORGANIZATION_MEMBERSHIPS_1,
     * CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC, CREATE_ORGANIZATIONS,
     * CREATE_ORGANIZATIONS_1, CREATE_ORGANIZATIONS_ASYNC,
     * CREATE_PERMISSION_GROUP, CREATE_REQUEST, CREATE_SATISFACTION_RATING,
     * CREATE_SATISFACTION_RATING_1, CREATE_SECTION, CREATE_SECTION_TRANSLATION,
     * CREATE_TARGET, CREATE_TICKET, CREATE_TICKET_ASYNC, CREATE_TICKET_FIELD,
     * CREATE_TICKET_FORM, CREATE_TICKET_FROM_TWEET, CREATE_TICKETS,
     * CREATE_TICKETS_1, CREATE_TICKETS_ASYNC, CREATE_TOPIC, CREATE_TRIGGER,
     * CREATE_UPLOAD, CREATE_UPLOAD_1, CREATE_UPLOAD_2, CREATE_UPLOAD_ARTICLE,
     * CREATE_UPLOAD_ARTICLE_1, CREATE_USER, CREATE_USER_IDENTITY,
     * CREATE_USER_IDENTITY_1, CREATE_USER_SEGMENT, CREATE_USERS,
     * CREATE_USERS_1, CREATE_USERS_ASYNC, DELETE_ARTICLE,
     * DELETE_ARTICLE_ATTACHMENT, DELETE_ARTICLE_ATTACHMENT_1,
     * DELETE_ATTACHMENT, DELETE_ATTACHMENT_1, DELETE_AUTOMATION,
     * DELETE_CATEGORY, DELETE_DYNAMIC_CONTENT_ITEM,
     * DELETE_DYNAMIC_CONTENT_ITEM_VARIANT, DELETE_FORUM, DELETE_GROUP,
     * DELETE_GROUP_1, DELETE_GROUP_MEMBERSHIP, DELETE_GROUP_MEMBERSHIP_1,
     * DELETE_GROUP_MEMBERSHIP_2, DELETE_GROUP_MEMBERSHIP_3,
     * DELETE_ORGANIZATION, DELETE_ORGANIZATION_1,
     * DELETE_ORGANIZATION_MEMBERSHIP, DELETE_ORGANIZATION_MEMBERSHIP_1,
     * DELETE_ORGANIZATION_MEMBERSHIP_2, DELETE_ORGANIZATION_MEMBERSHIPS,
     * DELETE_PERMISSION_GROUP, DELETE_PERMISSION_GROUP_1, DELETE_SECTION,
     * DELETE_SUSPENDED_TICKET, DELETE_SUSPENDED_TICKET_1, DELETE_TARGET,
     * DELETE_TICKET, DELETE_TICKET_1, DELETE_TICKET_FIELD,
     * DELETE_TICKET_FIELD_1, DELETE_TICKET_FORM, DELETE_TICKET_FORM_1,
     * DELETE_TICKETS, DELETE_TOPIC, DELETE_TRANSLATION, DELETE_TRANSLATION_1,
     * DELETE_TRIGGER, DELETE_UPLOAD, DELETE_UPLOAD_1, DELETE_USER,
     * DELETE_USER_1, DELETE_USER_IDENTITY, DELETE_USER_IDENTITY_1,
     * DELETE_USER_IDENTITY_2, DELETE_USER_SEGMENT, DELETE_USER_SEGMENT_1,
     * GET_ACTIVE_TRIGGERS, GET_ARTICLE, GET_ARTICLE_FROM_SEARCH,
     * GET_ARTICLE_FROM_SEARCH_1, GET_ARTICLE_SUBSCRIPTIONS,
     * GET_ARTICLE_SUBSCRIPTIONS_1, GET_ARTICLE_TRANSLATIONS, GET_ARTICLES,
     * GET_ARTICLES_1, GET_ARTICLES_2, GET_ARTICLES_3,
     * GET_ARTICLES_FROM_ALL_LABELS, GET_ARTICLES_FROM_ANY_LABELS,
     * GET_ARTICLES_FROM_PAGE, GET_ARTICLES_INCREMENTALLY,
     * GET_ASSIGNABLE_GROUP_MEMBERSHIPS, GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1,
     * GET_ASSIGNABLE_GROUPS, GET_ASSIGNED_TICKETS_COUNT_FOR_USER,
     * GET_ATTACHMENT, GET_ATTACHMENT_1, GET_ATTACHMENTS_FROM_ARTICLE,
     * GET_AUTHENTICATED_USER, GET_AUTO_COMPLETE_ORGANIZATIONS, GET_AUTOMATION,
     * GET_AUTOMATIONS, GET_BRANDS, GET_CC_REQUESTS, GET_CATEGORIES,
     * GET_CATEGORY, GET_CATEGORY_TRANSLATIONS, GET_CCD_TICKETS_COUNT_FOR_USER,
     * GET_COMPLIANCE_DELETION_STATUSES, GET_CURRENT_USER,
     * GET_CUSTOM_AGENT_ROLES, GET_DELETED_TICKETS, GET_DELETED_TICKETS_1,
     * GET_DYNAMIC_CONTENT_ITEM, GET_DYNAMIC_CONTENT_ITEM_VARIANT,
     * GET_DYNAMIC_CONTENT_ITEM_VARIANTS, GET_DYNAMIC_CONTENT_ITEMS, GET_FORUM,
     * GET_FORUMS, GET_FORUMS_1, GET_GROUP, GET_GROUP_MEMBERSHIP,
     * GET_GROUP_MEMBERSHIP_1, GET_GROUP_MEMBERSHIP_BY_USER,
     * GET_GROUP_MEMBERSHIPS, GET_GROUP_MEMBERSHIPS_1, GET_GROUP_ORGANIZATION,
     * GET_GROUP_USERS, GET_GROUPS, GET_HELP_CENTER_LOCALES,
     * GET_HOLIDAYS_FOR_SCHEDULE, GET_HOLIDAYS_FOR_SCHEDULE_1,
     * GET_INCREMENTAL_TICKETS_RESULT, GET_JOB_STATUS, GET_JOB_STATUS_ASYNC,
     * GET_JOB_STATUSES, GET_JOB_STATUSES_ASYNC, GET_MACRO, GET_MACROS,
     * GET_OPEN_REQUESTS, GET_ORGANIZATION, GET_ORGANIZATION_FIELDS,
     * GET_ORGANIZATION_MEMBERSHIP, GET_ORGANIZATION_MEMBERSHIP_BY_USER,
     * GET_ORGANIZATION_MEMBERSHIP_FOR_USER, GET_ORGANIZATION_MEMBERSHIPS,
     * GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG,
     * GET_ORGANIZATION_MEMBERSHIPS_FOR_USER, GET_ORGANIZATION_REQUESTS,
     * GET_ORGANIZATION_TICKETS, GET_ORGANIZATION_USERS, GET_ORGANIZATIONS,
     * GET_ORGANIZATIONS_1, GET_ORGANIZATIONS_INCREMENTALLY,
     * GET_PERMISSION_GROUP, GET_PERMISSION_GROUPS, GET_RECENT_TICKETS,
     * GET_REQUEST, GET_REQUEST_COMMENT, GET_REQUEST_COMMENT_1,
     * GET_REQUEST_COMMENT_2, GET_REQUEST_COMMENTS, GET_REQUEST_COMMENTS_1,
     * GET_REQUESTS, GET_SATISFACTION_RATING, GET_SATISFACTION_RATINGS,
     * GET_SCHEDULE, GET_SCHEDULE_1, GET_SCHEDULES, GET_SEARCH_TICKET_RESULTS,
     * GET_SECTION, GET_SECTION_SUBSCRIPTIONS, GET_SECTION_SUBSCRIPTIONS_1,
     * GET_SECTION_TRANSLATIONS, GET_SECTIONS, GET_SECTIONS_1, GET_SECTIONS_2,
     * GET_SOLVED_REQUESTS, GET_SUSPENDED_TICKETS, GET_TARGET, GET_TARGETS,
     * GET_TICKET, GET_TICKET_AUDIT, GET_TICKET_AUDIT_1, GET_TICKET_AUDIT_2,
     * GET_TICKET_AUDITS, GET_TICKET_AUDITS_1, GET_TICKET_COLLABORATORS,
     * GET_TICKET_COMMENTS, GET_TICKET_COMMENTS_1, GET_TICKET_FIELD,
     * GET_TICKET_FIELDS, GET_TICKET_FORM, GET_TICKET_FORMS,
     * GET_TICKET_INCIDENTS, GET_TICKET_METRIC, GET_TICKET_METRIC_BY_TICKET,
     * GET_TICKET_METRICS, GET_TICKETS, GET_TICKETS_1,
     * GET_TICKETS_BY_EXTERNAL_ID, GET_TICKETS_BY_EXTERNAL_ID_1,
     * GET_TICKETS_COUNT, GET_TICKETS_COUNT_FOR_ORGANIZATION,
     * GET_TICKETS_FROM_SEARCH, GET_TICKETS_INCREMENTALLY,
     * GET_TICKETS_INCREMENTALLY_1, GET_TOPIC, GET_TOPICS, GET_TOPICS_1,
     * GET_TOPICS_2, GET_TOPICS_3, GET_TOPICS_BY_USER, GET_TRIGGER,
     * GET_TRIGGERS, GET_TRIGGERS_1, GET_TWITTER_MONITORS, GET_USER,
     * GET_USER_CCD_TICKETS, GET_USER_FIELDS, GET_USER_IDENTITIES,
     * GET_USER_IDENTITIES_1, GET_USER_IDENTITY, GET_USER_IDENTITY_1,
     * GET_USER_IDENTITY_2, GET_USER_RELATED_INFO, GET_USER_REQUESTED_TICKETS,
     * GET_USER_REQUESTS, GET_USER_REQUESTS_1, GET_USER_SEGMENT,
     * GET_USER_SEGMENTS, GET_USER_SEGMENTS_1, GET_USER_SEGMENTS_APPLICABLE,
     * GET_USER_SUBSCRIPTIONS, GET_USER_SUBSCRIPTIONS_1, GET_USERS, GET_USERS_1,
     * GET_USERS_BY_EXTERNAL_IDS, GET_USERS_BY_ROLE, GET_USERS_INCREMENTALLY,
     * GET_VIEW, GET_VIEWS, IMPORT_TICKET, IMPORT_TOPIC,
     * LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID, LOOKUP_USER_BY_EMAIL,
     * LOOKUP_USER_BY_EXTERNAL_ID, MACROS_SHOW_CHANGES_TO_TICKET,
     * MACROS_SHOW_TICKET_AFTER_CHANGES, MAKE_PRIVATE_TICKET_AUDIT,
     * MAKE_PRIVATE_TICKET_AUDIT_1, MAKE_PRIVATE_TICKET_AUDIT_2,
     * MARK_TICKET_AS_SPAM, MARK_TICKET_AS_SPAM_1, MERGE_USERS, NOTIFY_APP,
     * PERMANENTLY_DELETE_TICKET, PERMANENTLY_DELETE_TICKET_1,
     * PERMANENTLY_DELETE_TICKETS, PERMANENTLY_DELETE_USER,
     * PERMANENTLY_DELETE_USER_1, QUEUE_CREATE_TICKET_ASYNC,
     * REMOVE_TAG_FROM_ORGANISATIONS, REMOVE_TAG_FROM_TICKET,
     * REMOVE_TAG_FROM_TOPICS, REQUEST_VERIFY_USER_IDENTITY,
     * REQUEST_VERIFY_USER_IDENTITY_1, REQUEST_VERIFY_USER_IDENTITY_2,
     * RESET_USER_PASSWORD, RESET_USER_PASSWORD_1, SEARCH_TRIGGERS,
     * SEARCH_TRIGGERS_1, SET_GROUP_MEMBERSHIP_AS_DEFAULT,
     * SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT, SET_TAG_ON_ORGANISATIONS,
     * SET_TAG_ON_TICKET, SET_TAG_ON_TOPICS, SET_USER_PRIMARY_IDENTITY,
     * SET_USER_PRIMARY_IDENTITY_1, SET_USER_PRIMARY_IDENTITY_2, SUSPEND_USER,
     * TRUST_TICKET_AUDIT, TRUST_TICKET_AUDIT_1, TRUST_TICKET_AUDIT_2,
     * UNSUSPEND_USER, UPDATE_ARTICLE, UPDATE_ARTICLE_TRANSLATION,
     * UPDATE_AUTOMATION, UPDATE_CATEGORY, UPDATE_CATEGORY_TRANSLATION,
     * UPDATE_DYNAMIC_CONTENT_ITEM, UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT,
     * UPDATE_FORUM, UPDATE_GROUP, UPDATE_INSTALLATION, UPDATE_MACRO,
     * UPDATE_ORGANIZATION, UPDATE_ORGANIZATIONS, UPDATE_ORGANIZATIONS_1,
     * UPDATE_ORGANIZATIONS_ASYNC, UPDATE_PERMISSION_GROUP, UPDATE_REQUEST,
     * UPDATE_SECTION, UPDATE_SECTION_TRANSLATION, UPDATE_TICKET,
     * UPDATE_TICKET_FIELD, UPDATE_TICKET_FORM, UPDATE_TICKETS,
     * UPDATE_TICKETS_1, UPDATE_TICKETS_ASYNC, UPDATE_TOPIC, UPDATE_TRIGGER,
     * UPDATE_USER, UPDATE_USER_IDENTITY, UPDATE_USER_IDENTITY_1,
     * UPDATE_USER_SEGMENT, UPDATE_USERS, UPDATE_USERS_1, UPDATE_USERS_ASYNC,
     * VERIFY_USER_IDENTITY, VERIFY_USER_IDENTITY_1, VERIFY_USER_IDENTITY_2
     * 
     * @param path methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZendeskEndpointBuilderFactory.ZendeskEndpointBuilder zendesk(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZendeskEndpointBuilderFactory.endpointBuilder("zendesk", path);
    }
    /**
     * Zendesk (camel-zendesk)
     * Manage Zendesk tickets, users, organizations, etc.
     * 
     * Category: cloud,api,support
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zendesk
     * 
     * Syntax: <code>zendesk:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to use
     * There are 355 enums and the value can be one of:
     * ADD_TAG_TO_ORGANISATIONS, ADD_TAG_TO_TICKET, ADD_TAG_TO_TOPICS,
     * ASSOCIATE_ATTACHMENTS_TO_ARTICLE, CHANGE_USER_PASSWORD, CREATE_ARTICLE,
     * CREATE_ARTICLE_1, CREATE_ARTICLE_TRANSLATION, CREATE_AUTOMATION,
     * CREATE_CATEGORY, CREATE_CATEGORY_TRANSLATION, CREATE_COMMENT,
     * CREATE_DYNAMIC_CONTENT_ITEM, CREATE_DYNAMIC_CONTENT_ITEM_VARIANT,
     * CREATE_FORUM, CREATE_GROUP, CREATE_GROUP_MEMBERSHIP,
     * CREATE_GROUP_MEMBERSHIP_1, CREATE_MACRO, CREATE_OR_UPDATE_USER,
     * CREATE_OR_UPDATE_USERS, CREATE_OR_UPDATE_USERS_1,
     * CREATE_OR_UPDATE_USERS_ASYNC, CREATE_ORGANIZATION,
     * CREATE_ORGANIZATION_MEMBERSHIP, CREATE_ORGANIZATION_MEMBERSHIP_1,
     * CREATE_ORGANIZATION_MEMBERSHIPS, CREATE_ORGANIZATION_MEMBERSHIPS_1,
     * CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC, CREATE_ORGANIZATIONS,
     * CREATE_ORGANIZATIONS_1, CREATE_ORGANIZATIONS_ASYNC,
     * CREATE_PERMISSION_GROUP, CREATE_REQUEST, CREATE_SATISFACTION_RATING,
     * CREATE_SATISFACTION_RATING_1, CREATE_SECTION, CREATE_SECTION_TRANSLATION,
     * CREATE_TARGET, CREATE_TICKET, CREATE_TICKET_ASYNC, CREATE_TICKET_FIELD,
     * CREATE_TICKET_FORM, CREATE_TICKET_FROM_TWEET, CREATE_TICKETS,
     * CREATE_TICKETS_1, CREATE_TICKETS_ASYNC, CREATE_TOPIC, CREATE_TRIGGER,
     * CREATE_UPLOAD, CREATE_UPLOAD_1, CREATE_UPLOAD_2, CREATE_UPLOAD_ARTICLE,
     * CREATE_UPLOAD_ARTICLE_1, CREATE_USER, CREATE_USER_IDENTITY,
     * CREATE_USER_IDENTITY_1, CREATE_USER_SEGMENT, CREATE_USERS,
     * CREATE_USERS_1, CREATE_USERS_ASYNC, DELETE_ARTICLE,
     * DELETE_ARTICLE_ATTACHMENT, DELETE_ARTICLE_ATTACHMENT_1,
     * DELETE_ATTACHMENT, DELETE_ATTACHMENT_1, DELETE_AUTOMATION,
     * DELETE_CATEGORY, DELETE_DYNAMIC_CONTENT_ITEM,
     * DELETE_DYNAMIC_CONTENT_ITEM_VARIANT, DELETE_FORUM, DELETE_GROUP,
     * DELETE_GROUP_1, DELETE_GROUP_MEMBERSHIP, DELETE_GROUP_MEMBERSHIP_1,
     * DELETE_GROUP_MEMBERSHIP_2, DELETE_GROUP_MEMBERSHIP_3,
     * DELETE_ORGANIZATION, DELETE_ORGANIZATION_1,
     * DELETE_ORGANIZATION_MEMBERSHIP, DELETE_ORGANIZATION_MEMBERSHIP_1,
     * DELETE_ORGANIZATION_MEMBERSHIP_2, DELETE_ORGANIZATION_MEMBERSHIPS,
     * DELETE_PERMISSION_GROUP, DELETE_PERMISSION_GROUP_1, DELETE_SECTION,
     * DELETE_SUSPENDED_TICKET, DELETE_SUSPENDED_TICKET_1, DELETE_TARGET,
     * DELETE_TICKET, DELETE_TICKET_1, DELETE_TICKET_FIELD,
     * DELETE_TICKET_FIELD_1, DELETE_TICKET_FORM, DELETE_TICKET_FORM_1,
     * DELETE_TICKETS, DELETE_TOPIC, DELETE_TRANSLATION, DELETE_TRANSLATION_1,
     * DELETE_TRIGGER, DELETE_UPLOAD, DELETE_UPLOAD_1, DELETE_USER,
     * DELETE_USER_1, DELETE_USER_IDENTITY, DELETE_USER_IDENTITY_1,
     * DELETE_USER_IDENTITY_2, DELETE_USER_SEGMENT, DELETE_USER_SEGMENT_1,
     * GET_ACTIVE_TRIGGERS, GET_ARTICLE, GET_ARTICLE_FROM_SEARCH,
     * GET_ARTICLE_FROM_SEARCH_1, GET_ARTICLE_SUBSCRIPTIONS,
     * GET_ARTICLE_SUBSCRIPTIONS_1, GET_ARTICLE_TRANSLATIONS, GET_ARTICLES,
     * GET_ARTICLES_1, GET_ARTICLES_2, GET_ARTICLES_3,
     * GET_ARTICLES_FROM_ALL_LABELS, GET_ARTICLES_FROM_ANY_LABELS,
     * GET_ARTICLES_FROM_PAGE, GET_ARTICLES_INCREMENTALLY,
     * GET_ASSIGNABLE_GROUP_MEMBERSHIPS, GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1,
     * GET_ASSIGNABLE_GROUPS, GET_ASSIGNED_TICKETS_COUNT_FOR_USER,
     * GET_ATTACHMENT, GET_ATTACHMENT_1, GET_ATTACHMENTS_FROM_ARTICLE,
     * GET_AUTHENTICATED_USER, GET_AUTO_COMPLETE_ORGANIZATIONS, GET_AUTOMATION,
     * GET_AUTOMATIONS, GET_BRANDS, GET_CC_REQUESTS, GET_CATEGORIES,
     * GET_CATEGORY, GET_CATEGORY_TRANSLATIONS, GET_CCD_TICKETS_COUNT_FOR_USER,
     * GET_COMPLIANCE_DELETION_STATUSES, GET_CURRENT_USER,
     * GET_CUSTOM_AGENT_ROLES, GET_DELETED_TICKETS, GET_DELETED_TICKETS_1,
     * GET_DYNAMIC_CONTENT_ITEM, GET_DYNAMIC_CONTENT_ITEM_VARIANT,
     * GET_DYNAMIC_CONTENT_ITEM_VARIANTS, GET_DYNAMIC_CONTENT_ITEMS, GET_FORUM,
     * GET_FORUMS, GET_FORUMS_1, GET_GROUP, GET_GROUP_MEMBERSHIP,
     * GET_GROUP_MEMBERSHIP_1, GET_GROUP_MEMBERSHIP_BY_USER,
     * GET_GROUP_MEMBERSHIPS, GET_GROUP_MEMBERSHIPS_1, GET_GROUP_ORGANIZATION,
     * GET_GROUP_USERS, GET_GROUPS, GET_HELP_CENTER_LOCALES,
     * GET_HOLIDAYS_FOR_SCHEDULE, GET_HOLIDAYS_FOR_SCHEDULE_1,
     * GET_INCREMENTAL_TICKETS_RESULT, GET_JOB_STATUS, GET_JOB_STATUS_ASYNC,
     * GET_JOB_STATUSES, GET_JOB_STATUSES_ASYNC, GET_MACRO, GET_MACROS,
     * GET_OPEN_REQUESTS, GET_ORGANIZATION, GET_ORGANIZATION_FIELDS,
     * GET_ORGANIZATION_MEMBERSHIP, GET_ORGANIZATION_MEMBERSHIP_BY_USER,
     * GET_ORGANIZATION_MEMBERSHIP_FOR_USER, GET_ORGANIZATION_MEMBERSHIPS,
     * GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG,
     * GET_ORGANIZATION_MEMBERSHIPS_FOR_USER, GET_ORGANIZATION_REQUESTS,
     * GET_ORGANIZATION_TICKETS, GET_ORGANIZATION_USERS, GET_ORGANIZATIONS,
     * GET_ORGANIZATIONS_1, GET_ORGANIZATIONS_INCREMENTALLY,
     * GET_PERMISSION_GROUP, GET_PERMISSION_GROUPS, GET_RECENT_TICKETS,
     * GET_REQUEST, GET_REQUEST_COMMENT, GET_REQUEST_COMMENT_1,
     * GET_REQUEST_COMMENT_2, GET_REQUEST_COMMENTS, GET_REQUEST_COMMENTS_1,
     * GET_REQUESTS, GET_SATISFACTION_RATING, GET_SATISFACTION_RATINGS,
     * GET_SCHEDULE, GET_SCHEDULE_1, GET_SCHEDULES, GET_SEARCH_TICKET_RESULTS,
     * GET_SECTION, GET_SECTION_SUBSCRIPTIONS, GET_SECTION_SUBSCRIPTIONS_1,
     * GET_SECTION_TRANSLATIONS, GET_SECTIONS, GET_SECTIONS_1, GET_SECTIONS_2,
     * GET_SOLVED_REQUESTS, GET_SUSPENDED_TICKETS, GET_TARGET, GET_TARGETS,
     * GET_TICKET, GET_TICKET_AUDIT, GET_TICKET_AUDIT_1, GET_TICKET_AUDIT_2,
     * GET_TICKET_AUDITS, GET_TICKET_AUDITS_1, GET_TICKET_COLLABORATORS,
     * GET_TICKET_COMMENTS, GET_TICKET_COMMENTS_1, GET_TICKET_FIELD,
     * GET_TICKET_FIELDS, GET_TICKET_FORM, GET_TICKET_FORMS,
     * GET_TICKET_INCIDENTS, GET_TICKET_METRIC, GET_TICKET_METRIC_BY_TICKET,
     * GET_TICKET_METRICS, GET_TICKETS, GET_TICKETS_1,
     * GET_TICKETS_BY_EXTERNAL_ID, GET_TICKETS_BY_EXTERNAL_ID_1,
     * GET_TICKETS_COUNT, GET_TICKETS_COUNT_FOR_ORGANIZATION,
     * GET_TICKETS_FROM_SEARCH, GET_TICKETS_INCREMENTALLY,
     * GET_TICKETS_INCREMENTALLY_1, GET_TOPIC, GET_TOPICS, GET_TOPICS_1,
     * GET_TOPICS_2, GET_TOPICS_3, GET_TOPICS_BY_USER, GET_TRIGGER,
     * GET_TRIGGERS, GET_TRIGGERS_1, GET_TWITTER_MONITORS, GET_USER,
     * GET_USER_CCD_TICKETS, GET_USER_FIELDS, GET_USER_IDENTITIES,
     * GET_USER_IDENTITIES_1, GET_USER_IDENTITY, GET_USER_IDENTITY_1,
     * GET_USER_IDENTITY_2, GET_USER_RELATED_INFO, GET_USER_REQUESTED_TICKETS,
     * GET_USER_REQUESTS, GET_USER_REQUESTS_1, GET_USER_SEGMENT,
     * GET_USER_SEGMENTS, GET_USER_SEGMENTS_1, GET_USER_SEGMENTS_APPLICABLE,
     * GET_USER_SUBSCRIPTIONS, GET_USER_SUBSCRIPTIONS_1, GET_USERS, GET_USERS_1,
     * GET_USERS_BY_EXTERNAL_IDS, GET_USERS_BY_ROLE, GET_USERS_INCREMENTALLY,
     * GET_VIEW, GET_VIEWS, IMPORT_TICKET, IMPORT_TOPIC,
     * LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID, LOOKUP_USER_BY_EMAIL,
     * LOOKUP_USER_BY_EXTERNAL_ID, MACROS_SHOW_CHANGES_TO_TICKET,
     * MACROS_SHOW_TICKET_AFTER_CHANGES, MAKE_PRIVATE_TICKET_AUDIT,
     * MAKE_PRIVATE_TICKET_AUDIT_1, MAKE_PRIVATE_TICKET_AUDIT_2,
     * MARK_TICKET_AS_SPAM, MARK_TICKET_AS_SPAM_1, MERGE_USERS, NOTIFY_APP,
     * PERMANENTLY_DELETE_TICKET, PERMANENTLY_DELETE_TICKET_1,
     * PERMANENTLY_DELETE_TICKETS, PERMANENTLY_DELETE_USER,
     * PERMANENTLY_DELETE_USER_1, QUEUE_CREATE_TICKET_ASYNC,
     * REMOVE_TAG_FROM_ORGANISATIONS, REMOVE_TAG_FROM_TICKET,
     * REMOVE_TAG_FROM_TOPICS, REQUEST_VERIFY_USER_IDENTITY,
     * REQUEST_VERIFY_USER_IDENTITY_1, REQUEST_VERIFY_USER_IDENTITY_2,
     * RESET_USER_PASSWORD, RESET_USER_PASSWORD_1, SEARCH_TRIGGERS,
     * SEARCH_TRIGGERS_1, SET_GROUP_MEMBERSHIP_AS_DEFAULT,
     * SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT, SET_TAG_ON_ORGANISATIONS,
     * SET_TAG_ON_TICKET, SET_TAG_ON_TOPICS, SET_USER_PRIMARY_IDENTITY,
     * SET_USER_PRIMARY_IDENTITY_1, SET_USER_PRIMARY_IDENTITY_2, SUSPEND_USER,
     * TRUST_TICKET_AUDIT, TRUST_TICKET_AUDIT_1, TRUST_TICKET_AUDIT_2,
     * UNSUSPEND_USER, UPDATE_ARTICLE, UPDATE_ARTICLE_TRANSLATION,
     * UPDATE_AUTOMATION, UPDATE_CATEGORY, UPDATE_CATEGORY_TRANSLATION,
     * UPDATE_DYNAMIC_CONTENT_ITEM, UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT,
     * UPDATE_FORUM, UPDATE_GROUP, UPDATE_INSTALLATION, UPDATE_MACRO,
     * UPDATE_ORGANIZATION, UPDATE_ORGANIZATIONS, UPDATE_ORGANIZATIONS_1,
     * UPDATE_ORGANIZATIONS_ASYNC, UPDATE_PERMISSION_GROUP, UPDATE_REQUEST,
     * UPDATE_SECTION, UPDATE_SECTION_TRANSLATION, UPDATE_TICKET,
     * UPDATE_TICKET_FIELD, UPDATE_TICKET_FORM, UPDATE_TICKETS,
     * UPDATE_TICKETS_1, UPDATE_TICKETS_ASYNC, UPDATE_TOPIC, UPDATE_TRIGGER,
     * UPDATE_USER, UPDATE_USER_IDENTITY, UPDATE_USER_IDENTITY_1,
     * UPDATE_USER_SEGMENT, UPDATE_USERS, UPDATE_USERS_1, UPDATE_USERS_ASYNC,
     * VERIFY_USER_IDENTITY, VERIFY_USER_IDENTITY_1, VERIFY_USER_IDENTITY_2
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path methodName
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZendeskEndpointBuilderFactory.ZendeskEndpointBuilder zendesk(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZendeskEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * ZooKeeper (camel-zookeeper)
     * Manage ZooKeeper clusters.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     * 
     * Syntax: <code>zookeeper:serverUrls/path</code>
     * 
     * Path parameter: serverUrls (required)
     * The zookeeper server hosts (multiple servers can be separated by comma)
     * 
     * Path parameter: path (required)
     * The node in the ZooKeeper server (aka znode)
     * 
     * @param path serverUrls/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZooKeeperEndpointBuilderFactory.ZooKeeperEndpointBuilder zookeeper(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZooKeeperEndpointBuilderFactory.endpointBuilder("zookeeper", path);
    }
    /**
     * ZooKeeper (camel-zookeeper)
     * Manage ZooKeeper clusters.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     * 
     * Syntax: <code>zookeeper:serverUrls/path</code>
     * 
     * Path parameter: serverUrls (required)
     * The zookeeper server hosts (multiple servers can be separated by comma)
     * 
     * Path parameter: path (required)
     * The node in the ZooKeeper server (aka znode)
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path serverUrls/path
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZooKeeperEndpointBuilderFactory.ZooKeeperEndpointBuilder zookeeper(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZooKeeperEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
    /**
     * ZooKeeper Master (camel-zookeeper-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zookeeper-master
     * 
     * Syntax: <code>zookeeper-master:groupName:consumerEndpointUri</code>
     * 
     * Path parameter: groupName (required)
     * The name of the cluster group to use
     * 
     * Path parameter: consumerEndpointUri (required)
     * The consumer endpoint to use in master/slave mode
     * 
     * @param path groupName:consumerEndpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZooKeeperMasterEndpointBuilderFactory.ZooKeeperMasterEndpointBuilder zookeeperMaster(
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZooKeeperMasterEndpointBuilderFactory.endpointBuilder("zookeeper-master", path);
    }
    /**
     * ZooKeeper Master (camel-zookeeper-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zookeeper-master
     * 
     * Syntax: <code>zookeeper-master:groupName:consumerEndpointUri</code>
     * 
     * Path parameter: groupName (required)
     * The name of the cluster group to use
     * 
     * Path parameter: consumerEndpointUri (required)
     * The consumer endpoint to use in master/slave mode
     * 
     * @param componentName to use a custom component name for the endpoint
     * instead of the default name
     * @param path groupName:consumerEndpointUri
     * @return the dsl builder
     */
    public static org.apache.camel.builder.endpoint.dsl.ZooKeeperMasterEndpointBuilderFactory.ZooKeeperMasterEndpointBuilder zookeeperMaster(
            String componentName,
            String path) {
        return org.apache.camel.builder.endpoint.dsl.ZooKeeperMasterEndpointBuilderFactory.endpointBuilder(componentName, path);
    }
}
//CHECKSTYLE:ON