/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from RocketMQ cluster.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RocketMQEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the RocketMQ component.
     */
    public interface RocketMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRocketMQEndpointConsumerBuilder advanced() {
            return (AdvancedRocketMQEndpointConsumerBuilder) this;
        }
        /**
         * Name server address of RocketMQ cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:9876
         * Group: common
         * 
         * @param namesrvAddr the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointConsumerBuilder namesrvAddr(String namesrvAddr) {
            doSetProperty("namesrvAddr", namesrvAddr);
            return this;
        }
        /**
         * Consumer group name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerGroup the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointConsumerBuilder consumerGroup(
                String consumerGroup) {
            doSetProperty("consumerGroup", consumerGroup);
            return this;
        }
        /**
         * Subscribe tags of consumer. Multiple tags could be split by , such as
         * TagATagB.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: consumer
         * 
         * @param subscribeTags the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointConsumerBuilder subscribeTags(
                String subscribeTags) {
            doSetProperty("subscribeTags", subscribeTags);
            return this;
        }
        /**
         * Access key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Secret key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the RocketMQ component.
     */
    public interface AdvancedRocketMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RocketMQEndpointConsumerBuilder basic() {
            return (RocketMQEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder requestTimeoutCheckerIntervalMillis(
                long requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder requestTimeoutCheckerIntervalMillis(
                String requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder requestTimeoutMillis(
                long requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointConsumerBuilder requestTimeoutMillis(
                String requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the RocketMQ component.
     */
    public interface RocketMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRocketMQEndpointProducerBuilder advanced() {
            return (AdvancedRocketMQEndpointProducerBuilder) this;
        }
        /**
         * Name server address of RocketMQ cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:9876
         * Group: common
         * 
         * @param namesrvAddr the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder namesrvAddr(String namesrvAddr) {
            doSetProperty("namesrvAddr", namesrvAddr);
            return this;
        }
        /**
         * Producer group name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerGroup the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder producerGroup(
                String producerGroup) {
            doSetProperty("producerGroup", producerGroup);
            return this;
        }
        /**
         * Consumer group name used for receiving response.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToConsumerGroup the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder replyToConsumerGroup(
                String replyToConsumerGroup) {
            doSetProperty("replyToConsumerGroup", replyToConsumerGroup);
            return this;
        }
        /**
         * Topic used for receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToTopic the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder replyToTopic(String replyToTopic) {
            doSetProperty("replyToTopic", replyToTopic);
            return this;
        }
        /**
         * Each message would be sent with this tag.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sendTag the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder sendTag(String sendTag) {
            doSetProperty("sendTag", sendTag);
            return this;
        }
        /**
         * Whether waiting for send result before routing to next endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param waitForSendResult the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder waitForSendResult(
                boolean waitForSendResult) {
            doSetProperty("waitForSendResult", waitForSendResult);
            return this;
        }
        /**
         * Whether waiting for send result before routing to next endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param waitForSendResult the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder waitForSendResult(
                String waitForSendResult) {
            doSetProperty("waitForSendResult", waitForSendResult);
            return this;
        }
        /**
         * Access key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Secret key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the RocketMQ component.
     */
    public interface AdvancedRocketMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RocketMQEndpointProducerBuilder basic() {
            return (RocketMQEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder requestTimeoutCheckerIntervalMillis(
                long requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder requestTimeoutCheckerIntervalMillis(
                String requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder requestTimeoutMillis(
                long requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointProducerBuilder requestTimeoutMillis(
                String requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
    }

    /**
     * Builder for endpoint for the RocketMQ component.
     */
    public interface RocketMQEndpointBuilder
            extends
                RocketMQEndpointConsumerBuilder,
                RocketMQEndpointProducerBuilder {
        default AdvancedRocketMQEndpointBuilder advanced() {
            return (AdvancedRocketMQEndpointBuilder) this;
        }
        /**
         * Name server address of RocketMQ cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:9876
         * Group: common
         * 
         * @param namesrvAddr the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointBuilder namesrvAddr(String namesrvAddr) {
            doSetProperty("namesrvAddr", namesrvAddr);
            return this;
        }
        /**
         * Access key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Secret key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default RocketMQEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the RocketMQ component.
     */
    public interface AdvancedRocketMQEndpointBuilder
            extends
                AdvancedRocketMQEndpointConsumerBuilder,
                AdvancedRocketMQEndpointProducerBuilder {
        default RocketMQEndpointBuilder basic() {
            return (RocketMQEndpointBuilder) this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointBuilder requestTimeoutCheckerIntervalMillis(
                long requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointBuilder requestTimeoutCheckerIntervalMillis(
                String requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointBuilder requestTimeoutMillis(
                long requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default AdvancedRocketMQEndpointBuilder requestTimeoutMillis(
                String requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
    }

    public interface RocketMQBuilders {
        /**
         * RocketMQ (camel-rocketmq)
         * Send and receive messages from RocketMQ cluster.
         * 
         * Category: messaging
         * Since: 3.20
         * Maven coordinates: org.apache.camel:camel-rocketmq
         * 
         * @return the dsl builder for the headers' name.
         */
        default RocketMQHeaderNameBuilder rocketmq() {
            return RocketMQHeaderNameBuilder.INSTANCE;
        }
        /**
         * RocketMQ (camel-rocketmq)
         * Send and receive messages from RocketMQ cluster.
         * 
         * Category: messaging
         * Since: 3.20
         * Maven coordinates: org.apache.camel:camel-rocketmq
         * 
         * Syntax: <code>rocketmq:topicName</code>
         * 
         * Path parameter: topicName (required)
         * Topic name of this endpoint.
         * 
         * @param path topicName
         * @return the dsl builder
         */
        default RocketMQEndpointBuilder rocketmq(String path) {
            return RocketMQEndpointBuilderFactory.endpointBuilder("rocketmq", path);
        }
        /**
         * RocketMQ (camel-rocketmq)
         * Send and receive messages from RocketMQ cluster.
         * 
         * Category: messaging
         * Since: 3.20
         * Maven coordinates: org.apache.camel:camel-rocketmq
         * 
         * Syntax: <code>rocketmq:topicName</code>
         * 
         * Path parameter: topicName (required)
         * Topic name of this endpoint.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topicName
         * @return the dsl builder
         */
        default RocketMQEndpointBuilder rocketmq(
                String componentName,
                String path) {
            return RocketMQEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the RocketMQ component.
     */
    public static class RocketMQHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final RocketMQHeaderNameBuilder INSTANCE = new RocketMQHeaderNameBuilder();

        /**
         * Topic of message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQTopic}.
         */
        public String rockerMQTopic() {
            return "RockerMQTopic";
        }

        /**
         * Tag of message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQTag}.
         */
        public String rockerMQTag() {
            return "RockerMQTag";
        }

        /**
         * Key of message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQKey}.
         */
        public String rockerMQKey() {
            return "RockerMQKey";
        }

        /**
         * If this header is set, the message will be routed to the topic
         * specified by this header instead of the origin topic in endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RockerMQOverrideTopicName}.
         */
        public String rockerMQOverrideTopicName() {
            return "RockerMQOverrideTopicName";
        }

        /**
         * If this header is set, the message's tag will be set to value
         * specified by this header instead of the sendTag defined in endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RockerMQOverrideTag}.
         */
        public String rockerMQOverrideTag() {
            return "RockerMQOverrideTag";
        }

        /**
         * Set keys for the message. When using in-out pattern, the value will
         * be prepended to the generated keys.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RockerMQOverrideMessageKey}.
         */
        public String rockerMQOverrideMessageKey() {
            return "RockerMQOverrideMessageKey";
        }

        /**
         * Broker name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQBrokerName}.
         */
        public String rockerMQBrokerName() {
            return "RockerMQBrokerName";
        }

        /**
         * Queue ID.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQQueueId}.
         */
        public String rockerMQQueueId() {
            return "RockerMQQueueId";
        }

        /**
         * Store size.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQStoreSize}.
         */
        public String rockerMQStoreSize() {
            return "RockerMQStoreSize";
        }

        /**
         * Queue offset.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQQueueOffset}.
         */
        public String rockerMQQueueOffset() {
            return "RockerMQQueueOffset";
        }

        /**
         * Sys flag.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQSysFlag}.
         */
        public String rockerMQSysFlag() {
            return "RockerMQSysFlag";
        }

        /**
         * Born timestamp.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQBornTimestamp}.
         */
        public String rockerMQBornTimestamp() {
            return "RockerMQBornTimestamp";
        }

        /**
         * Born host.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQBornHost}.
         */
        public String rockerMQBornHost() {
            return "RockerMQBornHost";
        }

        /**
         * Store timestamp.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQStoreTimestamp}.
         */
        public String rockerMQStoreTimestamp() {
            return "RockerMQStoreTimestamp";
        }

        /**
         * Store host.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQStoreHost}.
         */
        public String rockerMQStoreHost() {
            return "RockerMQStoreHost";
        }

        /**
         * Msg ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQMsgId}.
         */
        public String rockerMQMsgId() {
            return "RockerMQMsgId";
        }

        /**
         * Commit log offset.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQCommitLogOffset}.
         */
        public String rockerMQCommitLogOffset() {
            return "RockerMQCommitLogOffset";
        }

        /**
         * Body CRC.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQBodyCrc}.
         */
        public String rockerMQBodyCrc() {
            return "RockerMQBodyCrc";
        }

        /**
         * Reconsume times.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code RockerMQReconsumeTimes}.
         */
        public String rockerMQReconsumeTimes() {
            return "RockerMQReconsumeTimes";
        }

        /**
         * Prepard transaction offset.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * RockerMQPreparedTransactionOffset}.
         */
        public String rockerMQPreparedTransactionOffset() {
            return "RockerMQPreparedTransactionOffset";
        }
    }
    static RocketMQEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class RocketMQEndpointBuilderImpl extends AbstractEndpointBuilder implements RocketMQEndpointBuilder, AdvancedRocketMQEndpointBuilder {
            public RocketMQEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new RocketMQEndpointBuilderImpl(path);
    }
}