/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Communicate with Salesforce using Java DTOs.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SalesforceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Salesforce component.
     */
    public interface SalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSalesforceEndpointConsumerBuilder advanced() {
            return (AdvancedSalesforceEndpointConsumerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                Map<java.lang.String, java.lang.Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 54.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder contentType(
                org.apache.camel.component.salesforce.api.dto.bulk.ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder fallBackReplayId(
                Long fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder fallBackReplayId(
                String fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder format(
                org.apache.camel.component.salesforce.internal.PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder httpClient(
                org.apache.camel.component.salesforce.SalesforceHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                Map<java.lang.String, java.lang.Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Locator provided by salesforce Bulk 2.0 API for use in getting
         * results for a Query job.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder locator(String locator) {
            doSetProperty("locator", locator);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxRecords(Integer maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder maxRecords(String maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                org.apache.camel.component.salesforce.NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                com.fasterxml.jackson.databind.ObjectMapper objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunking(Boolean pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunking(String pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunkingChunkSize(
                Integer pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunkingChunkSize(
                String pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Specifies the parent object when you're enabling PK chunking for
         * queries on sharing objects. The chunks are based on the parent
         * object's records rather than the sharing object's records. For
         * example, when querying on AccountShare, specify Account as the parent
         * object. PK chunking is supported for sharing objects as long as the
         * parent object is supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingParent the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunkingParent(
                String pkChunkingParent) {
            doSetProperty("pkChunkingParent", pkChunkingParent);
            return this;
        }
        /**
         * Specifies the 15-character or 18-character record ID to be used as
         * the lower boundary for the first chunk. Use this parameter to specify
         * a starting ID when restarting a job that failed between batches.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingStartRow the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder pkChunkingStartRow(
                String pkChunkingStartRow) {
            doSetProperty("pkChunkingStartRow", pkChunkingStartRow);
            return this;
        }
        /**
         * Query Locator provided by salesforce for use when a query results in
         * more records than can be retrieved in a single call. Use this value
         * in a subsequent call to retrieve additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryLocator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder queryLocator(
                String queryLocator) {
            doSetProperty("queryLocator", queryLocator);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectClass(
                String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectFields(
                String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectIdName(
                String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectIdValue(
                String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectQuery(
                String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder sObjectSearch(
                String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder streamQueryResult(
                Boolean streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder streamQueryResult(
                String streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder updateTopic(
                boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param replayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder replayId(Long replayId) {
            doSetProperty("replayId", replayId);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param replayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointConsumerBuilder replayId(String replayId) {
            doSetProperty("replayId", replayId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SalesforceEndpointConsumerBuilder basic() {
            return (SalesforceEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Salesforce component.
     */
    public interface SalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSalesforceEndpointProducerBuilder advanced() {
            return (AdvancedSalesforceEndpointProducerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                Map<java.lang.String, java.lang.Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 54.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder contentType(
                org.apache.camel.component.salesforce.api.dto.bulk.ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder fallBackReplayId(
                Long fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder fallBackReplayId(
                String fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder format(
                org.apache.camel.component.salesforce.internal.PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder httpClient(
                org.apache.camel.component.salesforce.SalesforceHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                Map<java.lang.String, java.lang.Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Locator provided by salesforce Bulk 2.0 API for use in getting
         * results for a Query job.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder locator(String locator) {
            doSetProperty("locator", locator);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxRecords(Integer maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder maxRecords(String maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                org.apache.camel.component.salesforce.NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                com.fasterxml.jackson.databind.ObjectMapper objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunking(Boolean pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunking(String pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunkingChunkSize(
                Integer pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunkingChunkSize(
                String pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Specifies the parent object when you're enabling PK chunking for
         * queries on sharing objects. The chunks are based on the parent
         * object's records rather than the sharing object's records. For
         * example, when querying on AccountShare, specify Account as the parent
         * object. PK chunking is supported for sharing objects as long as the
         * parent object is supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingParent the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunkingParent(
                String pkChunkingParent) {
            doSetProperty("pkChunkingParent", pkChunkingParent);
            return this;
        }
        /**
         * Specifies the 15-character or 18-character record ID to be used as
         * the lower boundary for the first chunk. Use this parameter to specify
         * a starting ID when restarting a job that failed between batches.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingStartRow the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder pkChunkingStartRow(
                String pkChunkingStartRow) {
            doSetProperty("pkChunkingStartRow", pkChunkingStartRow);
            return this;
        }
        /**
         * Query Locator provided by salesforce for use when a query results in
         * more records than can be retrieved in a single call. Use this value
         * in a subsequent call to retrieve additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryLocator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder queryLocator(
                String queryLocator) {
            doSetProperty("queryLocator", queryLocator);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectClass(
                String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectFields(
                String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectIdName(
                String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectIdValue(
                String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectQuery(
                String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder sObjectSearch(
                String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder streamQueryResult(
                Boolean streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder streamQueryResult(
                String streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder updateTopic(
                boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Composite API option to indicate to rollback all records if any are
         * not successful.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allOrNone the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder allOrNone(boolean allOrNone) {
            doSetProperty("allOrNone", allOrNone);
            return this;
        }
        /**
         * Composite API option to indicate to rollback all records if any are
         * not successful.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allOrNone the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder allOrNone(String allOrNone) {
            doSetProperty("allOrNone", allOrNone);
            return this;
        }
        /**
         * APEX method URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apexUrl the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder apexUrl(String apexUrl) {
            doSetProperty("apexUrl", apexUrl);
            return this;
        }
        /**
         * Composite (raw) method.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param compositeMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder compositeMethod(
                String compositeMethod) {
            doSetProperty("compositeMethod", compositeMethod);
            return this;
        }
        /**
         * Comma separated list of message headers to include as HTTP parameters
         * for Raw operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawHttpHeaders the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawHttpHeaders(
                String rawHttpHeaders) {
            doSetProperty("rawHttpHeaders", rawHttpHeaders);
            return this;
        }
        /**
         * HTTP method to use for the Raw operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawMethod(String rawMethod) {
            doSetProperty("rawMethod", rawMethod);
            return this;
        }
        /**
         * The portion of the endpoint URL after the domain name. E.g.,
         * '/services/data/v52.0/sobjects/Account/'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawPath the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawPath(String rawPath) {
            doSetProperty("rawPath", rawPath);
            return this;
        }
        /**
         * Comma separated list of message headers to include as query
         * parameters for Raw operation. Do not url-encode values as this will
         * be done automatically.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rawQueryParameters the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointProducerBuilder rawQueryParameters(
                String rawQueryParameters) {
            doSetProperty("rawQueryParameters", rawQueryParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SalesforceEndpointProducerBuilder basic() {
            return (SalesforceEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSalesforceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Salesforce component.
     */
    public interface SalesforceEndpointBuilder
            extends
                SalesforceEndpointConsumerBuilder,
                SalesforceEndpointProducerBuilder {
        default AdvancedSalesforceEndpointBuilder advanced() {
            return (AdvancedSalesforceEndpointBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexMethod the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexMethod(String apexMethod) {
            doSetProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexQueryParams(
                Map<java.lang.String, java.lang.Object> apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param apexQueryParams the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apexQueryParams(String apexQueryParams) {
            doSetProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Salesforce API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 54.0
         * Group: common
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder backoffIncrement(long backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param backoffIncrement the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder backoffIncrement(
                String backoffIncrement) {
            doSetProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param batchId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder batchId(String batchId) {
            doSetProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder contentType(
                org.apache.camel.component.salesforce.api.dto.bulk.ContentType contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.bulk.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder defaultReplayId(Long defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param defaultReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder defaultReplayId(String defaultReplayId) {
            doSetProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder fallBackReplayId(Long fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * ReplayId to fall back to after an Invalid Replay Id response.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param fallBackReplayId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder fallBackReplayId(
                String fallBackReplayId) {
            doSetProperty("fallBackReplayId", fallBackReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder format(
                org.apache.camel.component.salesforce.internal.PayloadFormat format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON. As of Camel 3.12, this option only applies to the
         * Raw operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.PayloadFormat&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder httpClient(
                org.apache.camel.component.salesforce.SalesforceHttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.SalesforceHttpClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder includeDetails(Boolean includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeDetails the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder includeDetails(String includeDetails) {
            doSetProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                Map<java.lang.String, java.lang.Long> initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Long&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param initialReplayIdMap the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            doSetProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param instanceId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder instanceId(String instanceId) {
            doSetProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jobId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder jobId(String jobId) {
            doSetProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder limit(Integer limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param limit the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder limit(String limit) {
            doSetProperty("limit", limit);
            return this;
        }
        /**
         * Locator provided by salesforce Bulk 2.0 API for use in getting
         * results for a Query job.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder locator(String locator) {
            doSetProperty("locator", locator);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxBackoff(long maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxBackoff the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxBackoff(String maxBackoff) {
            doSetProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxRecords(Integer maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * The maximum number of records to retrieve per set of results for a
         * Bulk 2.0 Query. The request is still subject to the size limits. If
         * you are working with a very large number of query results, you may
         * experience a timeout before receiving all the data from Salesforce.
         * To prevent a timeout, specify the maximum number of records your
         * client is expecting to receive in the maxRecords parameter. This
         * splits the results into smaller sets with this value as the maximum
         * size.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRecords the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder maxRecords(String maxRecords) {
            doSetProperty("maxRecords", maxRecords);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                org.apache.camel.component.salesforce.NotFoundBehaviour notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.NotFoundBehaviour&lt;/code&gt; type.
         * 
         * Default: EXCEPTION
         * Group: common
         * 
         * @param notFoundBehaviour the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            doSetProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForFields(
                org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForFields(String notifyForFields) {
            doSetProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationCreate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            doSetProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationDelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            doSetProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperations(
                org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version &amp;amp;lt; 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperations the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperations(
                String notifyForOperations) {
            doSetProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUndelete the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            doSetProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version
         * &amp;amp;gt;= 29.0).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notifyForOperationUpdate the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            doSetProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder objectMapper(
                com.fasterxml.jackson.databind.ObjectMapper objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.fasterxml.jackson.databind.ObjectMapper&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param objectMapper the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder objectMapper(String objectMapper) {
            doSetProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunking(Boolean pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API
         * performs PK chunking automatically, if necessary.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunking the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunking(String pkChunking) {
            doSetProperty("pkChunking", pkChunking);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunkingChunkSize(
                Integer pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Chunk size for use with PK Chunking. If unspecified, salesforce
         * default is 100,000. Maximum size is 250,000.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingChunkSize the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunkingChunkSize(
                String pkChunkingChunkSize) {
            doSetProperty("pkChunkingChunkSize", pkChunkingChunkSize);
            return this;
        }
        /**
         * Specifies the parent object when you're enabling PK chunking for
         * queries on sharing objects. The chunks are based on the parent
         * object's records rather than the sharing object's records. For
         * example, when querying on AccountShare, specify Account as the parent
         * object. PK chunking is supported for sharing objects as long as the
         * parent object is supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingParent the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunkingParent(
                String pkChunkingParent) {
            doSetProperty("pkChunkingParent", pkChunkingParent);
            return this;
        }
        /**
         * Specifies the 15-character or 18-character record ID to be used as
         * the lower boundary for the first chunk. Use this parameter to specify
         * a starting ID when restarting a job that failed between batches.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pkChunkingStartRow the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder pkChunkingStartRow(
                String pkChunkingStartRow) {
            doSetProperty("pkChunkingStartRow", pkChunkingStartRow);
            return this;
        }
        /**
         * Query Locator provided by salesforce for use when a query results in
         * more records than can be retrieved in a single call. Use this value
         * in a subsequent call to retrieve additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queryLocator the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder queryLocator(String queryLocator) {
            doSetProperty("queryLocator", queryLocator);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder rawPayload(boolean rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param rawPayload the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder rawPayload(String rawPayload) {
            doSetProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportId(String reportId) {
            doSetProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportMetadata(
                org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportMetadata the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder reportMetadata(String reportMetadata) {
            doSetProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder resultId(String resultId) {
            doSetProperty("resultId", resultId);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectBlobFieldName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            doSetProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectClass the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectClass(String sObjectClass) {
            doSetProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectFields the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectFields(String sObjectFields) {
            doSetProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectId the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectId(String sObjectId) {
            doSetProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectIdName(String sObjectIdName) {
            doSetProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectIdValue the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectIdValue(String sObjectIdValue) {
            doSetProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectName the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectName(String sObjectName) {
            doSetProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectQuery the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectQuery(String sObjectQuery) {
            doSetProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sObjectSearch the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder sObjectSearch(String sObjectSearch) {
            doSetProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder streamQueryResult(
                Boolean streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * If true, streams SOQL query result and transparently handles
         * subsequent requests if there are multiple pages. Otherwise, results
         * are returned one page at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streamQueryResult the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder streamQueryResult(
                String streamQueryResult) {
            doSetProperty("streamQueryResult", streamQueryResult);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder updateTopic(boolean updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param updateTopic the value to set
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder updateTopic(String updateTopic) {
            doSetProperty("updateTopic", updateTopic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointBuilder
            extends
                AdvancedSalesforceEndpointConsumerBuilder,
                AdvancedSalesforceEndpointProducerBuilder {
        default SalesforceEndpointBuilder basic() {
            return (SalesforceEndpointBuilder) this;
        }
    }

    public interface SalesforceBuilders {
        /**
         * Salesforce (camel-salesforce)
         * Communicate with Salesforce using Java DTOs.
         * 
         * Category: cloud,api,crm
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-salesforce
         * 
         * @return the dsl builder for the headers' name.
         */
        default SalesforceHeaderNameBuilder salesforce() {
            return SalesforceHeaderNameBuilder.INSTANCE;
        }
        /**
         * Salesforce (camel-salesforce)
         * Communicate with Salesforce using Java DTOs.
         * 
         * Category: cloud,api,crm
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-salesforce
         * 
         * Syntax: <code>salesforce:operationName:topicName</code>
         * 
         * Path parameter: operationName (required)
         * The operation to use
         * There are 66 enums and the value can be one of: getVersions,
         * getResources, getGlobalObjects, getBasicInfo, getDescription,
         * getSObject, createSObject, updateSObject, deleteSObject,
         * getSObjectWithId, upsertSObject, deleteSObjectWithId, getBlobField,
         * query, queryMore, queryAll, search, apexCall, recent, createJob,
         * getJob, closeJob, abortJob, createBatch, getBatch, getAllBatches,
         * getRequest, getResults, createBatchQuery, getQueryResultIds,
         * getQueryResult, getRecentReports, getReportDescription,
         * executeSyncReport, executeAsyncReport, getReportInstances,
         * getReportResults, limits, approval, approvals, composite-tree,
         * composite-batch, composite, compositeRetrieveSObjectCollections,
         * compositeCreateSObjectCollections, compositeUpdateSObjectCollections,
         * compositeUpsertSObjectCollections, compositeDeleteSObjectCollections,
         * bulk2GetAllJobs, bulk2CreateJob, bulk2GetJob, bulk2CreateBatch,
         * bulk2CloseJob, bulk2AbortJob, bulk2DeleteJob,
         * bulk2GetSuccessfulResults, bulk2GetFailedResults,
         * bulk2GetUnprocessedRecords, bulk2CreateQueryJob, bulk2GetQueryJob,
         * bulk2GetAllQueryJobs, bulk2GetQueryJobResults, bulk2AbortQueryJob,
         * bulk2DeleteQueryJob, raw, subscribe
         * 
         * Path parameter: topicName
         * The name of the topic/channel to use
         * 
         * @param path operationName:topicName
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder salesforce(String path) {
            return SalesforceEndpointBuilderFactory.endpointBuilder("salesforce", path);
        }
        /**
         * Salesforce (camel-salesforce)
         * Communicate with Salesforce using Java DTOs.
         * 
         * Category: cloud,api,crm
         * Since: 2.12
         * Maven coordinates: org.apache.camel:camel-salesforce
         * 
         * Syntax: <code>salesforce:operationName:topicName</code>
         * 
         * Path parameter: operationName (required)
         * The operation to use
         * There are 66 enums and the value can be one of: getVersions,
         * getResources, getGlobalObjects, getBasicInfo, getDescription,
         * getSObject, createSObject, updateSObject, deleteSObject,
         * getSObjectWithId, upsertSObject, deleteSObjectWithId, getBlobField,
         * query, queryMore, queryAll, search, apexCall, recent, createJob,
         * getJob, closeJob, abortJob, createBatch, getBatch, getAllBatches,
         * getRequest, getResults, createBatchQuery, getQueryResultIds,
         * getQueryResult, getRecentReports, getReportDescription,
         * executeSyncReport, executeAsyncReport, getReportInstances,
         * getReportResults, limits, approval, approvals, composite-tree,
         * composite-batch, composite, compositeRetrieveSObjectCollections,
         * compositeCreateSObjectCollections, compositeUpdateSObjectCollections,
         * compositeUpsertSObjectCollections, compositeDeleteSObjectCollections,
         * bulk2GetAllJobs, bulk2CreateJob, bulk2GetJob, bulk2CreateBatch,
         * bulk2CloseJob, bulk2AbortJob, bulk2DeleteJob,
         * bulk2GetSuccessfulResults, bulk2GetFailedResults,
         * bulk2GetUnprocessedRecords, bulk2CreateQueryJob, bulk2GetQueryJob,
         * bulk2GetAllQueryJobs, bulk2GetQueryJobResults, bulk2AbortQueryJob,
         * bulk2DeleteQueryJob, raw, subscribe
         * 
         * Path parameter: topicName
         * The name of the topic/channel to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operationName:topicName
         * @return the dsl builder
         */
        default SalesforceEndpointBuilder salesforce(
                String componentName,
                String path) {
            return SalesforceEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Salesforce component.
     */
    public static class SalesforceHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SalesforceHeaderNameBuilder INSTANCE = new SalesforceHeaderNameBuilder();

        /**
         * The replay id.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceReplayId}.
         */
        public String salesforceReplayId() {
            return "CamelSalesforceReplayId";
        }

        /**
         * The change event schema.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceChangeEventSchema}.
         */
        public String salesforceChangeEventSchema() {
            return "CamelSalesforceChangeEventSchema";
        }

        /**
         * The event type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceEventType}.
         */
        public String salesforceEventType() {
            return "CamelSalesforceEventType";
        }

        /**
         * The commit timestamp.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceCommitTimestamp}.
         */
        public String salesforceCommitTimestamp() {
            return "CamelSalesforceCommitTimestamp";
        }

        /**
         * The commit user.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceCommitUser}.
         */
        public String salesforceCommitUser() {
            return "CamelSalesforceCommitUser";
        }

        /**
         * The commit number.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceCommitNumber}.
         */
        public String salesforceCommitNumber() {
            return "CamelSalesforceCommitNumber";
        }

        /**
         * The record ids.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceRecordIds}.
         */
        public String salesforceRecordIds() {
            return "CamelSalesforceRecordIds";
        }

        /**
         * The change type.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceChangeType}.
         */
        public String salesforceChangeType() {
            return "CamelSalesforceChangeType";
        }

        /**
         * The change origin.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceChangeOrigin}.
         */
        public String salesforceChangeOrigin() {
            return "CamelSalesforceChangeOrigin";
        }

        /**
         * The transaction key.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceTransactionKey}.
         */
        public String salesforceTransactionKey() {
            return "CamelSalesforceTransactionKey";
        }

        /**
         * The sequence number.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceSequenceNumber}.
         */
        public String salesforceSequenceNumber() {
            return "CamelSalesforceSequenceNumber";
        }

        /**
         * Is transaction end.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceIsTransactionEnd}.
         */
        public String salesforceIsTransactionEnd() {
            return "CamelSalesforceIsTransactionEnd";
        }

        /**
         * The entity name.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceEntityName}.
         */
        public String salesforceEntityName() {
            return "CamelSalesforceEntityName";
        }

        /**
         * The platform event schema.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforcePlatformEventSchema}.
         */
        public String salesforcePlatformEventSchema() {
            return "CamelSalesforcePlatformEventSchema";
        }

        /**
         * The created date.
         * 
         * The option is a: {@code java.time.ZonedDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceCreatedDate}.
         */
        public String salesforceCreatedDate() {
            return "CamelSalesforceCreatedDate";
        }

        /**
         * The topic name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceTopicName}.
         */
        public String salesforceTopicName() {
            return "CamelSalesforceTopicName";
        }

        /**
         * The channel.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceChannel}.
         */
        public String salesforceChannel() {
            return "CamelSalesforceChannel";
        }

        /**
         * The client id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SalesforceClientId}.
         */
        public String salesforceClientId() {
            return "CamelSalesforceClientId";
        }

        /**
         * Total number of records matching a query.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SalesforceQueryResultTotalSize}.
         */
        public String salesforceQueryResultTotalSize() {
            return "CamelSalesforceQueryResultTotalSize";
        }
    }
    static SalesforceEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class SalesforceEndpointBuilderImpl extends AbstractEndpointBuilder implements SalesforceEndpointBuilder, AdvancedSalesforceEndpointBuilder {
            public SalesforceEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SalesforceEndpointBuilderImpl(path);
    }
}