/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Capture changes from a DB2 database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumDb2EndpointBuilderFactory {


    /**
     * Builder for endpoint for the Debezium DB2 Connector component.
     */
    public interface DebeziumDb2EndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumDb2EndpointBuilder advanced() {
            return (AdvancedDebeziumDb2EndpointBuilder) this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder internalKeyConverter(
                String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder internalValueConverter(
                String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetCommitPolicy(
                String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetCommitTimeoutMs(
                String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetFlushIntervalMs(
                String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStorage(String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStorageFileName(
                String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStoragePartitions(
                String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStorageReplicationFactor(
                String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder offsetStorageTopic(
                String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events
         * (deprecated, use column.exclude.list instead).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnBlacklist the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder columnBlacklist(
                String columnBlacklist) {
            doSetProperty("columnBlacklist", columnBlacklist);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder columnExcludeList(
                String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder columnIncludeList(
                String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder columnPropagateSourceType(
                String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events
         * (deprecated, use column.include.list instead).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param columnWhitelist the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder columnWhitelist(
                String columnWhitelist) {
            doSetProperty("columnWhitelist", columnWhitelist);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The name of the database from which the connector should capture
         * changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseDbname the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseDbname(String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
        /**
         * The name of the DatabaseHistory class that should be used to store
         * and recover database schema changes. The configuration properties for
         * the history are prefixed with the 'database.history.' string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.relational.history.KafkaDatabaseHistory
         * Group: db2
         * 
         * @param databaseHistory the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistory(
                String databaseHistory) {
            doSetProperty("databaseHistory", databaseHistory);
            return this;
        }
        /**
         * The path to the file that will be used to record the database
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseHistoryFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryFileFilename(
                String databaseHistoryFileFilename) {
            doSetProperty("databaseHistoryFileFilename", databaseHistoryFileFilename);
            return this;
        }
        /**
         * A list of host/port pairs that the connector will use for
         * establishing the initial connection to the Kafka cluster for
         * retrieving database schema history previously stored by the
         * connector. This should point to the same Kafka cluster used by the
         * Kafka Connect process.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseHistoryKafkaBootstrapServers the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaBootstrapServers(
                String databaseHistoryKafkaBootstrapServers) {
            doSetProperty("databaseHistoryKafkaBootstrapServers", databaseHistoryKafkaBootstrapServers);
            return this;
        }
        /**
         * The number of milliseconds to wait while fetching cluster information
         * using Kafka admin client.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 3s
         * Group: db2
         * 
         * @param databaseHistoryKafkaQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaQueryTimeoutMs(
                long databaseHistoryKafkaQueryTimeoutMs) {
            doSetProperty("databaseHistoryKafkaQueryTimeoutMs", databaseHistoryKafkaQueryTimeoutMs);
            return this;
        }
        /**
         * The number of milliseconds to wait while fetching cluster information
         * using Kafka admin client.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 3s
         * Group: db2
         * 
         * @param databaseHistoryKafkaQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaQueryTimeoutMs(
                String databaseHistoryKafkaQueryTimeoutMs) {
            doSetProperty("databaseHistoryKafkaQueryTimeoutMs", databaseHistoryKafkaQueryTimeoutMs);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: db2
         * 
         * @param databaseHistoryKafkaRecoveryAttempts the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                int databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: db2
         * 
         * @param databaseHistoryKafkaRecoveryAttempts the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                String databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100ms
         * Group: db2
         * 
         * @param databaseHistoryKafkaRecoveryPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                int databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100ms
         * Group: db2
         * 
         * @param databaseHistoryKafkaRecoveryPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                String databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The name of the topic for the database schema history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseHistoryKafkaTopic the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryKafkaTopic(
                String databaseHistoryKafkaTopic) {
            doSetProperty("databaseHistoryKafkaTopic", databaseHistoryKafkaTopic);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistorySkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistorySkipUnparseableDdl(
                boolean databaseHistorySkipUnparseableDdl) {
            doSetProperty("databaseHistorySkipUnparseableDdl", databaseHistorySkipUnparseableDdl);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistorySkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistorySkipUnparseableDdl(
                String databaseHistorySkipUnparseableDdl) {
            doSetProperty("databaseHistorySkipUnparseableDdl", databaseHistorySkipUnparseableDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history. By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * true, then only DDL that manipulates a captured table will be stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistoryStoreOnlyCapturedTablesDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryStoreOnlyCapturedTablesDdl(
                boolean databaseHistoryStoreOnlyCapturedTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyCapturedTablesDdl", databaseHistoryStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history. By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * true, then only DDL that manipulates a captured table will be stored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistoryStoreOnlyCapturedTablesDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryStoreOnlyCapturedTablesDdl(
                String databaseHistoryStoreOnlyCapturedTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyCapturedTablesDdl", databaseHistoryStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history. By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * true, then only DDL that manipulates a monitored table will be stored
         * (deprecated, use database.history.store.only.captured.tables.ddl
         * instead).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistoryStoreOnlyMonitoredTablesDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryStoreOnlyMonitoredTablesDdl(
                boolean databaseHistoryStoreOnlyMonitoredTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyMonitoredTablesDdl", databaseHistoryStoreOnlyMonitoredTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history. By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * true, then only DDL that manipulates a monitored table will be stored
         * (deprecated, use database.history.store.only.captured.tables.ddl
         * instead).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param databaseHistoryStoreOnlyMonitoredTablesDdl the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHistoryStoreOnlyMonitoredTablesDdl(
                String databaseHistoryStoreOnlyMonitoredTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyMonitoredTablesDdl", databaseHistoryStoreOnlyMonitoredTablesDdl);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseHostname(
                String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: db2
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databasePassword(
                String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50000
         * Group: db2
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50000
         * Group: db2
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databasePort(String databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Unique name that identifies the database server and all recorded
         * offsets, and that is used as a prefix for all schemas and topics.
         * Each distinct installation should have a separate namespace and be
         * monitored by at most one Debezium connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: db2
         * 
         * @param databaseServerName the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseServerName(
                String databaseServerName) {
            doSetProperty("databaseServerName", databaseServerName);
            return this;
        }
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder databaseUser(String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder datatypePropagateSourceType(
                String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including:'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: precise
         * Group: db2
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder decimalHandlingMode(
                String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including:'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped;'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: db2
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder eventProcessingFailureHandlingMode(
                String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder heartbeatIntervalMs(
                String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: db2
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder heartbeatTopicsPrefix(
                String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s).The default is 'true'. This is
         * independent of how the connector internally records database history.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder includeSchemaChanges(
                boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s).The default is 'true'. This is
         * independent of how the connector internally records database history.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder includeSchemaChanges(
                String includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * The maximum size of chunk for incremental snapshotting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: db2
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder incrementalSnapshotChunkSize(
                int incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
        /**
         * The maximum size of chunk for incremental snapshotting.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: db2
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder incrementalSnapshotChunkSize(
                String incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: db2
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: db2
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: db2
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: db2
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: db2
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxQueueSizeInBytes(
                long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: db2
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder maxQueueSizeInBytes(
                String maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':',where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector,and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key.Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder messageKeyColumns(
                String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: db2
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: db2
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder pollIntervalMs(String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder provideTransactionMetadata(
                boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder provideTransactionMetadata(
                String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of 0 uses the default JDBC fetch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: db2
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of 0 uses the default JDBC fetch size.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: db2
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder queryFetchSize(String queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder retriableRestartConnectorWaitMs(
                long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder retriableRestartConnectorWaitMs(
                String retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param sanitizeFieldNames the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder sanitizeFieldNames(
                boolean sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param sanitizeFieldNames the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder sanitizeFieldNames(
                String sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including:'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore (default)'none' does not apply any adjustment.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: avro
         * Group: db2
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder schemaNameAdjustmentMode(
                String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder signalDataCollection(
                String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, no operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder skippedOperations(
                String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: db2
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotDelayMs(
                String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotFetchSize(
                String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * this setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotIncludeCollectionList(
                String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotLockTimeoutMs(
                long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: db2
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotLockTimeoutMs(
                String snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Options include: 'initial' (the default) to specify the connector
         * should run a snapshot only when no offsets are available for the
         * logical server name; 'schema_only' to specify the connector should
         * run a snapshot of the schema when no offsets are available for the
         * logical server name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: db2
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * thespecific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder snapshotSelectStatementOverrides(
                String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * A version of the format of the publicly visible source part in the
         * message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: v2
         * Group: db2
         * 
         * @param sourceStructVersion the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder sourceStructVersion(
                String sourceStructVersion) {
            doSetProperty("sourceStructVersion", sourceStructVersion);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring
         * (deprecated, use table.exclude.list instead).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableBlacklist the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableBlacklist(String tableBlacklist) {
            doSetProperty("tableBlacklist", tableBlacklist);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableExcludeList(
                String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableIgnoreBuiltin(
                boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: db2
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableIgnoreBuiltin(
                String tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableIncludeList(
                String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
        /**
         * The tables for which changes are to be captured (deprecated, use
         * table.include.list instead).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: db2
         * 
         * @param tableWhitelist the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tableWhitelist(String tableWhitelist) {
            doSetProperty("tableWhitelist", tableWhitelist);
            return this;
        }
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including:'adaptive' (the default) bases the precision of
         * time, date, and timestamp values on the database column's precision;
         * 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields
         * always use microseconds precision;'connect' always represents time,
         * date, and timestamp values using Kafka Connect's built-in
         * representations for Time, Date, and Timestamp, which uses millisecond
         * precision regardless of the database columns' precision .
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: adaptive
         * Group: db2
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder timePrecisionMode(
                String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: db2
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder tombstonesOnDelete(
                String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the transaction metadata topic. The placeholder
         * ${database.server.name} can be used for referring to the connector's
         * logical name; defaults to ${database.server.name}.transaction.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ${database.server.name}.transaction
         * Group: db2
         * 
         * @param transactionTopic the value to set
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder transactionTopic(
                String transactionTopic) {
            doSetProperty("transactionTopic", transactionTopic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium DB2 Connector component.
     */
    public interface AdvancedDebeziumDb2EndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumDb2EndpointBuilder basic() {
            return (DebeziumDb2EndpointBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDebeziumDb2EndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface DebeziumDb2Builders {
        /**
         * Debezium DB2 Connector (camel-debezium-db2)
         * Capture changes from a DB2 database.
         * 
         * Category: database,sql
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-db2
         * 
         * @return the dsl builder for the headers' name.
         */
        default DebeziumDb2HeaderNameBuilder debeziumDb2() {
            return DebeziumDb2HeaderNameBuilder.INSTANCE;
        }
        /**
         * Debezium DB2 Connector (camel-debezium-db2)
         * Capture changes from a DB2 database.
         * 
         * Category: database,sql
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-db2
         * 
         * Syntax: <code>debezium-db2:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder debeziumDb2(String path) {
            return DebeziumDb2EndpointBuilderFactory.endpointBuilder("debezium-db2", path);
        }
        /**
         * Debezium DB2 Connector (camel-debezium-db2)
         * Capture changes from a DB2 database.
         * 
         * Category: database,sql
         * Since: 3.17
         * Maven coordinates: org.apache.camel:camel-debezium-db2
         * 
         * Syntax: <code>debezium-db2:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default DebeziumDb2EndpointBuilder debeziumDb2(
                String componentName,
                String path) {
            return DebeziumDb2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Debezium DB2 Connector component.
     */
    public static class DebeziumDb2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DebeziumDb2HeaderNameBuilder INSTANCE = new DebeziumDb2HeaderNameBuilder();

        /**
         * The metadata about the source event, for example table name, database
         * name, log position, etc, please refer to the Debezium documentation
         * for more info.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumSourceMetadata}.
         */
        public String debeziumSourceMetadata() {
            return "DebeziumSourceMetadata";
        }

        /**
         * The identifier of the connector, normally is this format
         * {server-name}.{database-name}.{table-name}.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumIdentifier}.
         */
        public String debeziumIdentifier() {
            return "DebeziumIdentifier";
        }

        /**
         * The key of the event, normally is the table Primary Key.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumKey}.
         */
        public String debeziumKey() {
            return "DebeziumKey";
        }

        /**
         * If presents, the type of event operation. Values for the connector
         * are c for create (or insert), u for update, d for delete or r for
         * read (in the case of a initial sync) or in case of a snapshot event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumOperation}.
         */
        public String debeziumOperation() {
            return "DebeziumOperation";
        }

        /**
         * If presents, the time (using the system clock in the JVM) at which
         * the connector processed the event.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumTimestamp}.
         */
        public String debeziumTimestamp() {
            return "DebeziumTimestamp";
        }

        /**
         * If presents, contains the state of the row before the event occurred.
         * 
         * The option is a: {@code Struct} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumBefore}.
         */
        public String debeziumBefore() {
            return "DebeziumBefore";
        }

        /**
         * If presents, the ddl sql text of the event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DebeziumDdlSQL}.
         */
        public String debeziumDdlSQL() {
            return "DebeziumDdlSQL";
        }
    }
    static DebeziumDb2EndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DebeziumDb2EndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumDb2EndpointBuilder, AdvancedDebeziumDb2EndpointBuilder {
            public DebeziumDb2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumDb2EndpointBuilderImpl(path);
    }
}