/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Upload, download and manage files, folders, groups, collaborations, etc. on
 * box.com.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BoxEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Box component.
     */
    public interface BoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBoxEndpointConsumerBuilder advanced() {
            return (AdvancedBoxEndpointConsumerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param enterpriseId the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyFile the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder privateKeyPassword(
                String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param publicKeyId the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointConsumerBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Box component.
     */
    public interface AdvancedBoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BoxEndpointConsumerBuilder basic() {
            return (BoxEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(
                Map<java.lang.String, java.lang.Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                com.box.sdk.IAccessTokenCache accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                com.box.sdk.EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Box component.
     */
    public interface BoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBoxEndpointProducerBuilder advanced() {
            return (AdvancedBoxEndpointProducerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param enterpriseId the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyFile the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder privateKeyPassword(
                String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param publicKeyId the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointProducerBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Box component.
     */
    public interface AdvancedBoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BoxEndpointProducerBuilder basic() {
            return (BoxEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(
                Map<java.lang.String, java.lang.Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                com.box.sdk.IAccessTokenCache accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                com.box.sdk.EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Box component.
     */
    public interface BoxEndpointBuilder
            extends
                BoxEndpointConsumerBuilder,
                BoxEndpointProducerBuilder {
        default AdvancedBoxEndpointBuilder advanced() {
            return (AdvancedBoxEndpointBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param enterpriseId the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         * 
         * @param authenticationType the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder authenticationType(String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyFile the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privateKeyPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder privateKeyPassword(String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param publicKeyId the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userPassword the value to set
         * @return the dsl builder
         */
        default BoxEndpointBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Box component.
     */
    public interface AdvancedBoxEndpointBuilder
            extends
                AdvancedBoxEndpointConsumerBuilder,
                AdvancedBoxEndpointProducerBuilder {
        default BoxEndpointBuilder basic() {
            return (BoxEndpointBuilder) this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder httpParams(
                Map<java.lang.String, java.lang.Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpParams the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                com.box.sdk.IAccessTokenCache accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.IAccessTokenCache&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessTokenCache the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a:
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                com.box.sdk.EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.box.sdk.EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         * 
         * @param encryptionAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: security
         * 
         * @param maxCacheEntries the value to set
         * @return the dsl builder
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    public interface BoxBuilders {
        /**
         * Box (camel-box)
         * Upload, download and manage files, folders, groups, collaborations,
         * etc. on box.com.
         * 
         * Category: cloud,file,api
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-box
         * 
         * Syntax: <code>box:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 10 enums and the value can be one of: COLLABORATIONS,
         * COMMENTS, EVENT_LOGS, FILES, FOLDERS, GROUPS, EVENTS, SEARCH, TASKS,
         * USERS
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default BoxEndpointBuilder box(String path) {
            return BoxEndpointBuilderFactory.endpointBuilder("box", path);
        }
        /**
         * Box (camel-box)
         * Upload, download and manage files, folders, groups, collaborations,
         * etc. on box.com.
         * 
         * Category: cloud,file,api
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-box
         * 
         * Syntax: <code>box:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 10 enums and the value can be one of: COLLABORATIONS,
         * COMMENTS, EVENT_LOGS, FILES, FOLDERS, GROUPS, EVENTS, SEARCH, TASKS,
         * USERS
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default BoxEndpointBuilder box(String componentName, String path) {
            return BoxEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static BoxEndpointBuilder endpointBuilder(String componentName, String path) {
        class BoxEndpointBuilderImpl extends AbstractEndpointBuilder implements BoxEndpointBuilder, AdvancedBoxEndpointBuilder {
            public BoxEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new BoxEndpointBuilderImpl(path);
    }
}