/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms.issues;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.AbstractJMSTest;
import org.junit.jupiter.api.Test;

import static org.apache.camel.test.junit5.TestSupport.assertIsInstanceOf;
import static org.junit.jupiter.api.Assertions.assertEquals;

/**
 * Unit test for request-reply with jms where processing the input could cause: OK or Exception
 */
public class BruceHandlingBeanExceptionTest extends AbstractJMSTest {

    @Test
    public void testSendOK() {
        Object out = template.requestBody("activemq:queue:BruceHandlingBeanExceptionTest.ok", "Hello World");
        assertEquals("Bye World", out);
    }

    @Test
    public void testSendError() {
        Object out = template.requestBody("activemq:queue:BruceHandlingBeanExceptionTest.error", "Hello World");
        IllegalArgumentException e = assertIsInstanceOf(IllegalArgumentException.class, out);
        assertEquals("Forced exception by unit test", e.getMessage());
    }

    @Override
    protected String getComponentName() {
        return "activemq";
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            public void configure() {
                from("activemq:queue:BruceHandlingBeanExceptionTest.ok").transform(constant("Bye World"));

                from("activemq:queue:BruceHandlingBeanExceptionTest.error?transferException=true").bean(MyExceptionBean.class);
            }
        };
    }

    public static class MyExceptionBean {
        public String doSomething(String input) {
            throw new IllegalArgumentException("Forced exception by unit test");
        }
    }
}
