/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcConsumerStrategy;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.server.GrpcHeaderInterceptor;
import org.apache.camel.component.grpc.server.GrpcRequestAbstractStreamObserver;
import org.apache.camel.component.grpc.server.GrpcRequestAggregationStreamObserver;
import org.apache.camel.component.grpc.server.GrpcRequestPropagationStreamObserver;

public class GrpcMethodHandler
implements MethodHandler {
    private final GrpcEndpoint endpoint;
    private final GrpcConsumer consumer;

    public GrpcMethodHandler(GrpcEndpoint endpoint, GrpcConsumer consumer) {
        this.endpoint = endpoint;
        this.consumer = consumer;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        StreamObserver responseObserver;
        HashMap<String, Object> grcpHeaders = new HashMap<String, Object>();
        grcpHeaders.put(GrpcHeaderInterceptor.USER_AGENT_CONTEXT_KEY.toString(), GrpcHeaderInterceptor.USER_AGENT_CONTEXT_KEY.get());
        grcpHeaders.put(GrpcHeaderInterceptor.CONTENT_TYPE_CONTEXT_KEY.toString(), GrpcHeaderInterceptor.CONTENT_TYPE_CONTEXT_KEY.get());
        grcpHeaders.put("CamelGrpcMethodName", thisMethod.getName());
        if (args.length == 2 && args[1] instanceof StreamObserver) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setBody(args[0]);
            exchange.getIn().setHeaders(grcpHeaders);
            if (this.endpoint.isSynchronous()) {
                this.consumer.getProcessor().process(exchange);
            } else {
                this.consumer.getAsyncProcessor().process(exchange);
            }
            responseObserver = (StreamObserver)args[1];
            Object responseBody = exchange.getIn().getBody();
            if (responseBody instanceof List) {
                List responseList = (List)responseBody;
                responseList.forEach(arg_0 -> ((StreamObserver)responseObserver).onNext(arg_0));
            } else {
                responseObserver.onNext(responseBody);
            }
        } else {
            if (args.length == 1 && args[0] instanceof StreamObserver) {
                StreamObserver responseObserver2 = (StreamObserver)args[0];
                GrpcRequestAbstractStreamObserver requestObserver = null;
                if (this.consumer.getConfiguration().getConsumerStrategy() == GrpcConsumerStrategy.AGGREGATION) {
                    requestObserver = new GrpcRequestAggregationStreamObserver(this.endpoint, this.consumer, (StreamObserver<Object>)responseObserver2, grcpHeaders);
                } else if (this.consumer.getConfiguration().getConsumerStrategy() == GrpcConsumerStrategy.PROPAGATION) {
                    requestObserver = new GrpcRequestPropagationStreamObserver(this.endpoint, this.consumer, (StreamObserver<Object>)responseObserver2, grcpHeaders);
                } else {
                    throw new IllegalArgumentException("gRPC processing strategy not implemented " + (Object)((Object)this.consumer.getConfiguration().getConsumerStrategy()));
                }
                return requestObserver;
            }
            throw new IllegalArgumentException("Invalid to process gRPC method: " + thisMethod.getName());
        }
        responseObserver.onCompleted();
        return null;
    }
}

