/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.bonita.BonitaComponent;
import org.apache.camel.component.bonita.BonitaConfiguration;
import org.apache.camel.component.bonita.exception.BonitaException;
import org.apache.camel.component.bonita.producer.BonitaStartProducer;
import org.apache.camel.component.bonita.util.BonitaOperation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="bonita", title="Bonita", syntax="bonita:operation", producerOnly=true, label="process")
public class BonitaEndpoint
extends DefaultEndpoint {
    @UriParam
    private BonitaConfiguration configuration;

    public BonitaEndpoint() {
    }

    public BonitaEndpoint(String uri, BonitaComponent component, BonitaConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        if (this.configuration.getOperation() == BonitaOperation.startCase) {
            return new BonitaStartProducer(this, this.configuration);
        }
        throw new BonitaException("Operation specified is not supported.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public BonitaConfiguration getConfiguration() {
        return this.configuration;
    }
}

