/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.translate;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.translate.AmazonTranslate;
import com.amazonaws.services.translate.AmazonTranslateClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.translate.TranslateConfiguration;
import org.apache.camel.component.aws.translate.TranslateProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="aws-translate", title="AWS Translate", syntax="aws-translate:label", producerOnly=true, label="cloud,management")
public class TranslateEndpoint
extends ScheduledPollEndpoint {
    private AmazonTranslate translateClient;
    @UriParam
    private TranslateConfiguration configuration;

    public TranslateEndpoint(String uri, Component component, TranslateConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new TranslateProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.translateClient = this.configuration.getTranslateClient() != null ? this.configuration.getTranslateClient() : this.createTranslateClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTranslateClient()) && this.translateClient != null) {
            this.translateClient.shutdown();
        }
        super.doStop();
    }

    public TranslateConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonTranslate getTranslateClient() {
        return this.translateClient;
    }

    AmazonTranslate createTranslateClient() {
        AmazonTranslate client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonTranslateClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonTranslateClientBuilder)((AmazonTranslateClientBuilder)AmazonTranslateClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonTranslateClientBuilder)AmazonTranslateClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonTranslateClientBuilder.standard() : (AmazonTranslateClientBuilder)AmazonTranslateClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonTranslateClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonTranslate)clientBuilder.build();
        return client;
    }
}

