/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.BeanstalkExchangeHelper;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuryCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(BuryCommand.class);

    public BuryCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        long priority;
        long jobId = BeanstalkExchangeHelper.getJobID(exchange);
        boolean result = client.bury(jobId, priority = BeanstalkExchangeHelper.getPriority(this.endpoint, exchange.getIn()));
        if (!result && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Failed to bury job %d (with priority %d)", jobId, priority));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Job %d buried with priority %d. Result is %b", jobId, priority, result));
        }
        this.answerWith(exchange, "beanstalk.result", result);
    }
}

