/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.wordpress.WordpressComponentConfiguration;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="wordpress")
public class WordpressComponent
extends DefaultComponent {
    private static final String OP_SEPARATOR = ":";
    @Metadata(label="advanced", description="Wordpress component configuration")
    private WordpressComponentConfiguration configuration;

    public WordpressComponent() {
        this(new WordpressComponentConfiguration());
    }

    public WordpressComponent(WordpressComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    public WordpressComponent(CamelContext camelContext) {
        super(camelContext);
        this.configuration = new WordpressComponentConfiguration();
    }

    public WordpressComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WordpressComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.configuration != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection();
            beanIntrospection.getProperties((Object)this.configuration, properties, null, false);
            properties.forEach(parameters::putIfAbsent);
        }
        WordpressComponentConfiguration config = new WordpressComponentConfiguration();
        WordpressEndpoint endpoint = new WordpressEndpoint(uri, this, config);
        this.discoverOperations(endpoint, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        this.setProperties(config, parameters);
        return endpoint;
    }

    private void discoverOperations(WordpressEndpoint endpoint, String remaining) {
        String[] operations = remaining.split(OP_SEPARATOR);
        endpoint.setOperation(operations[0]);
        if (operations.length > 1) {
            endpoint.setOperationDetail(operations[1]);
        }
    }
}

