/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kms;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.kms.KMS2Configuration;
import org.apache.camel.component.aws2.kms.KMS2Endpoint;
import org.apache.camel.component.aws2.kms.KMS2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;

public class KMS2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KMS2Producer.class);
    private transient String kmsProducerToString;

    public KMS2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listKeys: {
                this.listKeys(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case createKey: {
                this.createKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case disableKey: {
                this.disableKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case enableKey: {
                this.enableKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case scheduleKeyDeletion: {
                this.scheduleKeyDeletion(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            case describeKey: {
                this.describeKey(this.getEndpoint().getKmsClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private KMS2Operations determineOperation(Exchange exchange) {
        KMS2Operations operation = (KMS2Operations)((Object)exchange.getIn().getHeader("CamelAwsKMSOperation", KMS2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            throw new IllegalArgumentException("Operation must be specified");
        }
        return operation;
    }

    protected KMS2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.kmsProducerToString == null) {
            this.kmsProducerToString = "KMSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.kmsProducerToString;
    }

    public KMS2Endpoint getEndpoint() {
        return (KMS2Endpoint)super.getEndpoint();
    }

    private void listKeys(KmsClient kmsClient, Exchange exchange) {
        ListKeysResponse result;
        ListKeysRequest.Builder builder = ListKeysRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSLimit"))) {
            int limit = (Integer)exchange.getIn().getHeader("CamelAwsKMSLimit", Integer.class);
            builder.limit(Integer.valueOf(limit));
        }
        try {
            result = kmsClient.listKeys((ListKeysRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Keys command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createKey(KmsClient kmsClient, Exchange exchange) {
        CreateKeyResponse result;
        CreateKeyRequest.Builder builder = CreateKeyRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSDescription"))) {
            String description = (String)exchange.getIn().getHeader("CamelAwsKMSDescription", String.class);
            builder.description(description);
        }
        try {
            result = kmsClient.createKey((CreateKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void disableKey(KmsClient kmsClient, Exchange exchange) {
        DisableKeyResponse result;
        DisableKeyRequest.Builder builder = DisableKeyRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        builder.keyId(keyId);
        try {
            result = kmsClient.disableKey((DisableKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Disable Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void scheduleKeyDeletion(KmsClient kmsClient, Exchange exchange) {
        ScheduleKeyDeletionResponse result;
        ScheduleKeyDeletionRequest.Builder builder = ScheduleKeyDeletionRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        builder.keyId(keyId);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSPendingWindowInDays"))) {
            int pendingWindows = (Integer)exchange.getIn().getHeader("CamelAwsKMSPendingWindowInDays", Integer.class);
            builder.pendingWindowInDays(Integer.valueOf(pendingWindows));
        }
        try {
            result = kmsClient.scheduleKeyDeletion((ScheduleKeyDeletionRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Schedule Key Deletion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeKey(KmsClient kmsClient, Exchange exchange) {
        DescribeKeyResponse result;
        DescribeKeyRequest.Builder builder = DescribeKeyRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        builder.keyId(keyId);
        try {
            result = kmsClient.describeKey((DescribeKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Describe Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void enableKey(KmsClient kmsClient, Exchange exchange) {
        EnableKeyResponse result;
        EnableKeyRequest.Builder builder = EnableKeyRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKMSKeyId"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String keyId = (String)exchange.getIn().getHeader("CamelAwsKMSKeyId", String.class);
        builder.keyId(keyId);
        try {
            result = kmsClient.enableKey((EnableKeyRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Enable Key command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = KMS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

