/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jbpm.JBPMComponent;
import org.apache.camel.component.jbpm.JBPMConfiguration;
import org.apache.camel.component.jbpm.JBPMConsumer;
import org.apache.camel.component.jbpm.JBPMProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.6.0", scheme="jbpm", title="JBPM", syntax="jbpm:connectionURL", label="process")
public class JBPMEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JBPMEndpoint.class);
    @UriParam
    private JBPMConfiguration configuration;

    public JBPMEndpoint(String uri, JBPMComponent component, JBPMConfiguration configuration) throws URISyntaxException, MalformedURLException {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        KieServicesConfiguration kieConfiguration = KieServicesFactory.newRestConfiguration((String)this.configuration.getConnectionURL().toExternalForm(), (String)this.configuration.getUserName(), (String)this.configuration.getPassword());
        if (this.configuration.getTimeout() != null) {
            kieConfiguration.setTimeout((long)this.configuration.getTimeout().intValue());
        }
        if (this.configuration.getExtraJaxbClasses() != null) {
            List<Class> classes = Arrays.asList(this.configuration.getExtraJaxbClasses());
            kieConfiguration.addExtraClasses(new LinkedHashSet<Class>(classes));
        }
        KieServicesClient kieServerClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)kieConfiguration);
        LOGGER.debug("JBPM Producer created with KieServerClient configured for {}", (Object)this.configuration.getConnectionURL());
        return new JBPMProducer(this, kieServerClient);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOGGER.debug("JBPM Consumer created and configured for deployment {}", (Object)this.configuration.getDeploymentId());
        JBPMConsumer consumer = new JBPMConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setConfiguration(JBPMConfiguration configuration) {
        this.configuration = configuration;
    }

    public JBPMConfiguration getConfiguration() {
        return this.configuration;
    }
}

