/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.robotframework;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.util.ObjectHelper;

public class RobotFrameworkArguments {
    private final List<String> arguments = new ArrayList<String>();

    public void addFileToArguments(File file, String flag) {
        if (this.isFileValid(file)) {
            String path = !file.getName().toUpperCase().equals("NONE") ? file.getPath() : file.getName();
            this.add(flag, path);
        }
    }

    protected boolean isFileValid(File file) {
        return file != null && file.getPath() != null && !file.getPath().equals("");
    }

    public void addNonEmptyStringToArguments(String variableToAdd, String flag) {
        if (!ObjectHelper.isEmpty((Object)variableToAdd)) {
            this.addStringToArguments(variableToAdd, flag);
        }
    }

    public void addFlagToArguments(boolean flag, String argument) {
        if (flag) {
            this.add(argument);
        }
    }

    public void addStringToArguments(String variableToAdd, String flag) {
        this.add(flag, variableToAdd);
    }

    public void addListToArguments(String variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        String[] splittedVariablesToAdd = variablesToAdd.split(",");
        this.addListToArguments(new ArrayList<String>(Arrays.asList(splittedVariablesToAdd)), flag);
    }

    public void addListToArguments(List<String> variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        for (String variableToAdd : variablesToAdd) {
            if (ObjectHelper.isEmpty((Object)variableToAdd)) continue;
            this.add(flag, variableToAdd);
        }
    }

    public void addFileListToArguments(List<File> variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        for (File variableToAdd : variablesToAdd) {
            this.addFileToArguments(variableToAdd, flag);
        }
    }

    public void add(String ... values) {
        this.arguments.addAll(Arrays.asList(values));
    }

    public String[] toArray() {
        return this.arguments.toArray(new String[this.arguments.size()]);
    }
}

