/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueMessage;
import com.microsoft.azure.storage.queue.QueueRequestOptions;
import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.common.ExchangeUtil;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceRequestOptions;

public final class QueueServiceUtil {
    private QueueServiceUtil() {
    }

    public static URI prepareStorageQueueUri(QueueServiceConfiguration cfg) {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("https://").append(cfg.getAccountName()).append(".queue.core.windows.net").append("/" + cfg.getQueueName());
        return URI.create(uriBuilder.toString());
    }

    public static CloudQueue createQueueClient(QueueServiceConfiguration cfg) throws Exception {
        CloudQueue client = QueueServiceUtil.getConfiguredClient(cfg);
        if (client == null) {
            URI uri = QueueServiceUtil.prepareStorageQueueUri(cfg);
            StorageCredentials creds = cfg.getAccountCredentials();
            client = new CloudQueue(uri, creds);
        }
        return client;
    }

    public static CloudQueue getConfiguredClient(QueueServiceConfiguration cfg) {
        CloudQueue client = cfg.getAzureQueueClient();
        if (client != null && !client.getUri().equals(QueueServiceUtil.prepareStorageQueueUri(cfg))) {
            throw new IllegalArgumentException("Invalid Client URI");
        }
        return client;
    }

    public static void retrieveMessage(Exchange exchange, QueueServiceConfiguration cfg) throws Exception {
        CloudQueue client = QueueServiceUtil.createQueueClient(cfg);
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        int visibilityTimeout = cfg.getMessageVisibilityDelay();
        visibilityTimeout = visibilityTimeout != 0 ? visibilityTimeout : 30;
        CloudQueueMessage message = client.retrieveMessage(visibilityTimeout, opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)message);
    }

    public static QueueServiceRequestOptions getRequestOptions(Exchange exchange) {
        QueueServiceRequestOptions opts = (QueueServiceRequestOptions)exchange.getIn().getHeader("QueueServiceRequestOptions", QueueServiceRequestOptions.class);
        if (opts != null) {
            return opts;
        }
        opts = new QueueServiceRequestOptions();
        QueueRequestOptions requestOpts = (QueueRequestOptions)exchange.getIn().getHeader("QueueRequestOptions", QueueRequestOptions.class);
        OperationContext opContext = (OperationContext)exchange.getIn().getHeader("QueueOperationContext", OperationContext.class);
        opts.setOpContext(opContext);
        opts.setRequestOpts(requestOpts);
        return opts;
    }
}

