/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.EtcdSecurityContext;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.etcd.EtcdHelper;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriParams
public class EtcdConfiguration
implements CamelContextAware,
Cloneable {
    @UriParam(label="common", defaultValue="http://localhost:2379,http://localhost:4001")
    private String uris = "http://localhost:2379,http://localhost:4001";
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="consumer", description="To send an empty message in case of timeout watching for a key.")
    private boolean sendEmptyExchangeOnTimeout;
    @UriParam
    private boolean recursive;
    @UriParam(label="producer", description="To set the lifespan of a key in milliseconds.")
    private Integer timeToLive;
    @UriParam
    private Long timeout;
    @UriParam(label="consumer,advanced", defaultValue="0", description="The index to watch from")
    private long fromIndex;
    @UriParam(defaultValue="/services/")
    private String servicePath = "/services/";
    private CamelContext context;

    public EtcdConfiguration() {
        this.context = null;
    }

    public EtcdConfiguration(CamelContext camelContext) {
        this.context = camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public String getUris() {
        return this.uris;
    }

    public void setUris(String uris) {
        this.uris = uris;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSendEmptyExchangeOnTimeout() {
        return this.sendEmptyExchangeOnTimeout;
    }

    public void setSendEmptyExchangeOnTimeout(boolean sendEmptyExchangeOnTimeout) {
        this.sendEmptyExchangeOnTimeout = sendEmptyExchangeOnTimeout;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != null && this.timeout > 0L;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public long getFromIndex() {
        return this.fromIndex;
    }

    public void setFromIndex(long fromIndex) {
        this.fromIndex = fromIndex;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public EtcdClient createClient() throws Exception {
        return new EtcdClient(new EtcdSecurityContext(this.sslContextParameters != null ? this.sslContextParameters.createSSLContext(this.context) : null, this.userName, this.password), EtcdHelper.resolveURIs(this.context, this.getUris()));
    }

    public EtcdConfiguration copy() {
        try {
            return (EtcdConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

