/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlsecurity.XmlSecurityProducer;
import org.apache.camel.component.xmlsecurity.XmlSignerComponent;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.12.0", scheme="xmlsecurity-sign", title="XML Security Sign", syntax="xmlsecurity-sign:name", producerOnly=true, label="security,transformation")
public class XmlSignerEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam
    private XmlSignerConfiguration configuration;

    public XmlSignerEndpoint(String uri, XmlSignerComponent component, XmlSignerConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XmlSignerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(XmlSignerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        XmlSignerProcessor processor = new XmlSignerProcessor(this.getCamelContext(), this.getConfiguration());
        return new XmlSecurityProducer((Endpoint)this, processor);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("XML Signature endpoints are not meant to be consumed from.");
    }
}

