/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.management.DefaultManagementObjectNameStrategy;
import org.apache.camel.management.DefaultManagementObjectStrategy;
import org.apache.camel.management.ManagedCamelContextImpl;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxManagementStrategy
extends DefaultManagementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JmxManagementStrategy.class);
    private final List<Object> managed = new ArrayList<Object>();

    public JmxManagementStrategy() {
    }

    public JmxManagementStrategy(CamelContext context, ManagementAgent managementAgent) {
        super(context, managementAgent);
        context.setExtension(ManagedCamelContext.class, (Object)new ManagedCamelContextImpl(context));
    }

    public void manageObject(Object managedObject) throws Exception {
        if (!this.isStartingOrStarted()) {
            this.managed.add(managedObject);
            return;
        }
        ObjectName objectName = this.getManagementObjectNameStrategy().getObjectName(managedObject);
        if (objectName != null) {
            this.getManagementAgent().register(managedObject, objectName);
        }
    }

    public void unmanageObject(Object managedObject) throws Exception {
        if (!this.isStartingOrStarted()) {
            this.managed.remove(managedObject);
            return;
        }
        ObjectName objectName = this.getManagementObjectNameStrategy().getObjectName(managedObject);
        if (objectName != null) {
            this.getManagementAgent().unregister(objectName);
        }
    }

    public boolean isManaged(Object managedObject) {
        try {
            ObjectName name = this.getManagementObjectNameStrategy().getObjectName(managedObject);
            if (name != null) {
                return this.getManagementAgent().isRegistered(name);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot check whether the managed object is registered. This exception will be ignored.", (Throwable)e);
        }
        return false;
    }

    public boolean isManagedName(Object name) {
        try {
            if (name instanceof ObjectName) {
                return this.getManagementAgent().isRegistered((ObjectName)name);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot check whether the managed object is registered. This exception will be ignored.", (Throwable)e);
        }
        return false;
    }

    public boolean manageProcessor(NamedNode definition) {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (Object o : this.managed) {
            this.manageObject(o);
        }
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy(String domain) {
        return new DefaultManagementObjectNameStrategy(domain);
    }

    protected ManagementObjectStrategy createManagementObjectStrategy() {
        return new DefaultManagementObjectStrategy();
    }
}

