/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import io.debezium.embedded.EmbeddedEngine;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.support.DefaultConsumer;
import org.apache.kafka.connect.source.SourceRecord;

public class DebeziumConsumer
extends DefaultConsumer {
    private final DebeziumEndpoint endpoint;
    private final EmbeddedDebeziumConfiguration configuration;
    private ExecutorService executorService;
    private EmbeddedEngine dbzEngine;

    public DebeziumConsumer(DebeziumEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executorService = this.endpoint.createExecutor();
        this.dbzEngine = this.createDbzEngine();
        this.executorService.submit((Runnable)this.dbzEngine);
    }

    protected void doStop() throws Exception {
        this.dbzEngine.stop();
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
        super.doStop();
    }

    private EmbeddedEngine createDbzEngine() {
        return EmbeddedEngine.create().using(this.configuration.createDebeziumConfiguration()).notifying(this::onEventListener).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventListener(SourceRecord event) {
        Exchange exchange = this.endpoint.createDbzExchange(event);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

