/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="sample")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SamplingDefinition
extends NoOutputDefinition<SamplingDefinition> {
    @XmlAttribute
    @Metadata(defaultValue="1", javaType="java.lang.Long")
    private String samplePeriod;
    @XmlAttribute
    @Metadata(javaType="java.lang.Long")
    private String messageFrequency;
    @XmlAttribute
    @Metadata(defaultValue="SECONDS", enums="NANOSECONDS,MICROSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS", javaType="java.util.concurrent.TimeUnit")
    private String units;

    public SamplingDefinition() {
    }

    public SamplingDefinition(long samplePeriod, TimeUnit units) {
        this.samplePeriod = Long.toString(samplePeriod);
        this.units = units.name();
    }

    public SamplingDefinition(long messageFrequency) {
        this.messageFrequency = Long.toString(messageFrequency);
    }

    public String getShortName() {
        return "sample";
    }

    public String toString() {
        return "Sample[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        if (this.messageFrequency != null) {
            return "1 Exchange per " + this.getMessageFrequency() + " messages received";
        }
        String tu = this.getUnits() != null ? this.getUnits() : TimeUnit.SECONDS.name();
        return "1 Exchange per " + this.getSamplePeriod() + " " + tu.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getLabel() {
        return "sample[" + this.description() + "]";
    }

    public SamplingDefinition sampleMessageFrequency(long messageFrequency) {
        this.setMessageFrequency(messageFrequency);
        return this;
    }

    public SamplingDefinition samplePeriod(long samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public SamplingDefinition timeUnits(TimeUnit units) {
        this.setUnits(units);
        return this;
    }

    public String getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(String samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public void setSamplePeriod(long samplePeriod) {
        this.samplePeriod = Long.toString(samplePeriod);
    }

    public String getMessageFrequency() {
        return this.messageFrequency;
    }

    public void setMessageFrequency(String messageFrequency) {
        this.messageFrequency = messageFrequency;
    }

    public void setMessageFrequency(long messageFrequency) {
        this.messageFrequency = Long.toString(messageFrequency);
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setUnits(TimeUnit units) {
        this.units = units.name();
    }

    public String getUnits() {
        return this.units;
    }
}

