/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Endpoint;
import org.apache.camel.component.aws2.ecs.ECS2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.CreateClusterRequest;
import software.amazon.awssdk.services.ecs.model.CreateClusterResponse;
import software.amazon.awssdk.services.ecs.model.DeleteClusterRequest;
import software.amazon.awssdk.services.ecs.model.DeleteClusterResponse;
import software.amazon.awssdk.services.ecs.model.DescribeClustersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeClustersResponse;
import software.amazon.awssdk.services.ecs.model.ListClustersRequest;
import software.amazon.awssdk.services.ecs.model.ListClustersResponse;

public class ECS2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ECS2Producer.class);
    private transient String ecsProducerToString;

    public ECS2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private ECS2Operations determineOperation(Exchange exchange) {
        ECS2Operations operation = (ECS2Operations)((Object)exchange.getIn().getHeader("CamelAwsECSOperation", ECS2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected ECS2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.ecsProducerToString == null) {
            this.ecsProducerToString = "ECSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.ecsProducerToString;
    }

    public ECS2Endpoint getEndpoint() {
        return (ECS2Endpoint)super.getEndpoint();
    }

    private void listClusters(EcsClient ecsClient, Exchange exchange) {
        ListClustersResponse result;
        ListClustersRequest.Builder builder = ListClustersRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSMaxResults"))) {
            int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsECSMaxResults", Integer.class);
            builder.maxResults(Integer.valueOf(maxRes));
        }
        try {
            ListClustersRequest request = (ListClustersRequest)builder.build();
            result = ecsClient.listClusters(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = ECS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createCluster(EcsClient ecsClient, Exchange exchange) {
        CreateClusterResponse result;
        CreateClusterRequest.Builder builder = CreateClusterRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            String name = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
            builder.clusterName(name);
        }
        try {
            CreateClusterRequest request = (CreateClusterRequest)builder.build();
            result = ecsClient.createCluster(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = ECS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeCluster(EcsClient ecsClient, Exchange exchange) {
        DescribeClustersResponse result;
        DescribeClustersRequest.Builder builder = DescribeClustersRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            String clusterName = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
            builder.clusters(new String[]{clusterName});
        }
        try {
            DescribeClustersRequest request = (DescribeClustersRequest)builder.build();
            result = ecsClient.describeClusters(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Describe Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = ECS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteCluster(EcsClient ecsClient, Exchange exchange) {
        DeleteClusterResponse result;
        DeleteClusterRequest.Builder builder = DeleteClusterRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            throw new IllegalArgumentException("Cluster name must be specified");
        }
        String name = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
        builder.cluster(name);
        try {
            DeleteClusterRequest request = (DeleteClusterRequest)builder.build();
            result = ecsClient.deleteCluster(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = ECS2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

