/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.component.aws2.mq.MQ2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;

public class MQ2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MQ2Producer.class);
    private transient String mqProducerToString;

    public MQ2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listBrokers: {
                this.listBrokers(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case createBroker: {
                this.createBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case deleteBroker: {
                this.deleteBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case rebootBroker: {
                this.rebootBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case updateBroker: {
                this.updateBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case describeBroker: {
                this.describeBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private MQ2Operations determineOperation(Exchange exchange) {
        MQ2Operations operation = (MQ2Operations)((Object)exchange.getIn().getHeader("CamelAwsMQOperation", MQ2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected MQ2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.mqProducerToString == null) {
            this.mqProducerToString = "MQProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.mqProducerToString;
    }

    public MQ2Endpoint getEndpoint() {
        return (MQ2Endpoint)super.getEndpoint();
    }

    private void listBrokers(MqClient mqClient, Exchange exchange) {
        ListBrokersResponse result;
        ListBrokersRequest.Builder builder = ListBrokersRequest.builder();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQMaxResults"))) {
            int maxResults = (Integer)exchange.getIn().getHeader("CamelAwsMQMaxResults", Integer.class);
            builder.maxResults(Integer.valueOf(maxResults));
        }
        try {
            result = mqClient.listBrokers((ListBrokersRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Brokers command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createBroker(MqClient mqClient, Exchange exchange) {
        CreateBrokerResponse result;
        CreateBrokerRequest.Builder builder = CreateBrokerRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerName"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerName = (String)exchange.getIn().getHeader("CamelAwsMQBrokerName", String.class);
        builder.brokerName(brokerName);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngine"))) {
            String brokerEngine = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngine", String.class);
            builder.engineType(EngineType.fromValue((String)brokerEngine));
        } else {
            builder.engineType(EngineType.ACTIVEMQ.name());
        }
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion"))) {
            throw new IllegalArgumentException("Broker Engine Version must be specified");
        }
        String brokerEngineVersion = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion", String.class);
        builder.engineVersion(brokerEngineVersion);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode"))) {
            throw new IllegalArgumentException("Deployment Mode must be specified");
        }
        String deploymentMode = (String)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode", String.class);
        builder.deploymentMode(DeploymentMode.fromValue((String)deploymentMode));
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType"))) {
            throw new IllegalArgumentException("Instance Type must be specified");
        }
        String instanceType = (String)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType", String.class);
        builder.hostInstanceType(instanceType);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerUsers"))) {
            throw new IllegalArgumentException("A Users list must be specified");
        }
        List users = (List)exchange.getIn().getHeader("CamelAwsMQBrokerUsers", List.class);
        builder.users((Collection)users);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible"))) {
            Boolean publiclyAccessible = (Boolean)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible", Boolean.class);
            builder.publiclyAccessible(publiclyAccessible);
        } else {
            builder.publiclyAccessible(Boolean.valueOf(false));
        }
        try {
            result = mqClient.createBroker((CreateBrokerRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteBroker(MqClient mqClient, Exchange exchange) {
        DeleteBrokerResponse result;
        DeleteBrokerRequest.Builder builder = DeleteBrokerRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        builder.brokerId(brokerId);
        try {
            result = mqClient.deleteBroker((DeleteBrokerRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void rebootBroker(MqClient mqClient, Exchange exchange) {
        RebootBrokerResponse result;
        RebootBrokerRequest.Builder builder = RebootBrokerRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        builder.brokerId(brokerId);
        try {
            result = mqClient.rebootBroker((RebootBrokerRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateBroker(MqClient mqClient, Exchange exchange) {
        UpdateBrokerResponse result;
        UpdateBrokerRequest.Builder builder = UpdateBrokerRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        builder.brokerId(brokerId);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQConfigurationID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        ConfigurationId configurationId = (ConfigurationId)exchange.getIn().getHeader("CamelAwsMQConfigurationID", ConfigurationId.class);
        builder.configuration(configurationId);
        try {
            result = mqClient.updateBroker((UpdateBrokerRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Update Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeBroker(MqClient mqClient, Exchange exchange) {
        DescribeBrokerResponse result;
        DescribeBrokerRequest.Builder builder = DescribeBrokerRequest.builder();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
            throw new IllegalArgumentException("Broker Name must be specified");
        }
        String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
        builder.brokerId(brokerId);
        try {
            result = mqClient.describeBroker((DescribeBrokerRequest)builder.build());
        }
        catch (AwsServiceException ase) {
            LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = MQ2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

