/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxPlatformHttpSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpSupport.class);

    private VertxPlatformHttpSupport() {
    }

    static Object toHttpResponse(HttpServerResponse response, Message message, HeaderFilterStrategy headerFilterStrategy) {
        String contentType;
        Exchange exchange = message.getExchange();
        TypeConverter tc = exchange.getContext().getTypeConverter();
        int code = VertxPlatformHttpSupport.determineResponseCode(exchange, message.getBody());
        response.setStatusCode(code);
        if (headerFilterStrategy != null) {
            for (Map.Entry entry : message.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Iterator it = ObjectHelper.createIterator(value, null);
                String firstValue = null;
                ArrayList<String> values = null;
                while (it.hasNext()) {
                    String headerValue = (String)tc.convertTo(String.class, it.next());
                    if (headerValue == null || headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
                    if (firstValue == null) {
                        firstValue = headerValue;
                        continue;
                    }
                    if (values == null) {
                        values = new ArrayList<String>();
                        values.add(firstValue);
                    }
                    values.add(headerValue);
                }
                if (values != null) {
                    response.putHeader(key, values);
                    continue;
                }
                if (firstValue == null) continue;
                response.putHeader(key, firstValue);
            }
        }
        Object body = message.getBody();
        Exception exception = exchange.getException();
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            body = ByteBuffer.wrap(sw.toString().getBytes(StandardCharsets.UTF_8));
            message.setHeader("Content-Type", (Object)"text/plain; charset=utf-8");
            ExchangeHelper.setFailureHandled((Exchange)exchange);
        }
        if ((contentType = MessageHelper.getContentType((Message)message)) != null) {
            response.putHeader("Content-Type", contentType);
        }
        return body;
    }

    static int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).trim().isEmpty())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    static void writeResponse(RoutingContext ctx, Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        Object body = VertxPlatformHttpSupport.toHttpResponse(ctx.response(), camelExchange.getMessage(), headerFilterStrategy);
        HttpServerResponse response = ctx.response();
        if (body == null) {
            LOGGER.trace("No payload to send as reply for exchange: {}", (Object)camelExchange);
            response.end();
        } else if (body instanceof String) {
            response.end((String)body);
        } else if (body instanceof InputStream) {
            byte[] bytes = new byte[4096];
            try (InputStream in = (InputStream)body;){
                int len;
                while ((len = in.read(bytes)) >= 0) {
                    Buffer b = Buffer.buffer((int)len);
                    b.appendBytes(bytes, 0, len);
                    response.write(b);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            response.end();
        } else {
            TypeConverter tc = camelExchange.getContext().getTypeConverter();
            try {
                ByteBuffer bb = (ByteBuffer)tc.mandatoryConvertTo(ByteBuffer.class, body);
                Buffer b = Buffer.buffer((int)bb.capacity());
                b.setBytes(0, bb);
                response.end(b);
            }
            catch (NoTypeConversionAvailableException | TypeConversionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static void populateCamelHeaders(RoutingContext ctx, Map<String, Object> headersMap, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        HttpServerRequest request = ctx.request();
        headersMap.put("CamelHttpPath", request.path());
        if (headerFilterStrategy != null) {
            MultiMap requestHeaders = request.headers();
            String authz = requestHeaders.get("authorization");
            if (authz != null && authz.trim().startsWith("Basic") && !headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                VertxPlatformHttpSupport.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (String name : requestHeaders.names()) {
                for (String value : requestHeaders.getAll(name)) {
                    if (headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), (Object)value, exchange)) continue;
                    VertxPlatformHttpSupport.appendHeader(headersMap, name.toString(), value);
                }
            }
            MultiMap pathParameters = ctx.queryParams();
            if (!pathParameters.isEmpty()) {
                for (String name : pathParameters.names()) {
                    for (String value : pathParameters.getAll(name)) {
                        if (headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                        VertxPlatformHttpSupport.appendHeader(headersMap, name, value);
                    }
                }
            }
        }
        for (Map.Entry en : ctx.pathParams().entrySet()) {
            VertxPlatformHttpSupport.appendHeader(headersMap, (String)en.getKey(), en.getValue());
        }
        headersMap.put("CamelHttpMethod", request.method().toString());
        headersMap.put("CamelHttpUrl", request.absoluteURI());
        headersMap.put("CamelHttpUri", request.uri());
        headersMap.put("CamelHttpQuery", request.query());
        headersMap.put("CamelHttpRawQuery", request.query());
    }

    static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }
}

