/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttp;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VertxPlatformHttpServer
extends ServiceSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpServer.class);
    private final CamelContext context;
    private final VertxPlatformHttpServerConfiguration configuration;
    private ExecutorService executor;
    private Vertx vertx;
    private boolean localVertx;
    private HttpServer server;

    public VertxPlatformHttpServer(CamelContext context, VertxPlatformHttpServerConfiguration configuration) {
        this(context, configuration, null);
    }

    public VertxPlatformHttpServer(CamelContext context, VertxPlatformHttpServerConfiguration configuration, Vertx vertx) {
        this.context = context;
        this.configuration = configuration;
        this.vertx = vertx;
    }

    protected void doStart() throws Exception {
        this.vertx = (Vertx)CamelContextHelper.findByType((CamelContext)this.context, Vertx.class);
        this.executor = this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "platform-http-service");
        if (this.vertx != null) {
            LOGGER.info("Found Vert.x instance in registry: {}", (Object)this.vertx);
        } else {
            VertxOptions options = (VertxOptions)CamelContextHelper.findByType((CamelContext)this.context, VertxOptions.class);
            if (options == null) {
                options = new VertxOptions();
            }
            LOGGER.info("Creating new Vert.x instance");
            this.vertx = Vertx.vertx((VertxOptions)options);
            this.localVertx = true;
        }
        this.startAsync().toCompletableFuture().join();
    }

    protected void doStop() throws Exception {
        try {
            if (this.server != null) {
                this.stopAsync().toCompletableFuture().join();
            }
        }
        finally {
            this.server = null;
        }
        if (this.vertx != null && this.localVertx) {
            Future<?> future = this.executor.submit(() -> {
                CountDownLatch latch = new CountDownLatch(1);
                this.vertx.close(result -> {
                    try {
                        if (result.failed()) {
                            LOGGER.warn("Failed to close Vert.x reason: {}", (Object)result.cause().getMessage());
                            throw new RuntimeException(result.cause());
                        }
                        LOGGER.info("Vert.x stopped");
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            try {
                future.get();
            }
            finally {
                this.vertx = null;
                this.localVertx = false;
            }
        }
        if (this.executor != null) {
            this.context.getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    private CompletionStage<Void> startAsync() {
        Router router = Router.router((Vertx)this.vertx);
        Router subRouter = Router.router((Vertx)this.vertx);
        router.mountSubRouter(this.configuration.getPath(), subRouter);
        this.context.getRegistry().bind("platform-http-router", (Object)new VertxPlatformHttp(this.vertx, subRouter, Collections.singletonList(this.createBodyHandler())));
        SSLContextParameters sslParameters = this.configuration.getSslContextParameters();
        if (sslParameters == null && this.configuration.isUseGlobalSslContextParameters()) {
            sslParameters = this.context.getSSLContextParameters();
        }
        HttpServerOptions options = new HttpServerOptions();
        if (sslParameters != null) {
            options.setSsl(true);
            options.setKeyCertOptions(this.createKeyCertOptions(sslParameters));
            options.setTrustOptions(this.createTrustOptions(sslParameters));
        }
        this.server = this.vertx.createHttpServer(options);
        return CompletableFuture.runAsync(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.requestHandler((Handler)router).listen(this.configuration.getBindPort(), this.configuration.getBindHost(), result -> {
                try {
                    if (result.failed()) {
                        LOGGER.warn("Failed to start Vert.x HttpServer on {}:{}, reason: {}", new Object[]{this.configuration.getBindHost(), this.configuration.getBindPort(), result.cause().getMessage()});
                        throw new RuntimeException(result.cause());
                    }
                    LOGGER.info("Vert.x HttpServer started on {}:{}", (Object)this.configuration.getBindHost(), (Object)this.configuration.getBindPort());
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.executor);
    }

    protected CompletionStage<Void> stopAsync() {
        return CompletableFuture.runAsync(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            this.context.removeComponent("platform-http");
            this.server.close(result -> {
                try {
                    if (result.failed()) {
                        LOGGER.warn("Failed to close Vert.x HttpServer reason: {}", (Object)result.cause().getMessage());
                        throw new RuntimeException(result.cause());
                    }
                    LOGGER.info("Vert.x HttpServer stopped");
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.executor);
    }

    private Handler<RoutingContext> createBodyHandler() {
        final BodyHandler bodyHandler = BodyHandler.create();
        if (this.configuration.getMaxBodySize() != null) {
            bodyHandler.setBodyLimit(this.configuration.getMaxBodySize().longValueExact());
        }
        bodyHandler.setHandleFileUploads(this.configuration.getBodyHandler().isHandleFileUploads());
        bodyHandler.setUploadsDirectory(this.configuration.getBodyHandler().getUploadsDirectory());
        bodyHandler.setDeleteUploadedFilesOnEnd(this.configuration.getBodyHandler().isDeleteUploadedFilesOnEnd());
        bodyHandler.setMergeFormAttributes(this.configuration.getBodyHandler().isMergeFormAttributes());
        bodyHandler.setPreallocateBodyBuffer(this.configuration.getBodyHandler().isPreallocateBodyBuffer());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                event.request().resume();
                bodyHandler.handle((Object)event);
            }
        };
    }

    private KeyCertOptions createKeyCertOptions(final SSLContextParameters sslContextParameters) {
        return new KeyCertOptions(){

            public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
                return VertxPlatformHttpServer.this.createKeyManagerFactory(sslContextParameters);
            }

            public KeyCertOptions clone() {
                return this;
            }
        };
    }

    private KeyManagerFactory createKeyManagerFactory(SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        KeyManagersParameters keyManagers = sslContextParameters.getKeyManagers();
        if (keyManagers == null) {
            return null;
        }
        String kmfAlgorithm = this.context.resolvePropertyPlaceholders(keyManagers.getAlgorithm());
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = keyManagers.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, this.context.resolvePropertyPlaceholders(keyManagers.getProvider()));
        char[] kmfPassword = null;
        if (keyManagers.getKeyPassword() != null) {
            kmfPassword = this.context.resolvePropertyPlaceholders(keyManagers.getKeyPassword()).toCharArray();
        }
        KeyStore ks = keyManagers.getKeyStore() == null ? null : keyManagers.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        return kmf;
    }

    private TrustOptions createTrustOptions(final SSLContextParameters sslContextParameters) {
        return new TrustOptions(){

            public TrustOptions clone() {
                return this;
            }

            public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
                return VertxPlatformHttpServer.this.createTrustManagerFactory(sslContextParameters);
            }
        };
    }

    private TrustManagerFactory createTrustManagerFactory(SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        TrustManagersParameters trustManagers = sslContextParameters.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        if (trustManagers.getKeyStore() != null) {
            String tmfAlgorithm = this.context.resolvePropertyPlaceholders(trustManagers.getAlgorithm());
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            tmf = trustManagers.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, this.context.resolvePropertyPlaceholders(trustManagers.getProvider()));
            KeyStore ks = trustManagers.getKeyStore() == null ? null : trustManagers.getKeyStore().createKeyStore();
            tmf.init(ks);
        }
        return tmf;
    }
}

