/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Experimental;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.spi.UploadAttacher;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttp;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpConsumer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

@Experimental
@JdkService(value="platform-http-engine")
public class VertxPlatformHttpEngine
extends ServiceSupport
implements PlatformHttpEngine,
CamelContextAware {
    private CamelContext camelContext;
    private VertxPlatformHttp router;
    private List<Handler<RoutingContext>> handlers = Collections.emptyList();
    private UploadAttacher uploadAttacher;

    public VertxPlatformHttp getRouter() {
        return this.router;
    }

    public void setRouter(VertxPlatformHttp router) {
        this.router = router;
    }

    public List<Handler<RoutingContext>> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void setHandlers(List<Handler<RoutingContext>> handlers) {
        if (handlers == null) {
            this.handlers = new ArrayList<Handler<RoutingContext>>(handlers);
        }
    }

    public UploadAttacher getUploadAttacher() {
        return this.uploadAttacher;
    }

    public void setUploadAttacher(UploadAttacher uploadAttacher) {
        this.uploadAttacher = uploadAttacher;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        if (this.router == null) {
            ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
            this.router = VertxPlatformHttp.lookup(this.getCamelContext());
        }
    }

    protected void doStop() throws Exception {
    }

    public Consumer createConsumer(PlatformHttpEndpoint endpoint, Processor processor) {
        ArrayList<Handler<RoutingContext>> handlers = new ArrayList<Handler<RoutingContext>>(this.handlers.size() + this.router.handlers().size());
        handlers.addAll(this.router.handlers());
        handlers.addAll(this.handlers);
        return new VertxPlatformHttpConsumer(endpoint, processor, this.router.router(), handlers, this.uploadAttacher);
    }
}

