/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import java.net.URI;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.apache.camel.component.undertow.UndertowHostOptions;
import org.apache.camel.component.undertow.handlers.CamelRootHandler;
import org.apache.camel.component.undertow.handlers.NotFoundHandler;
import org.apache.camel.component.undertow.handlers.RestRootHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUndertowHost
implements UndertowHost {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUndertowHost.class);
    private final UndertowHostKey key;
    private final UndertowHostOptions options;
    private final CamelRootHandler rootHandler;
    private final RestRootHandler restHandler;
    private Undertow undertow;
    private String hostString;

    public DefaultUndertowHost(UndertowHostKey key) {
        this(key, null);
    }

    public DefaultUndertowHost(UndertowHostKey key, UndertowHostOptions options) {
        this.key = key;
        this.options = options;
        this.rootHandler = new CamelRootHandler(new NotFoundHandler());
        this.restHandler = new RestRootHandler();
        this.restHandler.init(key.getPort());
    }

    @Override
    public void validateEndpointURI(URI httpURI) {
    }

    @Override
    public synchronized HttpHandler registerHandler(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo, HttpHandler handler) {
        if (this.undertow == null) {
            Undertow.Builder builder = Undertow.builder();
            if (this.key.getSslContext() != null) {
                builder.addHttpsListener(this.key.getPort(), this.key.getHost(), this.key.getSslContext());
            } else {
                builder.addHttpListener(this.key.getPort(), this.key.getHost());
            }
            if (this.options != null) {
                if (this.options.getIoThreads() != null) {
                    builder.setIoThreads(this.options.getIoThreads().intValue());
                }
                if (this.options.getWorkerThreads() != null) {
                    builder.setWorkerThreads(this.options.getWorkerThreads().intValue());
                }
                if (this.options.getBufferSize() != null) {
                    builder.setBufferSize(this.options.getBufferSize().intValue());
                }
                if (this.options.getDirectBuffers() != null) {
                    builder.setDirectBuffers(this.options.getDirectBuffers().booleanValue());
                }
                if (this.options.getHttp2Enabled() != null) {
                    builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)this.options.getHttp2Enabled());
                }
            }
            this.undertow = consumer != null && consumer.isRest() ? builder.setHandler((HttpHandler)this.restHandler).build() : builder.setHandler((HttpHandler)this.rootHandler).build();
            LOG.info("Starting Undertow server on {}://{}:{}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort()});
            try {
                this.undertow.start();
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to start Undertow server on {}://{}:{}, reason: {}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort(), e.getMessage()});
                this.undertow.stop();
                this.undertow = null;
                throw e;
            }
        }
        if (consumer != null && consumer.isRest()) {
            this.restHandler.addConsumer(consumer);
            return this.restHandler;
        }
        return this.rootHandler.add(registrationInfo.getUri().getPath(), registrationInfo.getMethodRestrict(), registrationInfo.isMatchOnUriPrefix(), handler);
    }

    @Override
    public synchronized void unregisterHandler(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo) {
        boolean stop;
        if (this.undertow == null) {
            return;
        }
        if (consumer != null && consumer.isRest()) {
            this.restHandler.removeConsumer(consumer);
            stop = this.restHandler.consumers() <= 0;
        } else {
            this.rootHandler.remove(registrationInfo.getUri().getPath(), registrationInfo.getMethodRestrict(), registrationInfo.isMatchOnUriPrefix());
            stop = this.rootHandler.isEmpty();
        }
        if (stop) {
            LOG.info("Stopping Undertow server on {}://{}:{}", new Object[]{this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort()});
            this.undertow.stop();
            this.undertow = null;
        }
    }

    public String toString() {
        if (this.hostString == null) {
            this.hostString = String.format("DefaultUndertowHost[%s://%s:%s]", this.key.getSslContext() != null ? "https" : "http", this.key.getHost(), this.key.getPort());
        }
        return this.hostString;
    }
}

