/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.PulsarMessageListener;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.MessageListener;

public final class CommonCreationStrategyImpl {
    private CommonCreationStrategyImpl() {
    }

    public static ConsumerBuilder<byte[]> create(String name, PulsarEndpoint pulsarEndpoint, PulsarConsumer pulsarConsumer) {
        PulsarConfiguration endpointConfiguration = pulsarEndpoint.getPulsarConfiguration();
        ConsumerBuilder builder = pulsarEndpoint.getPulsarClient().newConsumer().topic(new String[]{pulsarEndpoint.getUri()}).subscriptionName(endpointConfiguration.getSubscriptionName()).receiverQueueSize(endpointConfiguration.getConsumerQueueSize()).consumerName(name).ackTimeout(endpointConfiguration.getAckTimeoutMillis(), TimeUnit.MILLISECONDS).subscriptionInitialPosition(endpointConfiguration.getSubscriptionInitialPosition().toPulsarSubscriptionInitialPosition()).acknowledgmentGroupTime(endpointConfiguration.getAckGroupTimeMillis(), TimeUnit.MILLISECONDS).negativeAckRedeliveryDelay(endpointConfiguration.getNegativeAckRedeliveryDelayMicros(), TimeUnit.MICROSECONDS).messageListener((MessageListener)new PulsarMessageListener(pulsarEndpoint, pulsarConsumer));
        if (endpointConfiguration.getMaxRedeliverCount() != null) {
            DeadLetterPolicy.DeadLetterPolicyBuilder policy = DeadLetterPolicy.builder().maxRedeliverCount(endpointConfiguration.getMaxRedeliverCount().intValue());
            if (endpointConfiguration.getDeadLetterTopic() != null) {
                policy.deadLetterTopic(endpointConfiguration.getDeadLetterTopic());
            }
            builder.deadLetterPolicy(policy.build());
        }
        return builder;
    }
}

