/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * For reading/writing from/to an HDFS filesystem using Hadoop 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface HdfsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the HDFS component.
     */
    public interface HdfsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedHdfsEndpointConsumerBuilder advanced() {
            return (AdvancedHdfsEndpointConsumerBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointConsumerBuilder connectOnStartup(
                boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointConsumerBuilder connectOnStartup(
                String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointConsumerBuilder fileSystemType(
                HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointConsumerBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointConsumerBuilder fileType(HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointConsumerBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointConsumerBuilder keyType(WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointConsumerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointConsumerBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointConsumerBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointConsumerBuilder valueType(WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointConsumerBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The pattern used for scanning the directory.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: *
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder pattern(String pattern) {
            doSetProperty("pattern", pattern);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Sets the download method to use when not using a local working
         * directory. If set to true, the remote files are streamed to the route
         * as they are read. When set to false, the remote files are loaded into
         * memory before being sent into the route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder streamDownload(
                boolean streamDownload) {
            doSetProperty("streamDownload", streamDownload);
            return this;
        }
        /**
         * Sets the download method to use when not using a local working
         * directory. If set to true, the remote files are streamed to the route
         * as they are read. When set to false, the remote files are loaded into
         * memory before being sent into the route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default HdfsEndpointConsumerBuilder streamDownload(String streamDownload) {
            doSetProperty("streamDownload", streamDownload);
            return this;
        }
        /**
         * To define a maximum messages to gather per poll. By default a limit
         * of 100 is set. Can be used to set a limit of e.g. 1000 to avoid when
         * starting up the server that there are thousands of files. Values can
         * only be greater than 0. Notice: If this option is in use then the
         * limit will be applied on the valid files. For example if you have
         * 100000 files and use maxMessagesPerPoll=500, then only the first 500
         * files will be picked up.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: filter
         */
        default HdfsEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * To define a maximum messages to gather per poll. By default a limit
         * of 100 is set. Can be used to set a limit of e.g. 1000 to avoid when
         * starting up the server that there are thousands of files. Values can
         * only be greater than 0. Notice: If this option is in use then the
         * limit will be applied on the valid files. For example if you have
         * 100000 files and use maxMessagesPerPoll=500, then only the first 500
         * files will be picked up.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: filter
         */
        default HdfsEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default HdfsEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointConsumerBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointConsumerBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointConsumerBuilder kerberosUsername(
                String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the HDFS component.
     */
    public interface AdvancedHdfsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default HdfsEndpointConsumerBuilder basic() {
            return (HdfsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedHdfsEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionCodec(
                HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionType(
                CompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: opened
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder openedSuffix(
                String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: read
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder replication(
                short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder replication(
                String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder splitStrategy(
                String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the HDFS component.
     */
    public interface HdfsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedHdfsEndpointProducerBuilder advanced() {
            return (AdvancedHdfsEndpointProducerBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointProducerBuilder connectOnStartup(
                boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointProducerBuilder connectOnStartup(
                String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointProducerBuilder fileSystemType(
                HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointProducerBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointProducerBuilder fileType(HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointProducerBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointProducerBuilder keyType(WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointProducerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointProducerBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointProducerBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointProducerBuilder valueType(WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointProducerBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * Append to existing file. Notice that not all HDFS file systems
         * support the append option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HdfsEndpointProducerBuilder append(boolean append) {
            doSetProperty("append", append);
            return this;
        }
        /**
         * Append to existing file. Notice that not all HDFS file systems
         * support the append option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HdfsEndpointProducerBuilder append(String append) {
            doSetProperty("append", append);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HdfsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default HdfsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether to overwrite existing files with the same name.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HdfsEndpointProducerBuilder overwrite(boolean overwrite) {
            doSetProperty("overwrite", overwrite);
            return this;
        }
        /**
         * Whether to overwrite existing files with the same name.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default HdfsEndpointProducerBuilder overwrite(String overwrite) {
            doSetProperty("overwrite", overwrite);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointProducerBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointProducerBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointProducerBuilder kerberosUsername(
                String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the HDFS component.
     */
    public interface AdvancedHdfsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default HdfsEndpointProducerBuilder basic() {
            return (HdfsEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder compressionCodec(
                HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder compressionType(
                CompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: opened
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder openedSuffix(
                String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: read
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder replication(
                short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder replication(
                String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder splitStrategy(
                String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the HDFS component.
     */
    public interface HdfsEndpointBuilder
            extends
                HdfsEndpointConsumerBuilder,
                HdfsEndpointProducerBuilder {
        default AdvancedHdfsEndpointBuilder advanced() {
            return (AdvancedHdfsEndpointBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointBuilder connectOnStartup(boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default HdfsEndpointBuilder connectOnStartup(String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointBuilder fileSystemType(
                HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> type.
         * 
         * Default: HDFS
         * Group: common
         */
        default HdfsEndpointBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointBuilder fileType(HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsFileType</code> type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         */
        default HdfsEndpointBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointBuilder keyType(WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: NULL
         * Group: common
         */
        default HdfsEndpointBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default HdfsEndpointBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointBuilder valueType(WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.WritableType</code> type.
         * 
         * Default: BYTES
         * Group: common
         */
        default HdfsEndpointBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default HdfsEndpointBuilder kerberosUsername(String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the HDFS component.
     */
    public interface AdvancedHdfsEndpointBuilder
            extends
                AdvancedHdfsEndpointConsumerBuilder,
                AdvancedHdfsEndpointProducerBuilder {
        default HdfsEndpointBuilder basic() {
            return (HdfsEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 67108864
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 500
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 4096
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder compressionCodec(
                HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code>
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder compressionType(
                CompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> type.
         * 
         * Default: NONE
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: opened
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder openedSuffix(String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: read
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder replication(short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Default: 3
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder replication(String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder splitStrategy(String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedHdfsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.hdfs.HdfsFileSystemType</code> enum.
     */
    enum HdfsFileSystemType {
        LOCAL,
        HDFS;
    }

    /**
     * Proxy enum for <code>org.apache.camel.component.hdfs.HdfsFileType</code>
     * enum.
     */
    enum HdfsFileType {
        NORMAL_FILE,
        SEQUENCE_FILE,
        MAP_FILE,
        BLOOMMAP_FILE,
        ARRAY_FILE;
    }

    /**
     * Proxy enum for <code>org.apache.camel.component.hdfs.WritableType</code>
     * enum.
     */
    enum WritableType {
        NULL,
        BOOLEAN,
        BYTE,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        TEXT,
        BYTES;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.hdfs.HdfsCompressionCodec</code> enum.
     */
    enum HdfsCompressionCodec {
        DEFAULT,
        GZIP,
        BZIP2;
    }

    /**
     * Proxy enum for
     * <code>org.apache.hadoop.io.SequenceFile$CompressionType</code> enum.
     */
    enum CompressionType {
        NONE,
        RECORD,
        BLOCK;
    }

    public interface HdfsBuilders {
        /**
         * HDFS (camel-hdfs)
         * For reading/writing from/to an HDFS filesystem using Hadoop 2.x.
         * 
         * Category: hadoop,file
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-hdfs
         * 
         * Syntax: <code>hdfs:hostName:port/path</code>
         * 
         * Path parameter: hostName (required)
         * HDFS host to use
         * 
         * Path parameter: port
         * HDFS port to use
         * Default value: 8020
         * 
         * Path parameter: path (required)
         * The directory path to use
         */
        default HdfsEndpointBuilder hdfs(String path) {
            return HdfsEndpointBuilderFactory.hdfs(path);
        }
    }
    /**
     * HDFS (camel-hdfs)
     * For reading/writing from/to an HDFS filesystem using Hadoop 2.x.
     * 
     * Category: hadoop,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-hdfs
     * 
     * Syntax: <code>hdfs:hostName:port/path</code>
     * 
     * Path parameter: hostName (required)
     * HDFS host to use
     * 
     * Path parameter: port
     * HDFS port to use
     * Default value: 8020
     * 
     * Path parameter: path (required)
     * The directory path to use
     */
    static HdfsEndpointBuilder hdfs(String path) {
        class HdfsEndpointBuilderImpl extends AbstractEndpointBuilder implements HdfsEndpointBuilder, AdvancedHdfsEndpointBuilder {
            public HdfsEndpointBuilderImpl(String path) {
                super("hdfs", path);
            }
        }
        return new HdfsEndpointBuilderImpl(path);
    }
}