/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * For uploading downloading and managing files folders groups collaborations
 * etc on box DOT com.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BoxEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Box component.
     */
    public interface BoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBoxEndpointConsumerBuilder advanced() {
            return (AdvancedBoxEndpointConsumerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BoxEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         */
        default BoxEndpointConsumerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default BoxEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder privateKeyPassword(
                String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointConsumerBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Box component.
     */
    public interface AdvancedBoxEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BoxEndpointConsumerBuilder basic() {
            return (BoxEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBoxEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(
                Map<String, Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                Object accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointConsumerBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Box component.
     */
    public interface BoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBoxEndpointProducerBuilder advanced() {
            return (AdvancedBoxEndpointProducerBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BoxEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BoxEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         */
        default BoxEndpointProducerBuilder authenticationType(
                String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder privateKeyPassword(
                String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointProducerBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Box component.
     */
    public interface AdvancedBoxEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BoxEndpointProducerBuilder basic() {
            return (BoxEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(
                Map<String, Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                Object accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointProducerBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Box component.
     */
    public interface BoxEndpointBuilder
            extends
                BoxEndpointConsumerBuilder,
                BoxEndpointProducerBuilder {
        default AdvancedBoxEndpointBuilder advanced() {
            return (AdvancedBoxEndpointBuilder) this;
        }
        /**
         * Box application client ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The enterprise ID to use for an App Enterprise.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder enterpriseId(String enterpriseId) {
            doSetProperty("enterpriseId", enterpriseId);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The user ID to use for an App User.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BoxEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The type of authentication for connection. Types of Authentication:
         * STANDARD_AUTHENTICATION - OAuth 2.0 (3-legged) SERVER_AUTHENTICATION
         * - OAuth 2.0 with JSON Web Tokens.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: APP_USER_AUTHENTICATION
         * Group: authentication
         */
        default BoxEndpointBuilder authenticationType(String authenticationType) {
            doSetProperty("authenticationType", authenticationType);
            return this;
        }
        /**
         * Box application client secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * The private key for generating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder privateKeyFile(String privateKeyFile) {
            doSetProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * The password for the private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder privateKeyPassword(String privateKeyPassword) {
            doSetProperty("privateKeyPassword", privateKeyPassword);
            return this;
        }
        /**
         * The ID for public key for validating the JWT signature.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder publicKeyId(String publicKeyId) {
            doSetProperty("publicKeyId", publicKeyId);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Box user name, MUST be provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * Box user password, MUST be provided if authSecureStorage is not set,
         * or returns null on first call.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BoxEndpointBuilder userPassword(String userPassword) {
            doSetProperty("userPassword", userPassword);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Box component.
     */
    public interface AdvancedBoxEndpointBuilder
            extends
                AdvancedBoxEndpointConsumerBuilder,
                AdvancedBoxEndpointProducerBuilder {
        default BoxEndpointBuilder basic() {
            return (BoxEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder httpParams(
                Map<String, Object> httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Custom HTTP params for settings like proxy host.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder httpParams(String httpParams) {
            doSetProperty("httpParams", httpParams);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBoxEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option is a: <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                Object accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * Custom Access Token Cache for storing and retrieving access tokens.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.IAccessTokenCache</code> type.
         * 
         * Group: security
         */
        default AdvancedBoxEndpointBuilder accessTokenCache(
                String accessTokenCache) {
            doSetProperty("accessTokenCache", accessTokenCache);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option is a: <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                EncryptionAlgorithm encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The type of encryption algorithm for JWT. Supported Algorithms:
         * RSA_SHA_256 RSA_SHA_384 RSA_SHA_512.
         * 
         * The option will be converted to a
         * <code>com.box.sdk.EncryptionAlgorithm</code> type.
         * 
         * Default: RSA_SHA_256
         * Group: security
         */
        default AdvancedBoxEndpointBuilder encryptionAlgorithm(
                String encryptionAlgorithm) {
            doSetProperty("encryptionAlgorithm", encryptionAlgorithm);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(int maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
        /**
         * The maximum number of access tokens in cache.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: security
         */
        default AdvancedBoxEndpointBuilder maxCacheEntries(
                String maxCacheEntries) {
            doSetProperty("maxCacheEntries", maxCacheEntries);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.box.sdk.EncryptionAlgorithm</code> enum.
     */
    enum EncryptionAlgorithm {
        RSA_SHA_256,
        RSA_SHA_384,
        RSA_SHA_512;
    }

    public interface BoxBuilders {
        /**
         * Box (camel-box)
         * For uploading downloading and managing files folders groups
         * collaborations etc on box DOT com.
         * 
         * Category: api,file,cloud
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-box
         * 
         * Syntax: <code>box:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * The value can be one of: COLLABORATIONS, COMMENTS, EVENT_LOGS, FILES,
         * FOLDERS, GROUPS, EVENTS, SEARCH, TASKS, USERS
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         */
        default BoxEndpointBuilder box(String path) {
            return BoxEndpointBuilderFactory.box(path);
        }
    }
    /**
     * Box (camel-box)
     * For uploading downloading and managing files folders groups
     * collaborations etc on box DOT com.
     * 
     * Category: api,file,cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * Syntax: <code>box:apiName/methodName</code>
     * 
     * Path parameter: apiName (required)
     * What kind of operation to perform
     * The value can be one of: COLLABORATIONS, COMMENTS, EVENT_LOGS, FILES,
     * FOLDERS, GROUPS, EVENTS, SEARCH, TASKS, USERS
     * 
     * Path parameter: methodName (required)
     * What sub operation to use for the selected operation
     */
    static BoxEndpointBuilder box(String path) {
        class BoxEndpointBuilderImpl extends AbstractEndpointBuilder implements BoxEndpointBuilder, AdvancedBoxEndpointBuilder {
            public BoxEndpointBuilderImpl(String path) {
                super("box", path);
            }
        }
        return new BoxEndpointBuilderImpl(path);
    }
}