/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms;

import java.util.HashMap;
import java.util.Map;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class JmsRemoveHeaderTest extends AbstractJMSTest {

    @Test
    public void testRemoveHeader() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        // should not receive the foo header
        mock.expectedHeaderReceived("foo", null);
        // but only the bar header
        mock.expectedHeaderReceived("bar", 123);

        Map<String, Object> headers = new HashMap<>();
        headers.put("foo", "cheese");
        headers.put("bar", 123);

        template.sendBodyAndHeaders("activemq:queue:fooJmsRemoveHeaderTest", "Hello World", headers);

        assertMockEndpointsSatisfied();
    }

    @Override
    protected String getComponentName() {
        return "activemq";
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                from("activemq:queue:fooJmsRemoveHeaderTest").removeHeader("foo").to("activemq:queue:barJmsRemoveHeaderTest");

                from("activemq:queue:barJmsRemoveHeaderTest").to("mock:result");
            }
        };
    }
}
