/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages to/from Azure Event Bus.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ServiceBusEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedServiceBusEndpointConsumerBuilder advanced() {
            return (AdvancedServiceBusEndpointConsumerBuilder) this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder clientOptions(
                com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder clientOptions(
                String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder proxyOptions(
                com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder proxyOptions(
                String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusType(
                org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusType(
                String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the desired operation to be used in the consumer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusConsumerOperationDefinition&lt;/code&gt; type.
         * 
         * Default: receiveMessages
         * Group: consumer
         * 
         * @param consumerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder consumerOperation(
                org.apache.camel.component.azure.servicebus.ServiceBusConsumerOperationDefinition consumerOperation) {
            doSetProperty("consumerOperation", consumerOperation);
            return this;
        }
        /**
         * Sets the desired operation to be used in the consumer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusConsumerOperationDefinition&lt;/code&gt; type.
         * 
         * Default: receiveMessages
         * Group: consumer
         * 
         * @param consumerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder consumerOperation(
                String consumerOperation) {
            doSetProperty("consumerOperation", consumerOperation);
            return this;
        }
        /**
         * Disables auto-complete and auto-abandon of received messages. By
         * default, a successfully processed message is {link
         * ServiceBusReceiverAsyncClient#complete(ServiceBusReceivedMessage)
         * completed}. If an error happens when the message is processed, it is
         * {link
         * ServiceBusReceiverAsyncClient#abandon(ServiceBusReceivedMessage)
         * abandoned}.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param disableAutoComplete the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder disableAutoComplete(
                boolean disableAutoComplete) {
            doSetProperty("disableAutoComplete", disableAutoComplete);
            return this;
        }
        /**
         * Disables auto-complete and auto-abandon of received messages. By
         * default, a successfully processed message is {link
         * ServiceBusReceiverAsyncClient#complete(ServiceBusReceivedMessage)
         * completed}. If an error happens when the message is processed, it is
         * {link
         * ServiceBusReceiverAsyncClient#abandon(ServiceBusReceivedMessage)
         * abandoned}.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param disableAutoComplete the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder disableAutoComplete(
                String disableAutoComplete) {
            doSetProperty("disableAutoComplete", disableAutoComplete);
            return this;
        }
        /**
         * Sets the amount of time to continue auto-renewing the lock. Setting
         * Duration#ZERO or null disables auto-renewal. For {link
         * ServiceBusReceiveMode#RECEIVE_AND_DELETE RECEIVE_AND_DELETE} mode,
         * auto-renewal is disabled.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Default: 5m
         * Group: consumer
         * 
         * @param maxAutoLockRenewDuration the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(
                java.time.Duration maxAutoLockRenewDuration) {
            doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }
        /**
         * Sets the amount of time to continue auto-renewing the lock. Setting
         * Duration#ZERO or null disables auto-renewal. For {link
         * ServiceBusReceiveMode#RECEIVE_AND_DELETE RECEIVE_AND_DELETE} mode,
         * auto-renewal is disabled.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Default: 5m
         * Group: consumer
         * 
         * @param maxAutoLockRenewDuration the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder maxAutoLockRenewDuration(
                String maxAutoLockRenewDuration) {
            doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }
        /**
         * Set the max number of messages to be peeked during the peek
         * operation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param peekNumMaxMessages the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder peekNumMaxMessages(
                Integer peekNumMaxMessages) {
            doSetProperty("peekNumMaxMessages", peekNumMaxMessages);
            return this;
        }
        /**
         * Set the max number of messages to be peeked during the peek
         * operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param peekNumMaxMessages the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder peekNumMaxMessages(
                String peekNumMaxMessages) {
            doSetProperty("peekNumMaxMessages", peekNumMaxMessages);
            return this;
        }
        /**
         * Sets the prefetch count of the receiver. For both {link
         * ServiceBusReceiveMode#PEEK_LOCK PEEK_LOCK} and {link
         * ServiceBusReceiveMode#RECEIVE_AND_DELETE RECEIVE_AND_DELETE} modes
         * the default value is 1. Prefetch speeds up the message flow by aiming
         * to have a message readily available for local retrieval when and
         * before the application asks for one using
         * ServiceBusReceiverAsyncClient#receiveMessages(). Setting a non-zero
         * value will prefetch that number of messages. Setting the value to
         * zero turns prefetch off.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder prefetchCount(
                int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the prefetch count of the receiver. For both {link
         * ServiceBusReceiveMode#PEEK_LOCK PEEK_LOCK} and {link
         * ServiceBusReceiveMode#RECEIVE_AND_DELETE RECEIVE_AND_DELETE} modes
         * the default value is 1. Prefetch speeds up the message flow by aiming
         * to have a message readily available for local retrieval when and
         * before the application asks for one using
         * ServiceBusReceiverAsyncClient#receiveMessages(). Setting a non-zero
         * value will prefetch that number of messages. Setting the value to
         * zero turns prefetch off.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the receiverAsyncClient in order to consume messages in the
         * Consumer.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param receiverAsyncClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder receiverAsyncClient(
                com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient receiverAsyncClient) {
            doSetProperty("receiverAsyncClient", receiverAsyncClient);
            return this;
        }
        /**
         * Sets the receiverAsyncClient in order to consume messages in the
         * Consumer.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param receiverAsyncClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder receiverAsyncClient(
                String receiverAsyncClient) {
            doSetProperty("receiverAsyncClient", receiverAsyncClient);
            return this;
        }
        /**
         * Sets the receive mode for the receiver.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.servicebus.models.ServiceBusReceiveMode&lt;/code&gt; type.
         * 
         * Default: PEEK_LOCK
         * Group: consumer
         * 
         * @param serviceBusReceiveMode the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(
                com.azure.messaging.servicebus.models.ServiceBusReceiveMode serviceBusReceiveMode) {
            doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }
        /**
         * Sets the receive mode for the receiver.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.servicebus.models.ServiceBusReceiveMode&lt;/code&gt; type.
         * 
         * Default: PEEK_LOCK
         * Group: consumer
         * 
         * @param serviceBusReceiveMode the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder serviceBusReceiveMode(
                String serviceBusReceiveMode) {
            doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }
        /**
         * Sets the type of the SubQueue to connect to.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.servicebus.models.SubQueue&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subQueue the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subQueue(
                com.azure.messaging.servicebus.models.SubQueue subQueue) {
            doSetProperty("subQueue", subQueue);
            return this;
        }
        /**
         * Sets the type of the SubQueue to connect to.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.servicebus.models.SubQueue&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subQueue the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subQueue(String subQueue) {
            doSetProperty("subQueue", subQueue);
            return this;
        }
        /**
         * Sets the name of the subscription in the topic to listen to.
         * topicOrQueueName and serviceBusType=topic must also be set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subscriptionName the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder subscriptionName(
                String subscriptionName) {
            doSetProperty("subscriptionName", subscriptionName);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder fullyQualifiedNamespace(
                String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointConsumerBuilder tokenCredential(
                String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure ServiceBus
     * component.
     */
    public interface AdvancedServiceBusEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ServiceBusEndpointConsumerBuilder basic() {
            return (ServiceBusEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServiceBusEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedServiceBusEndpointProducerBuilder advanced() {
            return (AdvancedServiceBusEndpointProducerBuilder) this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder clientOptions(
                com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder clientOptions(
                String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder proxyOptions(
                com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder proxyOptions(
                String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusType(
                org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusType(
                String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the desired operation to be used in the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition&lt;/code&gt; type.
         * 
         * Default: sendMessages
         * Group: producer
         * 
         * @param producerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder producerOperation(
                org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition producerOperation) {
            doSetProperty("producerOperation", producerOperation);
            return this;
        }
        /**
         * Sets the desired operation to be used in the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition&lt;/code&gt; type.
         * 
         * Default: sendMessages
         * Group: producer
         * 
         * @param producerOperation the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder producerOperation(
                String producerOperation) {
            doSetProperty("producerOperation", producerOperation);
            return this;
        }
        /**
         * Sets OffsetDateTime at which the message should appear in the Service
         * Bus queue or topic.
         * 
         * The option is a: &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param scheduledEnqueueTime the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder scheduledEnqueueTime(
                java.time.OffsetDateTime scheduledEnqueueTime) {
            doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }
        /**
         * Sets OffsetDateTime at which the message should appear in the Service
         * Bus queue or topic.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param scheduledEnqueueTime the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder scheduledEnqueueTime(
                String scheduledEnqueueTime) {
            doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }
        /**
         * Sets SenderAsyncClient to be used in the producer.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusSenderAsyncClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param senderAsyncClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder senderAsyncClient(
                com.azure.messaging.servicebus.ServiceBusSenderAsyncClient senderAsyncClient) {
            doSetProperty("senderAsyncClient", senderAsyncClient);
            return this;
        }
        /**
         * Sets SenderAsyncClient to be used in the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusSenderAsyncClient&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param senderAsyncClient the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder senderAsyncClient(
                String senderAsyncClient) {
            doSetProperty("senderAsyncClient", senderAsyncClient);
            return this;
        }
        /**
         * Represents transaction in service. This object just contains
         * transaction id.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusTransactionContext&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param serviceBusTransactionContext the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusTransactionContext(
                com.azure.messaging.servicebus.ServiceBusTransactionContext serviceBusTransactionContext) {
            doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }
        /**
         * Represents transaction in service. This object just contains
         * transaction id.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.messaging.servicebus.ServiceBusTransactionContext&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param serviceBusTransactionContext the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder serviceBusTransactionContext(
                String serviceBusTransactionContext) {
            doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder fullyQualifiedNamespace(
                String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointProducerBuilder tokenCredential(
                String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure ServiceBus
     * component.
     */
    public interface AdvancedServiceBusEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ServiceBusEndpointProducerBuilder basic() {
            return (ServiceBusEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Azure ServiceBus component.
     */
    public interface ServiceBusEndpointBuilder
            extends
                ServiceBusEndpointConsumerBuilder,
                ServiceBusEndpointProducerBuilder {
        default AdvancedServiceBusEndpointBuilder advanced() {
            return (AdvancedServiceBusEndpointBuilder) this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpRetryOptions(
                com.azure.core.amqp.AmqpRetryOptions amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry options for Service Bus clients. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpRetryOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amqpRetryOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpTransportType(
                com.azure.core.amqp.AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Service Bus occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.AmqpTransportType&lt;/code&gt; type.
         * 
         * Default: AMQP
         * Group: common
         * 
         * @param amqpTransportType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder clientOptions(
                com.azure.core.util.ClientOptions clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the ClientOptions to be sent from the client built from this
         * builder, enabling customization of certain properties, as well as
         * support the addition of custom header information. Refer to the
         * ClientOptions documentation for more information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.util.ClientOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder clientOptions(String clientOptions) {
            doSetProperty("clientOptions", clientOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder proxyOptions(
                com.azure.core.amqp.ProxyOptions proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * Sets the proxy configuration to use for ServiceBusSenderAsyncClient.
         * When a proxy is configured, AmqpTransportType#AMQP_WEB_SOCKETS must
         * be used for the transport type.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.amqp.ProxyOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyOptions the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder proxyOptions(String proxyOptions) {
            doSetProperty("proxyOptions", proxyOptions);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder serviceBusType(
                org.apache.camel.component.azure.servicebus.ServiceBusType serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * The service bus type of connection to execute. Queue is for typical
         * queue option and topic for subscription based model.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.servicebus.ServiceBusType&lt;/code&gt; type.
         * 
         * Required: true
         * Default: queue
         * Group: common
         * 
         * @param serviceBusType the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder serviceBusType(String serviceBusType) {
            doSetProperty("serviceBusType", serviceBusType);
            return this;
        }
        /**
         * Sets the connection string for a Service Bus namespace or a specific
         * Service Bus resource.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param connectionString the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * Fully Qualified Namespace of the service bus.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param fullyQualifiedNamespace the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder fullyQualifiedNamespace(
                String fullyQualifiedNamespace) {
            doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder tokenCredential(
                com.azure.core.credential.TokenCredential tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
        /**
         * A TokenCredential for Azure AD authentication, implemented in
         * com.azure.identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.TokenCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param tokenCredential the value to set
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder tokenCredential(String tokenCredential) {
            doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure ServiceBus component.
     */
    public interface AdvancedServiceBusEndpointBuilder
            extends
                AdvancedServiceBusEndpointConsumerBuilder,
                AdvancedServiceBusEndpointProducerBuilder {
        default ServiceBusEndpointBuilder basic() {
            return (ServiceBusEndpointBuilder) this;
        }
    }

    public interface ServiceBusBuilders {
        /**
         * Azure ServiceBus (camel-azure-servicebus)
         * Send and receive messages to/from Azure Event Bus.
         * 
         * Category: cloud,messaging
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-azure-servicebus
         * 
         * Syntax: <code>azure-servicebus:topicOrQueueName</code>
         * 
         * Path parameter: topicOrQueueName
         * Selected topic name or the queue name, that is depending on
         * serviceBusType config. For example if serviceBusType=queue, then this
         * will be the queue name and if serviceBusType=topic, this will be the
         * topic name.
         * 
         * @param path topicOrQueueName
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder azureServicebus(String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder("azure-servicebus", path);
        }
        /**
         * Azure ServiceBus (camel-azure-servicebus)
         * Send and receive messages to/from Azure Event Bus.
         * 
         * Category: cloud,messaging
         * Since: 3.12
         * Maven coordinates: org.apache.camel:camel-azure-servicebus
         * 
         * Syntax: <code>azure-servicebus:topicOrQueueName</code>
         * 
         * Path parameter: topicOrQueueName
         * Selected topic name or the queue name, that is depending on
         * serviceBusType config. For example if serviceBusType=queue, then this
         * will be the queue name and if serviceBusType=topic, this will be the
         * topic name.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topicOrQueueName
         * @return the dsl builder
         */
        default ServiceBusEndpointBuilder azureServicebus(
                String componentName,
                String path) {
            return ServiceBusEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ServiceBusEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ServiceBusEndpointBuilderImpl extends AbstractEndpointBuilder implements ServiceBusEndpointBuilder, AdvancedServiceBusEndpointBuilder {
            public ServiceBusEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ServiceBusEndpointBuilderImpl(path);
    }
}