/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from NSQ realtime distributed messaging platform.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NsqEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the NSQ component.
     */
    public interface NsqEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedNsqEndpointConsumerBuilder advanced() {
            return (AdvancedNsqEndpointConsumerBuilder) this;
        }
        /**
         * The hostnames of one or more nsqlookupd servers (consumer) or nsqd
         * servers (producer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * A String to identify the kind of client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Automatically finish the NSQ Message when it is retrieved from the
         * queue and before the Exchange is processed.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoFinish the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder autoFinish(Boolean autoFinish) {
            doSetProperty("autoFinish", autoFinish);
            return this;
        }
        /**
         * Automatically finish the NSQ Message when it is retrieved from the
         * queue and before the Exchange is processed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoFinish the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder autoFinish(String autoFinish) {
            doSetProperty("autoFinish", autoFinish);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The NSQ channel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param channel the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder channel(String channel) {
            doSetProperty("channel", channel);
            return this;
        }
        /**
         * A Custom NSQ lookup implementation.
         * 
         * The option is a:
         * &lt;code&gt;com.github.brainlag.nsq.lookup.NSQLookup&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param customNSQLookup the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder customNSQLookup(
                com.github.brainlag.nsq.lookup.NSQLookup customNSQLookup) {
            doSetProperty("customNSQLookup", customNSQLookup);
            return this;
        }
        /**
         * A Custom NSQ lookup implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.github.brainlag.nsq.lookup.NSQLookup&lt;/code&gt;
         * type.
         * 
         * Group: consumer
         * 
         * @param customNSQLookup the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder customNSQLookup(
                String customNSQLookup) {
            doSetProperty("customNSQLookup", customNSQLookup);
            return this;
        }
        /**
         * The lookup interval.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param lookupInterval the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder lookupInterval(long lookupInterval) {
            doSetProperty("lookupInterval", lookupInterval);
            return this;
        }
        /**
         * The lookup interval.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param lookupInterval the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder lookupInterval(String lookupInterval) {
            doSetProperty("lookupInterval", lookupInterval);
            return this;
        }
        /**
         * The NSQ lookup server port.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4161
         * Group: consumer
         * 
         * @param lookupServerPort the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder lookupServerPort(int lookupServerPort) {
            doSetProperty("lookupServerPort", lookupServerPort);
            return this;
        }
        /**
         * The NSQ lookup server port.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4161
         * Group: consumer
         * 
         * @param lookupServerPort the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder lookupServerPort(
                String lookupServerPort) {
            doSetProperty("lookupServerPort", lookupServerPort);
            return this;
        }
        /**
         * The NSQ consumer timeout period for messages retrieved from the
         * queue. A value of -1 is the server default.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param messageTimeout the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder messageTimeout(long messageTimeout) {
            doSetProperty("messageTimeout", messageTimeout);
            return this;
        }
        /**
         * The NSQ consumer timeout period for messages retrieved from the
         * queue. A value of -1 is the server default.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param messageTimeout the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder messageTimeout(String messageTimeout) {
            doSetProperty("messageTimeout", messageTimeout);
            return this;
        }
        /**
         * Consumer pool size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder poolSize(int poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * Consumer pool size.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param poolSize the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder poolSize(String poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The requeue interval in milliseconds. A value of -1 is the server
         * default.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param requeueInterval the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder requeueInterval(long requeueInterval) {
            doSetProperty("requeueInterval", requeueInterval);
            return this;
        }
        /**
         * The requeue interval in milliseconds. A value of -1 is the server
         * default.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param requeueInterval the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder requeueInterval(
                String requeueInterval) {
            doSetProperty("requeueInterval", requeueInterval);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the NSQ component.
     */
    public interface AdvancedNsqEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default NsqEndpointConsumerBuilder basic() {
            return (NsqEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNsqEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNsqEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNsqEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNsqEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the NSQ component.
     */
    public interface NsqEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNsqEndpointProducerBuilder advanced() {
            return (AdvancedNsqEndpointProducerBuilder) this;
        }
        /**
         * The hostnames of one or more nsqlookupd servers (consumer) or nsqd
         * servers (producer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * A String to identify the kind of client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The port of the nsqd server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4150
         * Group: producer
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * The port of the nsqd server.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4150
         * Group: producer
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the NSQ component.
     */
    public interface AdvancedNsqEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default NsqEndpointProducerBuilder basic() {
            return (NsqEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the NSQ component.
     */
    public interface NsqEndpointBuilder
            extends
                NsqEndpointConsumerBuilder,
                NsqEndpointProducerBuilder {
        default AdvancedNsqEndpointBuilder advanced() {
            return (AdvancedNsqEndpointBuilder) this;
        }
        /**
         * The hostnames of one or more nsqlookupd servers (consumer) or nsqd
         * servers (producer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder servers(String servers) {
            doSetProperty("servers", servers);
            return this;
        }
        /**
         * A String to identify the kind of client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder secure(boolean secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * Set secure option indicating TLS is required.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secure the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder secure(String secure) {
            doSetProperty("secure", secure);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NsqEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the NSQ component.
     */
    public interface AdvancedNsqEndpointBuilder
            extends
                AdvancedNsqEndpointConsumerBuilder,
                AdvancedNsqEndpointProducerBuilder {
        default NsqEndpointBuilder basic() {
            return (NsqEndpointBuilder) this;
        }
    }

    public interface NsqBuilders {
        /**
         * NSQ (camel-nsq)
         * Send and receive messages from NSQ realtime distributed messaging
         * platform.
         * 
         * Category: messaging
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-nsq
         * 
         * Syntax: <code>nsq:topic</code>
         * 
         * Path parameter: topic (required)
         * The NSQ topic
         * 
         * @param path topic
         * @return the dsl builder
         */
        @Deprecated
        default NsqEndpointBuilder nsq(String path) {
            return NsqEndpointBuilderFactory.endpointBuilder("nsq", path);
        }
        /**
         * NSQ (camel-nsq)
         * Send and receive messages from NSQ realtime distributed messaging
         * platform.
         * 
         * Category: messaging
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-nsq
         * 
         * Syntax: <code>nsq:topic</code>
         * 
         * Path parameter: topic (required)
         * The NSQ topic
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topic
         * @return the dsl builder
         */
        @Deprecated
        default NsqEndpointBuilder nsq(String componentName, String path) {
            return NsqEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    @Deprecated
    static NsqEndpointBuilder endpointBuilder(String componentName, String path) {
        class NsqEndpointBuilderImpl extends AbstractEndpointBuilder implements NsqEndpointBuilder, AdvancedNsqEndpointBuilder {
            public NsqEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new NsqEndpointBuilderImpl(path);
    }
}