/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Sent and receive messages to/from an Apache Kafka broker.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface KafkaEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Kafka component.
     */
    public interface KafkaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedKafkaEndpointConsumerBuilder advanced() {
            return (AdvancedKafkaEndpointConsumerBuilder) this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * URL of the Kafka brokers to use. The format is
         * host1:port1,host2:port2, and the list can be a subset of brokers or a
         * VIP pointing to a subset of brokers. This option is known as
         * bootstrap.servers in the Kafka documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param brokers the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder brokers(String brokers) {
            doSetProperty("brokers", brokers);
            return this;
        }
        /**
         * The client id is a user-specified string sent in each request to help
         * trace calls. It should logically identify the application making the
         * request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder reconnectBackoffMaxMs(
                Integer reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder reconnectBackoffMaxMs(
                String reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder shutdownTimeout(
                String shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Whether to allow doing manual commits via KafkaManualCommit. If this
         * option is enabled then an instance of KafkaManualCommit is stored on
         * the Exchange message header, which allows end users to access this
         * API and perform manual offset commits via the Kafka consumer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param allowManualCommit the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder allowManualCommit(
                boolean allowManualCommit) {
            doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }
        /**
         * Whether to allow doing manual commits via KafkaManualCommit. If this
         * option is enabled then an instance of KafkaManualCommit is stored on
         * the Exchange message header, which allows end users to access this
         * API and perform manual offset commits via the Kafka consumer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param allowManualCommit the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder allowManualCommit(
                String allowManualCommit) {
            doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }
        /**
         * If true, periodically commit to ZooKeeper the offset of messages
         * already fetched by the consumer. This committed offset will be used
         * when the process fails as the position from which the new consumer
         * will begin.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCommitEnable the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoCommitEnable(
                boolean autoCommitEnable) {
            doSetProperty("autoCommitEnable", autoCommitEnable);
            return this;
        }
        /**
         * If true, periodically commit to ZooKeeper the offset of messages
         * already fetched by the consumer. This committed offset will be used
         * when the process fails as the position from which the new consumer
         * will begin.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCommitEnable the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoCommitEnable(
                String autoCommitEnable) {
            doSetProperty("autoCommitEnable", autoCommitEnable);
            return this;
        }
        /**
         * The frequency in ms that the consumer offsets are committed to
         * zookeeper.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param autoCommitIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoCommitIntervalMs(
                Integer autoCommitIntervalMs) {
            doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }
        /**
         * The frequency in ms that the consumer offsets are committed to
         * zookeeper.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param autoCommitIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoCommitIntervalMs(
                String autoCommitIntervalMs) {
            doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }
        /**
         * Whether to perform an explicit auto commit when the consumer stops to
         * ensure the broker has a commit from the last consumed message. This
         * requires the option autoCommitEnable is turned on. The possible
         * values are: sync, async, or none. And sync is the default value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: sync
         * Group: consumer
         * 
         * @param autoCommitOnStop the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoCommitOnStop(
                String autoCommitOnStop) {
            doSetProperty("autoCommitOnStop", autoCommitOnStop);
            return this;
        }
        /**
         * What to do when there is no initial offset in ZooKeeper or if an
         * offset is out of range: earliest : automatically reset the offset to
         * the earliest offset latest : automatically reset the offset to the
         * latest offset fail: throw exception to the consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: latest
         * Group: consumer
         * 
         * @param autoOffsetReset the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder autoOffsetReset(
                String autoOffsetReset) {
            doSetProperty("autoOffsetReset", autoOffsetReset);
            return this;
        }
        /**
         * This options controls what happens when a consumer is processing an
         * exchange and it fails. If the option is false then the consumer
         * continues to the next message and processes it. If the option is true
         * then the consumer breaks out, and will seek back to offset of the
         * message that caused a failure, and then re-attempt to process this
         * message. However this can lead to endless processing of the same
         * message if its bound to fail every time, eg a poison message.
         * Therefore its recommended to deal with that for example by using
         * Camel's error handler.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakOnFirstError the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder breakOnFirstError(
                boolean breakOnFirstError) {
            doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }
        /**
         * This options controls what happens when a consumer is processing an
         * exchange and it fails. If the option is false then the consumer
         * continues to the next message and processes it. If the option is true
         * then the consumer breaks out, and will seek back to offset of the
         * message that caused a failure, and then re-attempt to process this
         * message. However this can lead to endless processing of the same
         * message if its bound to fail every time, eg a poison message.
         * Therefore its recommended to deal with that for example by using
         * Camel's error handler.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakOnFirstError the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder breakOnFirstError(
                String breakOnFirstError) {
            doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Automatically check the CRC32 of the records consumed. This ensures
         * no on-the-wire or on-disk corruption to the messages occurred. This
         * check adds some overhead, so it may be disabled in cases seeking
         * extreme performance.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param checkCrcs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder checkCrcs(Boolean checkCrcs) {
            doSetProperty("checkCrcs", checkCrcs);
            return this;
        }
        /**
         * Automatically check the CRC32 of the records consumed. This ensures
         * no on-the-wire or on-disk corruption to the messages occurred. This
         * check adds some overhead, so it may be disabled in cases seeking
         * extreme performance.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param checkCrcs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder checkCrcs(String checkCrcs) {
            doSetProperty("checkCrcs", checkCrcs);
            return this;
        }
        /**
         * The maximum time, in milliseconds, that the code will wait for a
         * synchronous commit to complete.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param commitTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder commitTimeoutMs(
                Long commitTimeoutMs) {
            doSetProperty("commitTimeoutMs", commitTimeoutMs);
            return this;
        }
        /**
         * The maximum time, in milliseconds, that the code will wait for a
         * synchronous commit to complete.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param commitTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder commitTimeoutMs(
                String commitTimeoutMs) {
            doSetProperty("commitTimeoutMs", commitTimeoutMs);
            return this;
        }
        /**
         * The configuration controls the maximum amount of time the client will
         * wait for the response of a request. If the response is not received
         * before the timeout elapses the client will resend the request if
         * necessary or fail the request if retries are exhausted.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: consumer
         * 
         * @param consumerRequestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder consumerRequestTimeoutMs(
                Integer consumerRequestTimeoutMs) {
            doSetProperty("consumerRequestTimeoutMs", consumerRequestTimeoutMs);
            return this;
        }
        /**
         * The configuration controls the maximum amount of time the client will
         * wait for the response of a request. If the response is not received
         * before the timeout elapses the client will resend the request if
         * necessary or fail the request if retries are exhausted.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: consumer
         * 
         * @param consumerRequestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder consumerRequestTimeoutMs(
                String consumerRequestTimeoutMs) {
            doSetProperty("consumerRequestTimeoutMs", consumerRequestTimeoutMs);
            return this;
        }
        /**
         * The number of consumers that connect to kafka server. Each consumer
         * is run on a separate thread, that retrieves and process the incoming
         * data.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumersCount the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder consumersCount(int consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * The number of consumers that connect to kafka server. Each consumer
         * is run on a separate thread, that retrieves and process the incoming
         * data.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumersCount the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder consumersCount(
                String consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * The maximum amount of data the server should return for a fetch
         * request This is not an absolute maximum, if the first message in the
         * first non-empty partition of the fetch is larger than this value, the
         * message will still be returned to ensure that the consumer can make
         * progress. The maximum message size accepted by the broker is defined
         * via message.max.bytes (broker config) or max.message.bytes (topic
         * config). Note that the consumer performs multiple fetches in
         * parallel.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 52428800
         * Group: consumer
         * 
         * @param fetchMaxBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchMaxBytes(Integer fetchMaxBytes) {
            doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }
        /**
         * The maximum amount of data the server should return for a fetch
         * request This is not an absolute maximum, if the first message in the
         * first non-empty partition of the fetch is larger than this value, the
         * message will still be returned to ensure that the consumer can make
         * progress. The maximum message size accepted by the broker is defined
         * via message.max.bytes (broker config) or max.message.bytes (topic
         * config). Note that the consumer performs multiple fetches in
         * parallel.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 52428800
         * Group: consumer
         * 
         * @param fetchMaxBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchMaxBytes(String fetchMaxBytes) {
            doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }
        /**
         * The minimum amount of data the server should return for a fetch
         * request. If insufficient data is available the request will wait for
         * that much data to accumulate before answering the request.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param fetchMinBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchMinBytes(Integer fetchMinBytes) {
            doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }
        /**
         * The minimum amount of data the server should return for a fetch
         * request. If insufficient data is available the request will wait for
         * that much data to accumulate before answering the request.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param fetchMinBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchMinBytes(String fetchMinBytes) {
            doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }
        /**
         * The maximum amount of time the server will block before answering the
         * fetch request if there isn't sufficient data to immediately satisfy
         * fetch.min.bytes.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param fetchWaitMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchWaitMaxMs(
                Integer fetchWaitMaxMs) {
            doSetProperty("fetchWaitMaxMs", fetchWaitMaxMs);
            return this;
        }
        /**
         * The maximum amount of time the server will block before answering the
         * fetch request if there isn't sufficient data to immediately satisfy
         * fetch.min.bytes.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param fetchWaitMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder fetchWaitMaxMs(
                String fetchWaitMaxMs) {
            doSetProperty("fetchWaitMaxMs", fetchWaitMaxMs);
            return this;
        }
        /**
         * A string that uniquely identifies the group of consumer processes to
         * which this consumer belongs. By setting the same group id multiple
         * processes indicate that they are all part of the same consumer group.
         * This option is required for consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param groupId the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * A unique identifier of the consumer instance provided by the end
         * user. Only non-empty strings are permitted. If set, the consumer is
         * treated as a static member, which means that only one instance with
         * this ID is allowed in the consumer group at any time. This can be
         * used in combination with a larger session timeout to avoid group
         * rebalances caused by transient unavailability (e.g. process
         * restarts). If not set, the consumer will join the group as a dynamic
         * member, which is the traditional behavior.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param groupInstanceId the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder groupInstanceId(
                String groupInstanceId) {
            doSetProperty("groupInstanceId", groupInstanceId);
            return this;
        }
        /**
         * To use a custom KafkaHeaderDeserializer to deserialize kafka headers
         * values.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param headerDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder headerDeserializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer headerDeserializer) {
            doSetProperty("headerDeserializer", headerDeserializer);
            return this;
        }
        /**
         * To use a custom KafkaHeaderDeserializer to deserialize kafka headers
         * values.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param headerDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder headerDeserializer(
                String headerDeserializer) {
            doSetProperty("headerDeserializer", headerDeserializer);
            return this;
        }
        /**
         * The expected time between heartbeats to the consumer coordinator when
         * using Kafka's group management facilities. Heartbeats are used to
         * ensure that the consumer's session stays active and to facilitate
         * rebalancing when new consumers join or leave the group. The value
         * must be set lower than session.timeout.ms, but typically should be
         * set no higher than 1/3 of that value. It can be adjusted even lower
         * to control the expected time for normal rebalances.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 3000
         * Group: consumer
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder heartbeatIntervalMs(
                Integer heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The expected time between heartbeats to the consumer coordinator when
         * using Kafka's group management facilities. Heartbeats are used to
         * ensure that the consumer's session stays active and to facilitate
         * rebalancing when new consumers join or leave the group. The value
         * must be set lower than session.timeout.ms, but typically should be
         * set no higher than 1/3 of that value. It can be adjusted even lower
         * to control the expected time for normal rebalances.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 3000
         * Group: consumer
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder heartbeatIntervalMs(
                String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Deserializer class for key that implements the Deserializer
         * interface.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         * 
         * @param keyDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder keyDeserializer(
                String keyDeserializer) {
            doSetProperty("keyDeserializer", keyDeserializer);
            return this;
        }
        /**
         * The maximum amount of data per-partition the server will return. The
         * maximum total memory used for a request will be #partitions
         * max.partition.fetch.bytes. This size must be at least as large as the
         * maximum message size the server allows or else it is possible for the
         * producer to send messages larger than the consumer can fetch. If that
         * happens, the consumer can get stuck trying to fetch a large message
         * on a certain partition.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: consumer
         * 
         * @param maxPartitionFetchBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPartitionFetchBytes(
                Integer maxPartitionFetchBytes) {
            doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }
        /**
         * The maximum amount of data per-partition the server will return. The
         * maximum total memory used for a request will be #partitions
         * max.partition.fetch.bytes. This size must be at least as large as the
         * maximum message size the server allows or else it is possible for the
         * producer to send messages larger than the consumer can fetch. If that
         * happens, the consumer can get stuck trying to fetch a large message
         * on a certain partition.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: consumer
         * 
         * @param maxPartitionFetchBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPartitionFetchBytes(
                String maxPartitionFetchBytes) {
            doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }
        /**
         * The maximum delay between invocations of poll() when using consumer
         * group management. This places an upper bound on the amount of time
         * that the consumer can be idle before fetching more records. If poll()
         * is not called before expiration of this timeout, then the consumer is
         * considered failed and the group will rebalance in order to reassign
         * the partitions to another member.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxPollIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPollIntervalMs(
                Long maxPollIntervalMs) {
            doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }
        /**
         * The maximum delay between invocations of poll() when using consumer
         * group management. This places an upper bound on the amount of time
         * that the consumer can be idle before fetching more records. If poll()
         * is not called before expiration of this timeout, then the consumer is
         * considered failed and the group will rebalance in order to reassign
         * the partitions to another member.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxPollIntervalMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPollIntervalMs(
                String maxPollIntervalMs) {
            doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }
        /**
         * The maximum number of records returned in a single call to poll().
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param maxPollRecords the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPollRecords(
                Integer maxPollRecords) {
            doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }
        /**
         * The maximum number of records returned in a single call to poll().
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param maxPollRecords the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder maxPollRecords(
                String maxPollRecords) {
            doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }
        /**
         * The offset repository to use in order to locally store the offset of
         * each partition of the topic. Defining one will disable the
         * autocommit.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.StateRepository&amp;lt;java.lang.String, java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetRepository the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder offsetRepository(
                org.apache.camel.spi.StateRepository<java.lang.String, java.lang.String> offsetRepository) {
            doSetProperty("offsetRepository", offsetRepository);
            return this;
        }
        /**
         * The offset repository to use in order to locally store the offset of
         * each partition of the topic. Defining one will disable the
         * autocommit.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.StateRepository&amp;lt;java.lang.String, java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetRepository the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder offsetRepository(
                String offsetRepository) {
            doSetProperty("offsetRepository", offsetRepository);
            return this;
        }
        /**
         * The class name of the partition assignment strategy that the client
         * will use to distribute partition ownership amongst consumer instances
         * when group management is used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.clients.consumer.RangeAssignor
         * Group: consumer
         * 
         * @param partitionAssignor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder partitionAssignor(
                String partitionAssignor) {
            doSetProperty("partitionAssignor", partitionAssignor);
            return this;
        }
        /**
         * What to do if kafka threw an exception while polling for new
         * messages. Will by default use the value from the component
         * configuration unless an explicit value has been configured on the
         * endpoint level. DISCARD will discard the message and continue to poll
         * next message. ERROR_HANDLER will use Camel's error handler to process
         * the exception, and afterwards continue to poll next message.
         * RECONNECT will re-connect the consumer and try poll the message again
         * RETRY will let the consumer retry polling the same message again STOP
         * will stop the consumer (have to be manually started/restarted if the
         * consumer should be able to consume messages again).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.PollOnError&lt;/code&gt;
         * type.
         * 
         * Default: ERROR_HANDLER
         * Group: consumer
         * 
         * @param pollOnError the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder pollOnError(
                org.apache.camel.component.kafka.PollOnError pollOnError) {
            doSetProperty("pollOnError", pollOnError);
            return this;
        }
        /**
         * What to do if kafka threw an exception while polling for new
         * messages. Will by default use the value from the component
         * configuration unless an explicit value has been configured on the
         * endpoint level. DISCARD will discard the message and continue to poll
         * next message. ERROR_HANDLER will use Camel's error handler to process
         * the exception, and afterwards continue to poll next message.
         * RECONNECT will re-connect the consumer and try poll the message again
         * RETRY will let the consumer retry polling the same message again STOP
         * will stop the consumer (have to be manually started/restarted if the
         * consumer should be able to consume messages again).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.PollOnError&lt;/code&gt;
         * type.
         * 
         * Default: ERROR_HANDLER
         * Group: consumer
         * 
         * @param pollOnError the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder pollOnError(String pollOnError) {
            doSetProperty("pollOnError", pollOnError);
            return this;
        }
        /**
         * The timeout used when polling the KafkaConsumer.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param pollTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder pollTimeoutMs(Long pollTimeoutMs) {
            doSetProperty("pollTimeoutMs", pollTimeoutMs);
            return this;
        }
        /**
         * The timeout used when polling the KafkaConsumer.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param pollTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder pollTimeoutMs(String pollTimeoutMs) {
            doSetProperty("pollTimeoutMs", pollTimeoutMs);
            return this;
        }
        /**
         * This option allows the user to set a custom resume strategy. The
         * resume strategy is executed when partitions are assigned (i.e.: when
         * connecting or reconnecting). It allows implementations to customize
         * how to resume operations and serve as more flexible alternative to
         * the seekTo and the offsetRepository mechanisms. See the
         * KafkaConsumerResumeStrategy for implementation details. This option
         * does not affect the auto commit setting. It is likely that
         * implementations using this setting will also want to evaluate using
         * the manual commit option along with this.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param resumeStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder resumeStrategy(
                org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy resumeStrategy) {
            doSetProperty("resumeStrategy", resumeStrategy);
            return this;
        }
        /**
         * This option allows the user to set a custom resume strategy. The
         * resume strategy is executed when partitions are assigned (i.e.: when
         * connecting or reconnecting). It allows implementations to customize
         * how to resume operations and serve as more flexible alternative to
         * the seekTo and the offsetRepository mechanisms. See the
         * KafkaConsumerResumeStrategy for implementation details. This option
         * does not affect the auto commit setting. It is likely that
         * implementations using this setting will also want to evaluate using
         * the manual commit option along with this.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeStrategy&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param resumeStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder resumeStrategy(
                String resumeStrategy) {
            doSetProperty("resumeStrategy", resumeStrategy);
            return this;
        }
        /**
         * Set if KafkaConsumer will read from beginning or end on startup:
         * beginning : read from beginning end : read from end This is replacing
         * the earlier property seekToBeginning.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param seekTo the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder seekTo(String seekTo) {
            doSetProperty("seekTo", seekTo);
            return this;
        }
        /**
         * The timeout used to detect failures when using Kafka's group
         * management facilities.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param sessionTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sessionTimeoutMs(
                Integer sessionTimeoutMs) {
            doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }
        /**
         * The timeout used to detect failures when using Kafka's group
         * management facilities.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: consumer
         * 
         * @param sessionTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sessionTimeoutMs(
                String sessionTimeoutMs) {
            doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }
        /**
         * This enables the use of a specific Avro reader for use with the
         * Confluent Platform schema registry and the
         * io.confluent.kafka.serializers.KafkaAvroDeserializer. This option is
         * only available in the Confluent Platform (not standard Apache Kafka).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param specificAvroReader the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder specificAvroReader(
                boolean specificAvroReader) {
            doSetProperty("specificAvroReader", specificAvroReader);
            return this;
        }
        /**
         * This enables the use of a specific Avro reader for use with the
         * Confluent Platform schema registry and the
         * io.confluent.kafka.serializers.KafkaAvroDeserializer. This option is
         * only available in the Confluent Platform (not standard Apache Kafka).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param specificAvroReader the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder specificAvroReader(
                String specificAvroReader) {
            doSetProperty("specificAvroReader", specificAvroReader);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression). This can be used
         * to subscribe to dynamic number of topics matching the pattern.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param topicIsPattern the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder topicIsPattern(
                boolean topicIsPattern) {
            doSetProperty("topicIsPattern", topicIsPattern);
            return this;
        }
        /**
         * Whether the topic is a pattern (regular expression). This can be used
         * to subscribe to dynamic number of topics matching the pattern.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param topicIsPattern the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder topicIsPattern(
                String topicIsPattern) {
            doSetProperty("topicIsPattern", topicIsPattern);
            return this;
        }
        /**
         * Deserializer class for value that implements the Deserializer
         * interface.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringDeserializer
         * Group: consumer
         * 
         * @param valueDeserializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder valueDeserializer(
                String valueDeserializer) {
            doSetProperty("valueDeserializer", valueDeserializer);
            return this;
        }
        /**
         * URL of the Confluent Platform schema registry servers to use. The
         * format is host1:port1,host2:port2. This is known as
         * schema.registry.url in the Confluent Platform documentation. This
         * option is only available in the Confluent Platform (not standard
         * Apache Kafka).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: confluent
         * 
         * @param schemaRegistryURL the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder schemaRegistryURL(
                String schemaRegistryURL) {
            doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }
        /**
         * Sets interceptors for producer or consumers. Producer interceptors
         * have to be classes implementing
         * org.apache.kafka.clients.producer.ProducerInterceptor Consumer
         * interceptors have to be classes implementing
         * org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if
         * you use Producer interceptor on a consumer it will throw a class cast
         * exception in runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: monitoring
         * 
         * @param interceptorClasses the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder interceptorClasses(
                String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosBeforeReloginMinTime(
                Integer kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosBeforeReloginMinTime(
                String kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Kerberos kinit command path. Default is /usr/bin/kinit.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         * 
         * @param kerberosInitCmd the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosInitCmd(
                String kerberosInitCmd) {
            doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }
        /**
         * A list of rules for mapping from principal names to short names
         * (typically operating system usernames). The rules are evaluated in
         * order and the first rule that matches a principal name is used to map
         * it to a short name. Any later rules in the list are ignored. By
         * default, principal names of the form {username}/{hostname}{REALM} are
         * mapped to {username}. For more details on the format please see the
         * security authorization and acls documentation.. Multiple values can
         * be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: security
         * 
         * @param kerberosPrincipalToLocalRules the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosPrincipalToLocalRules(
                String kerberosPrincipalToLocalRules) {
            doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosRenewJitter(
                Double kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosRenewJitter(
                String kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosRenewWindowFactor(
                Double kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder kerberosRenewWindowFactor(
                String kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Expose the kafka sasl.jaas.config parameter Example:
         * org.apache.kafka.common.security.plain.PlainLoginModule required
         * username=USERNAME password=PASSWORD;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslJaasConfig the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder saslJaasConfig(
                String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslKerberosServiceName the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder saslKerberosServiceName(
                String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * The Simple Authentication and Security Layer (SASL) Mechanism used.
         * For the valid values see
         * http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: GSSAPI
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder saslMechanism(String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT
         * and SSL are supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param securityProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder securityProtocol(
                String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol.By default all the available cipher suites are
         * supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslCipherSuites the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslCipherSuites(
                String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1
         * and TLSv1 are enabled by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslEnabledProtocols the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslEnabledProtocols(
                String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: security
         * 
         * @param sslEndpointAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslEndpointAlgorithm(
                String sslEndpointAlgorithm) {
            doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: SunX509
         * Group: security
         * 
         * @param sslKeymanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslKeymanagerAlgorithm(
                String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslKeystoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslKeystoreType(
                String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. Default setting is
         * TLS, which is fine for most cases. Allowed values in recent JVMs are
         * TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in
         * older JVMs, but their usage is discouraged due to known security
         * vulnerabilities.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProvider the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslProvider(String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PKIX
         * Group: security
         * 
         * @param sslTrustmanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslTrustmanagerAlgorithm(
                String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The file format of the trust store file. Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslTruststoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointConsumerBuilder sslTruststoreType(
                String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Kafka component.
     */
    public interface AdvancedKafkaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default KafkaEndpointConsumerBuilder basic() {
            return (KafkaEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Factory to use for creating KafkaManualCommit instances. This allows
         * to plugin a custom factory to create custom KafkaManualCommit
         * instances in case special logic is needed when doing manual commits
         * that deviates from the default implementation that comes out of the
         * box.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param kafkaManualCommitFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder kafkaManualCommitFactory(
                org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory kafkaManualCommitFactory) {
            doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }
        /**
         * Factory to use for creating KafkaManualCommit instances. This allows
         * to plugin a custom factory to create custom KafkaManualCommit
         * instances in case special logic is needed when doing manual commits
         * that deviates from the default implementation that comes out of the
         * box.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param kafkaManualCommitFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder kafkaManualCommitFactory(
                String kafkaManualCommitFactory) {
            doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder kafkaClientFactory(
                org.apache.camel.component.kafka.KafkaClientFactory kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder kafkaClientFactory(
                String kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Kafka component.
     */
    public interface KafkaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedKafkaEndpointProducerBuilder advanced() {
            return (AdvancedKafkaEndpointProducerBuilder) this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * URL of the Kafka brokers to use. The format is
         * host1:port1,host2:port2, and the list can be a subset of brokers or a
         * VIP pointing to a subset of brokers. This option is known as
         * bootstrap.servers in the Kafka documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param brokers the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder brokers(String brokers) {
            doSetProperty("brokers", brokers);
            return this;
        }
        /**
         * The client id is a user-specified string sent in each request to help
         * trace calls. It should logically identify the application making the
         * request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder reconnectBackoffMaxMs(
                Integer reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder reconnectBackoffMaxMs(
                String reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder shutdownTimeout(
                String shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * The total bytes of memory the producer can use to buffer records
         * waiting to be sent to the server. If records are sent faster than
         * they can be delivered to the server the producer will either block or
         * throw an exception based on the preference specified by
         * block.on.buffer.full.This setting should correspond roughly to the
         * total memory the producer will use, but is not a hard bound since not
         * all memory the producer uses is used for buffering. Some additional
         * memory will be used for compression (if compression is enabled) as
         * well as for maintaining in-flight requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 33554432
         * Group: producer
         * 
         * @param bufferMemorySize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder bufferMemorySize(
                Integer bufferMemorySize) {
            doSetProperty("bufferMemorySize", bufferMemorySize);
            return this;
        }
        /**
         * The total bytes of memory the producer can use to buffer records
         * waiting to be sent to the server. If records are sent faster than
         * they can be delivered to the server the producer will either block or
         * throw an exception based on the preference specified by
         * block.on.buffer.full.This setting should correspond roughly to the
         * total memory the producer will use, but is not a hard bound since not
         * all memory the producer uses is used for buffering. Some additional
         * memory will be used for compression (if compression is enabled) as
         * well as for maintaining in-flight requests.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 33554432
         * Group: producer
         * 
         * @param bufferMemorySize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder bufferMemorySize(
                String bufferMemorySize) {
            doSetProperty("bufferMemorySize", bufferMemorySize);
            return this;
        }
        /**
         * This parameter allows you to specify the compression codec for all
         * data generated by this producer. Valid values are none, gzip and
         * snappy.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: producer
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * Close idle connections after the number of milliseconds specified by
         * this config.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 540000
         * Group: producer
         * 
         * @param connectionMaxIdleMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder connectionMaxIdleMs(
                Integer connectionMaxIdleMs) {
            doSetProperty("connectionMaxIdleMs", connectionMaxIdleMs);
            return this;
        }
        /**
         * Close idle connections after the number of milliseconds specified by
         * this config.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 540000
         * Group: producer
         * 
         * @param connectionMaxIdleMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder connectionMaxIdleMs(
                String connectionMaxIdleMs) {
            doSetProperty("connectionMaxIdleMs", connectionMaxIdleMs);
            return this;
        }
        /**
         * An upper bound on the time to report success or failure after a call
         * to send() returns. This limits the total time that a record will be
         * delayed prior to sending, the time to await acknowledgement from the
         * broker (if expected), and the time allowed for retriable send
         * failures.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: producer
         * 
         * @param deliveryTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder deliveryTimeoutMs(
                Integer deliveryTimeoutMs) {
            doSetProperty("deliveryTimeoutMs", deliveryTimeoutMs);
            return this;
        }
        /**
         * An upper bound on the time to report success or failure after a call
         * to send() returns. This limits the total time that a record will be
         * delayed prior to sending, the time to await acknowledgement from the
         * broker (if expected), and the time allowed for retriable send
         * failures.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: producer
         * 
         * @param deliveryTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder deliveryTimeoutMs(
                String deliveryTimeoutMs) {
            doSetProperty("deliveryTimeoutMs", deliveryTimeoutMs);
            return this;
        }
        /**
         * If set to 'true' the producer will ensure that exactly one copy of
         * each message is written in the stream. If 'false', producer retries
         * may write duplicates of the retried message in the stream. If set to
         * true this option will require max.in.flight.requests.per.connection
         * to be set to 1 and retries cannot be zero and additionally acks must
         * be set to 'all'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param enableIdempotence the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder enableIdempotence(
                boolean enableIdempotence) {
            doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }
        /**
         * If set to 'true' the producer will ensure that exactly one copy of
         * each message is written in the stream. If 'false', producer retries
         * may write duplicates of the retried message in the stream. If set to
         * true this option will require max.in.flight.requests.per.connection
         * to be set to 1 and retries cannot be zero and additionally acks must
         * be set to 'all'.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param enableIdempotence the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder enableIdempotence(
                String enableIdempotence) {
            doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }
        /**
         * To use a custom KafkaHeaderSerializer to serialize kafka headers
         * values.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderSerializer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param headerSerializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder headerSerializer(
                org.apache.camel.component.kafka.serde.KafkaHeaderSerializer headerSerializer) {
            doSetProperty("headerSerializer", headerSerializer);
            return this;
        }
        /**
         * To use a custom KafkaHeaderSerializer to serialize kafka headers
         * values.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.serde.KafkaHeaderSerializer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param headerSerializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder headerSerializer(
                String headerSerializer) {
            doSetProperty("headerSerializer", headerSerializer);
            return this;
        }
        /**
         * The record key (or null if no key is specified). If this option has
         * been configured then it take precedence over header
         * KafkaConstants#KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The serializer class for keys (defaults to the same as for messages
         * if nothing is given).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         * 
         * @param keySerializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder keySerializer(String keySerializer) {
            doSetProperty("keySerializer", keySerializer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The producer groups together any records that arrive in between
         * request transmissions into a single batched request. Normally this
         * occurs only under load when records arrive faster than they can be
         * sent out. However in some circumstances the client may want to reduce
         * the number of requests even under moderate load. This setting
         * accomplishes this by adding a small amount of artificial delay that
         * is, rather than immediately sending out a record the producer will
         * wait for up to the given delay to allow other records to be sent so
         * that the sends can be batched together. This can be thought of as
         * analogous to Nagle's algorithm in TCP. This setting gives the upper
         * bound on the delay for batching: once we get batch.size worth of
         * records for a partition it will be sent immediately regardless of
         * this setting, however if we have fewer than this many bytes
         * accumulated for this partition we will 'linger' for the specified
         * time waiting for more records to show up. This setting defaults to 0
         * (i.e. no delay). Setting linger.ms=5, for example, would have the
         * effect of reducing the number of requests sent but would add up to
         * 5ms of latency to records sent in the absense of load.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param lingerMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder lingerMs(Integer lingerMs) {
            doSetProperty("lingerMs", lingerMs);
            return this;
        }
        /**
         * The producer groups together any records that arrive in between
         * request transmissions into a single batched request. Normally this
         * occurs only under load when records arrive faster than they can be
         * sent out. However in some circumstances the client may want to reduce
         * the number of requests even under moderate load. This setting
         * accomplishes this by adding a small amount of artificial delay that
         * is, rather than immediately sending out a record the producer will
         * wait for up to the given delay to allow other records to be sent so
         * that the sends can be batched together. This can be thought of as
         * analogous to Nagle's algorithm in TCP. This setting gives the upper
         * bound on the delay for batching: once we get batch.size worth of
         * records for a partition it will be sent immediately regardless of
         * this setting, however if we have fewer than this many bytes
         * accumulated for this partition we will 'linger' for the specified
         * time waiting for more records to show up. This setting defaults to 0
         * (i.e. no delay). Setting linger.ms=5, for example, would have the
         * effect of reducing the number of requests sent but would add up to
         * 5ms of latency to records sent in the absense of load.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param lingerMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder lingerMs(String lingerMs) {
            doSetProperty("lingerMs", lingerMs);
            return this;
        }
        /**
         * The configuration controls how long sending to kafka will block.
         * These methods can be blocked for multiple reasons. For e.g: buffer
         * full, metadata unavailable.This configuration imposes maximum limit
         * on the total time spent in fetching metadata, serialization of key
         * and value, partitioning and allocation of buffer memory when doing a
         * send(). In case of partitionsFor(), this configuration imposes a
         * maximum time threshold on waiting for metadata.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: producer
         * 
         * @param maxBlockMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxBlockMs(Integer maxBlockMs) {
            doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }
        /**
         * The configuration controls how long sending to kafka will block.
         * These methods can be blocked for multiple reasons. For e.g: buffer
         * full, metadata unavailable.This configuration imposes maximum limit
         * on the total time spent in fetching metadata, serialization of key
         * and value, partitioning and allocation of buffer memory when doing a
         * send(). In case of partitionsFor(), this configuration imposes a
         * maximum time threshold on waiting for metadata.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: producer
         * 
         * @param maxBlockMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxBlockMs(String maxBlockMs) {
            doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }
        /**
         * The maximum number of unacknowledged requests the client will send on
         * a single connection before blocking. Note that if this setting is set
         * to be greater than 1 and there are failed sends, there is a risk of
         * message re-ordering due to retries (i.e., if retries are enabled).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: producer
         * 
         * @param maxInFlightRequest the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxInFlightRequest(
                Integer maxInFlightRequest) {
            doSetProperty("maxInFlightRequest", maxInFlightRequest);
            return this;
        }
        /**
         * The maximum number of unacknowledged requests the client will send on
         * a single connection before blocking. Note that if this setting is set
         * to be greater than 1 and there are failed sends, there is a risk of
         * message re-ordering due to retries (i.e., if retries are enabled).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: producer
         * 
         * @param maxInFlightRequest the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxInFlightRequest(
                String maxInFlightRequest) {
            doSetProperty("maxInFlightRequest", maxInFlightRequest);
            return this;
        }
        /**
         * The maximum size of a request. This is also effectively a cap on the
         * maximum record size. Note that the server has its own cap on record
         * size which may be different from this. This setting will limit the
         * number of record batches the producer will send in a single request
         * to avoid sending huge requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: producer
         * 
         * @param maxRequestSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxRequestSize(
                Integer maxRequestSize) {
            doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }
        /**
         * The maximum size of a request. This is also effectively a cap on the
         * maximum record size. Note that the server has its own cap on record
         * size which may be different from this. This setting will limit the
         * number of record batches the producer will send in a single request
         * to avoid sending huge requests.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: producer
         * 
         * @param maxRequestSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder maxRequestSize(
                String maxRequestSize) {
            doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }
        /**
         * The period of time in milliseconds after which we force a refresh of
         * metadata even if we haven't seen any partition leadership changes to
         * proactively discover any new brokers or partitions.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer
         * 
         * @param metadataMaxAgeMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder metadataMaxAgeMs(
                Integer metadataMaxAgeMs) {
            doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }
        /**
         * The period of time in milliseconds after which we force a refresh of
         * metadata even if we haven't seen any partition leadership changes to
         * proactively discover any new brokers or partitions.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer
         * 
         * @param metadataMaxAgeMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder metadataMaxAgeMs(
                String metadataMaxAgeMs) {
            doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }
        /**
         * A list of classes to use as metrics reporters. Implementing the
         * MetricReporter interface allows plugging in classes that will be
         * notified of new metric creation. The JmxReporter is always included
         * to register JMX statistics.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param metricReporters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder metricReporters(
                String metricReporters) {
            doSetProperty("metricReporters", metricReporters);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param metricsSampleWindowMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder metricsSampleWindowMs(
                Integer metricsSampleWindowMs) {
            doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param metricsSampleWindowMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder metricsSampleWindowMs(
                String metricsSampleWindowMs) {
            doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: producer
         * 
         * @param noOfMetricsSample the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder noOfMetricsSample(
                Integer noOfMetricsSample) {
            doSetProperty("noOfMetricsSample", noOfMetricsSample);
            return this;
        }
        /**
         * The number of samples maintained to compute metrics.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: producer
         * 
         * @param noOfMetricsSample the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder noOfMetricsSample(
                String noOfMetricsSample) {
            doSetProperty("noOfMetricsSample", noOfMetricsSample);
            return this;
        }
        /**
         * The partitioner class for partitioning messages amongst sub-topics.
         * The default partitioner is based on the hash of the key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * org.apache.kafka.clients.producer.internals.DefaultPartitioner
         * Group: producer
         * 
         * @param partitioner the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder partitioner(String partitioner) {
            doSetProperty("partitioner", partitioner);
            return this;
        }
        /**
         * The partition to which the record will be sent (or null if no
         * partition was specified). If this option has been configured then it
         * take precedence over header KafkaConstants#PARTITION_KEY.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param partitionKey the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder partitionKey(Integer partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * The partition to which the record will be sent (or null if no
         * partition was specified). If this option has been configured then it
         * take precedence over header KafkaConstants#PARTITION_KEY.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param partitionKey the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder partitionKey(String partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * The producer will attempt to batch records together into fewer
         * requests whenever multiple records are being sent to the same
         * partition. This helps performance on both the client and the server.
         * This configuration controls the default batch size in bytes. No
         * attempt will be made to batch records larger than this size.Requests
         * sent to brokers will contain multiple batches, one for each partition
         * with data available to be sent.A small batch size will make batching
         * less common and may reduce throughput (a batch size of zero will
         * disable batching entirely). A very large batch size may use memory a
         * bit more wastefully as we will always allocate a buffer of the
         * specified batch size in anticipation of additional records.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 16384
         * Group: producer
         * 
         * @param producerBatchSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder producerBatchSize(
                Integer producerBatchSize) {
            doSetProperty("producerBatchSize", producerBatchSize);
            return this;
        }
        /**
         * The producer will attempt to batch records together into fewer
         * requests whenever multiple records are being sent to the same
         * partition. This helps performance on both the client and the server.
         * This configuration controls the default batch size in bytes. No
         * attempt will be made to batch records larger than this size.Requests
         * sent to brokers will contain multiple batches, one for each partition
         * with data available to be sent.A small batch size will make batching
         * less common and may reduce throughput (a batch size of zero will
         * disable batching entirely). A very large batch size may use memory a
         * bit more wastefully as we will always allocate a buffer of the
         * specified batch size in anticipation of additional records.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 16384
         * Group: producer
         * 
         * @param producerBatchSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder producerBatchSize(
                String producerBatchSize) {
            doSetProperty("producerBatchSize", producerBatchSize);
            return this;
        }
        /**
         * The maximum number of unsent messages that can be queued up the
         * producer when using async mode before either the producer must be
         * blocked or data must be dropped.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param queueBufferingMaxMessages the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder queueBufferingMaxMessages(
                Integer queueBufferingMaxMessages) {
            doSetProperty("queueBufferingMaxMessages", queueBufferingMaxMessages);
            return this;
        }
        /**
         * The maximum number of unsent messages that can be queued up the
         * producer when using async mode before either the producer must be
         * blocked or data must be dropped.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param queueBufferingMaxMessages the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder queueBufferingMaxMessages(
                String queueBufferingMaxMessages) {
            doSetProperty("queueBufferingMaxMessages", queueBufferingMaxMessages);
            return this;
        }
        /**
         * The size of the TCP receive buffer (SO_RCVBUF) to use when reading
         * data.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: producer
         * 
         * @param receiveBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder receiveBufferBytes(
                Integer receiveBufferBytes) {
            doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }
        /**
         * The size of the TCP receive buffer (SO_RCVBUF) to use when reading
         * data.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: producer
         * 
         * @param receiveBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder receiveBufferBytes(
                String receiveBufferBytes) {
            doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }
        /**
         * The amount of time to wait before attempting to reconnect to a given
         * host. This avoids repeatedly connecting to a host in a tight loop.
         * This backoff applies to all requests sent by the consumer to the
         * broker.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: producer
         * 
         * @param reconnectBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder reconnectBackoffMs(
                Integer reconnectBackoffMs) {
            doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }
        /**
         * The amount of time to wait before attempting to reconnect to a given
         * host. This avoids repeatedly connecting to a host in a tight loop.
         * This backoff applies to all requests sent by the consumer to the
         * broker.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: producer
         * 
         * @param reconnectBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder reconnectBackoffMs(
                String reconnectBackoffMs) {
            doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }
        /**
         * Whether the producer should store the RecordMetadata results from
         * sending to Kafka. The results are stored in a List containing the
         * RecordMetadata metadata's. The list is stored on a header with the
         * key KafkaConstants#KAFKA_RECORDMETA.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param recordMetadata the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder recordMetadata(
                boolean recordMetadata) {
            doSetProperty("recordMetadata", recordMetadata);
            return this;
        }
        /**
         * Whether the producer should store the RecordMetadata results from
         * sending to Kafka. The results are stored in a List containing the
         * RecordMetadata metadata's. The list is stored on a header with the
         * key KafkaConstants#KAFKA_RECORDMETA.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param recordMetadata the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder recordMetadata(
                String recordMetadata) {
            doSetProperty("recordMetadata", recordMetadata);
            return this;
        }
        /**
         * The number of acknowledgments the producer requires the leader to
         * have received before considering a request complete. This controls
         * the durability of records that are sent. The following settings are
         * common: acks=0 If set to zero then the producer will not wait for any
         * acknowledgment from the server at all. The record will be immediately
         * added to the socket buffer and considered sent. No guarantee can be
         * made that the server has received the record in this case, and the
         * retries configuration will not take effect (as the client won't
         * generally know of any failures). The offset given back for each
         * record will always be set to -1. acks=1 This will mean the leader
         * will write the record to its local log but will respond without
         * awaiting full acknowledgement from all followers. In this case should
         * the leader fail immediately after acknowledging the record but before
         * the followers have replicated it then the record will be lost.
         * acks=all This means the leader will wait for the full set of in-sync
         * replicas to acknowledge the record. This guarantees that the record
         * will not be lost as long as at least one in-sync replica remains
         * alive. This is the strongest available guarantee.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param requestRequiredAcks the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder requestRequiredAcks(
                String requestRequiredAcks) {
            doSetProperty("requestRequiredAcks", requestRequiredAcks);
            return this;
        }
        /**
         * The amount of time the broker will wait trying to meet the
         * request.required.acks requirement before sending back an error to the
         * client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param requestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder requestTimeoutMs(
                Integer requestTimeoutMs) {
            doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }
        /**
         * The amount of time the broker will wait trying to meet the
         * request.required.acks requirement before sending back an error to the
         * client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param requestTimeoutMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder requestTimeoutMs(
                String requestTimeoutMs) {
            doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }
        /**
         * Setting a value greater than zero will cause the client to resend any
         * record whose send fails with a potentially transient error. Note that
         * this retry is no different than if the client resent the record upon
         * receiving the error. Allowing retries will potentially change the
         * ordering of records because if two records are sent to a single
         * partition, and the first fails and is retried but the second
         * succeeds, then the second record may appear first.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder retries(Integer retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Setting a value greater than zero will cause the client to resend any
         * record whose send fails with a potentially transient error. Note that
         * this retry is no different than if the client resent the record upon
         * receiving the error. Allowing retries will potentially change the
         * ordering of records because if two records are sent to a single
         * partition, and the first fails and is retried but the second
         * succeeds, then the second record may appear first.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder retries(String retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Before each retry, the producer refreshes the metadata of relevant
         * topics to see if a new leader has been elected. Since leader election
         * takes a bit of time, this property specifies the amount of time that
         * the producer waits before refreshing the metadata.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer
         * 
         * @param retryBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder retryBackoffMs(
                Integer retryBackoffMs) {
            doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }
        /**
         * Before each retry, the producer refreshes the metadata of relevant
         * topics to see if a new leader has been elected. Since leader election
         * takes a bit of time, this property specifies the amount of time that
         * the producer waits before refreshing the metadata.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer
         * 
         * @param retryBackoffMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder retryBackoffMs(
                String retryBackoffMs) {
            doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }
        /**
         * Socket write buffer size.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 131072
         * Group: producer
         * 
         * @param sendBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sendBufferBytes(
                Integer sendBufferBytes) {
            doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }
        /**
         * Socket write buffer size.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 131072
         * Group: producer
         * 
         * @param sendBufferBytes the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sendBufferBytes(
                String sendBufferBytes) {
            doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }
        /**
         * The serializer class for messages.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.common.serialization.StringSerializer
         * Group: producer
         * 
         * @param valueSerializer the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder valueSerializer(
                String valueSerializer) {
            doSetProperty("valueSerializer", valueSerializer);
            return this;
        }
        /**
         * To use a custom worker pool for continue routing Exchange after kafka
         * server has acknowledge the message that was sent to it from
         * KafkaProducer using asynchronous non-blocking processing. If using
         * this option then you must handle the lifecycle of the thread pool to
         * shut the pool down when no longer needed.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ExecutorService&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workerPool the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPool(
                ExecutorService workerPool) {
            doSetProperty("workerPool", workerPool);
            return this;
        }
        /**
         * To use a custom worker pool for continue routing Exchange after kafka
         * server has acknowledge the message that was sent to it from
         * KafkaProducer using asynchronous non-blocking processing. If using
         * this option then you must handle the lifecycle of the thread pool to
         * shut the pool down when no longer needed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ExecutorService&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workerPool the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPool(String workerPool) {
            doSetProperty("workerPool", workerPool);
            return this;
        }
        /**
         * Number of core threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param workerPoolCoreSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPoolCoreSize(
                Integer workerPoolCoreSize) {
            doSetProperty("workerPoolCoreSize", workerPoolCoreSize);
            return this;
        }
        /**
         * Number of core threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param workerPoolCoreSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPoolCoreSize(
                String workerPoolCoreSize) {
            doSetProperty("workerPoolCoreSize", workerPoolCoreSize);
            return this;
        }
        /**
         * Maximum number of threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: producer
         * 
         * @param workerPoolMaxSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPoolMaxSize(
                Integer workerPoolMaxSize) {
            doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }
        /**
         * Maximum number of threads for the worker pool for continue routing
         * Exchange after kafka server has acknowledge the message that was sent
         * to it from KafkaProducer using asynchronous non-blocking processing.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: producer
         * 
         * @param workerPoolMaxSize the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder workerPoolMaxSize(
                String workerPoolMaxSize) {
            doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }
        /**
         * URL of the Confluent Platform schema registry servers to use. The
         * format is host1:port1,host2:port2. This is known as
         * schema.registry.url in the Confluent Platform documentation. This
         * option is only available in the Confluent Platform (not standard
         * Apache Kafka).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: confluent
         * 
         * @param schemaRegistryURL the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder schemaRegistryURL(
                String schemaRegistryURL) {
            doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }
        /**
         * Sets interceptors for producer or consumers. Producer interceptors
         * have to be classes implementing
         * org.apache.kafka.clients.producer.ProducerInterceptor Consumer
         * interceptors have to be classes implementing
         * org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if
         * you use Producer interceptor on a consumer it will throw a class cast
         * exception in runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: monitoring
         * 
         * @param interceptorClasses the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder interceptorClasses(
                String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosBeforeReloginMinTime(
                Integer kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosBeforeReloginMinTime(
                String kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Kerberos kinit command path. Default is /usr/bin/kinit.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         * 
         * @param kerberosInitCmd the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosInitCmd(
                String kerberosInitCmd) {
            doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }
        /**
         * A list of rules for mapping from principal names to short names
         * (typically operating system usernames). The rules are evaluated in
         * order and the first rule that matches a principal name is used to map
         * it to a short name. Any later rules in the list are ignored. By
         * default, principal names of the form {username}/{hostname}{REALM} are
         * mapped to {username}. For more details on the format please see the
         * security authorization and acls documentation.. Multiple values can
         * be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: security
         * 
         * @param kerberosPrincipalToLocalRules the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosPrincipalToLocalRules(
                String kerberosPrincipalToLocalRules) {
            doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosRenewJitter(
                Double kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosRenewJitter(
                String kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosRenewWindowFactor(
                Double kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder kerberosRenewWindowFactor(
                String kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Expose the kafka sasl.jaas.config parameter Example:
         * org.apache.kafka.common.security.plain.PlainLoginModule required
         * username=USERNAME password=PASSWORD;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslJaasConfig the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder saslJaasConfig(
                String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslKerberosServiceName the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder saslKerberosServiceName(
                String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * The Simple Authentication and Security Layer (SASL) Mechanism used.
         * For the valid values see
         * http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: GSSAPI
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder saslMechanism(String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT
         * and SSL are supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param securityProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder securityProtocol(
                String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol.By default all the available cipher suites are
         * supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslCipherSuites the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslCipherSuites(
                String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1
         * and TLSv1 are enabled by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslEnabledProtocols the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslEnabledProtocols(
                String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: security
         * 
         * @param sslEndpointAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslEndpointAlgorithm(
                String sslEndpointAlgorithm) {
            doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: SunX509
         * Group: security
         * 
         * @param sslKeymanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslKeymanagerAlgorithm(
                String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The password of the private key in the key store file. This is
         * optional for client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeyPassword the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslKeyPassword(
                String sslKeyPassword) {
            doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }
        /**
         * The location of the key store file. This is optional for client and
         * can be used for two-way authentication for client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeystoreLocation the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslKeystoreLocation(
                String sslKeystoreLocation) {
            doSetProperty("sslKeystoreLocation", sslKeystoreLocation);
            return this;
        }
        /**
         * The store password for the key store file.This is optional for client
         * and only needed if ssl.keystore.location is configured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslKeystorePassword the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslKeystorePassword(
                String sslKeystorePassword) {
            doSetProperty("sslKeystorePassword", sslKeystorePassword);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslKeystoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslKeystoreType(
                String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. Default setting is
         * TLS, which is fine for most cases. Allowed values in recent JVMs are
         * TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in
         * older JVMs, but their usage is discouraged due to known security
         * vulnerabilities.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProvider the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslProvider(String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PKIX
         * Group: security
         * 
         * @param sslTrustmanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslTrustmanagerAlgorithm(
                String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The location of the trust store file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslTruststoreLocation the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslTruststoreLocation(
                String sslTruststoreLocation) {
            doSetProperty("sslTruststoreLocation", sslTruststoreLocation);
            return this;
        }
        /**
         * The password for the trust store file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslTruststorePassword the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslTruststorePassword(
                String sslTruststorePassword) {
            doSetProperty("sslTruststorePassword", sslTruststorePassword);
            return this;
        }
        /**
         * The file format of the trust store file. Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslTruststoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointProducerBuilder sslTruststoreType(
                String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Kafka component.
     */
    public interface AdvancedKafkaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default KafkaEndpointProducerBuilder basic() {
            return (KafkaEndpointProducerBuilder) this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointProducerBuilder kafkaClientFactory(
                org.apache.camel.component.kafka.KafkaClientFactory kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointProducerBuilder kafkaClientFactory(
                String kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Kafka component.
     */
    public interface KafkaEndpointBuilder
            extends
                KafkaEndpointConsumerBuilder,
                KafkaEndpointProducerBuilder {
        default AdvancedKafkaEndpointBuilder advanced() {
            return (AdvancedKafkaEndpointBuilder) this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default KafkaEndpointBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Sets additional properties for either kafka consumer or kafka
         * producer in case they can't be set directly on the camel
         * configurations (e.g: new Kafka properties that are not reflected yet
         * in Camel configurations), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default KafkaEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * URL of the Kafka brokers to use. The format is
         * host1:port1,host2:port2, and the list can be a subset of brokers or a
         * VIP pointing to a subset of brokers. This option is known as
         * bootstrap.servers in the Kafka documentation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param brokers the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder brokers(String brokers) {
            doSetProperty("brokers", brokers);
            return this;
        }
        /**
         * The client id is a user-specified string sent in each request to help
         * trace calls. It should logically identify the application making the
         * request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder reconnectBackoffMaxMs(
                Integer reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * The maximum amount of time in milliseconds to wait when reconnecting
         * to a broker that has repeatedly failed to connect. If provided, the
         * backoff per host will increase exponentially for each consecutive
         * connection failure, up to this maximum. After calculating the backoff
         * increase, 20% random jitter is added to avoid connection storms.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: common
         * 
         * @param reconnectBackoffMaxMs the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder reconnectBackoffMaxMs(
                String reconnectBackoffMaxMs) {
            doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Timeout in milliseconds to wait gracefully for the consumer or
         * producer to shutdown and terminate its worker threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder shutdownTimeout(String shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * URL of the Confluent Platform schema registry servers to use. The
         * format is host1:port1,host2:port2. This is known as
         * schema.registry.url in the Confluent Platform documentation. This
         * option is only available in the Confluent Platform (not standard
         * Apache Kafka).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: confluent
         * 
         * @param schemaRegistryURL the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder schemaRegistryURL(String schemaRegistryURL) {
            doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }
        /**
         * Sets interceptors for producer or consumers. Producer interceptors
         * have to be classes implementing
         * org.apache.kafka.clients.producer.ProducerInterceptor Consumer
         * interceptors have to be classes implementing
         * org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if
         * you use Producer interceptor on a consumer it will throw a class cast
         * exception in runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: monitoring
         * 
         * @param interceptorClasses the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder interceptorClasses(
                String interceptorClasses) {
            doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosBeforeReloginMinTime(
                Integer kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Login thread sleep time between refresh attempts.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: security
         * 
         * @param kerberosBeforeReloginMinTime the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosBeforeReloginMinTime(
                String kerberosBeforeReloginMinTime) {
            doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }
        /**
         * Kerberos kinit command path. Default is /usr/bin/kinit.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /usr/bin/kinit
         * Group: security
         * 
         * @param kerberosInitCmd the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosInitCmd(String kerberosInitCmd) {
            doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }
        /**
         * A list of rules for mapping from principal names to short names
         * (typically operating system usernames). The rules are evaluated in
         * order and the first rule that matches a principal name is used to map
         * it to a short name. Any later rules in the list are ignored. By
         * default, principal names of the form {username}/{hostname}{REALM} are
         * mapped to {username}. For more details on the format please see the
         * security authorization and acls documentation.. Multiple values can
         * be separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: security
         * 
         * @param kerberosPrincipalToLocalRules the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosPrincipalToLocalRules(
                String kerberosPrincipalToLocalRules) {
            doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosRenewJitter(
                Double kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Percentage of random jitter added to the renewal time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.05
         * Group: security
         * 
         * @param kerberosRenewJitter the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosRenewJitter(
                String kerberosRenewJitter) {
            doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosRenewWindowFactor(
                Double kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Login thread will sleep until the specified window factor of time
         * from last refresh to ticket's expiry has been reached, at which time
         * it will try to renew the ticket.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.8
         * Group: security
         * 
         * @param kerberosRenewWindowFactor the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kerberosRenewWindowFactor(
                String kerberosRenewWindowFactor) {
            doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }
        /**
         * Expose the kafka sasl.jaas.config parameter Example:
         * org.apache.kafka.common.security.plain.PlainLoginModule required
         * username=USERNAME password=PASSWORD;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslJaasConfig the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder saslJaasConfig(String saslJaasConfig) {
            doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }
        /**
         * The Kerberos principal name that Kafka runs as. This can be defined
         * either in Kafka's JAAS config or in Kafka's config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param saslKerberosServiceName the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder saslKerberosServiceName(
                String saslKerberosServiceName) {
            doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }
        /**
         * The Simple Authentication and Security Layer (SASL) Mechanism used.
         * For the valid values see
         * http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: GSSAPI
         * Group: security
         * 
         * @param saslMechanism the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder saslMechanism(String saslMechanism) {
            doSetProperty("saslMechanism", saslMechanism);
            return this;
        }
        /**
         * Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT
         * and SSL are supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PLAINTEXT
         * Group: security
         * 
         * @param securityProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder securityProtocol(String securityProtocol) {
            doSetProperty("securityProtocol", securityProtocol);
            return this;
        }
        /**
         * A list of cipher suites. This is a named combination of
         * authentication, encryption, MAC and key exchange algorithm used to
         * negotiate the security settings for a network connection using TLS or
         * SSL network protocol.By default all the available cipher suites are
         * supported.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslCipherSuites the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslCipherSuites(String sslCipherSuites) {
            doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using a Camel SSLContextParameters object. If
         * configured it's applied before the other SSL endpoint parameters.
         * NOTE: Kafka only supports loading keystore from file locations, so
         * prefix the location with file: in the KeyStoreParameters.resource
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1
         * and TLSv1 are enabled by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslEnabledProtocols the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslEnabledProtocols(
                String sslEnabledProtocols) {
            doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }
        /**
         * The endpoint identification algorithm to validate server hostname
         * using server certificate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https
         * Group: security
         * 
         * @param sslEndpointAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslEndpointAlgorithm(
                String sslEndpointAlgorithm) {
            doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }
        /**
         * The algorithm used by key manager factory for SSL connections.
         * Default value is the key manager factory algorithm configured for the
         * Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: SunX509
         * Group: security
         * 
         * @param sslKeymanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslKeymanagerAlgorithm(
                String sslKeymanagerAlgorithm) {
            doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }
        /**
         * The file format of the key store file. This is optional for client.
         * Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslKeystoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslKeystoreType(String sslKeystoreType) {
            doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }
        /**
         * The SSL protocol used to generate the SSLContext. Default setting is
         * TLS, which is fine for most cases. Allowed values in recent JVMs are
         * TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in
         * older JVMs, but their usage is discouraged due to known security
         * vulnerabilities.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProtocol the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslProtocol(String sslProtocol) {
            doSetProperty("sslProtocol", sslProtocol);
            return this;
        }
        /**
         * The name of the security provider used for SSL connections. Default
         * value is the default security provider of the JVM.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslProvider the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslProvider(String sslProvider) {
            doSetProperty("sslProvider", sslProvider);
            return this;
        }
        /**
         * The algorithm used by trust manager factory for SSL connections.
         * Default value is the trust manager factory algorithm configured for
         * the Java Virtual Machine.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PKIX
         * Group: security
         * 
         * @param sslTrustmanagerAlgorithm the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslTrustmanagerAlgorithm(
                String sslTrustmanagerAlgorithm) {
            doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }
        /**
         * The file format of the trust store file. Default value is JKS.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: JKS
         * Group: security
         * 
         * @param sslTruststoreType the value to set
         * @return the dsl builder
         */
        default KafkaEndpointBuilder sslTruststoreType(String sslTruststoreType) {
            doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Kafka component.
     */
    public interface AdvancedKafkaEndpointBuilder
            extends
                AdvancedKafkaEndpointConsumerBuilder,
                AdvancedKafkaEndpointProducerBuilder {
        default KafkaEndpointBuilder basic() {
            return (KafkaEndpointBuilder) this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointBuilder kafkaClientFactory(
                org.apache.camel.component.kafka.KafkaClientFactory kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Factory to use for creating
         * org.apache.kafka.clients.consumer.KafkaConsumer and
         * org.apache.kafka.clients.producer.KafkaProducer instances. This
         * allows to configure a custom factory to create instances with logic
         * that extends the vanilla Kafka clients.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.kafka.KafkaClientFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param kafkaClientFactory the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointBuilder kafkaClientFactory(
                String kafkaClientFactory) {
            doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedKafkaEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface KafkaBuilders {
        /**
         * Kafka (camel-kafka)
         * Sent and receive messages to/from an Apache Kafka broker.
         * 
         * Category: messaging
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-kafka
         * 
         * Syntax: <code>kafka:topic</code>
         * 
         * Path parameter: topic (required)
         * Name of the topic to use. On the consumer you can use comma to
         * separate multiple topics. A producer can only send a message to a
         * single topic.
         * 
         * @param path topic
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kafka(String path) {
            return KafkaEndpointBuilderFactory.endpointBuilder("kafka", path);
        }
        /**
         * Kafka (camel-kafka)
         * Sent and receive messages to/from an Apache Kafka broker.
         * 
         * Category: messaging
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-kafka
         * 
         * Syntax: <code>kafka:topic</code>
         * 
         * Path parameter: topic (required)
         * Name of the topic to use. On the consumer you can use comma to
         * separate multiple topics. A producer can only send a message to a
         * single topic.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topic
         * @return the dsl builder
         */
        default KafkaEndpointBuilder kafka(String componentName, String path) {
            return KafkaEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static KafkaEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class KafkaEndpointBuilderImpl extends AbstractEndpointBuilder implements KafkaEndpointBuilder, AdvancedKafkaEndpointBuilder {
            public KafkaEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new KafkaEndpointBuilderImpl(path);
    }
}