/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.math.BigInteger;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Integrate with Consul service discovery and configuration store.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ConsulEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Consul component.
     */
    public interface ConsulEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedConsulEndpointConsumerBuilder advanced() {
            return (AdvancedConsulEndpointConsumerBuilder) this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder connectTimeout(
                Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder connectTimeoutMillis(
                Long connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder connectTimeoutMillis(
                String connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option is a: &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder consulClient(Object consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder readTimeout(Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder readTimeoutMillis(
                Long readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder readTimeoutMillis(
                String readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder tags(Set<String> tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder writeTimeout(Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder writeTimeoutMillis(
                Long writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointConsumerBuilder writeTimeoutMillis(
                String writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
        /**
         * The second to wait for a watch event, default 10 seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: watch
         * 
         * @param blockSeconds the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder blockSeconds(Integer blockSeconds) {
            doSetProperty("blockSeconds", blockSeconds);
            return this;
        }
        /**
         * The second to wait for a watch event, default 10 seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: watch
         * 
         * @param blockSeconds the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder blockSeconds(String blockSeconds) {
            doSetProperty("blockSeconds", blockSeconds);
            return this;
        }
        /**
         * The first index for watch for, default 0.
         * 
         * The option is a: &lt;code&gt;java.math.BigInteger&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: watch
         * 
         * @param firstIndex the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder firstIndex(BigInteger firstIndex) {
            doSetProperty("firstIndex", firstIndex);
            return this;
        }
        /**
         * The first index for watch for, default 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.math.BigInteger&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: watch
         * 
         * @param firstIndex the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder firstIndex(String firstIndex) {
            doSetProperty("firstIndex", firstIndex);
            return this;
        }
        /**
         * Recursively watch, default false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: watch
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder recursive(boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * Recursively watch, default false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: watch
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default ConsulEndpointConsumerBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Consul component.
     */
    public interface AdvancedConsulEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ConsulEndpointConsumerBuilder basic() {
            return (ConsulEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder consistencyMode(
                Object consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder consistencyMode(
                String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder datacenter(
                String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nodeMeta(
                List<String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointConsumerBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Consul component.
     */
    public interface ConsulEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedConsulEndpointProducerBuilder advanced() {
            return (AdvancedConsulEndpointProducerBuilder) this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder connectTimeout(
                Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder connectTimeoutMillis(
                Long connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder connectTimeoutMillis(
                String connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option is a: &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder consulClient(Object consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder readTimeout(Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder readTimeoutMillis(
                Long readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder readTimeoutMillis(
                String readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder tags(Set<String> tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder writeTimeout(Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder writeTimeoutMillis(
                Long writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointProducerBuilder writeTimeoutMillis(
                String writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * The default action. Can be overridden by CamelConsulAction.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param action the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder action(String action) {
            doSetProperty("action", action);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Default to transform values retrieved from Consul i.e. on KV endpoint
         * to string.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param valueAsString the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder valueAsString(
                boolean valueAsString) {
            doSetProperty("valueAsString", valueAsString);
            return this;
        }
        /**
         * Default to transform values retrieved from Consul i.e. on KV endpoint
         * to string.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param valueAsString the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder valueAsString(String valueAsString) {
            doSetProperty("valueAsString", valueAsString);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Consul component.
     */
    public interface AdvancedConsulEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ConsulEndpointProducerBuilder basic() {
            return (ConsulEndpointProducerBuilder) this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder consistencyMode(
                Object consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder consistencyMode(
                String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder datacenter(
                String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nodeMeta(
                List<String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointProducerBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Consul component.
     */
    public interface ConsulEndpointBuilder
            extends
                ConsulEndpointConsumerBuilder,
                ConsulEndpointProducerBuilder {
        default AdvancedConsulEndpointBuilder advanced() {
            return (AdvancedConsulEndpointBuilder) this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder connectTimeout(Duration connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder connectTimeoutMillis(
                Long connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Connect timeout for OkHttpClient. Deprecation note: Use
         * connectTimeout instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder connectTimeoutMillis(
                String connectTimeoutMillis) {
            doSetProperty("connectTimeoutMillis", connectTimeoutMillis);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option is a: &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consulClient(Object consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * Reference to a com.orbitz.consul.Consul in the registry.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.Consul&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consulClient the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consulClient(String consulClient) {
            doSetProperty("consulClient", consulClient);
            return this;
        }
        /**
         * The default key. Can be overridden by CamelConsulKey.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder pingInstance(boolean pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Configure if the AgentClient should attempt a ping before returning
         * the Consul instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param pingInstance the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder pingInstance(String pingInstance) {
            doSetProperty("pingInstance", pingInstance);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder readTimeout(Duration readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder readTimeoutMillis(Long readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Read timeout for OkHttpClient. Deprecation note: Use readTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param readTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder readTimeoutMillis(String readTimeoutMillis) {
            doSetProperty("readTimeoutMillis", readTimeoutMillis);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder tags(Set<String> tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Set tags. You can separate multiple tags by comma.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * The Consul agent URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder writeTimeout(Duration writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeout the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder writeTimeout(String writeTimeout) {
            doSetProperty("writeTimeout", writeTimeout);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder writeTimeoutMillis(Long writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * Write timeout for OkHttpClient. Deprecation note: Use writeTimeout
         * instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param writeTimeoutMillis the value to set
         * @return the dsl builder
         */
        @Deprecated
        default ConsulEndpointBuilder writeTimeoutMillis(
                String writeTimeoutMillis) {
            doSetProperty("writeTimeoutMillis", writeTimeoutMillis);
            return this;
        }
        /**
         * Sets the ACL token to be used with Consul.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param aclToken the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder aclToken(String aclToken) {
            doSetProperty("aclToken", aclToken);
            return this;
        }
        /**
         * Sets the password to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * SSL configuration using an
         * org.apache.camel.support.jsse.SSLContextParameters instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Sets the username to be used for basic authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param userName the value to set
         * @return the dsl builder
         */
        default ConsulEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Consul component.
     */
    public interface AdvancedConsulEndpointBuilder
            extends
                AdvancedConsulEndpointConsumerBuilder,
                AdvancedConsulEndpointProducerBuilder {
        default ConsulEndpointBuilder basic() {
            return (ConsulEndpointBuilder) this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option is a:
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder consistencyMode(
                Object consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The consistencyMode used for queries, default
         * ConsistencyMode.DEFAULT.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.orbitz.consul.option.ConsistencyMode&lt;/code&gt;
         * type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param consistencyMode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder consistencyMode(
                String consistencyMode) {
            doSetProperty("consistencyMode", consistencyMode);
            return this;
        }
        /**
         * The data center.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param datacenter the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder datacenter(String datacenter) {
            doSetProperty("datacenter", datacenter);
            return this;
        }
        /**
         * The near node to use for queries.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nearNode the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nearNode(String nearNode) {
            doSetProperty("nearNode", nearNode);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nodeMeta(List<String> nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
        /**
         * The note meta-data to use for queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nodeMeta the value to set
         * @return the dsl builder
         */
        default AdvancedConsulEndpointBuilder nodeMeta(String nodeMeta) {
            doSetProperty("nodeMeta", nodeMeta);
            return this;
        }
    }

    public interface ConsulBuilders {
        /**
         * Consul (camel-consul)
         * Integrate with Consul service discovery and configuration store.
         * 
         * Category: cloud,api
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-consul
         * 
         * Syntax: <code>consul:apiEndpoint</code>
         * 
         * Path parameter: apiEndpoint (required)
         * The API endpoint
         * 
         * @param path apiEndpoint
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consul(String path) {
            return ConsulEndpointBuilderFactory.endpointBuilder("consul", path);
        }
        /**
         * Consul (camel-consul)
         * Integrate with Consul service discovery and configuration store.
         * 
         * Category: cloud,api
         * Since: 2.18
         * Maven coordinates: org.apache.camel:camel-consul
         * 
         * Syntax: <code>consul:apiEndpoint</code>
         * 
         * Path parameter: apiEndpoint (required)
         * The API endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiEndpoint
         * @return the dsl builder
         */
        default ConsulEndpointBuilder consul(String componentName, String path) {
            return ConsulEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ConsulEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ConsulEndpointBuilderImpl extends AbstractEndpointBuilder implements ConsulEndpointBuilder, AdvancedConsulEndpointBuilder {
            public ConsulEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ConsulEndpointBuilderImpl(path);
    }
}