/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component;

import javax.annotation.Generated;

/**
 * Component DSL builder.
 * 
 * You can build a component as follows:
 * <pre>
 * KafkaComponent kafka =
 * ComponentBuilderFactory.kafka().setBrokers("{{host:port}}").build();
 * </pre>
 * This creates a new Kafka component, but often you want to register the
 * component to CamelContext, which can be done as follows:
 * <pre>
 * ComponentBuilderFactory.kafka().setBrokers("{{host:port}}").register(camelContext, "kafka");
 * </pre>
 * This configures and registers the component to CamelContext with the name
 * kafka. If you have separate Kafka brokers you can register more components
 * with their own name:
 * <pre>
 * ComponentBuilderFactory.kafka().setBrokers("{{host2:port}}").register(camelContext, "kafka2");
 * </pre>
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface ComponentsBuilderFactory {

    /**
     * ActiveMQ (camel-activemq)
     * Send messages to (or consume from) Apache ActiveMQ. This component
     * extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-activemq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ActivemqComponentBuilderFactory.ActivemqComponentBuilder activemq() {
        return org.apache.camel.builder.component.dsl.ActivemqComponentBuilderFactory.activemq();
    }
    /**
     * Async HTTP Client (AHC) (camel-ahc)
     * Call external HTTP services using Async Http Client.
     * 
     * Category: http
     * Since: 2.8
     * Maven coordinates: org.apache.camel:camel-ahc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AhcComponentBuilderFactory.AhcComponentBuilder ahc() {
        return org.apache.camel.builder.component.dsl.AhcComponentBuilderFactory.ahc();
    }
    /**
     * Async HTTP Client (AHC) Websocket (camel-ahc-ws)
     * Exchange data with external Websocket servers using Async Http Client.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-ahc-ws
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AhcWsComponentBuilderFactory.AhcWsComponentBuilder ahcWs() {
        return org.apache.camel.builder.component.dsl.AhcWsComponentBuilderFactory.ahcWs();
    }
    /**
     * Async HTTP Client (AHC) Secure Websocket (Secure) (camel-ahc-ws)
     * Exchange data with external Websocket servers using Async Http Client.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-ahc-ws
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AhcWssComponentBuilderFactory.AhcWssComponentBuilder ahcWss() {
        return org.apache.camel.builder.component.dsl.AhcWssComponentBuilderFactory.ahcWss();
    }
    /**
     * AMQP (camel-amqp)
     * Messaging with AMQP protocol using Apache QPid Client.
     * 
     * Category: messaging
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-amqp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AmqpComponentBuilderFactory.AmqpComponentBuilder amqp() {
        return org.apache.camel.builder.component.dsl.AmqpComponentBuilderFactory.amqp();
    }
    /**
     * ArangoDb (camel-arangodb)
     * Perform operations on ArangoDb when used as a Document Database, or as a
     * Graph Database
     * 
     * Category: database,nosql
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-arangodb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ArangodbComponentBuilderFactory.ArangodbComponentBuilder arangodb() {
        return org.apache.camel.builder.component.dsl.ArangodbComponentBuilderFactory.arangodb();
    }
    /**
     * AS2 (camel-as2)
     * Transfer data securely and reliably using the AS2 protocol (RFC4130).
     * 
     * Category: file
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-as2
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.As2ComponentBuilderFactory.As2ComponentBuilder as2() {
        return org.apache.camel.builder.component.dsl.As2ComponentBuilderFactory.as2();
    }
    /**
     * Asterisk (camel-asterisk)
     * Interact with Asterisk PBX Server.
     * 
     * Category: voip
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-asterisk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AsteriskComponentBuilderFactory.AsteriskComponentBuilder asterisk() {
        return org.apache.camel.builder.component.dsl.AsteriskComponentBuilderFactory.asterisk();
    }
    /**
     * AtlasMap (camel-atlasmap)
     * Transforms the message using an AtlasMap transformation.
     * 
     * Category: transformation
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-atlasmap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtlasmapComponentBuilderFactory.AtlasmapComponentBuilder atlasmap() {
        return org.apache.camel.builder.component.dsl.AtlasmapComponentBuilderFactory.atlasmap();
    }
    /**
     * Atmos (camel-atmos)
     * Integrate with EMC's ViPR object data services using the Atmos Client.
     * 
     * Category: cloud,file
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-atmos
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtmosComponentBuilderFactory.AtmosComponentBuilder atmos() {
        return org.apache.camel.builder.component.dsl.AtmosComponentBuilderFactory.atmos();
    }
    /**
     * Atmosphere Websocket (camel-atmosphere-websocket)
     * Expose WebSocket endpoints using the Atmosphere framework.
     * 
     * Category: websocket
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-atmosphere-websocket
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtmosphereWebsocketComponentBuilderFactory.AtmosphereWebsocketComponentBuilder atmosphereWebsocket() {
        return org.apache.camel.builder.component.dsl.AtmosphereWebsocketComponentBuilderFactory.atmosphereWebsocket();
    }
    /**
     * Atom (camel-atom)
     * Poll Atom RSS feeds.
     * 
     * Category: rss
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-atom
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomComponentBuilderFactory.AtomComponentBuilder atom() {
        return org.apache.camel.builder.component.dsl.AtomComponentBuilderFactory.atom();
    }
    /**
     * Atomix Map (camel-atomix)
     * Access Atomix's distributed map.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixMapComponentBuilderFactory.AtomixMapComponentBuilder atomixMap() {
        return org.apache.camel.builder.component.dsl.AtomixMapComponentBuilderFactory.atomixMap();
    }
    /**
     * Atomix Messaging (camel-atomix)
     * Access Atomix's group messaging.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixMessagingComponentBuilderFactory.AtomixMessagingComponentBuilder atomixMessaging() {
        return org.apache.camel.builder.component.dsl.AtomixMessagingComponentBuilderFactory.atomixMessaging();
    }
    /**
     * Atomix MultiMap (camel-atomix)
     * Access Atomix's distributed multi map.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixMultimapComponentBuilderFactory.AtomixMultimapComponentBuilder atomixMultimap() {
        return org.apache.camel.builder.component.dsl.AtomixMultimapComponentBuilderFactory.atomixMultimap();
    }
    /**
     * Atomix Queue (camel-atomix)
     * Access Atomix's distributed queue.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixQueueComponentBuilderFactory.AtomixQueueComponentBuilder atomixQueue() {
        return org.apache.camel.builder.component.dsl.AtomixQueueComponentBuilderFactory.atomixQueue();
    }
    /**
     * Atomix Set (camel-atomix)
     * Access Atomix's distributed set.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixSetComponentBuilderFactory.AtomixSetComponentBuilder atomixSet() {
        return org.apache.camel.builder.component.dsl.AtomixSetComponentBuilderFactory.atomixSet();
    }
    /**
     * Atomix Value (camel-atomix)
     * Access Atomix's distributed value.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AtomixValueComponentBuilderFactory.AtomixValueComponentBuilder atomixValue() {
        return org.apache.camel.builder.component.dsl.AtomixValueComponentBuilderFactory.atomixValue();
    }
    /**
     * Avro RPC (camel-avro-rpc)
     * Produce or consume Apache Avro RPC services.
     * 
     * Category: rpc
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-avro-rpc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AvroComponentBuilderFactory.AvroComponentBuilder avro() {
        return org.apache.camel.builder.component.dsl.AvroComponentBuilderFactory.avro();
    }
    /**
     * AWS Secrets Manager (camel-aws-secrets-manager)
     * Manage AWS Secrets Manager services using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-aws-secrets-manager
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AwsSecretsManagerComponentBuilderFactory.AwsSecretsManagerComponentBuilder awsSecretsManager() {
        return org.apache.camel.builder.component.dsl.AwsSecretsManagerComponentBuilderFactory.awsSecretsManager();
    }
    /**
     * AWS Athena (camel-aws2-athena)
     * Access AWS Athena service using AWS SDK version 2.x.
     * 
     * Category: cloud,database
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-aws2-athena
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2AthenaComponentBuilderFactory.Aws2AthenaComponentBuilder aws2Athena() {
        return org.apache.camel.builder.component.dsl.Aws2AthenaComponentBuilderFactory.aws2Athena();
    }
    /**
     * AWS CloudWatch (camel-aws2-cw)
     * Sending metrics to AWS CloudWatch using AWS SDK version 2.x.
     * 
     * Category: cloud,monitoring
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-cw
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2CwComponentBuilderFactory.Aws2CwComponentBuilder aws2Cw() {
        return org.apache.camel.builder.component.dsl.Aws2CwComponentBuilderFactory.aws2Cw();
    }
    /**
     * AWS DynamoDB (camel-aws2-ddb)
     * Store and retrieve data from AWS DynamoDB service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,database,nosql
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2DdbComponentBuilderFactory.Aws2DdbComponentBuilder aws2Ddb() {
        return org.apache.camel.builder.component.dsl.Aws2DdbComponentBuilderFactory.aws2Ddb();
    }
    /**
     * AWS DynamoDB Streams (camel-aws2-ddb)
     * Receive messages from AWS DynamoDB Stream service using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,streams
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2DdbstreamComponentBuilderFactory.Aws2DdbstreamComponentBuilder aws2Ddbstream() {
        return org.apache.camel.builder.component.dsl.Aws2DdbstreamComponentBuilderFactory.aws2Ddbstream();
    }
    /**
     * AWS Elastic Compute Cloud (EC2) (camel-aws2-ec2)
     * Manage AWS EC2 instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ec2
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2Ec2ComponentBuilderFactory.Aws2Ec2ComponentBuilder aws2Ec2() {
        return org.apache.camel.builder.component.dsl.Aws2Ec2ComponentBuilderFactory.aws2Ec2();
    }
    /**
     * AWS Elastic Container Service (ECS) (camel-aws2-ecs)
     * Manage AWS ECS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ecs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2EcsComponentBuilderFactory.Aws2EcsComponentBuilder aws2Ecs() {
        return org.apache.camel.builder.component.dsl.Aws2EcsComponentBuilderFactory.aws2Ecs();
    }
    /**
     * AWS Elastic Kubernetes Service (EKS) (camel-aws2-eks)
     * Manage AWS EKS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-eks
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2EksComponentBuilderFactory.Aws2EksComponentBuilder aws2Eks() {
        return org.apache.camel.builder.component.dsl.Aws2EksComponentBuilderFactory.aws2Eks();
    }
    /**
     * AWS Eventbridge (camel-aws2-eventbridge)
     * Manage AWS Eventbridge cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.6
     * Maven coordinates: org.apache.camel:camel-aws2-eventbridge
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2EventbridgeComponentBuilderFactory.Aws2EventbridgeComponentBuilder aws2Eventbridge() {
        return org.apache.camel.builder.component.dsl.Aws2EventbridgeComponentBuilderFactory.aws2Eventbridge();
    }
    /**
     * AWS Identity and Access Management (IAM) (camel-aws2-iam)
     * Manage AWS IAM instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-iam
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2IamComponentBuilderFactory.Aws2IamComponentBuilder aws2Iam() {
        return org.apache.camel.builder.component.dsl.Aws2IamComponentBuilderFactory.aws2Iam();
    }
    /**
     * AWS Kinesis (camel-aws2-kinesis)
     * Consume and produce records from and to AWS Kinesis Streams using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2KinesisComponentBuilderFactory.Aws2KinesisComponentBuilder aws2Kinesis() {
        return org.apache.camel.builder.component.dsl.Aws2KinesisComponentBuilderFactory.aws2Kinesis();
    }
    /**
     * AWS Kinesis Firehose (camel-aws2-kinesis)
     * Produce data to AWS Kinesis Firehose streams using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2KinesisFirehoseComponentBuilderFactory.Aws2KinesisFirehoseComponentBuilder aws2KinesisFirehose() {
        return org.apache.camel.builder.component.dsl.Aws2KinesisFirehoseComponentBuilderFactory.aws2KinesisFirehose();
    }
    /**
     * AWS Key Management Service (KMS) (camel-aws2-kms)
     * Manage keys stored in AWS KMS instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-kms
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2KmsComponentBuilderFactory.Aws2KmsComponentBuilder aws2Kms() {
        return org.apache.camel.builder.component.dsl.Aws2KmsComponentBuilderFactory.aws2Kms();
    }
    /**
     * AWS Lambda (camel-aws2-lambda)
     * Manage and invoke AWS Lambda functions using AWS SDK version 2.x.
     * 
     * Category: cloud,computing,serverless
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-lambda
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2LambdaComponentBuilderFactory.Aws2LambdaComponentBuilder aws2Lambda() {
        return org.apache.camel.builder.component.dsl.Aws2LambdaComponentBuilderFactory.aws2Lambda();
    }
    /**
     * AWS MQ (camel-aws2-mq)
     * Manage AWS MQ instances using AWS SDK version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-mq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2MqComponentBuilderFactory.Aws2MqComponentBuilder aws2Mq() {
        return org.apache.camel.builder.component.dsl.Aws2MqComponentBuilderFactory.aws2Mq();
    }
    /**
     * AWS Managed Streaming for Apache Kafka (MSK) (camel-aws2-msk)
     * Manage AWS MSK instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-msk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2MskComponentBuilderFactory.Aws2MskComponentBuilder aws2Msk() {
        return org.apache.camel.builder.component.dsl.Aws2MskComponentBuilderFactory.aws2Msk();
    }
    /**
     * AWS S3 Storage Service (camel-aws2-s3)
     * Store and retrieve objects from AWS S3 Storage Service using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,file
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-s3
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2S3ComponentBuilderFactory.Aws2S3ComponentBuilder aws2S3() {
        return org.apache.camel.builder.component.dsl.Aws2S3ComponentBuilderFactory.aws2S3();
    }
    /**
     * AWS Simple Email Service (SES) (camel-aws2-ses)
     * Send e-mails through AWS SES service using AWS SDK version 2.x.
     * 
     * Category: cloud,mail
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ses
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2SesComponentBuilderFactory.Aws2SesComponentBuilder aws2Ses() {
        return org.apache.camel.builder.component.dsl.Aws2SesComponentBuilderFactory.aws2Ses();
    }
    /**
     * AWS Simple Notification System (SNS) (camel-aws2-sns)
     * Send messages to an AWS Simple Notification Topic using AWS SDK version
     * 2.x.
     * 
     * Category: cloud,messaging,mobile
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sns
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2SnsComponentBuilderFactory.Aws2SnsComponentBuilder aws2Sns() {
        return org.apache.camel.builder.component.dsl.Aws2SnsComponentBuilderFactory.aws2Sns();
    }
    /**
     * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
     * Sending and receive messages to/from AWS SQS service using AWS SDK
     * version 2.x.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sqs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2SqsComponentBuilderFactory.Aws2SqsComponentBuilder aws2Sqs() {
        return org.apache.camel.builder.component.dsl.Aws2SqsComponentBuilderFactory.aws2Sqs();
    }
    /**
     * AWS Security Token Service (STS) (camel-aws2-sts)
     * Manage AWS STS cluster instances using AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-aws2-sts
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2StsComponentBuilderFactory.Aws2StsComponentBuilder aws2Sts() {
        return org.apache.camel.builder.component.dsl.Aws2StsComponentBuilderFactory.aws2Sts();
    }
    /**
     * AWS Translate (camel-aws2-translate)
     * Translate texts using AWS Translate and AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-translate
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Aws2TranslateComponentBuilderFactory.Aws2TranslateComponentBuilder aws2Translate() {
        return org.apache.camel.builder.component.dsl.Aws2TranslateComponentBuilderFactory.aws2Translate();
    }
    /**
     * Azure CosmosDB (camel-azure-cosmosdb)
     * To read and write records to the CosmosDB database on Azure cloud
     * platform.
     * 
     * Category: cloud,database
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AzureCosmosdbComponentBuilderFactory.AzureCosmosdbComponentBuilder azureCosmosdb() {
        return org.apache.camel.builder.component.dsl.AzureCosmosdbComponentBuilderFactory.azureCosmosdb();
    }
    /**
     * Azure Event Hubs (camel-azure-eventhubs)
     * The azure-eventhubs component that integrates Azure Event Hubs using AMQP
     * protocol. Azure EventHubs is a highly scalable publish-subscribe service
     * that can ingest millions of events per second and stream them to multiple
     * consumers.
     * 
     * Category: cloud,messaging
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-azure-eventhubs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AzureEventhubsComponentBuilderFactory.AzureEventhubsComponentBuilder azureEventhubs() {
        return org.apache.camel.builder.component.dsl.AzureEventhubsComponentBuilderFactory.azureEventhubs();
    }
    /**
     * Azure Storage Blob Service (camel-azure-storage-blob)
     * Store and retrieve blobs from Azure Storage Blob Service using SDK v12.
     * 
     * Category: cloud,file
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-blob
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AzureStorageBlobComponentBuilderFactory.AzureStorageBlobComponentBuilder azureStorageBlob() {
        return org.apache.camel.builder.component.dsl.AzureStorageBlobComponentBuilderFactory.azureStorageBlob();
    }
    /**
     * Azure storage datalake service (camel-azure-storage-datalake)
     * Camel Azure Datalake Gen2 Component
     * 
     * Category: cloud,file
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AzureStorageDatalakeComponentBuilderFactory.AzureStorageDatalakeComponentBuilder azureStorageDatalake() {
        return org.apache.camel.builder.component.dsl.AzureStorageDatalakeComponentBuilderFactory.azureStorageDatalake();
    }
    /**
     * Azure Storage Queue Service (camel-azure-storage-queue)
     * The azure-storage-queue component is used for storing and retrieving the
     * messages to/from Azure Storage Queue using Azure SDK v12.
     * 
     * Category: cloud,messaging
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-queue
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.AzureStorageQueueComponentBuilderFactory.AzureStorageQueueComponentBuilder azureStorageQueue() {
        return org.apache.camel.builder.component.dsl.AzureStorageQueueComponentBuilderFactory.azureStorageQueue();
    }
    /**
     * Bean (camel-bean)
     * Invoke methods of Java beans stored in Camel registry.
     * 
     * Category: core,java
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BeanComponentBuilderFactory.BeanComponentBuilder bean() {
        return org.apache.camel.builder.component.dsl.BeanComponentBuilderFactory.bean();
    }
    /**
     * Bean Validator (camel-bean-validator)
     * Validate the message body using the Java Bean Validation API.
     * 
     * Category: validation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-bean-validator
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BeanValidatorComponentBuilderFactory.BeanValidatorComponentBuilder beanValidator() {
        return org.apache.camel.builder.component.dsl.BeanValidatorComponentBuilderFactory.beanValidator();
    }
    /**
     * Beanstalk (camel-beanstalk)
     * Retrieve and post-process Beanstalk jobs.
     * 
     * Category: messaging
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-beanstalk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BeanstalkComponentBuilderFactory.BeanstalkComponentBuilder beanstalk() {
        return org.apache.camel.builder.component.dsl.BeanstalkComponentBuilderFactory.beanstalk();
    }
    /**
     * Bonita (camel-bonita)
     * Communicate with a remote Bonita BPM process engine.
     * 
     * Category: process
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-bonita
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BonitaComponentBuilderFactory.BonitaComponentBuilder bonita() {
        return org.apache.camel.builder.component.dsl.BonitaComponentBuilderFactory.bonita();
    }
    /**
     * Box (camel-box)
     * Upload, download and manage files, folders, groups, collaborations, etc.
     * on box.com.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BoxComponentBuilderFactory.BoxComponentBuilder box() {
        return org.apache.camel.builder.component.dsl.BoxComponentBuilderFactory.box();
    }
    /**
     * Braintree (camel-braintree)
     * Process payments using Braintree Payments.
     * 
     * Category: cloud,payment
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-braintree
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BraintreeComponentBuilderFactory.BraintreeComponentBuilder braintree() {
        return org.apache.camel.builder.component.dsl.BraintreeComponentBuilderFactory.braintree();
    }
    /**
     * Browse (camel-browse)
     * Inspect the messages received on endpoints supporting BrowsableEndpoint.
     * 
     * Category: core,monitoring
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-browse
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.BrowseComponentBuilderFactory.BrowseComponentBuilder browse() {
        return org.apache.camel.builder.component.dsl.BrowseComponentBuilderFactory.browse();
    }
    /**
     * Caffeine Cache (camel-caffeine)
     * Perform caching operations using Caffeine Cache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CaffeineCacheComponentBuilderFactory.CaffeineCacheComponentBuilder caffeineCache() {
        return org.apache.camel.builder.component.dsl.CaffeineCacheComponentBuilderFactory.caffeineCache();
    }
    /**
     * Caffeine LoadCache (camel-caffeine)
     * Perform caching operations using Caffeine Cache with an attached
     * CacheLoader.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CaffeineLoadcacheComponentBuilderFactory.CaffeineLoadcacheComponentBuilder caffeineLoadcache() {
        return org.apache.camel.builder.component.dsl.CaffeineLoadcacheComponentBuilderFactory.caffeineLoadcache();
    }
    /**
     * ChatScript (camel-chatscript)
     * Chat with a ChatScript Server.
     * 
     * Category: ai,chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-chatscript
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ChatscriptComponentBuilderFactory.ChatscriptComponentBuilder chatscript() {
        return org.apache.camel.builder.component.dsl.ChatscriptComponentBuilderFactory.chatscript();
    }
    /**
     * Chunk (camel-chunk)
     * Transform messages using Chunk templating engine.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-chunk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ChunkComponentBuilderFactory.ChunkComponentBuilder chunk() {
        return org.apache.camel.builder.component.dsl.ChunkComponentBuilderFactory.chunk();
    }
    /**
     * Class (camel-bean)
     * Invoke methods of Java beans specified by class name.
     * 
     * Category: core,java
     * Since: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ClasComponentBuilderFactory.ClasComponentBuilder clas() {
        return org.apache.camel.builder.component.dsl.ClasComponentBuilderFactory.clas();
    }
    /**
     * CM SMS Gateway (camel-cm-sms)
     * Send SMS messages via CM SMS Gateway.
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-cm-sms
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CmSmsComponentBuilderFactory.CmSmsComponentBuilder cmSms() {
        return org.apache.camel.builder.component.dsl.CmSmsComponentBuilderFactory.cmSms();
    }
    /**
     * CMIS (camel-cmis)
     * Read and write data from to/from a CMIS compliant content repositories.
     * 
     * Category: cms,database
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-cmis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CmisComponentBuilderFactory.CmisComponentBuilder cmis() {
        return org.apache.camel.builder.component.dsl.CmisComponentBuilderFactory.cmis();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CoapComponentBuilderFactory.CoapComponentBuilder coap() {
        return org.apache.camel.builder.component.dsl.CoapComponentBuilderFactory.coap();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CoapTcpComponentBuilderFactory.CoapTcpComponentBuilder coapTcp() {
        return org.apache.camel.builder.component.dsl.CoapTcpComponentBuilderFactory.coapTcp();
    }
    /**
     * CoAP (Secure) (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CoapsComponentBuilderFactory.CoapsComponentBuilder coaps() {
        return org.apache.camel.builder.component.dsl.CoapsComponentBuilderFactory.coaps();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CoapsTcpComponentBuilderFactory.CoapsTcpComponentBuilder coapsTcp() {
        return org.apache.camel.builder.component.dsl.CoapsTcpComponentBuilderFactory.coapsTcp();
    }
    /**
     * CometD (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CometdComponentBuilderFactory.CometdComponentBuilder cometd() {
        return org.apache.camel.builder.component.dsl.CometdComponentBuilderFactory.cometd();
    }
    /**
     * CometD (Secure) (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: websocket
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CometdsComponentBuilderFactory.CometdsComponentBuilder cometds() {
        return org.apache.camel.builder.component.dsl.CometdsComponentBuilderFactory.cometds();
    }
    /**
     * Consul (camel-consul)
     * Integrate with Consul service discovery and configuration store.
     * 
     * Category: cloud,api
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-consul
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ConsulComponentBuilderFactory.ConsulComponentBuilder consul() {
        return org.apache.camel.builder.component.dsl.ConsulComponentBuilderFactory.consul();
    }
    /**
     * Control Bus (camel-controlbus)
     * Manage and monitor Camel routes.
     * 
     * Category: core,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-controlbus
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ControlbusComponentBuilderFactory.ControlbusComponentBuilder controlbus() {
        return org.apache.camel.builder.component.dsl.ControlbusComponentBuilderFactory.controlbus();
    }
    /**
     * Corda (camel-corda)
     * Perform operations against Corda blockchain platform using corda-rpc
     * library.
     * 
     * Category: blockchain,rpc
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-corda
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CordaComponentBuilderFactory.CordaComponentBuilder corda() {
        return org.apache.camel.builder.component.dsl.CordaComponentBuilderFactory.corda();
    }
    /**
     * Couchbase (camel-couchbase)
     * Query Couchbase Views with a poll strategy and/or perform various
     * operations against Couchbase databases.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CouchbaseComponentBuilderFactory.CouchbaseComponentBuilder couchbase() {
        return org.apache.camel.builder.component.dsl.CouchbaseComponentBuilderFactory.couchbase();
    }
    /**
     * CouchDB (camel-couchdb)
     * Consume changesets for inserts, updates and deletes in a CouchDB
     * database, as well as get, save, update and delete documents from a
     * CouchDB database.
     * 
     * Category: database,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-couchdb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CouchdbComponentBuilderFactory.CouchdbComponentBuilder couchdb() {
        return org.apache.camel.builder.component.dsl.CouchdbComponentBuilderFactory.couchdb();
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
     * Based on Cassandra Java Driver provided by DataStax.
     * 
     * Category: database,nosql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CqlComponentBuilderFactory.CqlComponentBuilder cql() {
        return org.apache.camel.builder.component.dsl.CqlComponentBuilderFactory.cql();
    }
    /**
     * Cron (camel-cron)
     * A generic interface for triggering events at times specified through the
     * Unix cron syntax.
     * 
     * Category: scheduling
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-cron
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CronComponentBuilderFactory.CronComponentBuilder cron() {
        return org.apache.camel.builder.component.dsl.CronComponentBuilderFactory.cron();
    }
    /**
     * Crypto (JCE) (camel-crypto)
     * Sign and verify exchanges using the Signature Service of the Java
     * Cryptographic Extension (JCE).
     * 
     * Category: security,transformation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-crypto
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CryptoComponentBuilderFactory.CryptoComponentBuilder crypto() {
        return org.apache.camel.builder.component.dsl.CryptoComponentBuilderFactory.crypto();
    }
    /**
     * CXF (camel-cxf)
     * Expose SOAP WebServices using Apache CXF or connect to external
     * WebServices using CXF WS client.
     * 
     * Category: soap,webservice
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-cxf
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CxfComponentBuilderFactory.CxfComponentBuilder cxf() {
        return org.apache.camel.builder.component.dsl.CxfComponentBuilderFactory.cxf();
    }
    /**
     * CXF-RS (camel-cxf)
     * Expose JAX-RS REST services using Apache CXF or connect to external REST
     * services using CXF REST client.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.CxfrsComponentBuilderFactory.CxfrsComponentBuilder cxfrs() {
        return org.apache.camel.builder.component.dsl.CxfrsComponentBuilderFactory.cxfrs();
    }
    /**
     * Data Format (camel-dataformat)
     * Use a Camel Data Format as a regular Camel Component.
     * 
     * Category: core,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-dataformat
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DataformatComponentBuilderFactory.DataformatComponentBuilder dataformat() {
        return org.apache.camel.builder.component.dsl.DataformatComponentBuilderFactory.dataformat();
    }
    /**
     * Dataset (camel-dataset)
     * Provide data for load and soak testing of your Camel application.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DatasetComponentBuilderFactory.DatasetComponentBuilder dataset() {
        return org.apache.camel.builder.component.dsl.DatasetComponentBuilderFactory.dataset();
    }
    /**
     * DataSet Test (camel-dataset)
     * Extends the mock component by pulling messages from another endpoint on
     * startup to set the expected message bodies.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DatasetTestComponentBuilderFactory.DatasetTestComponentBuilder datasetTest() {
        return org.apache.camel.builder.component.dsl.DatasetTestComponentBuilderFactory.datasetTest();
    }
    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Capture changes from a MongoDB database.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DebeziumMongodbComponentBuilderFactory.DebeziumMongodbComponentBuilder debeziumMongodb() {
        return org.apache.camel.builder.component.dsl.DebeziumMongodbComponentBuilderFactory.debeziumMongodb();
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Capture changes from a MySQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DebeziumMysqlComponentBuilderFactory.DebeziumMysqlComponentBuilder debeziumMysql() {
        return org.apache.camel.builder.component.dsl.DebeziumMysqlComponentBuilderFactory.debeziumMysql();
    }
    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Capture changes from a PostgresSQL database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DebeziumPostgresComponentBuilderFactory.DebeziumPostgresComponentBuilder debeziumPostgres() {
        return org.apache.camel.builder.component.dsl.DebeziumPostgresComponentBuilderFactory.debeziumPostgres();
    }
    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Capture changes from an SQL Server database.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DebeziumSqlserverComponentBuilderFactory.DebeziumSqlserverComponentBuilder debeziumSqlserver() {
        return org.apache.camel.builder.component.dsl.DebeziumSqlserverComponentBuilderFactory.debeziumSqlserver();
    }
    /**
     * DigitalOcean (camel-digitalocean)
     * Manage Droplets and resources within the DigitalOcean cloud.
     * 
     * Category: cloud,management
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-digitalocean
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DigitaloceanComponentBuilderFactory.DigitaloceanComponentBuilder digitalocean() {
        return org.apache.camel.builder.component.dsl.DigitaloceanComponentBuilderFactory.digitalocean();
    }
    /**
     * Direct (camel-direct)
     * Call another endpoint from the same Camel Context synchronously.
     * 
     * Category: core,endpoint
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-direct
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DirectComponentBuilderFactory.DirectComponentBuilder direct() {
        return org.apache.camel.builder.component.dsl.DirectComponentBuilderFactory.direct();
    }
    /**
     * Direct VM (camel-directvm)
     * Call another endpoint from any Camel Context in the same JVM
     * synchronously.
     * 
     * Category: core,endpoint
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-directvm
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DirectVmComponentBuilderFactory.DirectVmComponentBuilder directVm() {
        return org.apache.camel.builder.component.dsl.DirectVmComponentBuilderFactory.directVm();
    }
    /**
     * Disruptor (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DisruptorComponentBuilderFactory.DisruptorComponentBuilder disruptor() {
        return org.apache.camel.builder.component.dsl.DisruptorComponentBuilderFactory.disruptor();
    }
    /**
     * Disruptor VM (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: endpoint
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DisruptorVmComponentBuilderFactory.DisruptorVmComponentBuilder disruptorVm() {
        return org.apache.camel.builder.component.dsl.DisruptorVmComponentBuilderFactory.disruptorVm();
    }
    /**
     * Deep Java Library (camel-djl)
     * Infer Deep Learning models from message exchanges data using Deep Java
     * Library (DJL).
     * 
     * Category: ai,deeplearning
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-djl
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DjlComponentBuilderFactory.DjlComponentBuilder djl() {
        return org.apache.camel.builder.component.dsl.DjlComponentBuilderFactory.djl();
    }
    /**
     * DNS (camel-dns)
     * Perform DNS queries using DNSJava.
     * 
     * Category: networking
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-dns
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DnsComponentBuilderFactory.DnsComponentBuilder dns() {
        return org.apache.camel.builder.component.dsl.DnsComponentBuilderFactory.dns();
    }
    /**
     * Docker (camel-docker)
     * Manage Docker containers.
     * 
     * Category: cloud,container,paas
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-docker
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DockerComponentBuilderFactory.DockerComponentBuilder docker() {
        return org.apache.camel.builder.component.dsl.DockerComponentBuilderFactory.docker();
    }
    /**
     * Dozer (camel-dozer)
     * Map between Java beans using the Dozer mapping library.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-dozer
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DozerComponentBuilderFactory.DozerComponentBuilder dozer() {
        return org.apache.camel.builder.component.dsl.DozerComponentBuilderFactory.dozer();
    }
    /**
     * Drill (camel-drill)
     * Perform queries against an Apache Drill cluster.
     * 
     * Category: database,sql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-drill
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DrillComponentBuilderFactory.DrillComponentBuilder drill() {
        return org.apache.camel.builder.component.dsl.DrillComponentBuilderFactory.drill();
    }
    /**
     * Dropbox (camel-dropbox)
     * Upload, download and manage files, folders, groups, collaborations, etc
     * on Dropbox.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-dropbox
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.DropboxComponentBuilderFactory.DropboxComponentBuilder dropbox() {
        return org.apache.camel.builder.component.dsl.DropboxComponentBuilderFactory.dropbox();
    }
    /**
     * Ehcache (camel-ehcache)
     * Perform caching operations using Ehcache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.EhcacheComponentBuilderFactory.EhcacheComponentBuilder ehcache() {
        return org.apache.camel.builder.component.dsl.EhcacheComponentBuilderFactory.ehcache();
    }
    /**
     * Elasticsearch Rest (camel-elasticsearch-rest)
     * Send requests to with an ElasticSearch via REST API.
     * 
     * Category: search,monitoring
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-elasticsearch-rest
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ElasticsearchRestComponentBuilderFactory.ElasticsearchRestComponentBuilder elasticsearchRest() {
        return org.apache.camel.builder.component.dsl.ElasticsearchRestComponentBuilderFactory.elasticsearchRest();
    }
    /**
     * ElSQL (camel-elsql)
     * Use ElSql to define SQL queries. Extends the SQL Component.
     * 
     * Category: database,sql
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-elsql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ElsqlComponentBuilderFactory.ElsqlComponentBuilder elsql() {
        return org.apache.camel.builder.component.dsl.ElsqlComponentBuilderFactory.elsql();
    }
    /**
     * Etcd Keys (camel-etcd)
     * Get, set or delete keys in etcd key-value store.
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.EtcdKeysComponentBuilderFactory.EtcdKeysComponentBuilder etcdKeys() {
        return org.apache.camel.builder.component.dsl.EtcdKeysComponentBuilderFactory.etcdKeys();
    }
    /**
     * Etcd Stats (camel-etcd)
     * Access etcd cluster statistcs.
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.EtcdStatsComponentBuilderFactory.EtcdStatsComponentBuilder etcdStats() {
        return org.apache.camel.builder.component.dsl.EtcdStatsComponentBuilderFactory.etcdStats();
    }
    /**
     * Etcd Watch (camel-etcd)
     * Watch specific etcd keys or directories for changes.
     * 
     * Category: clustering,database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-etcd
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.EtcdWatchComponentBuilderFactory.EtcdWatchComponentBuilder etcdWatch() {
        return org.apache.camel.builder.component.dsl.EtcdWatchComponentBuilderFactory.etcdWatch();
    }
    /**
     * Exec (camel-exec)
     * Execute commands on the underlying operating system.
     * 
     * Category: system
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-exec
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ExecComponentBuilderFactory.ExecComponentBuilder exec() {
        return org.apache.camel.builder.component.dsl.ExecComponentBuilderFactory.exec();
    }
    /**
     * Facebook (camel-facebook)
     * Send requests to Facebook APIs supported by Facebook4J.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FacebookComponentBuilderFactory.FacebookComponentBuilder facebook() {
        return org.apache.camel.builder.component.dsl.FacebookComponentBuilderFactory.facebook();
    }
    /**
     * FHIR (camel-fhir)
     * Exchange information in the healthcare domain using the FHIR (Fast
     * Healthcare Interoperability Resources) standard.
     * 
     * Category: api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FhirComponentBuilderFactory.FhirComponentBuilder fhir() {
        return org.apache.camel.builder.component.dsl.FhirComponentBuilderFactory.fhir();
    }
    /**
     * File (camel-file)
     * Read and write files.
     * 
     * Category: file,core
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-file
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FileComponentBuilderFactory.FileComponentBuilder file() {
        return org.apache.camel.builder.component.dsl.FileComponentBuilderFactory.file();
    }
    /**
     * File Watch (camel-file-watch)
     * Get notified about file events in a directory using
     * java.nio.file.WatchService.
     * 
     * Category: file
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-file-watch
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FileWatchComponentBuilderFactory.FileWatchComponentBuilder fileWatch() {
        return org.apache.camel.builder.component.dsl.FileWatchComponentBuilderFactory.fileWatch();
    }
    /**
     * Flatpack (camel-flatpack)
     * Parse fixed width and delimited files using the FlatPack library.
     * 
     * Category: transformation
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FlatpackComponentBuilderFactory.FlatpackComponentBuilder flatpack() {
        return org.apache.camel.builder.component.dsl.FlatpackComponentBuilderFactory.flatpack();
    }
    /**
     * Flink (camel-flink)
     * Send DataSet jobs to an Apache Flink cluster.
     * 
     * Category: transformation,bigdata,streams
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-flink
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FlinkComponentBuilderFactory.FlinkComponentBuilder flink() {
        return org.apache.camel.builder.component.dsl.FlinkComponentBuilderFactory.flink();
    }
    /**
     * FOP (camel-fop)
     * Render messages into PDF and other output formats supported by Apache
     * FOP.
     * 
     * Category: file,transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-fop
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FopComponentBuilderFactory.FopComponentBuilder fop() {
        return org.apache.camel.builder.component.dsl.FopComponentBuilderFactory.fop();
    }
    /**
     * Freemarker (camel-freemarker)
     * Transform messages using FreeMarker templates.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-freemarker
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FreemarkerComponentBuilderFactory.FreemarkerComponentBuilder freemarker() {
        return org.apache.camel.builder.component.dsl.FreemarkerComponentBuilderFactory.freemarker();
    }
    /**
     * FTP (camel-ftp)
     * Upload and download files to/from FTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FtpComponentBuilderFactory.FtpComponentBuilder ftp() {
        return org.apache.camel.builder.component.dsl.FtpComponentBuilderFactory.ftp();
    }
    /**
     * FTPS (camel-ftp)
     * Upload and download files to/from FTP servers supporting the FTPS
     * protocol.
     * 
     * Category: file
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.FtpsComponentBuilderFactory.FtpsComponentBuilder ftps() {
        return org.apache.camel.builder.component.dsl.FtpsComponentBuilderFactory.ftps();
    }
    /**
     * Ganglia (camel-ganglia)
     * Send metrics to Ganglia monitoring system.
     * 
     * Category: monitoring
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-ganglia
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GangliaComponentBuilderFactory.GangliaComponentBuilder ganglia() {
        return org.apache.camel.builder.component.dsl.GangliaComponentBuilderFactory.ganglia();
    }
    /**
     * Geocoder (camel-geocoder)
     * Find geocodes (latitude and longitude) for a given address or the other
     * way round.
     * 
     * Category: api,location
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-geocoder
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GeocoderComponentBuilderFactory.GeocoderComponentBuilder geocoder() {
        return org.apache.camel.builder.component.dsl.GeocoderComponentBuilderFactory.geocoder();
    }
    /**
     * Git (camel-git)
     * Perform operations on git repositories.
     * 
     * Category: file
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-git
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GitComponentBuilderFactory.GitComponentBuilder git() {
        return org.apache.camel.builder.component.dsl.GitComponentBuilderFactory.git();
    }
    /**
     * GitHub (camel-github)
     * Interact with the GitHub API.
     * 
     * Category: file,cloud,api
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GithubComponentBuilderFactory.GithubComponentBuilder github() {
        return org.apache.camel.builder.component.dsl.GithubComponentBuilderFactory.github();
    }
    /**
     * Google BigQuery (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics.
     * 
     * Category: cloud,bigdata
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleBigqueryComponentBuilderFactory.GoogleBigqueryComponentBuilder googleBigquery() {
        return org.apache.camel.builder.component.dsl.GoogleBigqueryComponentBuilderFactory.googleBigquery();
    }
    /**
     * Google BigQuery Standard SQL (camel-google-bigquery)
     * Access Google Cloud BigQuery service using SQL queries.
     * 
     * Category: cloud,messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleBigquerySqlComponentBuilderFactory.GoogleBigquerySqlComponentBuilder googleBigquerySql() {
        return org.apache.camel.builder.component.dsl.GoogleBigquerySqlComponentBuilderFactory.googleBigquerySql();
    }
    /**
     * Google Calendar (camel-google-calendar)
     * Perform various operations on a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleCalendarComponentBuilderFactory.GoogleCalendarComponentBuilder googleCalendar() {
        return org.apache.camel.builder.component.dsl.GoogleCalendarComponentBuilderFactory.googleCalendar();
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * Poll for changes in a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleCalendarStreamComponentBuilderFactory.GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return org.apache.camel.builder.component.dsl.GoogleCalendarStreamComponentBuilderFactory.googleCalendarStream();
    }
    /**
     * Google Drive (camel-google-drive)
     * Manage files in Google Drive.
     * 
     * Category: file,cloud,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-google-drive
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleDriveComponentBuilderFactory.GoogleDriveComponentBuilder googleDrive() {
        return org.apache.camel.builder.component.dsl.GoogleDriveComponentBuilderFactory.googleDrive();
    }
    /**
     * Google Cloud Functions (camel-google-functions)
     * Manage and invoke Google Cloud Functions
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-functions
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleFunctionsComponentBuilderFactory.GoogleFunctionsComponentBuilder googleFunctions() {
        return org.apache.camel.builder.component.dsl.GoogleFunctionsComponentBuilderFactory.googleFunctions();
    }
    /**
     * Google Mail (camel-google-mail)
     * Manage messages in Google Mail.
     * 
     * Category: cloud,api,mail
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleMailComponentBuilderFactory.GoogleMailComponentBuilder googleMail() {
        return org.apache.camel.builder.component.dsl.GoogleMailComponentBuilderFactory.googleMail();
    }
    /**
     * Google Mail Stream (camel-google-mail)
     * Poll for incoming messages in Google Mail.
     * 
     * Category: cloud,api,mail
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleMailStreamComponentBuilderFactory.GoogleMailStreamComponentBuilder googleMailStream() {
        return org.apache.camel.builder.component.dsl.GoogleMailStreamComponentBuilderFactory.googleMailStream();
    }
    /**
     * Google Pubsub (camel-google-pubsub)
     * Send and receive messages to/from Google Cloud Platform PubSub Service.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GooglePubsubComponentBuilderFactory.GooglePubsubComponentBuilder googlePubsub() {
        return org.apache.camel.builder.component.dsl.GooglePubsubComponentBuilderFactory.googlePubsub();
    }
    /**
     * Google Sheets (camel-google-sheets)
     * Manage spreadsheets in Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleSheetsComponentBuilderFactory.GoogleSheetsComponentBuilder googleSheets() {
        return org.apache.camel.builder.component.dsl.GoogleSheetsComponentBuilderFactory.googleSheets();
    }
    /**
     * Google Sheets Stream (camel-google-sheets)
     * Poll for changes in Google Sheets.
     * 
     * Category: api,cloud,sheets
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleSheetsStreamComponentBuilderFactory.GoogleSheetsStreamComponentBuilder googleSheetsStream() {
        return org.apache.camel.builder.component.dsl.GoogleSheetsStreamComponentBuilderFactory.googleSheetsStream();
    }
    /**
     * Google Storage (camel-google-storage)
     * Store and retrieve objects from Google Cloud Storage Service using the
     * google-cloud-storage library.
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-storage
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoogleStorageComponentBuilderFactory.GoogleStorageComponentBuilder googleStorage() {
        return org.apache.camel.builder.component.dsl.GoogleStorageComponentBuilderFactory.googleStorage();
    }
    /**
     * Gora (camel-gora)
     * Access NoSQL databases using the Apache Gora framework.
     * 
     * Category: database,nosql,bigdata
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-gora
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GoraComponentBuilderFactory.GoraComponentBuilder gora() {
        return org.apache.camel.builder.component.dsl.GoraComponentBuilderFactory.gora();
    }
    /**
     * Grape (camel-grape)
     * Fetch, load and manage additional jars dynamically after Camel Context
     * was started.
     * 
     * Category: management,deployment
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GrapeComponentBuilderFactory.GrapeComponentBuilder grape() {
        return org.apache.camel.builder.component.dsl.GrapeComponentBuilderFactory.grape();
    }
    /**
     * GraphQL (camel-graphql)
     * Send GraphQL queries and mutations to external systems.
     * 
     * Category: api
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-graphql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GraphqlComponentBuilderFactory.GraphqlComponentBuilder graphql() {
        return org.apache.camel.builder.component.dsl.GraphqlComponentBuilderFactory.graphql();
    }
    /**
     * gRPC (camel-grpc)
     * Expose gRPC endpoints and access external gRPC endpoints.
     * 
     * Category: rpc
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-grpc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GrpcComponentBuilderFactory.GrpcComponentBuilder grpc() {
        return org.apache.camel.builder.component.dsl.GrpcComponentBuilderFactory.grpc();
    }
    /**
     * Guava EventBus (camel-guava-eventbus)
     * Send and receive messages to/from Guava EventBus.
     * 
     * Category: eventbus
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-guava-eventbus
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.GuavaEventbusComponentBuilderFactory.GuavaEventbusComponentBuilder guavaEventbus() {
        return org.apache.camel.builder.component.dsl.GuavaEventbusComponentBuilderFactory.guavaEventbus();
    }
    /**
     * Hazelcast Atomic Number (camel-hazelcast)
     * Increment, decrement, set, etc. Hazelcast atomic number (a grid wide
     * number).
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastAtomicvalueComponentBuilderFactory.HazelcastAtomicvalueComponentBuilder hazelcastAtomicvalue() {
        return org.apache.camel.builder.component.dsl.HazelcastAtomicvalueComponentBuilderFactory.hazelcastAtomicvalue();
    }
    /**
     * Hazelcast Instance (camel-hazelcast)
     * Consume join/leave events of a cache instance in a Hazelcast cluster.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastInstanceComponentBuilderFactory.HazelcastInstanceComponentBuilder hazelcastInstance() {
        return org.apache.camel.builder.component.dsl.HazelcastInstanceComponentBuilderFactory.hazelcastInstance();
    }
    /**
     * Hazelcast List (camel-hazelcast)
     * Perform operations on Hazelcast distributed list.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastListComponentBuilderFactory.HazelcastListComponentBuilder hazelcastList() {
        return org.apache.camel.builder.component.dsl.HazelcastListComponentBuilderFactory.hazelcastList();
    }
    /**
     * Hazelcast Map (camel-hazelcast)
     * Perform operations on Hazelcast distributed map.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastMapComponentBuilderFactory.HazelcastMapComponentBuilder hazelcastMap() {
        return org.apache.camel.builder.component.dsl.HazelcastMapComponentBuilderFactory.hazelcastMap();
    }
    /**
     * Hazelcast Multimap (camel-hazelcast)
     * Perform operations on Hazelcast distributed multimap.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastMultimapComponentBuilderFactory.HazelcastMultimapComponentBuilder hazelcastMultimap() {
        return org.apache.camel.builder.component.dsl.HazelcastMultimapComponentBuilderFactory.hazelcastMultimap();
    }
    /**
     * Hazelcast Queue (camel-hazelcast)
     * Perform operations on Hazelcast distributed queue.
     * 
     * Category: cache,datagrid,messaging
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastQueueComponentBuilderFactory.HazelcastQueueComponentBuilder hazelcastQueue() {
        return org.apache.camel.builder.component.dsl.HazelcastQueueComponentBuilderFactory.hazelcastQueue();
    }
    /**
     * Hazelcast Replicated Map (camel-hazelcast)
     * Perform operations on Hazelcast replicated map.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastReplicatedmapComponentBuilderFactory.HazelcastReplicatedmapComponentBuilder hazelcastReplicatedmap() {
        return org.apache.camel.builder.component.dsl.HazelcastReplicatedmapComponentBuilderFactory.hazelcastReplicatedmap();
    }
    /**
     * Hazelcast Ringbuffer (camel-hazelcast)
     * Perform operations on Hazelcast distributed ringbuffer.
     * 
     * Category: cache,datagrid
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastRingbufferComponentBuilderFactory.HazelcastRingbufferComponentBuilder hazelcastRingbuffer() {
        return org.apache.camel.builder.component.dsl.HazelcastRingbufferComponentBuilderFactory.hazelcastRingbuffer();
    }
    /**
     * Hazelcast SEDA (camel-hazelcast)
     * Asynchronously send/receive Exchanges between Camel routes running on
     * potentially distinct JVMs/hosts backed by Hazelcast BlockingQueue.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastSedaComponentBuilderFactory.HazelcastSedaComponentBuilder hazelcastSeda() {
        return org.apache.camel.builder.component.dsl.HazelcastSedaComponentBuilderFactory.hazelcastSeda();
    }
    /**
     * Hazelcast Set (camel-hazelcast)
     * Perform operations on Hazelcast distributed set.
     * 
     * Category: cache,datagrid
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastSetComponentBuilderFactory.HazelcastSetComponentBuilder hazelcastSet() {
        return org.apache.camel.builder.component.dsl.HazelcastSetComponentBuilderFactory.hazelcastSet();
    }
    /**
     * Hazelcast Topic (camel-hazelcast)
     * Send and receive messages to/from Hazelcast distributed topic.
     * 
     * Category: cache,datagrid
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HazelcastTopicComponentBuilderFactory.HazelcastTopicComponentBuilder hazelcastTopic() {
        return org.apache.camel.builder.component.dsl.HazelcastTopicComponentBuilderFactory.hazelcastTopic();
    }
    /**
     * HBase (camel-hbase)
     * Reading and write from/to an HBase store (Hadoop database).
     * 
     * Category: bigdata,database,hadoop
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-hbase
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HbaseComponentBuilderFactory.HbaseComponentBuilder hbase() {
        return org.apache.camel.builder.component.dsl.HbaseComponentBuilderFactory.hbase();
    }
    /**
     * HDFS (camel-hdfs)
     * Read and write from/to an HDFS filesystem using Hadoop 2.x.
     * 
     * Category: bigdata,hadoop,file
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-hdfs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HdfsComponentBuilderFactory.HdfsComponentBuilder hdfs() {
        return org.apache.camel.builder.component.dsl.HdfsComponentBuilderFactory.hdfs();
    }
    /**
     * HTTP (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HttpComponentBuilderFactory.HttpComponentBuilder http() {
        return org.apache.camel.builder.component.dsl.HttpComponentBuilderFactory.http();
    }
    /**
     * HTTPS (Secure) (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 4.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HttpsComponentBuilderFactory.HttpsComponentBuilder https() {
        return org.apache.camel.builder.component.dsl.HttpsComponentBuilderFactory.https();
    }
    /**
     * Huawei Cloud FunctionGraph (camel-huaweicloud-functiongraph)
     * To call serverless functions on Huawei Cloud
     * 
     * Category: cloud,serverless
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-functiongraph
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HwcloudFunctiongraphComponentBuilderFactory.HwcloudFunctiongraphComponentBuilder hwcloudFunctiongraph() {
        return org.apache.camel.builder.component.dsl.HwcloudFunctiongraphComponentBuilderFactory.hwcloudFunctiongraph();
    }
    /**
     * Huawei Cloud Identity and Access Management (IAM) (camel-huaweicloud-iam)
     * To securely manage users on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-iam
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HwcloudIamComponentBuilderFactory.HwcloudIamComponentBuilder hwcloudIam() {
        return org.apache.camel.builder.component.dsl.HwcloudIamComponentBuilderFactory.hwcloudIam();
    }
    /**
     * Huawei Cloud Simple Message Notification (SMN) (camel-huaweicloud-smn)
     * To broadcast messages and connect cloud services through notifications on
     * Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-huaweicloud-smn
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.HwcloudSmnComponentBuilderFactory.HwcloudSmnComponentBuilder hwcloudSmn() {
        return org.apache.camel.builder.component.dsl.HwcloudSmnComponentBuilderFactory.hwcloudSmn();
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) client using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Iec60870ClientComponentBuilderFactory.Iec60870ClientComponentBuilder iec60870Client() {
        return org.apache.camel.builder.component.dsl.Iec60870ClientComponentBuilderFactory.iec60870Client();
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) server using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Iec60870ServerComponentBuilderFactory.Iec60870ServerComponentBuilder iec60870Server() {
        return org.apache.camel.builder.component.dsl.Iec60870ServerComponentBuilderFactory.iec60870Server();
    }
    /**
     * Ignite Cache (camel-ignite)
     * Perform cache operations on an Ignite cache or consume changes from a
     * continuous query.
     * 
     * Category: cache,datagrid
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteCacheComponentBuilderFactory.IgniteCacheComponentBuilder igniteCache() {
        return org.apache.camel.builder.component.dsl.IgniteCacheComponentBuilderFactory.igniteCache();
    }
    /**
     * Ignite Compute (camel-ignite)
     * Run compute operations on an Ignite cluster.
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteComputeComponentBuilderFactory.IgniteComputeComponentBuilder igniteCompute() {
        return org.apache.camel.builder.component.dsl.IgniteComputeComponentBuilderFactory.igniteCompute();
    }
    /**
     * Ignite Events (camel-ignite)
     * Receive events from an Ignite cluster by creating a local event listener.
     * 
     * Category: messaging,eventbus
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteEventsComponentBuilderFactory.IgniteEventsComponentBuilder igniteEvents() {
        return org.apache.camel.builder.component.dsl.IgniteEventsComponentBuilderFactory.igniteEvents();
    }
    /**
     * Ignite ID Generator (camel-ignite)
     * Interact with Ignite Atomic Sequences and ID Generators .
     * 
     * Category: compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteIdgenComponentBuilderFactory.IgniteIdgenComponentBuilder igniteIdgen() {
        return org.apache.camel.builder.component.dsl.IgniteIdgenComponentBuilderFactory.igniteIdgen();
    }
    /**
     * Ignite Messaging (camel-ignite)
     * Send and receive messages from an Ignite topic.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteMessagingComponentBuilderFactory.IgniteMessagingComponentBuilder igniteMessaging() {
        return org.apache.camel.builder.component.dsl.IgniteMessagingComponentBuilderFactory.igniteMessaging();
    }
    /**
     * Ignite Queues (camel-ignite)
     * Interact with Ignite Queue data structures.
     * 
     * Category: messaging,queue
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteQueueComponentBuilderFactory.IgniteQueueComponentBuilder igniteQueue() {
        return org.apache.camel.builder.component.dsl.IgniteQueueComponentBuilderFactory.igniteQueue();
    }
    /**
     * Ignite Sets (camel-ignite)
     * Interact with Ignite Set data structures.
     * 
     * Category: cache,compute
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IgniteSetComponentBuilderFactory.IgniteSetComponentBuilder igniteSet() {
        return org.apache.camel.builder.component.dsl.IgniteSetComponentBuilderFactory.igniteSet();
    }
    /**
     * IMAP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ImapComponentBuilderFactory.ImapComponentBuilder imap() {
        return org.apache.camel.builder.component.dsl.ImapComponentBuilderFactory.imap();
    }
    /**
     * IMAPS (Secure) (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ImapsComponentBuilderFactory.ImapsComponentBuilder imaps() {
        return org.apache.camel.builder.component.dsl.ImapsComponentBuilderFactory.imaps();
    }
    /**
     * Infinispan (camel-infinispan)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.InfinispanComponentBuilderFactory.InfinispanComponentBuilder infinispan() {
        return org.apache.camel.builder.component.dsl.InfinispanComponentBuilderFactory.infinispan();
    }
    /**
     * Infinispan Embedded (camel-infinispan-embedded)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan-embedded
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.InfinispanEmbeddedComponentBuilderFactory.InfinispanEmbeddedComponentBuilder infinispanEmbedded() {
        return org.apache.camel.builder.component.dsl.InfinispanEmbeddedComponentBuilderFactory.infinispanEmbedded();
    }
    /**
     * InfluxDB (camel-influxdb)
     * Interact with InfluxDB, a time series database.
     * 
     * Category: database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-influxdb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.InfluxdbComponentBuilderFactory.InfluxdbComponentBuilder influxdb() {
        return org.apache.camel.builder.component.dsl.InfluxdbComponentBuilderFactory.influxdb();
    }
    /**
     * IOTA (camel-iota)
     * Manage financial transactions using IOTA distributed ledger.
     * 
     * Category: ledger,api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-iota
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IotaComponentBuilderFactory.IotaComponentBuilder iota() {
        return org.apache.camel.builder.component.dsl.IotaComponentBuilderFactory.iota();
    }
    /**
     * IPFS (camel-ipfs)
     * Access the Interplanetary File System (IPFS).
     * 
     * Category: file,ipfs
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-ipfs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IpfsComponentBuilderFactory.IpfsComponentBuilder ipfs() {
        return org.apache.camel.builder.component.dsl.IpfsComponentBuilderFactory.ipfs();
    }
    /**
     * IRC (camel-irc)
     * Send and receive messages to/from and IRC chat.
     * 
     * Category: chat
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IrcComponentBuilderFactory.IrcComponentBuilder irc() {
        return org.apache.camel.builder.component.dsl.IrcComponentBuilderFactory.irc();
    }
    /**
     * IronMQ (camel-ironmq)
     * Send and receive messages to/from IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.IronmqComponentBuilderFactory.IronmqComponentBuilder ironmq() {
        return org.apache.camel.builder.component.dsl.IronmqComponentBuilderFactory.ironmq();
    }
    /**
     * JBPM (camel-jbpm)
     * Interact with jBPM workflow engine over REST.
     * 
     * Category: api,workflow
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jbpm
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JbpmComponentBuilderFactory.JbpmComponentBuilder jbpm() {
        return org.apache.camel.builder.component.dsl.JbpmComponentBuilderFactory.jbpm();
    }
    /**
     * JCache (camel-jcache)
     * Perform caching operations against JSR107/JCache.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JcacheComponentBuilderFactory.JcacheComponentBuilder jcache() {
        return org.apache.camel.builder.component.dsl.JcacheComponentBuilderFactory.jcache();
    }
    /**
     * JClouds (camel-jclouds)
     * Interact with jclouds compute and blobstore service.
     * 
     * Category: api,cloud,compute
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-jclouds
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JcloudsComponentBuilderFactory.JcloudsComponentBuilder jclouds() {
        return org.apache.camel.builder.component.dsl.JcloudsComponentBuilderFactory.jclouds();
    }
    /**
     * JCR (camel-jcr)
     * Read and write nodes to/from a JCR compliant content repository.
     * 
     * Category: database,cms
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JcrComponentBuilderFactory.JcrComponentBuilder jcr() {
        return org.apache.camel.builder.component.dsl.JcrComponentBuilderFactory.jcr();
    }
    /**
     * JDBC (camel-jdbc)
     * Access databases through SQL and JDBC.
     * 
     * Category: database,sql
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jdbc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JdbcComponentBuilderFactory.JdbcComponentBuilder jdbc() {
        return org.apache.camel.builder.component.dsl.JdbcComponentBuilderFactory.jdbc();
    }
    /**
     * Jetty (camel-jetty)
     * Expose HTTP endpoints using Jetty 9.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JettyComponentBuilderFactory.JettyComponentBuilder jetty() {
        return org.apache.camel.builder.component.dsl.JettyComponentBuilderFactory.jetty();
    }
    /**
     * JGroups (camel-jgroups)
     * Exchange messages with JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-jgroups
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JgroupsComponentBuilderFactory.JgroupsComponentBuilder jgroups() {
        return org.apache.camel.builder.component.dsl.JgroupsComponentBuilderFactory.jgroups();
    }
    /**
     * JGroups raft (camel-jgroups-raft)
     * Exchange messages with JGroups-raft clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-jgroups-raft
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JgroupsRaftComponentBuilderFactory.JgroupsRaftComponentBuilder jgroupsRaft() {
        return org.apache.camel.builder.component.dsl.JgroupsRaftComponentBuilderFactory.jgroupsRaft();
    }
    /**
     * Jing (camel-jing)
     * Validate XML against a RelaxNG schema (XML Syntax or Compact Syntax)
     * using Jing library.
     * 
     * Category: validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-jing
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JingComponentBuilderFactory.JingComponentBuilder jing() {
        return org.apache.camel.builder.component.dsl.JingComponentBuilderFactory.jing();
    }
    /**
     * Jira (camel-jira)
     * Interact with JIRA issue tracker.
     * 
     * Category: api,reporting
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jira
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JiraComponentBuilderFactory.JiraComponentBuilder jira() {
        return org.apache.camel.builder.component.dsl.JiraComponentBuilderFactory.jira();
    }
    /**
     * JMS (camel-jms)
     * Sent and receive messages to/from a JMS Queue or Topic.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jms
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JmsComponentBuilderFactory.JmsComponentBuilder jms() {
        return org.apache.camel.builder.component.dsl.JmsComponentBuilderFactory.jms();
    }
    /**
     * JMX (camel-jmx)
     * Receive JMX notifications.
     * 
     * Category: monitoring
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jmx
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JmxComponentBuilderFactory.JmxComponentBuilder jmx() {
        return org.apache.camel.builder.component.dsl.JmxComponentBuilderFactory.jmx();
    }
    /**
     * JOLT (camel-jolt)
     * JSON to JSON transformation using JOLT.
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JoltComponentBuilderFactory.JoltComponentBuilder jolt() {
        return org.apache.camel.builder.component.dsl.JoltComponentBuilderFactory.jolt();
    }
    /**
     * JOOQ (camel-jooq)
     * Store and retrieve Java objects from an SQL database using JOOQ.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jooq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JooqComponentBuilderFactory.JooqComponentBuilder jooq() {
        return org.apache.camel.builder.component.dsl.JooqComponentBuilderFactory.jooq();
    }
    /**
     * JPA (camel-jpa)
     * Store and retrieve Java objects from databases using Java Persistence API
     * (JPA).
     * 
     * Category: database,sql
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JpaComponentBuilderFactory.JpaComponentBuilder jpa() {
        return org.apache.camel.builder.component.dsl.JpaComponentBuilderFactory.jpa();
    }
    /**
     * JSLT (camel-jslt)
     * Query or transform JSON payloads using an JSLT.
     * 
     * Category: transformation
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-jslt
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JsltComponentBuilderFactory.JsltComponentBuilder jslt() {
        return org.apache.camel.builder.component.dsl.JsltComponentBuilderFactory.jslt();
    }
    /**
     * JSON Schema Validator (camel-json-validator)
     * Validate JSON payloads using NetworkNT JSON Schema.
     * 
     * Category: validation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-json-validator
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JsonValidatorComponentBuilderFactory.JsonValidatorComponentBuilder jsonValidator() {
        return org.apache.camel.builder.component.dsl.JsonValidatorComponentBuilderFactory.jsonValidator();
    }
    /**
     * JSONata (camel-jsonata)
     * Transforms JSON payload using JSONata transformation.
     * 
     * Category: transformation
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-jsonata
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.JsonataComponentBuilderFactory.JsonataComponentBuilder jsonata() {
        return org.apache.camel.builder.component.dsl.JsonataComponentBuilderFactory.jsonata();
    }
    /**
     * JT400 (camel-jt400)
     * Exchanges messages with an IBM i system using data queues, message
     * queues, or program call. IBM i is the replacement for AS/400 and iSeries
     * servers.
     * 
     * Category: messaging
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Jt400ComponentBuilderFactory.Jt400ComponentBuilder jt400() {
        return org.apache.camel.builder.component.dsl.Jt400ComponentBuilderFactory.jt400();
    }
    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KafkaComponentBuilderFactory.KafkaComponentBuilder kafka() {
        return org.apache.camel.builder.component.dsl.KafkaComponentBuilderFactory.kafka();
    }
    /**
     * Kamelet (camel-kamelet)
     * To call Kamelets
     * 
     * Category: core
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-kamelet
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KameletComponentBuilderFactory.KameletComponentBuilder kamelet() {
        return org.apache.camel.builder.component.dsl.KameletComponentBuilderFactory.kamelet();
    }
    /**
     * Kamelet Reify (camel-kamelet-reify)
     * To call Kamelets (indirectly)
     * 
     * Category: core
     * Since: 3.6
     * Maven coordinates: org.apache.camel:camel-kamelet-reify
     * 
     * @return the dsl builder
     */
    @Deprecated
    static org.apache.camel.builder.component.dsl.KameletReifyComponentBuilderFactory.KameletReifyComponentBuilder kameletReify() {
        return org.apache.camel.builder.component.dsl.KameletReifyComponentBuilderFactory.kameletReify();
    }
    /**
     * Kubernetes ConfigMap (camel-kubernetes)
     * Perform operations on Kubernetes ConfigMaps and get notified on
     * ConfigMaps changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesConfigMapsComponentBuilderFactory.KubernetesConfigMapsComponentBuilder kubernetesConfigMaps() {
        return org.apache.camel.builder.component.dsl.KubernetesConfigMapsComponentBuilderFactory.kubernetesConfigMaps();
    }
    /**
     * Kubernetes Custom Resources (camel-kubernetes)
     * Perform operations on Kubernetes Custom Resources and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesCustomResourcesComponentBuilderFactory.KubernetesCustomResourcesComponentBuilder kubernetesCustomResources() {
        return org.apache.camel.builder.component.dsl.KubernetesCustomResourcesComponentBuilderFactory.kubernetesCustomResources();
    }
    /**
     * Kubernetes Deployments (camel-kubernetes)
     * Perform operations on Kubernetes Deployments and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesDeploymentsComponentBuilderFactory.KubernetesDeploymentsComponentBuilder kubernetesDeployments() {
        return org.apache.camel.builder.component.dsl.KubernetesDeploymentsComponentBuilderFactory.kubernetesDeployments();
    }
    /**
     * Kubernetes HPA (camel-kubernetes)
     * Perform operations on Kubernetes Horizontal Pod Autoscalers (HPA) and get
     * notified on HPA changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesHpaComponentBuilderFactory.KubernetesHpaComponentBuilder kubernetesHpa() {
        return org.apache.camel.builder.component.dsl.KubernetesHpaComponentBuilderFactory.kubernetesHpa();
    }
    /**
     * Kubernetes Job (camel-kubernetes)
     * Perform operations on Kubernetes Jobs.
     * 
     * Category: container,cloud,paas
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesJobComponentBuilderFactory.KubernetesJobComponentBuilder kubernetesJob() {
        return org.apache.camel.builder.component.dsl.KubernetesJobComponentBuilderFactory.kubernetesJob();
    }
    /**
     * Kubernetes Namespaces (camel-kubernetes)
     * Perform operations on Kubernetes Namespaces and get notified on Namespace
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesNamespacesComponentBuilderFactory.KubernetesNamespacesComponentBuilder kubernetesNamespaces() {
        return org.apache.camel.builder.component.dsl.KubernetesNamespacesComponentBuilderFactory.kubernetesNamespaces();
    }
    /**
     * Kubernetes Nodes (camel-kubernetes)
     * Perform operations on Kubernetes Nodes and get notified on Node changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesNodesComponentBuilderFactory.KubernetesNodesComponentBuilder kubernetesNodes() {
        return org.apache.camel.builder.component.dsl.KubernetesNodesComponentBuilderFactory.kubernetesNodes();
    }
    /**
     * Kubernetes Persistent Volume (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes and get notified on
     * Persistent Volume changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesComponentBuilderFactory.KubernetesPersistentVolumesComponentBuilder kubernetesPersistentVolumes() {
        return org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesComponentBuilderFactory.kubernetesPersistentVolumes();
    }
    /**
     * Kubernetes Persistent Volume Claim (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes Claims and get
     * notified on Persistent Volumes Claim changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesClaimsComponentBuilderFactory.KubernetesPersistentVolumesClaimsComponentBuilder kubernetesPersistentVolumesClaims() {
        return org.apache.camel.builder.component.dsl.KubernetesPersistentVolumesClaimsComponentBuilderFactory.kubernetesPersistentVolumesClaims();
    }
    /**
     * Kubernetes Pods (camel-kubernetes)
     * Perform operations on Kubernetes Pods and get notified on Pod changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesPodsComponentBuilderFactory.KubernetesPodsComponentBuilder kubernetesPods() {
        return org.apache.camel.builder.component.dsl.KubernetesPodsComponentBuilderFactory.kubernetesPods();
    }
    /**
     * Kubernetes Replication Controller (camel-kubernetes)
     * Perform operations on Kubernetes Replication Controllers and get notified
     * on Replication Controllers changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesReplicationControllersComponentBuilderFactory.KubernetesReplicationControllersComponentBuilder kubernetesReplicationControllers() {
        return org.apache.camel.builder.component.dsl.KubernetesReplicationControllersComponentBuilderFactory.kubernetesReplicationControllers();
    }
    /**
     * Kubernetes Resources Quota (camel-kubernetes)
     * Perform operations on Kubernetes Resources Quotas.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesResourcesQuotaComponentBuilderFactory.KubernetesResourcesQuotaComponentBuilder kubernetesResourcesQuota() {
        return org.apache.camel.builder.component.dsl.KubernetesResourcesQuotaComponentBuilderFactory.kubernetesResourcesQuota();
    }
    /**
     * Kubernetes Secrets (camel-kubernetes)
     * Perform operations on Kubernetes Secrets.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesSecretsComponentBuilderFactory.KubernetesSecretsComponentBuilder kubernetesSecrets() {
        return org.apache.camel.builder.component.dsl.KubernetesSecretsComponentBuilderFactory.kubernetesSecrets();
    }
    /**
     * Kubernetes Service Account (camel-kubernetes)
     * Perform operations on Kubernetes Service Accounts.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesServiceAccountsComponentBuilderFactory.KubernetesServiceAccountsComponentBuilder kubernetesServiceAccounts() {
        return org.apache.camel.builder.component.dsl.KubernetesServiceAccountsComponentBuilderFactory.kubernetesServiceAccounts();
    }
    /**
     * Kubernetes Services (camel-kubernetes)
     * Perform operations on Kubernetes Services and get notified on Service
     * changes.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KubernetesServicesComponentBuilderFactory.KubernetesServicesComponentBuilder kubernetesServices() {
        return org.apache.camel.builder.component.dsl.KubernetesServicesComponentBuilderFactory.kubernetesServices();
    }
    /**
     * Kudu (camel-kudu)
     * Interact with Apache Kudu, a free and open source column-oriented data
     * store of the Apache Hadoop ecosystem.
     * 
     * Category: database,iot,cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-kudu
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.KuduComponentBuilderFactory.KuduComponentBuilder kudu() {
        return org.apache.camel.builder.component.dsl.KuduComponentBuilderFactory.kudu();
    }
    /**
     * Language (camel-language)
     * Execute scripts in any of the languages supported by Camel.
     * 
     * Category: core,script
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-language
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LanguageComponentBuilderFactory.LanguageComponentBuilder language() {
        return org.apache.camel.builder.component.dsl.LanguageComponentBuilderFactory.language();
    }
    /**
     * LDAP (camel-ldap)
     * Perform searches on LDAP servers.
     * 
     * Category: search,ldap
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-ldap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LdapComponentBuilderFactory.LdapComponentBuilder ldap() {
        return org.apache.camel.builder.component.dsl.LdapComponentBuilderFactory.ldap();
    }
    /**
     * LDIF (camel-ldif)
     * Perform updates on an LDAP server from an LDIF body content.
     * 
     * Category: ldap
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LdifComponentBuilderFactory.LdifComponentBuilder ldif() {
        return org.apache.camel.builder.component.dsl.LdifComponentBuilderFactory.ldif();
    }
    /**
     * Log (camel-log)
     * Log messages to the underlying logging mechanism.
     * 
     * Category: core,monitoring
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LogComponentBuilderFactory.LogComponentBuilder log() {
        return org.apache.camel.builder.component.dsl.LogComponentBuilderFactory.log();
    }
    /**
     * Printer (camel-printer)
     * Send print jobs to printers.
     * 
     * Category: printing
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-printer
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LprComponentBuilderFactory.LprComponentBuilder lpr() {
        return org.apache.camel.builder.component.dsl.LprComponentBuilderFactory.lpr();
    }
    /**
     * Lucene (camel-lucene)
     * Perform inserts or queries against Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LuceneComponentBuilderFactory.LuceneComponentBuilder lucene() {
        return org.apache.camel.builder.component.dsl.LuceneComponentBuilderFactory.lucene();
    }
    /**
     * Lumberjack (camel-lumberjack)
     * Receive logs messages using the Lumberjack protocol.
     * 
     * Category: log
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-lumberjack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.LumberjackComponentBuilderFactory.LumberjackComponentBuilder lumberjack() {
        return org.apache.camel.builder.component.dsl.LumberjackComponentBuilderFactory.lumberjack();
    }
    /**
     * Master (camel-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-master
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MasterComponentBuilderFactory.MasterComponentBuilder master() {
        return org.apache.camel.builder.component.dsl.MasterComponentBuilderFactory.master();
    }
    /**
     * Metrics (camel-metrics)
     * Collect various metrics directly from Camel routes using the DropWizard
     * metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MetricsComponentBuilderFactory.MetricsComponentBuilder metrics() {
        return org.apache.camel.builder.component.dsl.MetricsComponentBuilderFactory.metrics();
    }
    /**
     * Micrometer (camel-micrometer)
     * Collect various metrics directly from Camel routes using the Micrometer
     * library.
     * 
     * Category: monitoring
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-micrometer
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MicrometerComponentBuilderFactory.MicrometerComponentBuilder micrometer() {
        return org.apache.camel.builder.component.dsl.MicrometerComponentBuilderFactory.micrometer();
    }
    /**
     * MicroProfile Metrics (camel-microprofile-metrics)
     * Expose metrics from Camel routes.
     * 
     * Category: monitoring
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-microprofile-metrics
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MicroprofileMetricsComponentBuilderFactory.MicroprofileMetricsComponentBuilder microprofileMetrics() {
        return org.apache.camel.builder.component.dsl.MicroprofileMetricsComponentBuilderFactory.microprofileMetrics();
    }
    /**
     * OPC UA Client (camel-milo)
     * Connect to OPC UA servers using the binary protocol for acquiring
     * telemetry data.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MiloClientComponentBuilderFactory.MiloClientComponentBuilder miloClient() {
        return org.apache.camel.builder.component.dsl.MiloClientComponentBuilderFactory.miloClient();
    }
    /**
     * OPC UA Server (camel-milo)
     * Make telemetry data available as an OPC UA server.
     * 
     * Category: iot
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-milo
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MiloServerComponentBuilderFactory.MiloServerComponentBuilder miloServer() {
        return org.apache.camel.builder.component.dsl.MiloServerComponentBuilderFactory.miloServer();
    }
    /**
     * Mina (camel-mina)
     * Socket level networking using TCP or UDP with Apache Mina 2.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-mina
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MinaComponentBuilderFactory.MinaComponentBuilder mina() {
        return org.apache.camel.builder.component.dsl.MinaComponentBuilderFactory.mina();
    }
    /**
     * Minio (camel-minio)
     * Store and retrieve objects from Minio Storage Service using Minio SDK.
     * 
     * Category: cloud,file
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-minio
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MinioComponentBuilderFactory.MinioComponentBuilder minio() {
        return org.apache.camel.builder.component.dsl.MinioComponentBuilderFactory.minio();
    }
    /**
     * MLLP (camel-mllp)
     * Communicate with external systems using the MLLP protocol.
     * 
     * Category: networking,rpc,mllp
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MllpComponentBuilderFactory.MllpComponentBuilder mllp() {
        return org.apache.camel.builder.component.dsl.MllpComponentBuilderFactory.mllp();
    }
    /**
     * Mock (camel-mock)
     * Test routes and mediation rules using mocks.
     * 
     * Category: core,testing
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mock
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MockComponentBuilderFactory.MockComponentBuilder mock() {
        return org.apache.camel.builder.component.dsl.MockComponentBuilderFactory.mock();
    }
    /**
     * MongoDB (camel-mongodb)
     * Perform operations on MongoDB documents and collections.
     * 
     * Category: database,nosql
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-mongodb
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MongodbComponentBuilderFactory.MongodbComponentBuilder mongodb() {
        return org.apache.camel.builder.component.dsl.MongodbComponentBuilderFactory.mongodb();
    }
    /**
     * MongoDB GridFS (camel-mongodb-gridfs)
     * Interact with MongoDB GridFS.
     * 
     * Category: database,nosql
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-mongodb-gridfs
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MongodbGridfsComponentBuilderFactory.MongodbGridfsComponentBuilder mongodbGridfs() {
        return org.apache.camel.builder.component.dsl.MongodbGridfsComponentBuilderFactory.mongodbGridfs();
    }
    /**
     * MSV (camel-msv)
     * Validate XML payloads using Multi-Schema Validator (MSV).
     * 
     * Category: validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-msv
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MsvComponentBuilderFactory.MsvComponentBuilder msv() {
        return org.apache.camel.builder.component.dsl.MsvComponentBuilderFactory.msv();
    }
    /**
     * Mustache (camel-mustache)
     * Transform messages using a Mustache template.
     * 
     * Category: transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mustache
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MustacheComponentBuilderFactory.MustacheComponentBuilder mustache() {
        return org.apache.camel.builder.component.dsl.MustacheComponentBuilderFactory.mustache();
    }
    /**
     * MVEL (camel-mvel)
     * Transform messages using an MVEL template.
     * 
     * Category: transformation,script
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mvel
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MvelComponentBuilderFactory.MvelComponentBuilder mvel() {
        return org.apache.camel.builder.component.dsl.MvelComponentBuilderFactory.mvel();
    }
    /**
     * MyBatis (camel-mybatis)
     * Performs a query, poll, insert, update or delete in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MybatisComponentBuilderFactory.MybatisComponentBuilder mybatis() {
        return org.apache.camel.builder.component.dsl.MybatisComponentBuilderFactory.mybatis();
    }
    /**
     * MyBatis Bean (camel-mybatis)
     * Perform queries, inserts, updates or deletes in a relational database
     * using MyBatis.
     * 
     * Category: database,sql
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.MybatisBeanComponentBuilderFactory.MybatisBeanComponentBuilder mybatisBean() {
        return org.apache.camel.builder.component.dsl.MybatisBeanComponentBuilderFactory.mybatisBean();
    }
    /**
     * Nagios (camel-nagios)
     * Send passive checks to Nagios using JSendNSCA.
     * 
     * Category: monitoring
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-nagios
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NagiosComponentBuilderFactory.NagiosComponentBuilder nagios() {
        return org.apache.camel.builder.component.dsl.NagiosComponentBuilderFactory.nagios();
    }
    /**
     * Nats (camel-nats)
     * Send and receive messages from NATS messaging system.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NatsComponentBuilderFactory.NatsComponentBuilder nats() {
        return org.apache.camel.builder.component.dsl.NatsComponentBuilderFactory.nats();
    }
    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with the Netty 4.x.
     * 
     * Category: networking,tcp,udp
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NettyComponentBuilderFactory.NettyComponentBuilder netty() {
        return org.apache.camel.builder.component.dsl.NettyComponentBuilderFactory.netty();
    }
    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x.
     * 
     * Category: networking,http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NettyHttpComponentBuilderFactory.NettyHttpComponentBuilder nettyHttp() {
        return org.apache.camel.builder.component.dsl.NettyHttpComponentBuilderFactory.nettyHttp();
    }
    /**
     * Nitrite (camel-nitrite)
     * Access Nitrite databases.
     * 
     * Category: database,nosql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-nitrite
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NitriteComponentBuilderFactory.NitriteComponentBuilder nitrite() {
        return org.apache.camel.builder.component.dsl.NitriteComponentBuilderFactory.nitrite();
    }
    /**
     * NSQ (camel-nsq)
     * Send and receive messages from NSQ realtime distributed messaging
     * platform.
     * 
     * Category: messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-nsq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.NsqComponentBuilderFactory.NsqComponentBuilder nsq() {
        return org.apache.camel.builder.component.dsl.NsqComponentBuilderFactory.nsq();
    }
    /**
     * OAI-PMH (camel-oaipmh)
     * Harvest metadata using OAI-PMH protocol
     * 
     * Category: endpoint,webservice,batch
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-oaipmh
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OaipmhComponentBuilderFactory.OaipmhComponentBuilder oaipmh() {
        return org.apache.camel.builder.component.dsl.OaipmhComponentBuilderFactory.oaipmh();
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicate with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Olingo2ComponentBuilderFactory.Olingo2ComponentBuilder olingo2() {
        return org.apache.camel.builder.component.dsl.Olingo2ComponentBuilderFactory.olingo2();
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicate with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Olingo4ComponentBuilderFactory.Olingo4ComponentBuilder olingo4() {
        return org.apache.camel.builder.component.dsl.Olingo4ComponentBuilderFactory.olingo4();
    }
    /**
     * Openshift Build Config (camel-kubernetes)
     * Perform operations on OpenShift Build Configs.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenshiftBuildConfigsComponentBuilderFactory.OpenshiftBuildConfigsComponentBuilder openshiftBuildConfigs() {
        return org.apache.camel.builder.component.dsl.OpenshiftBuildConfigsComponentBuilderFactory.openshiftBuildConfigs();
    }
    /**
     * Openshift Builds (camel-kubernetes)
     * Perform operations on OpenShift Builds.
     * 
     * Category: container,cloud,paas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenshiftBuildsComponentBuilderFactory.OpenshiftBuildsComponentBuilder openshiftBuilds() {
        return org.apache.camel.builder.component.dsl.OpenshiftBuildsComponentBuilderFactory.openshiftBuilds();
    }
    /**
     * OpenStack Cinder (camel-openstack)
     * Access data in OpenStack Cinder block storage.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackCinderComponentBuilderFactory.OpenstackCinderComponentBuilder openstackCinder() {
        return org.apache.camel.builder.component.dsl.OpenstackCinderComponentBuilderFactory.openstackCinder();
    }
    /**
     * OpenStack Glance (camel-openstack)
     * Manage VM images and metadata definitions in OpenStack Glance.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackGlanceComponentBuilderFactory.OpenstackGlanceComponentBuilder openstackGlance() {
        return org.apache.camel.builder.component.dsl.OpenstackGlanceComponentBuilderFactory.openstackGlance();
    }
    /**
     * OpenStack Keystone (camel-openstack)
     * Access OpenStack Keystone for API client authentication, service
     * discovery and distributed multi-tenant authorization.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackKeystoneComponentBuilderFactory.OpenstackKeystoneComponentBuilder openstackKeystone() {
        return org.apache.camel.builder.component.dsl.OpenstackKeystoneComponentBuilderFactory.openstackKeystone();
    }
    /**
     * OpenStack Neutron (camel-openstack)
     * Access OpenStack Neutron for network services.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackNeutronComponentBuilderFactory.OpenstackNeutronComponentBuilder openstackNeutron() {
        return org.apache.camel.builder.component.dsl.OpenstackNeutronComponentBuilderFactory.openstackNeutron();
    }
    /**
     * OpenStack Nova (camel-openstack)
     * Access OpenStack to manage compute resources.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackNovaComponentBuilderFactory.OpenstackNovaComponentBuilder openstackNova() {
        return org.apache.camel.builder.component.dsl.OpenstackNovaComponentBuilderFactory.openstackNova();
    }
    /**
     * OpenStack Swift (camel-openstack)
     * Access OpenStack Swift object/blob store.
     * 
     * Category: cloud,paas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OpenstackSwiftComponentBuilderFactory.OpenstackSwiftComponentBuilder openstackSwift() {
        return org.apache.camel.builder.component.dsl.OpenstackSwiftComponentBuilderFactory.openstackSwift();
    }
    /**
     * OptaPlanner (camel-optaplanner)
     * Solve planning problems with OptaPlanner.
     * 
     * Category: engine,planning
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-optaplanner
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.OptaplannerComponentBuilderFactory.OptaplannerComponentBuilder optaplanner() {
        return org.apache.camel.builder.component.dsl.OptaplannerComponentBuilderFactory.optaplanner();
    }
    /**
     * Paho (camel-paho)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT Client.
     * 
     * Category: messaging,iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-paho
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PahoComponentBuilderFactory.PahoComponentBuilder paho() {
        return org.apache.camel.builder.component.dsl.PahoComponentBuilderFactory.paho();
    }
    /**
     * Paho MQTT 5 (camel-paho-mqtt5)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT v5 Client.
     * 
     * Category: messaging,iot
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-paho-mqtt5
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PahoMqtt5ComponentBuilderFactory.PahoMqtt5ComponentBuilder pahoMqtt5() {
        return org.apache.camel.builder.component.dsl.PahoMqtt5ComponentBuilderFactory.pahoMqtt5();
    }
    /**
     * PDF (camel-pdf)
     * Create, modify or extract content from PDF documents.
     * 
     * Category: document,transformation,printing
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-pdf
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PdfComponentBuilderFactory.PdfComponentBuilder pdf() {
        return org.apache.camel.builder.component.dsl.PdfComponentBuilderFactory.pdf();
    }
    /**
     * PostgresSQL Replication Slot (camel-pg-replication-slot)
     * Poll for PostgreSQL Write-Ahead Log (WAL) records using Streaming
     * Replication Slots.
     * 
     * Category: database,sql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-pg-replication-slot
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PgReplicationSlotComponentBuilderFactory.PgReplicationSlotComponentBuilder pgReplicationSlot() {
        return org.apache.camel.builder.component.dsl.PgReplicationSlotComponentBuilderFactory.pgReplicationSlot();
    }
    /**
     * PostgresSQL Event (camel-pgevent)
     * Send and receive PostgreSQL events via LISTEN and NOTIFY commands.
     * 
     * Category: database,sql
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-pgevent
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PgeventComponentBuilderFactory.PgeventComponentBuilder pgevent() {
        return org.apache.camel.builder.component.dsl.PgeventComponentBuilderFactory.pgevent();
    }
    /**
     * Platform HTTP (camel-platform-http)
     * Expose HTTP endpoints using the HTTP server available in the current
     * platform.
     * 
     * Category: http
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-platform-http
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PlatformHttpComponentBuilderFactory.PlatformHttpComponentBuilder platformHttp() {
        return org.apache.camel.builder.component.dsl.PlatformHttpComponentBuilderFactory.platformHttp();
    }
    /**
     * POP3 (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Pop3ComponentBuilderFactory.Pop3ComponentBuilder pop3() {
        return org.apache.camel.builder.component.dsl.Pop3ComponentBuilderFactory.pop3();
    }
    /**
     * POP3S (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Pop3sComponentBuilderFactory.Pop3sComponentBuilder pop3s() {
        return org.apache.camel.builder.component.dsl.Pop3sComponentBuilderFactory.pop3s();
    }
    /**
     * PubNub (camel-pubnub)
     * Send and receive messages to/from PubNub data stream network for
     * connected devices.
     * 
     * Category: cloud,iot,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-pubnub
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PubnubComponentBuilderFactory.PubnubComponentBuilder pubnub() {
        return org.apache.camel.builder.component.dsl.PubnubComponentBuilderFactory.pubnub();
    }
    /**
     * Pulsar (camel-pulsar)
     * Send and receive messages from/to Apache Pulsar messaging system.
     * 
     * Category: messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-pulsar
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.PulsarComponentBuilderFactory.PulsarComponentBuilder pulsar() {
        return org.apache.camel.builder.component.dsl.PulsarComponentBuilderFactory.pulsar();
    }
    /**
     * Quartz (camel-quartz)
     * Schedule sending of messages using the Quartz 2.x scheduler.
     * 
     * Category: scheduling
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-quartz
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.QuartzComponentBuilderFactory.QuartzComponentBuilder quartz() {
        return org.apache.camel.builder.component.dsl.QuartzComponentBuilderFactory.quartz();
    }
    /**
     * QuickFix (camel-quickfix)
     * Open a Financial Interchange (FIX) session using an embedded QuickFix/J
     * engine.
     * 
     * Category: messaging
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-quickfix
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.QuickfixComponentBuilderFactory.QuickfixComponentBuilder quickfix() {
        return org.apache.camel.builder.component.dsl.QuickfixComponentBuilderFactory.quickfix();
    }
    /**
     * RabbitMQ (camel-rabbitmq)
     * Send and receive messages from RabbitMQ instances.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-rabbitmq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RabbitmqComponentBuilderFactory.RabbitmqComponentBuilder rabbitmq() {
        return org.apache.camel.builder.component.dsl.RabbitmqComponentBuilderFactory.rabbitmq();
    }
    /**
     * Reactive Streams (camel-reactive-streams)
     * Exchange messages with reactive stream processing libraries compatible
     * with the reactive streams standard.
     * 
     * Category: reactive,streams
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-reactive-streams
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ReactiveStreamsComponentBuilderFactory.ReactiveStreamsComponentBuilder reactiveStreams() {
        return org.apache.camel.builder.component.dsl.ReactiveStreamsComponentBuilderFactory.reactiveStreams();
    }
    /**
     * Ref (camel-ref)
     * Route messages to an endpoint looked up dynamically by name in the Camel
     * Registry.
     * 
     * Category: core,endpoint
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-ref
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RefComponentBuilderFactory.RefComponentBuilder ref() {
        return org.apache.camel.builder.component.dsl.RefComponentBuilderFactory.ref();
    }
    /**
     * REST (camel-rest)
     * Expose REST services or call external REST services.
     * 
     * Category: core,rest
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RestEndpointComponentBuilderFactory.RestEndpointComponentBuilder restEndpoint() {
        return org.apache.camel.builder.component.dsl.RestEndpointComponentBuilderFactory.restEndpoint();
    }
    /**
     * REST API (camel-rest)
     * Expose OpenAPI Specification of the REST services defined using Camel
     * REST DSL.
     * 
     * Category: core,rest
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RestApiComponentBuilderFactory.RestApiComponentBuilder restApi() {
        return org.apache.camel.builder.component.dsl.RestApiComponentBuilderFactory.restApi();
    }
    /**
     * REST OpenApi (camel-rest-openapi)
     * Configure REST producers based on an OpenAPI specification document
     * delegating to a component implementing the RestProducerFactory interface.
     * 
     * Category: openapi,rest,api
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RestOpenapiComponentBuilderFactory.RestOpenapiComponentBuilder restOpenapi() {
        return org.apache.camel.builder.component.dsl.RestOpenapiComponentBuilderFactory.restOpenapi();
    }
    /**
     * REST Swagger (camel-rest-swagger)
     * Configure REST producers based on a Swagger (OpenAPI) specification
     * document delegating to a component implementing the RestProducerFactory
     * interface.
     * 
     * Category: rest,swagger,http
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-rest-swagger
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RestSwaggerComponentBuilderFactory.RestSwaggerComponentBuilder restSwagger() {
        return org.apache.camel.builder.component.dsl.RestSwaggerComponentBuilderFactory.restSwagger();
    }
    /**
     * Resteasy (camel-resteasy)
     * Expose REST endpoints and access external REST servers.
     * 
     * Category: rest
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-resteasy
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ResteasyComponentBuilderFactory.ResteasyComponentBuilder resteasy() {
        return org.apache.camel.builder.component.dsl.ResteasyComponentBuilderFactory.resteasy();
    }
    /**
     * Robot Framework (camel-robotframework)
     * Pass camel exchanges to acceptence test written in Robot DSL.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RobotframeworkComponentBuilderFactory.RobotframeworkComponentBuilder robotframework() {
        return org.apache.camel.builder.component.dsl.RobotframeworkComponentBuilderFactory.robotframework();
    }
    /**
     * RSS (camel-rss)
     * Poll RSS feeds.
     * 
     * Category: rss
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-rss
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.RssComponentBuilderFactory.RssComponentBuilder rss() {
        return org.apache.camel.builder.component.dsl.RssComponentBuilderFactory.rss();
    }
    /**
     * Saga (camel-saga)
     * Execute custom actions within a route using the Saga EIP.
     * 
     * Category: core,endpoint
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-saga
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SagaComponentBuilderFactory.SagaComponentBuilder saga() {
        return org.apache.camel.builder.component.dsl.SagaComponentBuilderFactory.saga();
    }
    /**
     * Salesforce (camel-salesforce)
     * Communicate with Salesforce using Java DTOs.
     * 
     * Category: cloud,api,crm
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SalesforceComponentBuilderFactory.SalesforceComponentBuilder salesforce() {
        return org.apache.camel.builder.component.dsl.SalesforceComponentBuilderFactory.salesforce();
    }
    /**
     * SAP NetWeaver (camel-sap-netweaver)
     * Send requests to SAP NetWeaver Gateway using HTTP.
     * 
     * Category: sap,cloud,api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-sap-netweaver
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SapNetweaverComponentBuilderFactory.SapNetweaverComponentBuilder sapNetweaver() {
        return org.apache.camel.builder.component.dsl.SapNetweaverComponentBuilderFactory.sapNetweaver();
    }
    /**
     * Scheduler (camel-scheduler)
     * Generate messages in specified intervals using
     * java.util.concurrent.ScheduledExecutorService.
     * 
     * Category: core,scheduling
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-scheduler
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SchedulerComponentBuilderFactory.SchedulerComponentBuilder scheduler() {
        return org.apache.camel.builder.component.dsl.SchedulerComponentBuilderFactory.scheduler();
    }
    /**
     * Schematron (camel-schematron)
     * Validate XML payload using the Schematron Library.
     * 
     * Category: validation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-schematron
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SchematronComponentBuilderFactory.SchematronComponentBuilder schematron() {
        return org.apache.camel.builder.component.dsl.SchematronComponentBuilderFactory.schematron();
    }
    /**
     * SCP (camel-jsch)
     * Copy files to/from remote hosts using the secure copy protocol (SCP).
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ScpComponentBuilderFactory.ScpComponentBuilder scp() {
        return org.apache.camel.builder.component.dsl.ScpComponentBuilderFactory.scp();
    }
    /**
     * SEDA (camel-seda)
     * Asynchronously call another endpoint from any Camel Context in the same
     * JVM.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-seda
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SedaComponentBuilderFactory.SedaComponentBuilder seda() {
        return org.apache.camel.builder.component.dsl.SedaComponentBuilderFactory.seda();
    }
    /**
     * Service (camel-service)
     * Register a Camel endpoint to a Service Registry (such as Consul, Etcd)
     * and delegate to it.
     * 
     * Category: cloud
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-service
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ServiceComponentBuilderFactory.ServiceComponentBuilder service() {
        return org.apache.camel.builder.component.dsl.ServiceComponentBuilderFactory.service();
    }
    /**
     * ServiceNow (camel-servicenow)
     * Interact with ServiceNow via its REST API.
     * 
     * Category: api,cloud,management
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-servicenow
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ServicenowComponentBuilderFactory.ServicenowComponentBuilder servicenow() {
        return org.apache.camel.builder.component.dsl.ServicenowComponentBuilderFactory.servicenow();
    }
    /**
     * Servlet (camel-servlet)
     * Serve HTTP requests by a Servlet.
     * 
     * Category: http
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-servlet
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ServletComponentBuilderFactory.ServletComponentBuilder servlet() {
        return org.apache.camel.builder.component.dsl.ServletComponentBuilderFactory.servlet();
    }
    /**
     * SFTP (camel-ftp)
     * Upload and download files to/from SFTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SftpComponentBuilderFactory.SftpComponentBuilder sftp() {
        return org.apache.camel.builder.component.dsl.SftpComponentBuilderFactory.sftp();
    }
    /**
     * SIP (camel-sip)
     * Send and receive messages using the SIP protocol (used in
     * telecommunications).
     * 
     * Category: mobile
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-sip
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SipComponentBuilderFactory.SipComponentBuilder sip() {
        return org.apache.camel.builder.component.dsl.SipComponentBuilderFactory.sip();
    }
    /**
     * SIP (Secure) (camel-sip)
     * Send and receive messages using the SIP protocol (used in
     * telecommunications).
     * 
     * Category: mobile
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-sip
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SipsComponentBuilderFactory.SipsComponentBuilder sips() {
        return org.apache.camel.builder.component.dsl.SipsComponentBuilderFactory.sips();
    }
    /**
     * Simple JMS (camel-sjms)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 1.x API.
     * 
     * Category: messaging
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SjmsComponentBuilderFactory.SjmsComponentBuilder sjms() {
        return org.apache.camel.builder.component.dsl.SjmsComponentBuilderFactory.sjms();
    }
    /**
     * Simple JMS2 (camel-sjms2)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 2.x API.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-sjms2
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Sjms2ComponentBuilderFactory.Sjms2ComponentBuilder sjms2() {
        return org.apache.camel.builder.component.dsl.Sjms2ComponentBuilderFactory.sjms2();
    }
    /**
     * Slack (camel-slack)
     * Send and receive messages to/from Slack.
     * 
     * Category: social
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-slack
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SlackComponentBuilderFactory.SlackComponentBuilder slack() {
        return org.apache.camel.builder.component.dsl.SlackComponentBuilderFactory.slack();
    }
    /**
     * SMPP (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SmppComponentBuilderFactory.SmppComponentBuilder smpp() {
        return org.apache.camel.builder.component.dsl.SmppComponentBuilderFactory.smpp();
    }
    /**
     * SMPP (Secure) (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SmppsComponentBuilderFactory.SmppsComponentBuilder smpps() {
        return org.apache.camel.builder.component.dsl.SmppsComponentBuilderFactory.smpps();
    }
    /**
     * SMTP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SmtpComponentBuilderFactory.SmtpComponentBuilder smtp() {
        return org.apache.camel.builder.component.dsl.SmtpComponentBuilderFactory.smtp();
    }
    /**
     * SMTPS (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SmtpsComponentBuilderFactory.SmtpsComponentBuilder smtps() {
        return org.apache.camel.builder.component.dsl.SmtpsComponentBuilderFactory.smtps();
    }
    /**
     * SNMP (camel-snmp)
     * Receive traps and poll SNMP (Simple Network Management Protocol) capable
     * devices.
     * 
     * Category: monitoring
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-snmp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SnmpComponentBuilderFactory.SnmpComponentBuilder snmp() {
        return org.apache.camel.builder.component.dsl.SnmpComponentBuilderFactory.snmp();
    }
    /**
     * Solr (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SolrComponentBuilderFactory.SolrComponentBuilder solr() {
        return org.apache.camel.builder.component.dsl.SolrComponentBuilderFactory.solr();
    }
    /**
     * Solr (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SolrcloudComponentBuilderFactory.SolrcloudComponentBuilder solrcloud() {
        return org.apache.camel.builder.component.dsl.SolrcloudComponentBuilderFactory.solrcloud();
    }
    /**
     * Solr (Secure) (camel-solr)
     * Perform operations against Apache Lucene Solr.
     * 
     * Category: monitoring,search
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-solr
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SolrsComponentBuilderFactory.SolrsComponentBuilder solrs() {
        return org.apache.camel.builder.component.dsl.SolrsComponentBuilderFactory.solrs();
    }
    /**
     * Soroush (camel-soroush)
     * Send and receive messages as a Soroush chat bot.
     * 
     * Category: chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-soroush
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SoroushComponentBuilderFactory.SoroushComponentBuilder soroush() {
        return org.apache.camel.builder.component.dsl.SoroushComponentBuilderFactory.soroush();
    }
    /**
     * Spark (camel-spark)
     * Send RDD or DataFrame jobs to Apache Spark clusters.
     * 
     * Category: bigdata,iot
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-spark
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SparkComponentBuilderFactory.SparkComponentBuilder spark() {
        return org.apache.camel.builder.component.dsl.SparkComponentBuilderFactory.spark();
    }
    /**
     * Splunk (camel-splunk)
     * Publish or search for events in Splunk.
     * 
     * Category: iot,monitoring
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-splunk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SplunkComponentBuilderFactory.SplunkComponentBuilder splunk() {
        return org.apache.camel.builder.component.dsl.SplunkComponentBuilderFactory.splunk();
    }
    /**
     * Splunk HEC (camel-splunk-hec)
     * The splunk component allows to publish events in Splunk using the HTTP
     * Event Collector.
     * 
     * Category: log,monitoring
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-splunk-hec
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SplunkHecComponentBuilderFactory.SplunkHecComponentBuilder splunkHec() {
        return org.apache.camel.builder.component.dsl.SplunkHecComponentBuilderFactory.splunkHec();
    }
    /**
     * Spring Batch (camel-spring-batch)
     * Send messages to Spring Batch for further processing.
     * 
     * Category: spring,batch,scheduling
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-spring-batch
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringBatchComponentBuilderFactory.SpringBatchComponentBuilder springBatch() {
        return org.apache.camel.builder.component.dsl.SpringBatchComponentBuilderFactory.springBatch();
    }
    /**
     * Spring Event (camel-spring)
     * Listen for Spring Application Events.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringEventComponentBuilderFactory.SpringEventComponentBuilder springEvent() {
        return org.apache.camel.builder.component.dsl.SpringEventComponentBuilderFactory.springEvent();
    }
    /**
     * Spring Integration (camel-spring-integration)
     * Bridge Camel with Spring Integration.
     * 
     * Category: spring,eventbus
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring-integration
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringIntegrationComponentBuilderFactory.SpringIntegrationComponentBuilder springIntegration() {
        return org.apache.camel.builder.component.dsl.SpringIntegrationComponentBuilderFactory.springIntegration();
    }
    /**
     * Spring JDBC (camel-spring-jdbc)
     * Access databases through SQL and JDBC with Spring Transaction support.
     * 
     * Category: database,sql
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-spring-jdbc
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringJdbcComponentBuilderFactory.SpringJdbcComponentBuilder springJdbc() {
        return org.apache.camel.builder.component.dsl.SpringJdbcComponentBuilderFactory.springJdbc();
    }
    /**
     * Spring LDAP (camel-spring-ldap)
     * Perform searches in LDAP servers using filters as the message payload.
     * 
     * Category: spring,ldap
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-ldap
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringLdapComponentBuilderFactory.SpringLdapComponentBuilder springLdap() {
        return org.apache.camel.builder.component.dsl.SpringLdapComponentBuilderFactory.springLdap();
    }
    /**
     * Spring RabbitMQ (camel-spring-rabbitmq)
     * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
     * 
     * Category: messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringRabbitmqComponentBuilderFactory.SpringRabbitmqComponentBuilder springRabbitmq() {
        return org.apache.camel.builder.component.dsl.SpringRabbitmqComponentBuilderFactory.springRabbitmq();
    }
    /**
     * Spring Redis (camel-spring-redis)
     * Send and receive messages from Redis.
     * 
     * Category: spring,nosql
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-redis
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringRedisComponentBuilderFactory.SpringRedisComponentBuilder springRedis() {
        return org.apache.camel.builder.component.dsl.SpringRedisComponentBuilderFactory.springRedis();
    }
    /**
     * Spring WebService (camel-spring-ws)
     * Access external web services as a client or expose your own web services.
     * 
     * Category: spring,soap,webservice
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SpringWsComponentBuilderFactory.SpringWsComponentBuilder springWs() {
        return org.apache.camel.builder.component.dsl.SpringWsComponentBuilderFactory.springWs();
    }
    /**
     * SQL (camel-sql)
     * Perform SQL queries using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SqlComponentBuilderFactory.SqlComponentBuilder sql() {
        return org.apache.camel.builder.component.dsl.SqlComponentBuilderFactory.sql();
    }
    /**
     * SQL Stored Procedure (camel-sql)
     * Perform SQL queries as a JDBC Stored Procedures using Spring JDBC.
     * 
     * Category: database,sql
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SqlStoredComponentBuilderFactory.SqlStoredComponentBuilder sqlStored() {
        return org.apache.camel.builder.component.dsl.SqlStoredComponentBuilderFactory.sqlStored();
    }
    /**
     * SSH (camel-ssh)
     * Execute commands on remote hosts using SSH.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.SshComponentBuilderFactory.SshComponentBuilder ssh() {
        return org.apache.camel.builder.component.dsl.SshComponentBuilderFactory.ssh();
    }
    /**
     * StAX (camel-stax)
     * Process XML payloads by a SAX ContentHandler.
     * 
     * Category: transformation
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-stax
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StaxComponentBuilderFactory.StaxComponentBuilder stax() {
        return org.apache.camel.builder.component.dsl.StaxComponentBuilderFactory.stax();
    }
    /**
     * Stitch (camel-stitch)
     * Stitch is a cloud ETL service that integrates various data sources into a
     * central data warehouse through various integrations.
     * 
     * Category: cloud,api,compute,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-stitch
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StitchComponentBuilderFactory.StitchComponentBuilder stitch() {
        return org.apache.camel.builder.component.dsl.StitchComponentBuilderFactory.stitch();
    }
    /**
     * Stomp (camel-stomp)
     * Send and rececive messages to/from STOMP (Simple Text Oriented Messaging
     * Protocol) compliant message brokers.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-stomp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StompComponentBuilderFactory.StompComponentBuilder stomp() {
        return org.apache.camel.builder.component.dsl.StompComponentBuilderFactory.stomp();
    }
    /**
     * Stream (camel-stream)
     * Read from system-in and write to system-out and system-err streams.
     * 
     * Category: file,system
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-stream
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StreamComponentBuilderFactory.StreamComponentBuilder stream() {
        return org.apache.camel.builder.component.dsl.StreamComponentBuilderFactory.stream();
    }
    /**
     * String Template (camel-stringtemplate)
     * Transform messages using StringTemplate engine.
     * 
     * Category: transformation,script
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-stringtemplate
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StringTemplateComponentBuilderFactory.StringTemplateComponentBuilder stringTemplate() {
        return org.apache.camel.builder.component.dsl.StringTemplateComponentBuilderFactory.stringTemplate();
    }
    /**
     * Stub (camel-stub)
     * Stub out any physical endpoints while in development or testing.
     * 
     * Category: core,testing
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-stub
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.StubComponentBuilderFactory.StubComponentBuilder stub() {
        return org.apache.camel.builder.component.dsl.StubComponentBuilderFactory.stub();
    }
    /**
     * Telegram (camel-telegram)
     * Send and receive messages acting as a Telegram Bot Telegram Bot API.
     * 
     * Category: cloud,api,chat
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-telegram
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TelegramComponentBuilderFactory.TelegramComponentBuilder telegram() {
        return org.apache.camel.builder.component.dsl.TelegramComponentBuilderFactory.telegram();
    }
    /**
     * Thrift (camel-thrift)
     * Call and expose remote procedures (RPC) with Apache Thrift data format
     * and serialization mechanism.
     * 
     * Category: rpc,transformation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ThriftComponentBuilderFactory.ThriftComponentBuilder thrift() {
        return org.apache.camel.builder.component.dsl.ThriftComponentBuilderFactory.thrift();
    }
    /**
     * Tika (camel-tika)
     * Parse documents and extract metadata and text using Apache Tika.
     * 
     * Category: document,transformation
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-tika
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TikaComponentBuilderFactory.TikaComponentBuilder tika() {
        return org.apache.camel.builder.component.dsl.TikaComponentBuilderFactory.tika();
    }
    /**
     * Timer (camel-timer)
     * Generate messages in specified intervals using java.util.Timer.
     * 
     * Category: core,scheduling
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-timer
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TimerComponentBuilderFactory.TimerComponentBuilder timer() {
        return org.apache.camel.builder.component.dsl.TimerComponentBuilderFactory.timer();
    }
    /**
     * Twilio (camel-twilio)
     * Interact with Twilio REST APIs using Twilio Java SDK.
     * 
     * Category: api,messaging,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-twilio
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TwilioComponentBuilderFactory.TwilioComponentBuilder twilio() {
        return org.apache.camel.builder.component.dsl.TwilioComponentBuilderFactory.twilio();
    }
    /**
     * Twitter Direct Message (camel-twitter)
     * Send and receive Twitter direct messages.
     * 
     * Category: cloud,api,social,chat
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TwitterDirectmessageComponentBuilderFactory.TwitterDirectmessageComponentBuilder twitterDirectmessage() {
        return org.apache.camel.builder.component.dsl.TwitterDirectmessageComponentBuilderFactory.twitterDirectmessage();
    }
    /**
     * Twitter Search (camel-twitter)
     * Access Twitter Search.
     * 
     * Category: cloud,api,search,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TwitterSearchComponentBuilderFactory.TwitterSearchComponentBuilder twitterSearch() {
        return org.apache.camel.builder.component.dsl.TwitterSearchComponentBuilderFactory.twitterSearch();
    }
    /**
     * Twitter Timeline (camel-twitter)
     * Send tweets and receive tweets from user's timeline.
     * 
     * Category: api,cloud,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.TwitterTimelineComponentBuilderFactory.TwitterTimelineComponentBuilder twitterTimeline() {
        return org.apache.camel.builder.component.dsl.TwitterTimelineComponentBuilderFactory.twitterTimeline();
    }
    /**
     * Undertow (camel-undertow)
     * Expose HTTP and WebSocket endpoints and access external HTTP/WebSocket
     * servers.
     * 
     * Category: http,websocket
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.UndertowComponentBuilderFactory.UndertowComponentBuilder undertow() {
        return org.apache.camel.builder.component.dsl.UndertowComponentBuilderFactory.undertow();
    }
    /**
     * Validator (camel-validator)
     * Validate the payload using XML Schema and JAXP Validation.
     * 
     * Category: core,validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-validator
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ValidatorComponentBuilderFactory.ValidatorComponentBuilder validator() {
        return org.apache.camel.builder.component.dsl.ValidatorComponentBuilderFactory.validator();
    }
    /**
     * Velocity (camel-velocity)
     * Transform messages using a Velocity template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-velocity
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VelocityComponentBuilderFactory.VelocityComponentBuilder velocity() {
        return org.apache.camel.builder.component.dsl.VelocityComponentBuilderFactory.velocity();
    }
    /**
     * Vert.x (camel-vertx)
     * Send and receive messages to/from Vert.x Event Bus.
     * 
     * Category: eventbus,reactive
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-vertx
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VertxComponentBuilderFactory.VertxComponentBuilder vertx() {
        return org.apache.camel.builder.component.dsl.VertxComponentBuilderFactory.vertx();
    }
    /**
     * Vert.x HTTP Client (camel-vertx-http)
     * Send requests to external HTTP servers using Vert.x
     * 
     * Category: http
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-http
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VertxHttpComponentBuilderFactory.VertxHttpComponentBuilder vertxHttp() {
        return org.apache.camel.builder.component.dsl.VertxHttpComponentBuilderFactory.vertxHttp();
    }
    /**
     * Vert.x Kafka (camel-vertx-kafka)
     * Sent and receive messages to/from an Apache Kafka broker using vert.x
     * Kafka client
     * 
     * Category: messaging
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-vertx-kafka
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VertxKafkaComponentBuilderFactory.VertxKafkaComponentBuilder vertxKafka() {
        return org.apache.camel.builder.component.dsl.VertxKafkaComponentBuilderFactory.vertxKafka();
    }
    /**
     * Vert.x WebSocket (camel-vertx-websocket)
     * Expose WebSocket endpoints and connect to remote WebSocket servers using
     * Vert.x
     * 
     * Category: websocket
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-websocket
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VertxWebsocketComponentBuilderFactory.VertxWebsocketComponentBuilder vertxWebsocket() {
        return org.apache.camel.builder.component.dsl.VertxWebsocketComponentBuilderFactory.vertxWebsocket();
    }
    /**
     * VM (camel-vm)
     * Call another endpoint in the same CamelContext asynchronously.
     * 
     * Category: core,endpoint
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-vm
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.VmComponentBuilderFactory.VmComponentBuilder vm() {
        return org.apache.camel.builder.component.dsl.VmComponentBuilderFactory.vm();
    }
    /**
     * Weather (camel-weather)
     * Poll the weather information from Open Weather Map.
     * 
     * Category: api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WeatherComponentBuilderFactory.WeatherComponentBuilder weather() {
        return org.apache.camel.builder.component.dsl.WeatherComponentBuilderFactory.weather();
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * Interact with Ethereum nodes using web3j client API.
     * 
     * Category: bitcoin,blockchain,api
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.Web3jComponentBuilderFactory.Web3jComponentBuilder web3j() {
        return org.apache.camel.builder.component.dsl.Web3jComponentBuilderFactory.web3j();
    }
    /**
     * Webhook (camel-webhook)
     * Expose webhook endpoints to receive push notifications for other Camel
     * components.
     * 
     * Category: cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-webhook
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WebhookComponentBuilderFactory.WebhookComponentBuilder webhook() {
        return org.apache.camel.builder.component.dsl.WebhookComponentBuilderFactory.webhook();
    }
    /**
     * Jetty Websocket (camel-websocket)
     * Expose websocket endpoints using Jetty.
     * 
     * Category: websocket
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-websocket
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WebsocketComponentBuilderFactory.WebsocketComponentBuilder websocket() {
        return org.apache.camel.builder.component.dsl.WebsocketComponentBuilderFactory.websocket();
    }
    /**
     * Javax Websocket (camel-websocket-jsr356)
     * Expose websocket endpoints using JSR356.
     * 
     * Category: http
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-websocket-jsr356
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WebsocketJsr356ComponentBuilderFactory.WebsocketJsr356ComponentBuilder websocketJsr356() {
        return org.apache.camel.builder.component.dsl.WebsocketJsr356ComponentBuilderFactory.websocketJsr356();
    }
    /**
     * Weka (camel-weka)
     * Perform machine learning tasks using Weka.
     * 
     * Category: datamining
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-weka
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WekaComponentBuilderFactory.WekaComponentBuilder weka() {
        return org.apache.camel.builder.component.dsl.WekaComponentBuilderFactory.weka();
    }
    /**
     * Wordpress (camel-wordpress)
     * Manage posts and users using Wordpress API.
     * 
     * Category: cloud,api,cms
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-wordpress
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WordpressComponentBuilderFactory.WordpressComponentBuilder wordpress() {
        return org.apache.camel.builder.component.dsl.WordpressComponentBuilderFactory.wordpress();
    }
    /**
     * Workday (camel-workday)
     * Detect and parse documents using Workday.
     * 
     * Category: cloud,api,hcm
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-workday
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.WorkdayComponentBuilderFactory.WorkdayComponentBuilder workday() {
        return org.apache.camel.builder.component.dsl.WorkdayComponentBuilderFactory.workday();
    }
    /**
     * XChange (camel-xchange)
     * Access market data and trade on Bitcoin and Altcoin exchanges.
     * 
     * Category: bitcoin,blockchain
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XchangeComponentBuilderFactory.XchangeComponentBuilder xchange() {
        return org.apache.camel.builder.component.dsl.XchangeComponentBuilderFactory.xchange();
    }
    /**
     * XJ (camel-xj)
     * Transform JSON and XML message using a XSLT.
     * 
     * Category: transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xj
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XjComponentBuilderFactory.XjComponentBuilder xj() {
        return org.apache.camel.builder.component.dsl.XjComponentBuilderFactory.xj();
    }
    /**
     * XML Security Sign (camel-xmlsecurity)
     * Sign XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XmlsecuritySignComponentBuilderFactory.XmlsecuritySignComponentBuilder xmlsecuritySign() {
        return org.apache.camel.builder.component.dsl.XmlsecuritySignComponentBuilderFactory.xmlsecuritySign();
    }
    /**
     * XML Security Verify (camel-xmlsecurity)
     * Verify XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XmlsecurityVerifyComponentBuilderFactory.XmlsecurityVerifyComponentBuilder xmlsecurityVerify() {
        return org.apache.camel.builder.component.dsl.XmlsecurityVerifyComponentBuilderFactory.xmlsecurityVerify();
    }
    /**
     * XMPP (camel-xmpp)
     * Send and receive messages to/from an XMPP chat server.
     * 
     * Category: chat,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-xmpp
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XmppComponentBuilderFactory.XmppComponentBuilder xmpp() {
        return org.apache.camel.builder.component.dsl.XmppComponentBuilderFactory.xmpp();
    }
    /**
     * XQuery (camel-saxon)
     * Query and/or transform XML payloads using XQuery and Saxon.
     * 
     * Category: transformation
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XqueryComponentBuilderFactory.XqueryComponentBuilder xquery() {
        return org.apache.camel.builder.component.dsl.XqueryComponentBuilderFactory.xquery();
    }
    /**
     * XSLT (camel-xslt)
     * Transforms XML payload using an XSLT template.
     * 
     * Category: core,transformation
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-xslt
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XsltComponentBuilderFactory.XsltComponentBuilder xslt() {
        return org.apache.camel.builder.component.dsl.XsltComponentBuilderFactory.xslt();
    }
    /**
     * XSLT Saxon (camel-xslt-saxon)
     * Transform XML payloads using an XSLT template using Saxon.
     * 
     * Category: core,transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xslt-saxon
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.XsltSaxonComponentBuilderFactory.XsltSaxonComponentBuilder xsltSaxon() {
        return org.apache.camel.builder.component.dsl.XsltSaxonComponentBuilderFactory.xsltSaxon();
    }
    /**
     * Yammer (camel-yammer)
     * Interact with the Yammer enterprise social network.
     * 
     * Category: social,cloud,api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-yammer
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.YammerComponentBuilderFactory.YammerComponentBuilder yammer() {
        return org.apache.camel.builder.component.dsl.YammerComponentBuilderFactory.yammer();
    }
    /**
     * Zendesk (camel-zendesk)
     * Manage Zendesk tickets, users, organizations, etc.
     * 
     * Category: cloud,api,support
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zendesk
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ZendeskComponentBuilderFactory.ZendeskComponentBuilder zendesk() {
        return org.apache.camel.builder.component.dsl.ZendeskComponentBuilderFactory.zendesk();
    }
    /**
     * ZooKeeper (camel-zookeeper)
     * Manage ZooKeeper clusters.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ZookeeperComponentBuilderFactory.ZookeeperComponentBuilder zookeeper() {
        return org.apache.camel.builder.component.dsl.ZookeeperComponentBuilderFactory.zookeeper();
    }
    /**
     * ZooKeeper Master (camel-zookeeper-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zookeeper-master
     * 
     * @return the dsl builder
     */
    static org.apache.camel.builder.component.dsl.ZookeeperMasterComponentBuilderFactory.ZookeeperMasterComponentBuilder zookeeperMaster() {
        return org.apache.camel.builder.component.dsl.ZookeeperMasterComponentBuilderFactory.zookeeperMaster();
    }
}